/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.spring;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.log4j.Logger;

public class StarterBean {
    private static final Logger log = Logger.getLogger(StarterBean.class);
    private Map<Object, String> initializationMethods;

    public void afterPropertiesSet() throws Exception {
        if (this.initializationMethods == null) {
            log.warn((Object)"initializationMethods not set.");
            return;
        }
        for (Map.Entry<Object, String> entry : this.initializationMethods.entrySet()) {
            String[] methodNames;
            Object bean = entry.getKey();
            for (String methodName : methodNames = entry.getValue().split(",")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoking method [" + methodName + "] on bean [" + entry.getKey() + "]."));
                }
                Method method = bean.getClass().getMethod(methodName, new Class[0]);
                method.invoke(bean, new Object[0]);
            }
        }
    }

    public Map<Object, String> getInitializationMethods() {
        return this.initializationMethods;
    }

    public void setInitializationMethods(Map<Object, String> initializationMethods) {
        this.initializationMethods = initializationMethods;
    }
}

