/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.bo.data.attachment.Attachment;
import at.cdes.bo.data.certificate.CDESCertificate;
import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.document.ArchiveBulkDownloadEntry;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentRef;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.file.CDESDataFile;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.label.TemporaryCustomTextField;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.order.OrderAddress;
import at.cdes.bo.data.order.OrderAddressComparator;
import at.cdes.bo.data.order.orig.OriginalDocumentOrder;
import at.cdes.bo.data.order.plott.PlottOrder;
import at.cdes.bo.data.order.plott.PlottOrderItem;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.person.Person;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.ProjectStatusChange;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.data.search.ReviewCycleStatusSearch;
import at.cdes.bo.data.sec.CDESSignature;
import at.cdes.bo.data.sec.DigestCalculatorType;
import at.cdes.bo.document.DocumentTranslator;
import at.cdes.bo.file.FileFinder;
import at.cdes.bo.mime.MimeSourceFactory;
import at.cdes.bo.sec.digest.DigestCalculator;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.DigestCalculatorFactory;
import at.cdes.bo.sec.signature.SignatureCalculator;
import at.cdes.bo.sec.signature.SignatureCalculatorException;
import at.cdes.bo.sec.signature.SignatureCalculatorFactory;
import at.cdes.controller.actionhandler.DocumentVersionSaver;
import at.cdes.controller.actionhandler.archive.ProjectArchiveWriter;
import at.cdes.controller.apiHelper.ArchiveHelper;
import at.cdes.controller.helper.ArchiveTableOfContentsWriter;
import at.cdes.db.dao.AttachmentDAO;
import at.cdes.db.dao.CertificateDAO;
import at.cdes.db.dao.DigestCalculatorDAO;
import at.cdes.db.dao.OrderDAO;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.db.dao.SignatureDAO;
import at.cdes.db.dao.SubProjectDAO;
import at.cdes.ext.preview.AbstractDocumentVersionPdfMimeSource;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.Timeout;
import at.cdes.service.ActionOperations;
import at.cdes.service.ArchiveService;
import at.cdes.service.MailOperations;
import at.cdes.service.ProjectOperations;
import at.cdes.service.ReviewOperations;
import at.cdes.service.exception.ActionException;
import at.cdes.service.exception.FileHandleException;
import at.cdes.service.exception.WrongPasswordException;
import at.cdes.util.ArchiveEstimation;
import at.cdes.util.ArchiveJobStatus;
import at.cdes.util.ConfigurationHelper;
import at.cdes.util.OperatingSystem;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FileSystemUtils;
import org.apache.log4j.Logger;
import org.apache.pdfbox.io.IOUtils;
import org.bouncycastle.util.encoders.Base64;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.datetime.ISO8601Format;
import org.clazzes.util.http.UrlHelper;
import org.clazzes.util.lang.Pair;
import org.clazzes.util.lang.Triple;
import org.clazzes.util.lang.Util;
import org.clazzes.util.xml.XMLSerializerHelper;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xnap.commons.i18n.I18n;

public class ArchiveServiceImpl
implements ArchiveService {
    private static Logger log = Logger.getLogger(ArchiveServiceImpl.class);
    private ActionOperations actionOperations;
    private MailOperations mailOperations;
    private ProjectOperations projectOperations;
    private ReviewOperations reviewOperations;
    private AttachmentDAO attachmentDAO;
    private OrderDAO orderDAO;
    private FileFinder fileFinder;
    private File allowedBaseDir;
    private DigestCalculatorFactory digestCalculatorFactory;
    private SignatureCalculatorFactory signatureCalculatorFactory;
    private SignatureDAO signatureDAO;
    private DigestCalculatorDAO digestCalculatorDAO;
    private ProjectDAO projectDAO;
    private SubProjectDAO subProjectDAO;
    private CertificateDAO certificateDAO;
    private ProjectArchiveWriter projectArchiveWriter;
    private MimeSourceFactory mimeSourceFactory;
    private double pdfZipCompressionFactorEstimate;
    private double pltZipCompressionFactorEstimate;
    private String cdesDataFilesRoot;
    private boolean enableCustomerLogo;
    private String cookieThreadLocalKey;
    private String applicationUrl;
    private static final String MANIFEST_XML_FILENAME = "manifest.xml";
    private static final String PROJECT_XML_FILENAME = "project.xml";

    public void setCookieThreadLocalKey(String cookieThreadLocalKey) {
        this.cookieThreadLocalKey = cookieThreadLocalKey;
    }

    public void setApplicationUrl(String applicationUrl) {
        this.applicationUrl = applicationUrl;
    }

    private ProjectStatusChange changeProjectStatus(Project project, int newStatus, CDESCertificate signer, String password) throws WrongPasswordException {
        if (newStatus == 0 && project.getStatus() != 5 || newStatus != project.getStatus() + 1 && newStatus != 0 && project.getStatus() != 5) {
            throw new ActionException("Invalid project status change.");
        }
        ProjectStatusChange psc = new ProjectStatusChange();
        psc.setOldStatus(project.getStatus());
        psc.setNewStatus(newStatus);
        psc.setProject(project);
        project.setStatus(newStatus);
        project.setAccess(Project.getMaxAllowedAccess(newStatus));
        try {
            DigestCalculator hc = this.digestCalculatorFactory.getDigestCalculator(project.getNetwork(), psc);
            DigestCalculatorType type = this.digestCalculatorDAO.get(hc.getClass().getName());
            psc.setDigestCalculatorType(type);
            psc.setDigest(hc.getDigest(psc));
            psc = this.projectDAO.save(psc);
            SignatureCalculator sigc = this.signatureCalculatorFactory.getSignatureCalculator(project.getNetwork(), psc);
            CDESSignature signature = sigc.createSignature(null, hc.getSignableContent(psc), signer, password);
            signature = this.signatureDAO.save(signature);
            psc.setSignature(signature);
            return this.projectDAO.update(psc);
        }
        catch (DigestCalculatorException e) {
            log.error((Object)"Digest creation error changing project status", (Throwable)e);
            throw new ActionException("Digest creation error changing project status", e);
        }
        catch (SignatureCalculatorException e) {
            log.error((Object)"Signature calculation error changing project status", (Throwable)e);
            throw new ActionException("Signature calculation error changing project status", e);
        }
    }

    private void postForwardEMail(Network network, String actionName, String subject, String message, OrganisationPerson originator) {
        List<OrganisationPerson> addressees = this.actionOperations.getNetworkDeputies(actionName, network.getId());
        for (OrganisationPerson addressee : addressees) {
            this.mailOperations.createSimpleMailReply(addressee, subject, message, originator.getEmailAddress());
        }
    }

    private void postConfirmationEMail(ProjectStatusChange last_psc, String subject, String message, OrganisationPerson originator) {
        OrganisationPerson addressee = last_psc.getSignature().getCertificate().getOrganisationPerson();
        this.mailOperations.createSimpleMailReply(addressee, subject, message, originator.getEmailAddress());
    }

    private static String getGenderAttribution(I18n i18n, Person person) {
        if (person.isFemale()) {
            return i18n.tr("Frau");
        }
        return i18n.tr("Herr");
    }

    private static ProjectStatusChange parseManifest(FileFinder importFileFinder, OutputStream sha1_out) throws FileHandleException, SAXException, IOException, ParserConfigurationException, NumberFormatException, XPathExpressionException, ParseException {
        File manifestFile = importFileFinder.buildFile(MANIFEST_XML_FILENAME, CDESFileRepository.TEMPREPOSITORY);
        FileInputStream mis = new FileInputStream(manifestFile);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        org.w3c.dom.Document document = db.parse(mis);
        XPath xpath = XPathFactory.newInstance().newXPath();
        if (log.isDebugEnabled()) {
            log.debug((Object)("reading [" + manifestFile.getAbsolutePath() + "]."));
        }
        ProjectStatusChange ret = new ProjectStatusChange();
        Project project = new Project();
        CDESSignature signature = new CDESSignature();
        CDESCertificate cert = new CDESCertificate();
        signature.setCertificate(cert);
        ret.setProject(project);
        ret.setSignature(signature);
        ret.setId(Integer.valueOf((String)xpath.evaluate("/manifest/id", document, XPathConstants.STRING)));
        ret.setNewStatus(Integer.valueOf((String)xpath.evaluate("/manifest/newStatus", document, XPathConstants.STRING)));
        ret.setOldStatus(Integer.valueOf((String)xpath.evaluate("/manifest/oldStatus", document, XPathConstants.STRING)));
        ret.setDigest((String)xpath.evaluate("/manifest/digest", document, XPathConstants.STRING));
        signature.setContent((String)xpath.evaluate("/manifest/signedData", document, XPathConstants.STRING));
        signature.setSignature((String)xpath.evaluate("/manifest/signature", document, XPathConstants.STRING));
        ISO8601Format df = new ISO8601Format(ISO8601Format.DATETIME_FORMAT);
        Calendar c = (Calendar)df.parseObject((String)xpath.evaluate("/manifest/date", document, XPathConstants.STRING));
        signature.setTime(c.getTime());
        cert.setCertificate((String)xpath.evaluate("/manifest/certificate", document, XPathConstants.STRING));
        project.setId(Integer.valueOf((String)xpath.evaluate("/manifest/projectId", document, XPathConstants.STRING)));
        project.setName((String)xpath.evaluate("/manifest/projectName", document, XPathConstants.STRING));
        if (!PROJECT_XML_FILENAME.equals((String)xpath.evaluate("/manifest/exportDigest/@file", document, XPathConstants.STRING))) {
            throw new IOException("exportDigest does not refer project.xml.");
        }
        if (!"SHA-1".equals((String)xpath.evaluate("/manifest/exportDigest/@algorithm", document, XPathConstants.STRING))) {
            throw new IOException("exportDigest does use algorithm SHA-1.");
        }
        if (sha1_out != null) {
            sha1_out.write(Base64.decode((String)((String)xpath.evaluate("/manifest/exportDigest", document, XPathConstants.STRING))));
        }
        return ret;
    }

    private FileFinder checkImportDirectory(ProjectStatusChange last_psc, File importDir) {
        try {
            int n;
            FileFinder importFileFinder = this.setupLocalFileFinder(importDir, false);
            ByteArrayOutputStream sha1_out = new ByteArrayOutputStream();
            if (log.isDebugEnabled()) {
                log.debug((Object)("***** inspecting import directory [" + importDir + "]."));
            }
            ProjectStatusChange psc = ArchiveServiceImpl.parseManifest(importFileFinder, sha1_out);
            if (log.isDebugEnabled()) {
                log.debug((Object)("project ids: DB [" + last_psc.getProject().getId() + "], import: [" + psc.getProject().getId() + "]."));
                log.debug((Object)("new status: DB [" + last_psc.getNewStatus() + "], import: [" + psc.getNewStatus() + "]."));
                log.debug((Object)("old status: DB [" + last_psc.getOldStatus() + "], import: [" + psc.getOldStatus() + "]."));
                log.debug((Object)("digest: DB [" + last_psc.getDigest() + "], import: [" + psc.getDigest() + "]."));
                log.debug((Object)("signature: DB [" + last_psc.getSignature().getSignature() + "], import: [" + psc.getSignature().getSignature() + "]."));
            }
            if (!(last_psc.getProject().getId().equals(psc.getProject().getId()) && psc.getNewStatus() == last_psc.getNewStatus() && psc.getOldStatus() == last_psc.getOldStatus() && last_psc.getDigest().equals(psc.getDigest()) && last_psc.getSignature().getSignature().equals(psc.getSignature().getSignature()))) {
                log.warn((Object)("Rejected importdirectory [" + importDir + "] because the manifest differs."));
                return null;
            }
            File xmlFile = importFileFinder.findFile(PROJECT_XML_FILENAME, CDESFileRepository.TEMPREPOSITORY);
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            FileInputStream fis = new FileInputStream(xmlFile);
            byte[] buf = new byte[4096];
            while ((n = ((InputStream)fis).read(buf)) > 0) {
                sha1.update(buf, 0, n);
            }
            byte[] sha1_b64 = sha1.digest();
            byte[] sha1_b64_imp = sha1_out.toByteArray();
            if (log.isDebugEnabled()) {
                log.debug((Object)("SHA-1 of project.xml: file [" + new String(Base64.encode((byte[])sha1_b64), "US-ASCII") + "], import: [" + new String(Base64.encode((byte[])sha1_b64_imp), "US-ASCII") + "]."));
            }
            if (!Util.equals((byte[])sha1_b64, (byte[])sha1_b64_imp)) {
                log.warn((Object)("Rejected importdirectory [" + importDir + "] because the export file hash differs."));
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("import directory [" + importDir + "] has been accepted."));
            }
            return importFileFinder;
        }
        catch (Throwable e) {
            log.warn((Object)("Caught exception while exmining directory [" + importDir + "]"), e);
            return null;
        }
    }

    @Override
    public void requestArchiveProject(Integer projectId, Integer signerId, String password) throws WrongPasswordException {
        Project project = this.projectOperations.getProject(projectId);
        CDESCertificate signer = this.certificateDAO.get(signerId);
        this.changeProjectStatus(project, 1, signer, password);
        Locale locale = new Locale(signer.getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        this.postForwardEMail(project.getNetwork(), "createProjectArchive", String.format(locale, i18n.tr("Archivierung des Projekts %s angefordert"), project.getName()), String.format(locale, i18n.tr("%s %s (%s)\nhat die Archvierung des Projekts\n\n  %s\n\nbeantragt.\n\nBitte veranlassen Sie die Archivierung der Daten im Men\u00fc\n\n  Netzwerk -> Projekt.\n\nBeim Archvieren des Projekts wird ein automatische e-mail\nan den Antragsteller gesendet.\n"), ArchiveServiceImpl.getGenderAttribution(i18n, signer.getOrganisationPerson().getPerson()), signer.getOrganisationPerson().getPerson().getCommonName(), signer.getOrganisationPerson().getOrganisation().getName(), project.getName()), signer.getOrganisationPerson());
    }

    private FileFinder setupLocalFileFinder(String serverPath, boolean createDirs) {
        File baseDir = new File(serverPath);
        return this.setupLocalFileFinder(baseDir, createDirs);
    }

    private FileFinder setupLocalFileFinder(File baseDir, boolean createDirs) {
        File tmp;
        FileFinder ff = new FileFinder();
        for (tmp = baseDir.getParentFile(); tmp != null && !tmp.equals(this.allowedBaseDir); tmp = tmp.getParentFile()) {
        }
        if (tmp == null) {
            throw new ActionException("Export directory [" + baseDir + "] is not a subdirectory of [" + this.allowedBaseDir + "].");
        }
        if (createDirs && baseDir.exists()) {
            throw new ActionException("Export directory [" + baseDir + "] already exists.");
        }
        if (createDirs && !baseDir.mkdirs()) {
            throw new ActionException("Unable to create export directory [" + baseDir + "].");
        }
        File docDir = new File(baseDir, "documents");
        if (createDirs && !docDir.mkdirs()) {
            throw new ActionException("Unable to create export directory [" + docDir + "].");
        }
        File attDir = new File(baseDir, "attachments");
        if (createDirs && !attDir.mkdirs()) {
            throw new ActionException("Unable to create export directory [" + attDir + "].");
        }
        File orgDir = new File(baseDir, "originals");
        if (createDirs && !orgDir.mkdirs()) {
            throw new ActionException("Unable to create export directory [" + orgDir + "].");
        }
        File labDir = new File(baseDir, "labels");
        if (createDirs && !labDir.mkdirs()) {
            throw new ActionException("Unable to create export directory [" + labDir + "].");
        }
        File docrefDir = new File(baseDir, "documentRefs");
        if (createDirs && !docrefDir.mkdirs()) {
            throw new ActionException("Unable to create export directory [" + docrefDir + "].");
        }
        File xmlDir = new File(baseDir, "xmldump");
        if (createDirs && !xmlDir.mkdirs()) {
            throw new ActionException("Unable to create export directory [" + xmlDir + "].");
        }
        HashMap<String, File> repositoryToPath = new HashMap<String, File>();
        repositoryToPath.put(CDESFileRepository.PLANREPOSITORY.getKey(), docDir);
        repositoryToPath.put(CDESFileRepository.TEMPREPOSITORY.getKey(), xmlDir);
        repositoryToPath.put(CDESFileRepository.ATTACHMENTREPOSITORY.getKey(), attDir);
        repositoryToPath.put(CDESFileRepository.LABELREPOSITORY.getKey(), labDir);
        repositoryToPath.put(CDESFileRepository.ORIGINALDOCUMENTSREPOSITORY.getKey(), orgDir);
        repositoryToPath.put(CDESFileRepository.DOCUMENTREFSREPOSITORY.getKey(), docrefDir);
        ff.setFileRepositoryToPath(repositoryToPath);
        return ff;
    }

    @Override
    public void archiveProject(Integer projectId, String serverPath, Integer signerId, String password) throws WrongPasswordException {
        Project project = this.projectOperations.getProject(projectId);
        CDESCertificate signer = this.certificateDAO.get(signerId);
        ProjectStatusChange last_psc = this.projectDAO.getLastStatusChange(project);
        ProjectStatusChange psc = this.changeProjectStatus(project, 2, signer, password);
        FileFinder exportFileFinder = this.setupLocalFileFinder(serverPath, true);
        File xmlFile = null;
        String sha1_b64 = null;
        FileOutputStream mos = null;
        try {
            xmlFile = exportFileFinder.buildFile(PROJECT_XML_FILENAME, CDESFileRepository.TEMPREPOSITORY);
            sha1_b64 = this.projectArchiveWriter.writeArchiveXml(project, xmlFile);
            File manifestFile = exportFileFinder.buildFile(MANIFEST_XML_FILENAME, CDESFileRepository.TEMPREPOSITORY);
            log.info((Object)("Saving Manifest-File for project [id=" + projectId + "] to file [" + manifestFile.getAbsolutePath() + "]..."));
            mos = new FileOutputStream(manifestFile);
            ContentHandler ch = XMLSerializerHelper.newSerializer((OutputStream)mos);
            ch.startDocument();
            ch.ignorableWhitespace("\n".toCharArray(), 0, 1);
            ch.startElement(null, "manifest", "manifest", null);
            ch.ignorableWhitespace("\n".toCharArray(), 0, 1);
            this.writeValueToXml(ch, "id", psc.getId().toString());
            this.writeValueToXml(ch, "newStatus", Integer.toString(psc.getNewStatus()));
            this.writeValueToXml(ch, "oldStatus", Integer.toString(psc.getOldStatus()));
            this.writeValueToXml(ch, "digest", psc.getDigest());
            ISO8601Format df = new ISO8601Format(ISO8601Format.DATETIME_FORMAT);
            Calendar c = Calendar.getInstance();
            c.setTime(psc.getSignature().getTime());
            this.writeValueToXml(ch, "date", df.format((Object)c));
            this.writeValueToXml(ch, "signedData", psc.getSignature().getContent());
            this.writeValueToXml(ch, "signature", psc.getSignature().getSignature());
            this.writeValueToXml(ch, "certificate", psc.getSignature().getCertificate().getCertificate().replace("\r", ""));
            this.writeValueToXml(ch, "projectId", Integer.toString(psc.getProject().getId()));
            this.writeValueToXml(ch, "projectName", psc.getProject().getName());
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "", "file", "CDATA", PROJECT_XML_FILENAME);
            atts.addAttribute("", "", "algorithm", "CDATA", "SHA-1");
            ch.startElement(null, "exportDigest", "exportDigest", atts);
            ch.characters(sha1_b64.toCharArray(), 0, sha1_b64.length());
            ch.endElement(null, "exportDigest", "exportDigest");
            ch.ignorableWhitespace("\n".toCharArray(), 0, 1);
            ch.endElement(null, "manifest", "manifest");
            ch.endDocument();
            mos.flush();
            ((OutputStream)mos).close();
        }
        catch (IOException e) {
            throw new ActionException("Caught IOException writing manifest.xml, project-Id=[" + project.getId() + "]", e);
        }
        catch (FileHandleException e) {
            throw new ActionException("Caught filehandle exception creating project archive, project-Id=[" + project.getId() + "].", e);
        }
        catch (SQLException e) {
            throw new ActionException("Caught SQLException writing project.xml.", e);
        }
        catch (SAXException e) {
            throw new ActionException("Caught SAXException writing project.xml.", e);
        }
        DocumentVersionSaver saver = new DocumentVersionSaver(project, this.fileFinder, exportFileFinder, this.orderDAO, this.attachmentDAO);
        saver.save();
        Locale locale = new Locale(signer.getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        this.postForwardEMail(project.getNetwork(), "deleteProjectArchiveDataFiles", String.format(locale, i18n.tr("Datensicherung des Projekts %s angefordert"), project.getName()), String.format(locale, i18n.tr("%s %s (%s)\nhat das Projekt\n\n  %s\n\narchiviert und die Sicherung auf ein externes Medium beantragt.\n\nBitte veranlassen Sie die Sicherung der Daten im Verzeichnis\n\n  %s\n\nauf einen externen Datentr\u00e4ger.\nAnschlie\u00dfend l\u00f6schen Sie bitte den Datenbestand des Projekts\nim Men\u00fc\n\n  Netzwerk -> Projekt.\n\nBeim L\u00f6 des Datenbestands wird ein automatisches e-mail\nan die Projektleitung gesendet.\n"), ArchiveServiceImpl.getGenderAttribution(i18n, signer.getOrganisationPerson().getPerson()), signer.getOrganisationPerson().getPerson().getCommonName(), signer.getOrganisationPerson().getOrganisation().getName(), project.getName(), serverPath), signer.getOrganisationPerson());
        this.postConfirmationEMail(last_psc, String.format(locale, i18n.tr("Projekt %s wurde archiviert"), project.getName()), String.format(locale, i18n.tr("%s %s (%s)\nhat das Projekt\n\n  %s\n\narchiviert und die Sicherung auf ein externes Medium beantragt.\n\nDie EDV-Administration wird im n\u00e4chsten Schritt den Datenbestand\ndes Projekt l\u00f6schen. Dabei wird ein automatisches e-mail\nan die Projektleitung gesendet.\n"), ArchiveServiceImpl.getGenderAttribution(i18n, signer.getOrganisationPerson().getPerson()), signer.getOrganisationPerson().getPerson().getCommonName(), signer.getOrganisationPerson().getOrganisation().getName(), project.getName(), serverPath), signer.getOrganisationPerson());
    }

    private void writeValueToXml(ContentHandler ch, String key, String value) throws SAXException {
        ch.startElement(null, key, key, null);
        ch.characters(value.toCharArray(), 0, value.length());
        ch.endElement(null, key, key);
        ch.ignorableWhitespace("\n".toCharArray(), 0, 1);
    }

    @Override
    public void activateProject(Integer projectId, Integer signerId, String password) throws WrongPasswordException {
        Project project = this.projectOperations.getProject(projectId);
        CDESCertificate signer = this.certificateDAO.get(signerId);
        this.changeProjectStatus(project, 0, signer, password);
    }

    @Override
    public void requestRestoreProjectFiles(Integer projectId, Integer signerId, String password) throws WrongPasswordException {
        Project project = this.projectOperations.getProject(projectId);
        CDESCertificate signer = this.certificateDAO.get(signerId);
        this.changeProjectStatus(project, 4, signer, password);
        Locale locale = new Locale(signer.getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        this.postForwardEMail(project.getNetwork(), "restoreProjectArchive", String.format(locale, i18n.tr("Wiederherstellung des Datenbestands des Projekts %s beantragt"), project.getName()), String.format(locale, i18n.tr("%s %s (%s)\nhat die Wiederherstellung des Datenbestands des Projekts\n\n  %s\n\nbeantragt.\n\nBitte veranlassen Sie das Einspielen der externen Sicherung\nin ein Unterverzeichnis des Pfads\n\n  %s\n\nund die anschlie\u00dfende Wiederherstellung des Datenbestands\nim Men\u00fc\n\n  Netzwerk -> Projekt.\n\n"), ArchiveServiceImpl.getGenderAttribution(i18n, signer.getOrganisationPerson().getPerson()), signer.getOrganisationPerson().getPerson().getCommonName(), signer.getOrganisationPerson().getOrganisation().getName(), project.getName(), this.getAllowedBaseDir().getAbsolutePath()), signer.getOrganisationPerson());
    }

    @Override
    public void removeProjectDataFiles(Integer projectId, Integer signerId, String password) throws WrongPasswordException {
        Project project = this.projectOperations.getProject(projectId);
        CDESCertificate signer = this.certificateDAO.get(signerId);
        this.changeProjectStatus(project, 3, signer, password);
        try {
            for (SubProject subProject : project.getSubProjects().values()) {
                if (subProject.getActiveDocumentList() == null) continue;
                for (Document document : subProject.getActiveDocumentList().getDocuments().values()) {
                    for (DocumentVersion dv : document.getAllDocumentVersions()) {
                        File dvFile = this.fileFinder.buildFile(dv.getFileName(), CDESFileRepository.PLANREPOSITORY);
                        if (!dvFile.delete()) {
                            log.error((Object)("Cannot delete file [" + dvFile + "], continuing anyway..."));
                        }
                        List<Attachment> attachments = this.attachmentDAO.getAll(dv.getId());
                        for (Attachment attachment : attachments) {
                            File attFile = this.fileFinder.buildFile(attachment.getFileName(), CDESFileRepository.ATTACHMENTREPOSITORY);
                            if (attFile.delete()) continue;
                            log.error((Object)("Cannot delete file [" + dvFile + "], continuing anyway..."));
                        }
                    }
                    for (DocumentRef ref : document.getDocumentRefs().values()) {
                        File refFile = this.fileFinder.buildFile(ref.getAttachmentFilename(), CDESFileRepository.DOCUMENTREFSREPOSITORY);
                        if (refFile.delete()) continue;
                        log.error((Object)("Cannot delete file [" + refFile + "], continuing anyway..."));
                    }
                }
                Collection<OriginalDocumentOrder> originals = this.orderDAO.getOriginalDocumentOrders(subProject.getId());
                for (OriginalDocumentOrder original : originals) {
                    File origFile;
                    if (original.getFileName() == null || (origFile = this.fileFinder.buildFile(original.getFileName(), CDESFileRepository.ORIGINALDOCUMENTSREPOSITORY)).delete()) continue;
                    log.error((Object)("Cannot delete file [" + origFile + "], continuing anyway..."));
                }
            }
        }
        catch (FileHandleException e) {
            throw new ActionException("Caught filehandle exception", e);
        }
        Locale locale = new Locale(signer.getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        this.postForwardEMail(project.getNetwork(), "requestRestoreProjectArchive", String.format(locale, i18n.tr("Datenbestand des Projekts %s gel\u00f6scht"), project.getName()), String.format(locale, i18n.tr("%s %s (%s)\nhat den Datenbestand des Projekts\n\n  %s\n\nnach der Datensicherung auf ein externes Medium gel\u00f6scht.\n\nSie k\u00f6nnen die Wiederherstellung des Datenbestands jederzeit\nim Men\u00fc\n\n  Netzwerk -> Projekt.\n\nbeantragen.\n"), ArchiveServiceImpl.getGenderAttribution(i18n, signer.getOrganisationPerson().getPerson()), signer.getOrganisationPerson().getPerson().getCommonName(), signer.getOrganisationPerson().getOrganisation().getName(), project.getName()), signer.getOrganisationPerson());
    }

    @Override
    public void restoreProjectFiles(Integer projectId, String serverPath, Integer signerId, String password) throws WrongPasswordException {
        File importDir;
        Project project = this.projectOperations.getProject(projectId);
        CDESCertificate signer = this.certificateDAO.get(signerId);
        ProjectStatusChange last_export_psc = this.projectDAO.getLastExportStatusChange(project);
        FileFinder importFileFinder = this.checkImportDirectory(last_export_psc, importDir = new File(serverPath));
        if (importFileFinder == null) {
            throw new ActionException("The import directory [" + serverPath + "] has been rejected. See log files for details.");
        }
        ProjectStatusChange last_psc = this.projectDAO.getLastStatusChange(project);
        this.changeProjectStatus(project, 5, signer, password);
        DocumentVersionSaver saver = new DocumentVersionSaver(project, importFileFinder, this.fileFinder, this.orderDAO, this.attachmentDAO);
        saver.save();
        Locale locale = new Locale(signer.getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        this.postForwardEMail(project.getNetwork(), "reactivateProjectFromArchive", String.format(locale, i18n.tr("Datenbestand des Projekts %s wiederhergestellt"), project.getName()), String.format(locale, i18n.tr("%s %s (%s)\nhat den Datenbestand des Projekts\n\n  %s\n\nwiederhergestellt.\n\nSie k\u00f6nnen jetzt das Projekt im Men\u00fc\n\n  Netzwerk -> Projekt\n\nwieder aktivieren."), ArchiveServiceImpl.getGenderAttribution(i18n, signer.getOrganisationPerson().getPerson()), signer.getOrganisationPerson().getPerson().getCommonName(), signer.getOrganisationPerson().getOrganisation().getName(), project.getName()), signer.getOrganisationPerson());
        this.postConfirmationEMail(last_psc, String.format(locale, i18n.tr("Datenbestand des Projekts %s wiederhergestellt"), project.getName()), String.format(locale, i18n.tr("%s %s (%s)\nhat den Datenbestand des Projekts\n\n  %s\n\nauf Ihren Antrag hin wiederhergestellt.\n"), ArchiveServiceImpl.getGenderAttribution(i18n, signer.getOrganisationPerson().getPerson()), signer.getOrganisationPerson().getPerson().getCommonName(), signer.getOrganisationPerson().getOrganisation().getName(), project.getName(), serverPath), signer.getOrganisationPerson());
    }

    @Override
    public List<String> getImportableDirectories(Integer projectId) throws ActionException {
        ArrayList<String> importableDirs = new ArrayList<String>();
        Project project = this.projectDAO.get(projectId);
        ProjectStatusChange last_psc = this.projectDAO.getLastExportStatusChange(project);
        File[] possibleDirectories = this.getAllowedBaseDir().listFiles();
        for (int i = 0; i < possibleDirectories.length; ++i) {
            FileFinder importFileFinder = this.checkImportDirectory(last_psc, possibleDirectories[i]);
            if (importFileFinder == null) continue;
            importableDirs.add(possibleDirectories[i].getAbsolutePath());
        }
        return importableDirs;
    }

    private void addDocumentVersionToZip(ZipArchiveOutputStream zos, VisitlessMimeSource ms, DocumentVersion dv, String filenamePostfix, String forcedFilename) {
        IMimeInputStream mimeStream = null;
        try {
            byte[] data;
            do {
                try {
                    mimeStream = ms.getMimeStream(new Object[]{dv.getId()});
                }
                catch (Timeout e) {
                    log.info((Object)("retrieving data for document version [" + dv.getName() + "] time out, retrying..."));
                }
            } while (mimeStream == null);
            String prettyFilename = "";
            prettyFilename = forcedFilename != null ? forcedFilename : ("application/pdf".equals(mimeStream.getMimeType()) ? dv.getName() + filenamePostfix + ".pdf" : dv.getName() + filenamePostfix + "." + dv.getFileType());
            ZipArchiveEntry ze = new ZipArchiveEntry(prettyFilename);
            log.info((Object)("addDocumentVersionToZip for documentVersion [" + dv.getId() + "] adds entry [" + ze + "] to bulk download."));
            zos.putArchiveEntry((ArchiveEntry)ze);
            for (long len = mimeStream.getStreamSize(); len > 0L; len -= (long)data.length) {
                data = mimeStream.readBlock(4096);
                zos.write(data);
            }
            zos.closeArchiveEntry();
        }
        catch (Exception e) {
            log.error((Object)("Caught exception while adding document version [" + dv.getName() + "] to zip file."), (Throwable)e);
            throw new ActionException("Caught exception while adding document version [" + dv.getName() + "] to zip file.", e);
        }
        finally {
            if (mimeStream != null) {
                try {
                    mimeStream.close();
                }
                catch (Throwable e) {
                    log.warn((Object)("Caught exception while closing document version [" + dv.getName() + "] added to zip file."), e);
                }
            }
        }
    }

    private void addDocumentReferenceToZip(DocumentRef ref, ZipArchiveOutputStream zos, String fn) {
        if (ref.getAttachmentFilename() != null) {
            try {
                int length;
                ZipArchiveEntry ze = new ZipArchiveEntry(fn);
                log.info((Object)("addDocumentReferenceToZip for documentReference [" + ref.getId() + "] adds entry [" + ze + "] to bulk download."));
                File attFile = this.fileFinder.buildFile(ref.getAttachmentFilename(), CDESFileRepository.DOCUMENTREFSREPOSITORY);
                FileInputStream fis = new FileInputStream(attFile);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((length = fis.read(buffer)) >= 0) {
                    bos.write(buffer, 0, length);
                }
                zos.putArchiveEntry((ArchiveEntry)ze);
                byte[] ba = bos.toByteArray();
                zos.write(ba);
                zos.closeArchiveEntry();
            }
            catch (IOException e) {
                throw new ActionException("Caught exception while adding document reference [" + ref.getAttachmentOriginalFilename() + "] to zip file.", e);
            }
            catch (FileHandleException e) {
                throw new ActionException("Caught exception while adding document reference [" + ref.getAttachmentOriginalFilename() + "] to zip file.", e);
            }
        }
    }

    private void addAttachmentToZip(Attachment attachment, ZipArchiveOutputStream zos, String filename) {
        if (attachment.isRedliningDelta()) {
            return;
        }
        try {
            int length;
            ZipArchiveEntry ze = new ZipArchiveEntry(filename);
            log.info((Object)("addAttachmentToZip for attachment [" + attachment.getId() + "] adds entry [" + ze + "] to bulk download."));
            File attFile = this.fileFinder.buildFile(attachment.getFileName(), CDESFileRepository.ATTACHMENTREPOSITORY);
            FileInputStream fis = new FileInputStream(attFile);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) >= 0) {
                bos.write(buffer, 0, length);
            }
            zos.putArchiveEntry((ArchiveEntry)ze);
            byte[] ba = bos.toByteArray();
            zos.write(ba);
            zos.closeArchiveEntry();
        }
        catch (IOException e) {
            throw new ActionException("Caught exception while adding attachment [" + attachment.getOriginalName() + "] to zip file.", e);
        }
        catch (FileHandleException e) {
            throw new ActionException("Caught exception while adding attachment [" + attachment.getOriginalName() + "] to zip file.", e);
        }
    }

    private void addReviewProtocollPdfToZip(ZipArchiveOutputStream zos, String[] serviceParameter, Locale locale, String fn, String tabSessionId) {
        try {
            URL contextUrl = new URL(this.applicationUrl);
            String urlString = "/cdes/app";
            urlString = UrlHelper.appendQueryParameterToUrl((String)urlString, (String)"service", (String)"OOo2PDFService/3/ArchiveReviewProtocollOOo/pdf/reviewProtocoll");
            if (serviceParameter != null) {
                for (int n = 0; n < serviceParameter.length; ++n) {
                    urlString = UrlHelper.appendQueryParameterToUrl((String)urlString, (String)"sp", (String)serviceParameter[n]);
                }
            }
            urlString = UrlHelper.appendQueryParameterToUrl((String)urlString, (String)"ts", (String)tabSessionId);
            String cookie = (String)ThreadLocalManager.getBoundResource((String)this.cookieThreadLocalKey);
            URL url = new URL(contextUrl, urlString);
            URLConnection connection = url.openConnection();
            connection.addRequestProperty("Cookie", cookie);
            byte[] dataAsByteArray = IOUtils.toByteArray((InputStream)connection.getInputStream());
            ZipArchiveEntry ze = new ZipArchiveEntry(fn);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding entry [" + ze + "] to bulk download."));
            }
            zos.putArchiveEntry((ArchiveEntry)ze);
            zos.write(dataAsByteArray);
            zos.closeArchiveEntry();
        }
        catch (Exception e) {
            log.error((Object)"Caught exception while adding page ReviewProtocoll pdf to zip file.", (Throwable)e);
            throw new ActionException("Caught exception while adding page ReviewProtocoll pdf to zip file.", e);
        }
    }

    @Override
    public CDESDataFile getBulkDownload(Integer projectId, Integer signerId, Integer activeSubProjectId, ReviewCycleStatusSearch search, String mimeSource, boolean allDocumentVersions) {
        List documentVersions = this.reviewOperations.getDocumentHighestVersions(activeSubProjectId, search);
        SubProject subProject = this.subProjectDAO.get(activeSubProjectId);
        String prj = subProject.getProject().getCode().replace(' ', '_').replace('/', '_').replace('\\', '_');
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss_SSS");
        CDESDataFile ret = new CDESDataFile("cdes_download_" + prj + "_" + df.format(new Date()) + ".zip", CDESFileRepository.TEMPREPOSITORY);
        if (!projectId.equals(subProject.getProject().getId())) {
            throw new ActionException("project and subProject Ids do not match.");
        }
        log.info((Object)("Starting assembly of bulk download [" + ret + "]..."));
        File tmpFile = null;
        ZipArchiveOutputStream zos = null;
        try {
            tmpFile = this.fileFinder.buildFile(ret);
            zos = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(tmpFile));
            zos.setEncoding("CP437");
            zos.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NOT_ENCODEABLE);
            VisitlessMimeSource ms = this.mimeSourceFactory.getMimeSource(mimeSource);
            boolean pdf = ms instanceof AbstractDocumentVersionPdfMimeSource;
            for (DocumentVersion dv : documentVersions) {
                if (allDocumentVersions) {
                    ArrayList<DocumentVersion> deletedDocumentVersions = new ArrayList<DocumentVersion>();
                    for (DocumentVersion dv2 : dv.getDocument().getAllDocumentVersions()) {
                        String statusPostfix = "";
                        Integer postfixIncrementer = 0;
                        if (dv2.getStatus() == 7) {
                            statusPostfix = "(deleted)";
                            for (DocumentVersion ddv : deletedDocumentVersions) {
                                if (!ddv.getName().equals(dv2.getName())) continue;
                                Integer n = postfixIncrementer;
                                postfixIncrementer = postfixIncrementer + 1;
                            }
                            if (postfixIncrementer > 0) {
                                statusPostfix = "(deleted-" + postfixIncrementer + ")";
                            }
                            deletedDocumentVersions.add(dv2);
                        }
                        if (!pdf || ConfigurationHelper.isFileTypeSupportedForPreview(dv.getFileType())) {
                            this.addDocumentVersionToZip(zos, ms, dv2, statusPostfix, null);
                            continue;
                        }
                        log.info((Object)("Skipping non-previewable document version [" + dv2.getName() + "] in bulk download."));
                    }
                    continue;
                }
                if (!pdf || ConfigurationHelper.isFileTypeSupportedForPreview(dv.getFileType())) {
                    this.addDocumentVersionToZip(zos, ms, dv, "", null);
                    continue;
                }
                log.info((Object)("Skipping non-previewable document version [" + dv.getName() + "] in bulk download."));
            }
            zos.close();
            zos = null;
            tmpFile.deleteOnExit();
            tmpFile = null;
            log.info((Object)("Assembly of bulk download [" + ret + "] has successfully been finished."));
            CDESDataFile cDESDataFile = ret;
            return cDESDataFile;
        }
        catch (IOException e) {
            throw new ActionException("Caught I/O exception", e);
        }
        catch (FileHandleException e) {
            throw new ActionException("Caught filehandle exception", e);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error closing zip output stream for file [" + tmpFile + "]"), (Throwable)e);
                }
            }
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    @Override
    public ArchiveEstimation getArchiveSizeEstimate(Integer activeSubProjectId, ReviewCycleStatusSearch search, int archiveType, boolean withReviewHistory, boolean allDocumentVersions) {
        List documentVersions = this.reviewOperations.getDocumentHighestVersions(activeSubProjectId, search);
        long totalLength = 100000L;
        double pdfConversionFactor = 1.0;
        long reviewProtocollEstimate = 300000L;
        int fileCount = 0;
        boolean hasError = false;
        for (DocumentVersion dv : documentVersions) {
            if (allDocumentVersions) {
                for (DocumentVersion dv2 : dv.getDocument().getAllDocumentVersions()) {
                    File file;
                    try {
                        file = this.fileFinder.findFile(dv2.getFileName(), CDESFileRepository.PLANREPOSITORY);
                    }
                    catch (FileHandleException e) {
                        log.error((Object)("Caught Exception trying to find file  with fileName=[" + dv2.getFileName() + "] for documentVersion=[" + dv2.getName() + "]"));
                        hasError = true;
                        continue;
                    }
                    if (file == null || !file.exists()) {
                        hasError = true;
                        continue;
                    }
                    boolean isOriginalPdf = dv2.getFileType() != null && dv2.getFileType().toLowerCase().equals("pdf");
                    long documentVersionFileLength = file.length();
                    switch (archiveType) {
                        case 0: {
                            totalLength += documentVersionFileLength;
                            ++fileCount;
                            break;
                        }
                        case 1: {
                            totalLength = (long)((double)totalLength + (isOriginalPdf ? (double)documentVersionFileLength : (double)documentVersionFileLength * pdfConversionFactor));
                            ++fileCount;
                            break;
                        }
                        case 2: {
                            totalLength = (long)((double)totalLength + (isOriginalPdf ? (double)(documentVersionFileLength * 2L) : (double)documentVersionFileLength * pdfConversionFactor + (double)documentVersionFileLength));
                            fileCount += isOriginalPdf ? 1 : 2;
                            break;
                        }
                    }
                    if (!withReviewHistory) continue;
                    try {
                        Pair<Integer, Long> reviewHistoryFilesEstimate = this.getReviewHistoryFilesEstimate(dv2, documentVersionFileLength);
                        totalLength += ((Long)reviewHistoryFilesEstimate.getSecond()).longValue();
                        fileCount += ((Integer)reviewHistoryFilesEstimate.getFirst()).intValue();
                    }
                    catch (FileHandleException e) {
                        log.error((Object)("Caught Exception trying to estimate the review history of documentVersion [" + dv2.getName() + "]"));
                    }
                }
            } else {
                File file = null;
                try {
                    file = this.fileFinder.findFile(dv.getFileName(), CDESFileRepository.PLANREPOSITORY);
                }
                catch (FileHandleException e) {
                    log.error((Object)"");
                    continue;
                }
                if (file == null || !file.exists()) {
                    log.error((Object)("Could not find file with path [" + dv.getFileName() + "]"));
                    continue;
                }
                boolean isOriginalPdf = dv.getFileType() != null && dv.getFileType().toLowerCase().equals("pdf");
                long documentVersionFileLength = file.length();
                switch (archiveType) {
                    case 0: {
                        totalLength = (long)((double)totalLength + (isOriginalPdf ? (double)documentVersionFileLength * this.pdfZipCompressionFactorEstimate : (double)documentVersionFileLength * this.pltZipCompressionFactorEstimate));
                        ++fileCount;
                        break;
                    }
                    case 1: {
                        totalLength = (long)((double)totalLength + (double)documentVersionFileLength * this.pdfZipCompressionFactorEstimate);
                        ++fileCount;
                        break;
                    }
                    case 2: {
                        totalLength = (long)((double)totalLength + (isOriginalPdf ? (double)documentVersionFileLength * this.pdfZipCompressionFactorEstimate * 2.0 : (double)documentVersionFileLength * this.pdfZipCompressionFactorEstimate + (double)documentVersionFileLength * this.pltZipCompressionFactorEstimate));
                        fileCount += isOriginalPdf ? 1 : 2;
                        break;
                    }
                }
                if (withReviewHistory) {
                    try {
                        Pair<Integer, Long> reviewHistoryFilesEstimate = this.getReviewHistoryFilesEstimate(dv, documentVersionFileLength);
                        totalLength += ((Long)reviewHistoryFilesEstimate.getSecond()).longValue();
                        fileCount += ((Integer)reviewHistoryFilesEstimate.getFirst()).intValue();
                    }
                    catch (FileHandleException e) {
                        log.error((Object)("Caught Exception trying to estimate the review history of documentVersion [" + dv.getName() + "]"));
                    }
                }
            }
            if (!withReviewHistory) continue;
            totalLength += reviewProtocollEstimate;
            ++fileCount;
        }
        long usableDiskSpaceKB = this.getUsableDiskSpace();
        double usableDiskSpaceMB = usableDiskSpaceKB > 0L ? (double)usableDiskSpaceKB / 1024.0 : -1.0;
        double totalFileSizeMB = (double)totalLength / 1024.0 / 1024.0;
        log.info((Object)String.format("Archive-Estimate [ArchiveType=%s] [withReviewHistory=%s] [allDocumentVersions=%s]: %s total files, %s MB size, %s MB usable disk space.", archiveType == 0 ? "original" : (archiveType == 1 ? "PDF" : "both"), withReviewHistory ? "yes" : "no", allDocumentVersions ? "yes" : "no", fileCount, totalFileSizeMB, usableDiskSpaceMB));
        return new ArchiveEstimation(fileCount, totalFileSizeMB, usableDiskSpaceMB);
    }

    private Pair<Integer, Long> getReviewHistoryFilesEstimate(DocumentVersion dv, long documentFileSize) throws FileHandleException {
        long totalLength = 0L;
        int filesCount = 0;
        List<Attachment> attachments = this.attachmentDAO.getAll(dv.getId(), null, false);
        for (Attachment att : attachments) {
            File file = this.fileFinder.findFile(att.getFileName(), CDESFileRepository.ATTACHMENTREPOSITORY);
            if (file == null || !file.exists()) {
                throw new FileHandleException("Could not find file with path [" + dv.getFileName() + "]");
            }
            totalLength += file.length();
            ++filesCount;
        }
        List<Attachment> redlinings = this.attachmentDAO.getAll(dv.getId(), null, true);
        if (!redlinings.isEmpty()) {
            totalLength += documentFileSize;
            ++filesCount;
        }
        ArrayList<DocumentRef> docRefs = new ArrayList<DocumentRef>(dv.getDocument().getDocumentRefs().values());
        for (DocumentRef ref : docRefs) {
            if (ref.getAttachmentFilename() == null || ref.getAttachmentFilename().isEmpty()) continue;
            File refFile = this.fileFinder.buildFile(ref.getAttachmentFilename(), CDESFileRepository.DOCUMENTREFSREPOSITORY);
            if (refFile == null || !refFile.exists()) {
                throw new FileHandleException("Could not find document reference file with path [" + dv.getFileName() + "]");
            }
            totalLength += refFile.length();
            ++filesCount;
        }
        return new Pair((Object)filesCount, (Object)totalLength);
    }

    @Override
    public long getUsableDiskSpace() {
        try {
            if (ConfigurationHelper.getOperationSystemStatic().equals((Object)OperatingSystem.UNIX)) {
                return FileSystemUtils.freeSpace((String)this.cdesDataFilesRoot);
            }
            return FileSystemUtils.freeSpace((String)this.cdesDataFilesRoot) / 1024L;
        }
        catch (Exception e) {
            log.error((Object)("Could not get usable space for directory [" + this.cdesDataFilesRoot + "]"));
            return -1L;
        }
    }

    @Override
    public CDESDataFile getPlotOrderDeliveryNoteBulkDownload(Integer projectId, Integer plotOrderId, long plottOrderNumber, ArchiveJobStatus status, Integer userCertificateId, String tabSessionId) {
        PlottOrder plottOrder = this.orderDAO.getPlottOrder(plotOrderId);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss_SSS");
        CDESDataFile ret = new CDESDataFile("cdes_download_" + plottOrder.getProject().getId() + "_" + df.format(new Date()) + ".zip", CDESFileRepository.TEMPREPOSITORY);
        log.info((Object)("creating bulk dowload for plotOrderDeliveryNotes with filename=[" + ret.getPath() + "]"));
        Locale projectLocale = new Locale(plottOrder.getProject().getLocalisation().getCountry().getCode2());
        ArrayList items = new ArrayList(plottOrder.getOrderItems().values());
        Collections.sort(items, new OrderAddressComparator(projectLocale, true));
        ArrayList<Pair> orderAddressPairs = new ArrayList<Pair>();
        ArrayList<PlottOrderItem> currentList = new ArrayList<PlottOrderItem>();
        OrderAddress currentAddress = null;
        for (PlottOrderItem item : items) {
            if (!(currentAddress == null || item.getDeliveryAddress().getOrganisationName().equals(currentAddress.getOrganisationName()) && (item.getDeliveryAddress().getGivenName() + item.getDeliveryAddress().getSurName()).equals(currentAddress.getGivenName() + currentAddress.getSurName()) && (item.getDeliveryAddress().getPostalAddress() + item.getDeliveryAddress().getPostalCode() + item.getDeliveryAddress().getLocalityName()).equals(currentAddress.getPostalAddress() + currentAddress.getPostalCode() + currentAddress.getLocalityName()))) {
                orderAddressPairs.add(new Pair((Object)currentAddress, currentList));
                currentList = new ArrayList();
            }
            currentAddress = item.getDeliveryAddress();
            currentList.add(item);
        }
        if (currentAddress != null) {
            orderAddressPairs.add(new Pair(currentAddress, currentList));
        }
        File tmpFile = null;
        ZipArchiveOutputStream zos = null;
        try {
            tmpFile = this.fileFinder.buildFile(ret);
            tmpFile.deleteOnExit();
            zos = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(tmpFile));
            zos.setEncoding("CP437");
            zos.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NOT_ENCODEABLE);
            status.setTotalFiles(orderAddressPairs.size());
            status.setPackedFiles(0);
            int index = 1;
            for (Pair pair : orderAddressPairs) {
                String deliveryNoteFilename = "DeliveryNote_" + index + ".pdf";
                log.info((Object)("adding deliveryNote [" + deliveryNoteFilename + "] for orderAddress [" + ((OrderAddress)pair.getFirst()).getId() + "]"));
                ++index;
                status.increment();
                this.addPlotOrderDeliveryNoteToZip(plottOrder.getId(), ((OrderAddress)pair.getFirst()).getId(), projectLocale, deliveryNoteFilename, zos, tabSessionId);
            }
            zos.close();
            zos = null;
            tmpFile.deleteOnExit();
            tmpFile = null;
            File archiveFile = this.fileFinder.findFile(ret);
            status.setArchiveFileSize(archiveFile.length());
        }
        catch (Exception e) {
            log.error((Object)"Could not complete plot order delivery note bulk download", (Throwable)e);
        }
        return ret;
    }

    public void addPlotOrderDeliveryNoteToZip(Integer orderId, Integer orderAddressId, Locale locale, String deliveryNoteFilename, ZipArchiveOutputStream zos, String tabSessionId) throws Exception {
        URL contextUrl = new URL(this.applicationUrl);
        String urlString = "/cdes/app";
        urlString = UrlHelper.appendQueryParameterToUrl((String)urlString, (String)"service", (String)"OOo2PDFService/3/PlotOrderDeliveryNoteOOo/pdf/showProject");
        urlString = UrlHelper.appendQueryParameterToUrl((String)urlString, (String)"sp", (String)orderId.toString());
        urlString = UrlHelper.appendQueryParameterToUrl((String)urlString, (String)"sp", (String)"0");
        urlString = UrlHelper.appendQueryParameterToUrl((String)urlString, (String)"sp", (String)orderAddressId.toString());
        urlString = UrlHelper.appendQueryParameterToUrl((String)urlString, (String)"ts", (String)tabSessionId);
        URL url = new URL(contextUrl, urlString);
        URLConnection connection = url.openConnection();
        String cookie = (String)ThreadLocalManager.getBoundResource((String)this.cookieThreadLocalKey);
        connection.addRequestProperty("Cookie", cookie);
        byte[] dataAsByteArray = IOUtils.toByteArray((InputStream)connection.getInputStream());
        ZipArchiveEntry ze = new ZipArchiveEntry(deliveryNoteFilename);
        log.info((Object)("Adding entry [" + ze + "] to bulk download."));
        zos.putArchiveEntry((ArchiveEntry)ze);
        zos.write(dataAsByteArray);
        zos.closeArchiveEntry();
    }

    @Override
    public CDESDataFile getArchiveBulkDownload(Integer projectId, Integer signerId, Integer activeSubProjectId, ReviewCycleStatusSearch search, int archiveType, boolean withReviewHistory, boolean allDocumentVersions, ArchiveJobStatus status, String tabSessionId) {
        List documentVersions = this.reviewOperations.getDocumentHighestVersions(activeSubProjectId, search);
        SubProject subProject = this.subProjectDAO.get(activeSubProjectId);
        String prj = subProject.getProject().getCode().replace(' ', '_').replace('/', '_').replace('\\', '_');
        Locale projectLocale = new Locale(subProject.getProject().getLocalisation().getCountry().getCode2());
        I18n i18n = I18nFactory.getI18n(projectLocale);
        SimpleDateFormat statusDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss_SSS");
        CDESDataFile ret = new CDESDataFile("cdes_download_" + prj + "_" + df.format(new Date()) + ".zip", CDESFileRepository.TEMPREPOSITORY);
        if (!projectId.equals(subProject.getProject().getId())) {
            throw new ActionException("project and subProject Ids do not match.");
        }
        log.info((Object)("Starting assembly of bulk download [" + ret + "]..."));
        File tmpFile = null;
        ZipArchiveOutputStream zos = null;
        HashMap<Integer, ArchiveBulkDownloadEntry> archiveEntries = new HashMap<Integer, ArchiveBulkDownloadEntry>();
        try {
            tmpFile = this.fileFinder.buildFile(ret);
            tmpFile.deleteOnExit();
            zos = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(tmpFile));
            zos.setEncoding("CP437");
            zos.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NOT_ENCODEABLE);
            zos.setUseZip64(Zip64Mode.Always);
            VisitlessMimeSource documentVersionMimeSource = this.mimeSourceFactory.getMimeSource("documentVersionMimeSource");
            VisitlessMimeSource pdfMimeSource = this.mimeSourceFactory.getMimeSource("documentVersionPdfMimeSource");
            VisitlessMimeSource redliningMimeSource = this.mimeSourceFactory.getMimeSource("documentVersionReviewProtocolPdfMimeSource");
            for (DocumentVersion dv : documentVersions) {
                boolean hasFiles = false;
                ArchiveBulkDownloadEntry lastVersion = new ArchiveBulkDownloadEntry(dv.getId());
                if (allDocumentVersions) {
                    for (DocumentVersion dv2 : dv.getDocument().getAllDocumentVersions()) {
                        String fileName;
                        ArchiveBulkDownloadEntry currentVersion = null;
                        currentVersion = dv2.getId().equals(lastVersion.getDocumentVersionId()) ? lastVersion : new ArchiveBulkDownloadEntry(dv2.getId());
                        if (archiveType == 2 || archiveType == 0) {
                            fileName = ArchiveHelper.getDocumentVersionFilename(dv2, i18n, withReviewHistory ? 1 : 2, false);
                            try {
                                this.addDocumentVersionToZip(zos, documentVersionMimeSource, dv2, null, fileName);
                                currentVersion.setDocumentPath(fileName);
                                if (dv2.getFileType() != null && dv2.getFileType().equalsIgnoreCase("pdf")) {
                                    currentVersion.setPdfPreviewPath(fileName);
                                }
                            }
                            catch (ActionException e) {
                                status.getErrorMessages().add(String.format(i18n.tr("Die Datei %s konnte nicht interpretiert werden."), dv2.getName() + "." + dv2.getFileType()));
                            }
                            status.increment();
                            hasFiles = true;
                        }
                        if (dv2.getFileType() != null && !dv2.getFileType().equalsIgnoreCase("pdf") && archiveType == 2 || archiveType == 1) {
                            if (ConfigurationHelper.isFileTypeSupportedForPreview(dv.getFileType())) {
                                fileName = ArchiveHelper.getDocumentVersionFilename(dv2, i18n, withReviewHistory ? 1 : 2, true);
                                try {
                                    this.addDocumentVersionToZip(zos, pdfMimeSource, dv2, null, fileName);
                                    currentVersion.setPdfPreviewPath(fileName);
                                }
                                catch (ActionException e) {
                                    status.getErrorMessages().add(String.format(i18n.tr("Die Datei %s konnte nicht interpretiert werden."), dv2.getName() + ".pdf"));
                                }
                                status.increment();
                                hasFiles = true;
                            } else {
                                log.info((Object)("Skipping non-previewable document version [" + dv2.getName() + "] in bulk download."));
                            }
                        }
                        if (!withReviewHistory || currentVersion.getDocumentPath() == null && currentVersion.getPdfPreviewPath() == null) continue;
                        List<Attachment> attachments = this.attachmentDAO.getAll(dv2.getId(), null, false);
                        for (Attachment att : attachments) {
                            String attachmentFilename = ArchiveHelper.getAttachmentFilename(att, dv2, i18n, withReviewHistory ? 1 : 2);
                            try {
                                this.addAttachmentToZip(att, zos, attachmentFilename);
                                status.increment();
                                currentVersion.getAttachments().put(att.getId(), attachmentFilename);
                            }
                            catch (Exception e) {
                                status.getErrorMessages().add(String.format(i18n.tr("Der Dateianhang mit dem Dateinamen %s f\u00fcr den Plan %s konnte nicht gefunden werden."), att.getFileName(), dv2.getName()));
                            }
                        }
                        List<Attachment> redlinings = this.attachmentDAO.getAll(dv2.getId(), null, true);
                        if (!redlinings.isEmpty()) {
                            String redliningFilename = ArchiveHelper.getRedliningFilename(dv2, i18n, withReviewHistory ? 1 : 2);
                            try {
                                this.addDocumentVersionToZip(zos, redliningMimeSource, dv2, null, redliningFilename);
                                currentVersion.getRedlinings().put(dv2.getId(), redliningFilename);
                            }
                            catch (ActionException e) {
                                status.getErrorMessages().add(String.format(i18n.tr("Die grafische Planpr\u00fcfung den Plan %s konnte nicht erstellt werden."), dv2.getName()));
                            }
                            status.increment();
                        }
                        if (lastVersion.getDocumentVersionId().equals(currentVersion.getDocumentVersionId())) continue;
                        lastVersion.getPreviousVersions().put(currentVersion.getDocumentVersionId(), currentVersion);
                    }
                } else {
                    String fileName;
                    if (archiveType == 2 || archiveType == 0) {
                        fileName = ArchiveHelper.getDocumentVersionFilename(dv, i18n, withReviewHistory ? 1 : 2, false);
                        try {
                            this.addDocumentVersionToZip(zos, documentVersionMimeSource, dv, null, fileName);
                            lastVersion.setDocumentPath(fileName);
                        }
                        catch (ActionException e) {
                            status.getErrorMessages().add(String.format(i18n.tr("Die Datei %s konnte nicht interpretiert werden."), dv.getName() + "." + dv.getFileType()));
                        }
                        status.increment();
                        hasFiles = true;
                    }
                    if (dv.getFileType() != null && !dv.getFileType().equalsIgnoreCase("pdf") && archiveType == 2 || archiveType == 1) {
                        if (ConfigurationHelper.isFileTypeSupportedForPreview(dv.getFileType())) {
                            fileName = ArchiveHelper.getDocumentVersionFilename(dv, i18n, withReviewHistory ? 1 : 2, true);
                            try {
                                this.addDocumentVersionToZip(zos, pdfMimeSource, dv, null, fileName);
                                lastVersion.setPdfPreviewPath(fileName);
                            }
                            catch (ActionException e) {
                                status.getErrorMessages().add(String.format(i18n.tr("Die Datei %s konnte nicht interpretiert werden."), dv.getName() + ".pdf"));
                            }
                            status.increment();
                            hasFiles = true;
                        } else {
                            log.info((Object)("Skipping non-previewable document version [" + dv.getName() + "] in bulk download."));
                        }
                    }
                    if (withReviewHistory && (lastVersion.getDocumentPath() != null || lastVersion.getPdfPreviewPath() != null)) {
                        List<Attachment> attachments = this.attachmentDAO.getAll(dv.getId(), null, false);
                        for (Attachment att : attachments) {
                            String attachmentFilename = ArchiveHelper.getAttachmentFilename(att, dv, i18n, withReviewHistory ? 1 : 2);
                            try {
                                this.addAttachmentToZip(att, zos, attachmentFilename);
                                lastVersion.getAttachments().put(att.getId(), attachmentFilename);
                            }
                            catch (ActionException e) {
                                status.getErrorMessages().add(String.format(i18n.tr("Der Dateianhang mit dem Dateinamen %s f\u00fcr den Plan %s konnte nicht gefunden werden."), att.getFileName(), dv.getName()));
                            }
                            status.increment();
                        }
                        List<Attachment> redlinings = this.attachmentDAO.getAll(dv.getId(), null, true);
                        if (!redlinings.isEmpty()) {
                            String redliningFilename = ArchiveHelper.getRedliningFilename(dv, i18n, withReviewHistory ? 1 : 2);
                            try {
                                this.addDocumentVersionToZip(zos, redliningMimeSource, dv, null, redliningFilename);
                                lastVersion.getRedlinings().put(dv.getId(), redliningFilename);
                            }
                            catch (ActionException e) {
                                status.getErrorMessages().add(String.format(i18n.tr("Die grafische Planpr\u00fcfung den Plan %s konnte nicht erstellt werden."), dv.getName()));
                            }
                            status.increment();
                        }
                    }
                }
                if (!hasFiles) continue;
                if (withReviewHistory && (!dv.isDeleted() || dv.isDeleted() && !dv.getDocument().getDocumentVersions().isEmpty())) {
                    String reviewProtocolFileName = ArchiveHelper.getReviewProtocollFilename(dv, i18n, withReviewHistory ? 1 : 2);
                    String[] serviceParameters = new String[]{dv.getId().toString(), "" + archiveType, allDocumentVersions ? "1" : "0"};
                    try {
                        this.addReviewProtocollPdfToZip(zos, serviceParameters, projectLocale, reviewProtocolFileName, tabSessionId);
                    }
                    catch (Exception e) {
                        log.error((Object)("Error creating review protocoll for documentVersion [" + dv.getName() + "]"), (Throwable)e);
                        status.getErrorMessages().add(String.format(i18n.tr("Beim Erstellen des Pr\u00fcfprotokolls f\u00fcr das Dokument \"%s\" ist ein Fehler aufgetreten."), dv.getDocument().getName()));
                    }
                    status.increment();
                    lastVersion.setReviewProtocolPath(reviewProtocolFileName);
                    ArrayList<DocumentRef> docRefs = new ArrayList<DocumentRef>(dv.getDocument().getDocumentRefs().values());
                    for (DocumentRef ref : docRefs) {
                        String docRefPath = ArchiveHelper.getDocumentReferenceFilename(ref, dv, i18n, withReviewHistory ? 1 : 2);
                        try {
                            this.addDocumentReferenceToZip(ref, zos, docRefPath);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error creating DocumentRef [" + ref.getAttachmentFilename() + "] for documentVersion [" + dv.getName() + "]"), (Throwable)e);
                            status.getErrorMessages().add(String.format(i18n.tr("Die Verwendete Unterlage %s zu Dokument %s konnte nicht gefunden/interpretiert werden."), ref.getAttachmentOriginalFilename() + "." + ref.getAttachmentFiletype(), dv.getName()));
                        }
                        status.increment();
                        lastVersion.getDocumentRefs().put(ref.getId(), docRefPath);
                    }
                }
                lastVersion.setName(dv.getName());
                lastVersion.setTitle(dv.getDocument().getContent());
                lastVersion.setPlanner(dv.getDocument().getObjectPlanner().getPlanner().getMainParticipant().getOrganisationPerson().getOrganisation().getName());
                lastVersion.setObject(dv.getDocument().getObjectPlanner().getObject().getCode() + " " + dv.getDocument().getObjectPlanner().getObject().getName());
                lastVersion.setObjectplanner(dv.getDocument().getObjectPlanner().getCode() + " " + dv.getDocument().getObjectPlanner().getArea());
                lastVersion.setObjectkm(dv.getDocument().getObjectPlanner().getObject().getStretchKmFrom() + " - " + dv.getDocument().getObjectPlanner().getObject().getStretchKmTo());
                lastVersion.setStatus(DocumentTranslator.getStatusName(i18n, dv.getStatus()));
                if (dv.isReleased()) {
                    ReviewCyclePositionResult latestPositionResult = this.reviewOperations.getLatestPositionResultOfDocumentVersion(dv.getId());
                    if (latestPositionResult == null) {
                        ReviewCycleNodeResult nodeResult = this.reviewOperations.getReviewCycleNodeResult(dv.getActualReviewCycleNode(), dv);
                        if (nodeResult != null) {
                            lastVersion.setStatusSuffix("[" + statusDateFormat.format(nodeResult.getDocumentArrivalDate()) + "]");
                        }
                    } else if (latestPositionResult.getReviewCycleResultOption() != null && latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus() != null && latestPositionResult.getReviewCycleResultOption().getDocumentVersionStatus().equals(2)) {
                        lastVersion.setStatusSuffix("[" + statusDateFormat.format(latestPositionResult.getResultDate()) + "]");
                    }
                }
                archiveEntries.put(dv.getId(), lastVersion);
            }
            try {
                ArchiveTableOfContentsWriter writer = new ArchiveTableOfContentsWriter(i18n);
                writer.writeTableOfContents(zos, archiveEntries.values(), projectLocale, subProject, status, this.enableCustomerLogo);
                String prefix = "at/cdes/archive/html/";
                this.writeRessourceToZip(zos, prefix + "archive.css", ArchiveHelper.getHTMLRessourcePath(i18n, "archive.css"));
                this.writeRessourceToZip(zos, prefix + "table.js", ArchiveHelper.getHTMLRessourcePath(i18n, "table.js"));
                this.writeRessourceToZip(zos, prefix + "bgImageTop.png", ArchiveHelper.getHTMLRessourcePath(i18n, "bgImageTop.png"));
                this.writeRessourceToZip(zos, prefix + "li_o_c8.jpg", ArchiveHelper.getHTMLRessourcePath(i18n, "li_o_c8.jpg"));
                this.writeRessourceToZip(zos, prefix + "li_o_f3.jpg", ArchiveHelper.getHTMLRessourcePath(i18n, "li_o_f3.jpg"));
                this.writeRessourceToZip(zos, prefix + "li_u_c8.jpg", ArchiveHelper.getHTMLRessourcePath(i18n, "li_u_c8.jpg"));
                this.writeRessourceToZip(zos, prefix + "li_u_f3.jpg", ArchiveHelper.getHTMLRessourcePath(i18n, "li_u_f3.jpg"));
                this.writeRessourceToZip(zos, prefix + "logoCdes.png", ArchiveHelper.getHTMLRessourcePath(i18n, "logoCdes.png"));
                this.writeRessourceToZip(zos, prefix + "planvorschau_pdf.gif", ArchiveHelper.getHTMLRessourcePath(i18n, "planvorschau_pdf.gif"));
                this.writeRessourceToZip(zos, prefix + "pruefprotokoll.gif", ArchiveHelper.getHTMLRessourcePath(i18n, "pruefprotokoll.gif"));
                this.writeRessourceToZip(zos, prefix + "re_o_c8.jpg", ArchiveHelper.getHTMLRessourcePath(i18n, "re_o_c8.jpg"));
                this.writeRessourceToZip(zos, prefix + "re_o_f3.jpg", ArchiveHelper.getHTMLRessourcePath(i18n, "re_o_f3.jpg"));
                this.writeRessourceToZip(zos, prefix + "re_u_c8.jpg", ArchiveHelper.getHTMLRessourcePath(i18n, "re_u_c8.jpg"));
                this.writeRessourceToZip(zos, prefix + "re_u_f3.jpg", ArchiveHelper.getHTMLRessourcePath(i18n, "re_u_f3.jpg"));
                this.writeRessourceToZip(zos, prefix + "sortable.gif", ArchiveHelper.getHTMLRessourcePath(i18n, "sortable.gif"));
                this.writeRessourceToZip(zos, prefix + "sorted_down.gif", ArchiveHelper.getHTMLRessourcePath(i18n, "sorted_down.gif"));
                this.writeRessourceToZip(zos, prefix + "sorted_up.gif", ArchiveHelper.getHTMLRessourcePath(i18n, "sorted_up.gif"));
                this.writeRessourceToZip(zos, prefix + "speichern.gif", ArchiveHelper.getHTMLRessourcePath(i18n, "speichern.gif"));
                this.writeRessourceToZip(zos, prefix + "tab_li_o_C8C8C8.jpg", ArchiveHelper.getHTMLRessourcePath(i18n, "tab_li_o_C8C8C8.jpg"));
                this.writeRessourceToZip(zos, prefix + "tab_li_o.jpg", ArchiveHelper.getHTMLRessourcePath(i18n, "tab_li_o.jpg"));
                this.writeRessourceToZip(zos, prefix + "tab_li_u_C8C8C8.jpg", ArchiveHelper.getHTMLRessourcePath(i18n, "tab_li_u_C8C8C8.jpg"));
                this.writeRessourceToZip(zos, prefix + "tab_li_u.jpg", ArchiveHelper.getHTMLRessourcePath(i18n, "tab_li_u.jpg"));
                this.writeRessourceToZip(zos, prefix + "tab_re_o_C8C8C8.jpg", ArchiveHelper.getHTMLRessourcePath(i18n, "tab_re_o_C8C8C8.jpg"));
                this.writeRessourceToZip(zos, prefix + "tab_re_o.jpg", ArchiveHelper.getHTMLRessourcePath(i18n, "tab_re_o.jpg"));
                this.writeRessourceToZip(zos, prefix + "tab_re_u_C8C8C8.jpg", ArchiveHelper.getHTMLRessourcePath(i18n, "tab_re_u_C8C8C8.jpg"));
                this.writeRessourceToZip(zos, prefix + "tab_re_u.jpg", ArchiveHelper.getHTMLRessourcePath(i18n, "tab_re_u.jpg"));
                this.writeRessourceToZip(zos, prefix + "error_small.png", ArchiveHelper.getHTMLRessourcePath(i18n, "error_small.png"));
            }
            catch (XMLStreamException e) {
                log.error((Object)"Error creating index.html for archive bulk download.", (Throwable)e);
            }
            catch (FactoryConfigurationError e) {
                log.error((Object)"Error creating index.html for archive bulk download.", (Throwable)e);
            }
            zos.close();
            zos = null;
            tmpFile.deleteOnExit();
            tmpFile = null;
            File archiveFile = this.fileFinder.findFile(ret);
            status.setArchiveFileSize(archiveFile.length());
            log.info((Object)("Assembly of bulk download [" + ret + "] has successfully been finished."));
            CDESDataFile cDESDataFile = ret;
            return cDESDataFile;
        }
        catch (IOException e) {
            throw new ActionException("Caught I/O exception", e);
        }
        catch (FileHandleException e) {
            throw new ActionException("Caught filehandle exception", e);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error closing zip output stream for file [" + tmpFile + "]"), (Throwable)e);
                }
            }
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    private void writeRessourceToZip(ZipArchiveOutputStream zos, String sourceFileName, String destinationFileName) throws IOException {
        int numRead;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(sourceFileName);
        if (is == null) {
            log.error((Object)("Cold not add resource '" + sourceFileName + "' to zip."));
            return;
        }
        ZipArchiveEntry ze = new ZipArchiveEntry(destinationFileName);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Adding entry [" + ze + "] to bulk download."));
        }
        zos.putArchiveEntry((ArchiveEntry)ze);
        byte[] buf = new byte[4096];
        while ((numRead = is.read(buf)) >= 0) {
            zos.write(buf, 0, numRead);
        }
        zos.closeArchiveEntry();
    }

    public void setProjectOperations(ProjectOperations projectOperations) {
        this.projectOperations = projectOperations;
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    @Override
    public File getAllowedBaseDir() {
        return this.allowedBaseDir;
    }

    public void setAllowedBaseDir(File allowedBaseDir) {
        this.allowedBaseDir = allowedBaseDir;
    }

    public void setAttachmentDAO(AttachmentDAO attachmentDAO) {
        this.attachmentDAO = attachmentDAO;
    }

    public void setOrderDAO(OrderDAO orderDAO) {
        this.orderDAO = orderDAO;
    }

    public void setDigestCalculatorFactory(DigestCalculatorFactory digestCalculatorFactory) {
        this.digestCalculatorFactory = digestCalculatorFactory;
    }

    public void setSignatureCalculatorFactory(SignatureCalculatorFactory signatureCalculatorFactory) {
        this.signatureCalculatorFactory = signatureCalculatorFactory;
    }

    public void setSignatureDAO(SignatureDAO signatureDAO) {
        this.signatureDAO = signatureDAO;
    }

    public void setDigestCalculatorDAO(DigestCalculatorDAO digestCalculatorDAO) {
        this.digestCalculatorDAO = digestCalculatorDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setActionOperations(ActionOperations actionOperations) {
        this.actionOperations = actionOperations;
    }

    public void setMailOperations(MailOperations mailOperations) {
        this.mailOperations = mailOperations;
    }

    public void setCertificateDAO(CertificateDAO certificateDAO) {
        this.certificateDAO = certificateDAO;
    }

    public void setProjectArchiveWriter(ProjectArchiveWriter projectArchiveWriter) {
        this.projectArchiveWriter = projectArchiveWriter;
    }

    public void setReviewOperations(ReviewOperations reviewOperations) {
        this.reviewOperations = reviewOperations;
    }

    public void setMimeSourceFactory(MimeSourceFactory mimeSourceFactory) {
        this.mimeSourceFactory = mimeSourceFactory;
    }

    @Override
    public CDESDataFile getPlotStudioBulkDownload(Integer projectId, Integer signerId, Integer activeSubProjectId, PlottOrder plottOrder, String mimeSource) {
        HashMap<Integer, DocumentVersion> docVersions = new HashMap<Integer, DocumentVersion>();
        ArrayList orderItems = new ArrayList(plottOrder.getOrderItems().values());
        File tmpFile = null;
        ZipArchiveOutputStream zos = null;
        String prj = this.projectDAO.get(projectId).getCode().replace(' ', '_').replace('/', '_').replace('\\', '_');
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss_SSS");
        CDESDataFile ret = new CDESDataFile("cdes_download_" + prj + "_" + df.format(new Date()) + ".zip", CDESFileRepository.TEMPREPOSITORY);
        try {
            tmpFile = this.fileFinder.buildFile(ret);
            zos = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(tmpFile));
            zos.setEncoding("CP437");
            VisitlessMimeSource ms = this.mimeSourceFactory.getMimeSource(mimeSource);
            boolean pdf = ms instanceof AbstractDocumentVersionPdfMimeSource;
            for (PlottOrderItem item : orderItems) {
                if (item.getDocumentVersion().getStatus() == 7) continue;
                docVersions.put(item.getDocumentVersion().getId(), item.getDocumentVersion());
            }
            for (DocumentVersion dv : docVersions.values()) {
                if (pdf && !ConfigurationHelper.isFileTypeSupportedForPreview(dv.getFileType())) continue;
                this.addDocumentVersionToZip(zos, ms, dv, "", null);
            }
            zos.close();
            zos = null;
            tmpFile.deleteOnExit();
            tmpFile = null;
            log.info((Object)("Assembly of bulk download [" + ret + "] has successfully been finished."));
            CDESDataFile cDESDataFile = ret;
            return cDESDataFile;
        }
        catch (FileNotFoundException e) {
            throw new ActionException("Caught FileNotFoundException", e);
        }
        catch (IOException e) {
            throw new ActionException("Caught IOException", e);
        }
        catch (FileHandleException e) {
            throw new ActionException("Caught FileHandleException", e);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error closing zip output stream for file [" + tmpFile + "]"), (Throwable)e);
                }
            }
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDESDataFile getCustomLabelBulkDownload(Integer projectId, List<String[]> customTextFieldCsv, List<String[]> documentVersionsCsv, String mimeSource) {
        Project project = this.projectDAO.get(projectId);
        ArrayList<TemporaryCustomTextField> customTextFields = new ArrayList<TemporaryCustomTextField>();
        ArrayList<Triple> plans = new ArrayList<Triple>();
        StringBuffer completionLog = new StringBuffer();
        completionLog.append("-----------------getCustomLabelBulkDownload summary:-------------------\n");
        int csvDocumentVersionFetchErrors = 0;
        for (String[] parts : customTextFieldCsv) {
            completionLog.append("-- custom textfield name=[" + parts[0] + "] llx=[" + parts[1] + "] lly=[" + parts[2] + "] urx=[" + parts[3] + "] ury=[" + parts[4] + "] font=[" + parts[5] + "] fontstyle=[" + parts[6] + "] fontPtStyle=[" + parts[7] + "] alignment=[" + parts[8] + "]\n");
            TemporaryCustomTextField textField = new TemporaryCustomTextField();
            textField.setName(parts[0]);
            textField.setLlx(Double.parseDouble(parts[1]));
            textField.setLly(Double.parseDouble(parts[2]));
            textField.setUrx(Double.parseDouble(parts[3]));
            textField.setUry(Double.parseDouble(parts[4]));
            textField.setFont(parts[5]);
            textField.setFontStyle(Integer.parseInt(parts[6]));
            textField.setFontPtSize(Integer.parseInt(parts[7]));
            textField.setAlignment(Integer.parseInt(parts[8]));
            customTextFields.add(textField);
        }
        for (String[] parts : documentVersionsCsv) {
            DocumentVersion dv = null;
            try {
                dv = this.reviewOperations.getDocumentVersionByName(parts[0], projectId);
            }
            catch (Exception e) {
                log.error((Object)("could not fetch DocumentVersion with name=[" + parts[0] + "] - query didn't return a unique result!"));
            }
            if (dv == null) {
                ++csvDocumentVersionFetchErrors;
                completionLog.append("-- Could not find documentVersion for name=[" + parts[0] + "] -- skipped this entry!\n");
                continue;
            }
            String unique_id = parts[1];
            ArrayList<Pair> fields = new ArrayList<Pair>();
            for (int j = 2; j < parts.length; ++j) {
                if (!parts[j].contains("|")) continue;
                String[] keyVal = parts[j].split("\\|");
                Pair field = new Pair((Object)keyVal[0], (Object)keyVal[1]);
                fields.add(field);
            }
            plans.add(new Triple((Object)dv, (Object)unique_id, fields));
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss_SSS");
        CDESDataFile ret = new CDESDataFile("cdes_download_" + project.getCode().replace(' ', '_').replace('/', '_').replace('\\', '_') + "_" + df.format(new Date()) + ".zip", CDESFileRepository.TEMPREPOSITORY);
        File tmpFile = null;
        ZipArchiveOutputStream zos = null;
        try {
            tmpFile = this.fileFinder.buildFile(ret);
            zos = new ZipArchiveOutputStream((OutputStream)new FileOutputStream(tmpFile));
            zos.setEncoding("CP437");
            zos.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.NOT_ENCODEABLE);
            ArrayList<DocumentVersion> renderedCorrectly = new ArrayList<DocumentVersion>();
            ArrayList<DocumentVersion> notRenderedCorrectly = new ArrayList<DocumentVersion>();
            VisitlessMimeSource ms = this.mimeSourceFactory.getMimeSource(mimeSource);
            for (Triple plan : plans) {
                IMimeInputStream mimeStream = null;
                try {
                    byte[] data;
                    do {
                        try {
                            mimeStream = ms.getMimeStream(new Object[]{((DocumentVersion)plan.getFirst()).getId(), customTextFields, plan.getThird()});
                        }
                        catch (Timeout e) {
                            log.info((Object)("retrieving data for document version [" + ((DocumentVersion)plan.getFirst()).getName() + "] time out, retrying..."));
                        }
                    } while (mimeStream == null);
                    String prettyFilename = mimeStream.getPrettyName();
                    prettyFilename = "application/pdf".equals(mimeStream.getMimeType()) ? ((DocumentVersion)plan.getFirst()).getName() + (String)plan.getSecond() + ".pdf" : ((DocumentVersion)plan.getFirst()).getName() + (String)plan.getSecond() + "." + ((DocumentVersion)plan.getFirst()).getFileType();
                    ZipArchiveEntry ze = new ZipArchiveEntry(prettyFilename);
                    log.info((Object)("Adding entry [" + ze + "] to bulk download."));
                    zos.putArchiveEntry((ArchiveEntry)ze);
                    for (long len = mimeStream.getStreamSize(); len > 0L; len -= (long)data.length) {
                        data = mimeStream.readBlock(4096);
                        zos.write(data);
                    }
                    zos.closeArchiveEntry();
                    renderedCorrectly.add((DocumentVersion)plan.getFirst());
                }
                catch (Exception e) {
                    if (plan.getFirst() != null) {
                        log.error((Object)("Caught exception while adding document version [" + ((DocumentVersion)plan.getFirst()).getName() + "] to zip file."), (Throwable)e);
                    } else {
                        log.error((Object)"Caught exception while adding document version - contained documentVersion is null!");
                    }
                    notRenderedCorrectly.add((DocumentVersion)plan.getFirst());
                }
                finally {
                    if (mimeStream == null) continue;
                    try {
                        mimeStream.close();
                    }
                    catch (Throwable e) {
                        log.warn((Object)("Caught exception while closing document version [" + ((DocumentVersion)plan.getFirst()).getName() + "] added to zip file."), e);
                    }
                }
            }
            zos.close();
            zos = null;
            tmpFile.deleteOnExit();
            tmpFile = null;
            log.info((Object)("Assembly of bulk download [" + ret + "] has been finished."));
            completionLog.append("-----> [" + renderedCorrectly.size() + "] plans converted successfully - [" + notRenderedCorrectly.size() + "] conversions resulted in an exception - [" + csvDocumentVersionFetchErrors + "] plans could not be found and were not rendered at all -----\n");
            if (!notRenderedCorrectly.isEmpty()) {
                completionLog.append("---> Not rendered correctly: ---\n");
                for (DocumentVersion dv : notRenderedCorrectly) {
                    if (dv != null) {
                        completionLog.append("--> DocumentVersion with id=[" + dv.getId() + "] and name=[" + dv.getName() + "] could not be converted!\n");
                        continue;
                    }
                    completionLog.append("--> DocumentVersion is null!");
                }
            }
            log.info((Object)completionLog.toString());
            Iterator iterator = ret;
            return iterator;
        }
        catch (IOException e) {
            throw new ActionException("Caught I/O exception", e);
        }
        catch (FileHandleException e) {
            throw new ActionException("Caught filehandle exception", e);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error closing zip output stream for file [" + tmpFile + "]"), (Throwable)e);
                }
            }
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    public void setCdesDataFilesRoot(String cdesDataFilesRoot) {
        this.cdesDataFilesRoot = cdesDataFilesRoot;
    }

    public void setPdfZipCompressionFactorEstimate(double pdfZipCompressionFactorEstimate) {
        this.pdfZipCompressionFactorEstimate = pdfZipCompressionFactorEstimate;
    }

    public void setPltZipCompressionFactorEstimate(double pltZipCompressionFactorEstimate) {
        this.pltZipCompressionFactorEstimate = pltZipCompressionFactorEstimate;
    }

    public void setEnableCustomerLogo(boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }
}

