/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.order.plott;

import at.cdes.bo.data.CdesDataObject;
import at.cdes.bo.plot.BoundingBox;
import at.cdes.bo.plot.LengthCalculator;
import at.cdes.bo.plot.LengthUnit;
import java.util.Locale;

public class PlottProperties
implements BoundingBox,
CdesDataObject {
    private static final long serialVersionUID = 7211329109259205857L;
    public static final String[] paperQualities = new String[]{"Laserplot 80g/m2", "Tintenstrahlplot 80g/m2", "Laserplot 90g/m2", "Tintenstrahlplot 90g/m2"};
    public static final String[] margins = new String[]{"Nicht falten", "Falten mit 20mm Heftrand", "Falten ohne Heftrand"};
    public static final String[] deliveries = new String[]{"Zustelldienst Auftragnehmer", "Post", "UPS Packetdienst", "Velo Express", "Selbstabholung"};
    public static final String[] scales = new String[]{"keine", "A4", "A3", "A2", "A1", "A0"};
    public static final int CHROMATICITY_MONOCHROME = 0;
    public static final int CHROMATICITY_IN_COLOR = 1;
    public static final int CHROMATICITY_LIKE_TEMPLATE = 2;
    private Integer id;
    private int count;
    private String paperQuality;
    private int color;
    private String margin;
    private boolean mirroring;
    private String scale;
    private Double llx;
    private Double lly;
    private Double urx;
    private Double ury;
    private double userUnit;

    public PlottProperties() {
    }

    public PlottProperties(PlottProperties props) {
        this.count = props.getCount();
        this.paperQuality = props.getPaperQuality();
        this.color = props.getColor();
        this.margin = props.getMargin();
        this.mirroring = props.isMirroring();
        this.scale = props.getScale();
        this.userUnit = props.userUnit;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int col) {
        this.color = col;
    }

    public String getMargin() {
        return this.margin;
    }

    public void setMargin(String margin) {
        this.margin = margin;
    }

    public boolean isMirroring() {
        return this.mirroring;
    }

    public void setMirroring(boolean mirroring) {
        this.mirroring = mirroring;
    }

    public String getPaperQuality() {
        return this.paperQuality;
    }

    public void setPaperQuality(String paperQuality) {
        this.paperQuality = paperQuality;
    }

    public synchronized String getScale() {
        return this.scale;
    }

    public synchronized void setScale(String scale) {
        this.scale = scale;
    }

    @Override
    public Double getLlx() {
        return this.llx;
    }

    @Override
    public void setLlx(Double llx) {
        this.llx = llx;
    }

    @Override
    public Double getLly() {
        return this.lly;
    }

    @Override
    public void setLly(Double lly) {
        this.lly = lly;
    }

    @Override
    public Double getUrx() {
        return this.urx;
    }

    @Override
    public void setUrx(Double urx) {
        this.urx = urx;
    }

    @Override
    public Double getUry() {
        return this.ury;
    }

    @Override
    public void setUry(Double ury) {
        this.ury = ury;
    }

    @Override
    public double getUserUnit() {
        return this.userUnit;
    }

    @Override
    public void setUserUnit(double userUnit) {
        this.userUnit = userUnit;
    }

    public String getArea() {
        String res = "";
        res = String.format(Locale.US, "%.2f", LengthCalculator.getBBoxArea(this, LengthUnit.METER));
        return res;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!PlottProperties.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        PlottProperties other = (PlottProperties)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }
}

