/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.bo.cycle.EvaluationException;
import at.cdes.bo.cycle.ReviewCycleCellConnectionEvaluator;
import at.cdes.bo.data.cycle.AttachedReviewCyclePositionImpl;
import at.cdes.bo.data.cycle.ReviewCycleEntryResult;
import at.cdes.bo.data.cycle.ReviewCycleInstance;
import at.cdes.bo.data.cycle.ReviewCycleInstanceImpl;
import at.cdes.bo.data.cycle.ReviewCycleInstanceRelease;
import at.cdes.bo.data.cycle.ReviewCyclePosition;
import at.cdes.bo.data.cycle.ReviewCyclePositionRelease;
import at.cdes.bo.data.cycle.ReviewCyclePositionReleaseImpl;
import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.data.cycle.ReviewCycleResultOption;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnection;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnectionResult;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstance;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstanceRelease;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellResult;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResultImpl;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.document.ReleasedDocument;
import at.cdes.bo.data.document.ReleasedDocumentList;
import at.cdes.bo.data.localisation.Localisation;
import at.cdes.bo.data.mail.StatusEMailSnippet;
import at.cdes.bo.data.mail.TaskEMailSnippet;
import at.cdes.bo.data.mail.TaskFutureEMail;
import at.cdes.bo.data.object.ObjectPlanner;
import at.cdes.bo.data.object.ObjectPlannerImpl;
import at.cdes.bo.data.object.ReleasedCDESObject;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.order.OrderStep;
import at.cdes.bo.data.order.OrderStepImpl;
import at.cdes.bo.data.order.ProjectParticipationOrderStep;
import at.cdes.bo.data.order.orig.OriginalDocumentOrder;
import at.cdes.bo.data.order.orig.OriginalDocumentOrderItem;
import at.cdes.bo.data.order.plott.PlottOrder;
import at.cdes.bo.data.order.plott.PlottOrderItem;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.data.task.AttachedReviewTask;
import at.cdes.bo.data.task.AttachedReviewTaskDone;
import at.cdes.bo.data.task.DocumentTask;
import at.cdes.bo.data.task.DocumentVersionTask;
import at.cdes.bo.data.task.DocumentVersionTaskBase;
import at.cdes.bo.data.task.OriginalDocumentTask;
import at.cdes.bo.data.task.OriginalDocumentTaskDone;
import at.cdes.bo.data.task.PlotOrderAcceptanceTask;
import at.cdes.bo.data.task.PlotOrderAcceptanceTaskDone;
import at.cdes.bo.data.task.ReviewCycleEntryTask;
import at.cdes.bo.data.task.ReviewCycleEntryTaskDone;
import at.cdes.bo.data.task.ReviewCycleNodeInstanceTaskQuery;
import at.cdes.bo.data.task.ReviewCyclePlottTask;
import at.cdes.bo.data.task.ReviewCyclePlottTaskDone;
import at.cdes.bo.data.task.ReviewCycleTask;
import at.cdes.bo.data.task.ReviewTask;
import at.cdes.bo.data.task.ReviewTaskDone;
import at.cdes.bo.data.task.ReviewableTask;
import at.cdes.bo.data.task.ReviewableTaskDone;
import at.cdes.bo.data.task.SelectCellConnectionTask;
import at.cdes.bo.data.task.SelectCellConnectionTaskDone;
import at.cdes.bo.data.task.Task;
import at.cdes.bo.data.task.TaskBase;
import at.cdes.bo.data.task.TaskMonitoringResult;
import at.cdes.bo.data.task.TaskTO;
import at.cdes.bo.data.task.TaskTOContainer;
import at.cdes.bo.date.HolidayCalculator;
import at.cdes.bo.date.HolidayCalculatorFactory;
import at.cdes.bo.service.ReviewCycleNodeInstanceHelper;
import at.cdes.controller.apiHelper.SubProjectCopyContainer;
import at.cdes.controller.helper.TaskOverviewTaskTOGenerator;
import at.cdes.db.dao.DocumentDAO;
import at.cdes.db.dao.DocumentVersionDAO;
import at.cdes.db.dao.EMailDAO;
import at.cdes.db.dao.ObjectListDAO;
import at.cdes.db.dao.ObjectPlannerDAO;
import at.cdes.db.dao.OrderDAO;
import at.cdes.db.dao.OrganisationPersonDAO;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.db.dao.ProjectParticipationDAO;
import at.cdes.db.dao.ReviewCycleCellInstanceDAO;
import at.cdes.db.dao.ReviewCycleCellResultDAO;
import at.cdes.db.dao.ReviewCycleInstanceDAO;
import at.cdes.db.dao.ReviewCycleNodeInstanceDAO;
import at.cdes.db.dao.ReviewCycleNodeResultDAO;
import at.cdes.db.dao.ReviewCyclePositionDAO;
import at.cdes.db.dao.ReviewCyclePositionResultDAO;
import at.cdes.db.dao.TaskDAO;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.service.MailOperations;
import at.cdes.service.ObjectOperations;
import at.cdes.service.ProjectOperations;
import at.cdes.service.ReviewCycleOperations;
import at.cdes.service.ReviewOperations;
import at.cdes.service.TaskOperations;
import at.cdes.service.exception.ReviewException;
import at.cdes.util.ReverseIntegerComparator;
import at.cdes.util.TapestryI18nHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.clazzes.util.datetime.CalendarHelper;
import org.clazzes.util.lang.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class TaskOperationsImpl
implements TaskOperations {
    private TaskDAO taskDAO;
    private ObjectPlannerDAO objectPlannerDAO;
    private ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO;
    private ReviewCycleInstanceDAO reviewCycleInstanceDAO;
    private ReviewCycleCellConnectionEvaluator reviewCycleCellConnectionEvaluator;
    private ReviewCycleCellInstanceDAO reviewCycleCellInstanceDAO;
    private ReviewCycleCellResultDAO reviewCycleCellResultDAO;
    private ReviewCycleNodeResultDAO reviewCycleNodeResultDAO;
    private DocumentDAO documentDAO;
    private DocumentVersionDAO documentVersionDAO;
    private ObjectListDAO objectListDAO;
    private EMailDAO mailDAO;
    private ReviewCycleOperations reviewCycleOperations;
    private HolidayCalculatorFactory holidayCalculatorFactory;
    private ProjectParticipationDAO projectParticipationDAO;
    private ReviewOperations reviewOperations;
    private ObjectOperations objectOperations;
    private ReviewCyclePositionResultDAO reviewCyclePositionResultDAO;
    private ReviewCyclePositionDAO reviewCyclePositionDAO;
    private MailOperations mailOperations;
    private OrderDAO orderDAO;
    private ProjectOperations projectOperations;
    private OrganisationPersonDAO organisationPersonDAO;
    private TaskOverviewTaskTOGenerator taskOverviewTaskTOGenerator;
    private static Logger log = LoggerFactory.getLogger(TaskOperationsImpl.class);
    private int tabViewmode;
    private boolean reversePreduration;
    private ProjectDAO projectDAO;

    @Override
    public Task getTask(Integer id) {
        return this.taskDAO.get(id);
    }

    @Override
    public void removeTask(Integer taskId) {
        Collection<TaskEMailSnippet> snippets = this.mailDAO.getSnippetsOfTask(taskId);
        Collection<TaskFutureEMail> futureMails = this.mailDAO.getFutureMailsOfTask(taskId);
        if (snippets != null) {
            for (TaskEMailSnippet snippet : snippets) {
                this.mailDAO.deleteSnippet(snippet);
            }
        }
        if (futureMails != null) {
            for (TaskFutureEMail femail : futureMails) {
                this.mailDAO.deleteFutureEMail(femail);
            }
        }
        this.taskDAO.delete(taskId);
    }

    @Override
    public void doReviewCyclePlottTask(ReviewCyclePlottTask plottTask, OrderStep step) {
        ReviewCyclePlottTaskDone taskDone = new ReviewCyclePlottTaskDone(plottTask);
        taskDone.setDoneDate(new GregorianCalendar());
        taskDone.setOrderStep(step);
        this.removeTask(plottTask.getId());
        this.taskDAO.save(taskDone);
    }

    @Override
    public void doOriginalDocumentTask(OriginalDocumentTask task, OrderStep step) {
        OriginalDocumentTaskDone taskDone = new OriginalDocumentTaskDone(task);
        taskDone.setDoneDate(new GregorianCalendar());
        taskDone.setOrderStep(step);
        this.removeTask(task.getId());
        this.taskDAO.save(taskDone);
    }

    @Override
    public void doSelectCellTask(SelectCellConnectionTask selectCellConnectionTask, ReviewCycleCellConnectionResult connectionResult) {
        SelectCellConnectionTaskDone taskDone = new SelectCellConnectionTaskDone(selectCellConnectionTask);
        taskDone.setDoneDate(new GregorianCalendar());
        taskDone.setReviewCycleCellConnectionResult(connectionResult);
        this.removeTask(selectCellConnectionTask.getId());
        this.taskDAO.save(taskDone);
    }

    @Override
    public void doReviewCycleEntryTask(ReviewCycleEntryTask task, ReviewCycleEntryResult result) {
        ReviewCycleEntryTaskDone taskDone = new ReviewCycleEntryTaskDone(task);
        taskDone.setDoneDate(new GregorianCalendar());
        taskDone.setReviewCycleEntryResult(result);
        this.removeTask(task.getId());
        this.taskDAO.save(taskDone);
    }

    @Override
    public void doReviewTask(ReviewTask reviewTask, List reviews, List donePositionIds) {
        ReviewTaskDone taskDone = new ReviewTaskDone(reviewTask);
        Iterator doneIt = donePositionIds.iterator();
        taskDone.setDoneDate(new GregorianCalendar());
        taskDone.setReviewCyclePositionResults(new HashMap());
        boolean breakingResult = false;
        for (int i = 0; i < reviews.size(); ++i) {
            ReviewCyclePositionResult res = (ReviewCyclePositionResult)reviews.get(i);
            taskDone.getReviewCyclePositionResults().put(res.getId(), res);
            if (!res.getReviewCycleResultOption().isFinishCell()) continue;
            breakingResult = true;
        }
        while (doneIt.hasNext()) {
            Integer posId = (Integer)doneIt.next();
            reviewTask.getReviewCyclePositionReleases().remove(posId);
        }
        if (breakingResult) {
            this.removeNodeTasks(reviewTask);
        } else if (reviewTask.getReviewCyclePositionReleases().isEmpty()) {
            this.removeTask(reviewTask.getId());
        } else {
            reviewTask.setTaskStatus(0);
            this.taskDAO.update(reviewTask);
        }
        this.taskDAO.save(taskDone);
    }

    @Override
    public void doAttachedReviewTask(AttachedReviewTask reviewTask, List reviews, List donePositionIds) {
        AttachedReviewTaskDone taskDone = new AttachedReviewTaskDone(reviewTask);
        Iterator doneIt = donePositionIds.iterator();
        taskDone.setDoneDate(new GregorianCalendar());
        taskDone.setReviewCyclePositionResults(new HashMap());
        boolean breakingResult = false;
        for (int i = 0; i < reviews.size(); ++i) {
            ReviewCyclePositionResult res = (ReviewCyclePositionResult)reviews.get(i);
            taskDone.getReviewCyclePositionResults().put(res.getId(), res);
            if (!res.getReviewCycleResultOption().isFinishCell()) continue;
            breakingResult = true;
        }
        while (doneIt.hasNext()) {
            Integer posId = (Integer)doneIt.next();
            reviewTask.getReviewCyclePositionReleases().remove(posId);
        }
        if (breakingResult) {
            this.removeNodeTasks(reviewTask);
        } else if (reviewTask.getReviewCyclePositionReleases().isEmpty()) {
            this.removeTask(reviewTask.getId());
        } else {
            reviewTask.setTaskStatus(0);
            this.taskDAO.update(reviewTask);
        }
        this.taskDAO.save(taskDone);
    }

    @Override
    public Task preGenerateTaskDeadlines(Integer documentVersionId, Integer releasedObjectListId) {
        DocumentVersion version = this.documentVersionDAO.get(documentVersionId);
        Document unreleasedDocument = version.getDocument();
        Project project = unreleasedDocument.getDocumentList().getSubProject().getProject();
        ReleasedObjectList objectList = this.objectListDAO.getReleasedObjectList(releasedObjectListId);
        ReviewTask newTask = new ReviewTask();
        ReviewCycleNodeInstanceImpl nodeInstance = version.getActualReviewCycleNodeInstance();
        ReviewCycleInstanceRelease rel = this.reviewCycleInstanceDAO.getReleased(objectList.getId(), nodeInstance.getReviewCycleCellInstance().getReviewCycleInstance().getId());
        if (rel == null) {
            return newTask;
        }
        ReviewCycleNodeInstanceRelease relNodeInstance = this.reviewCycleNodeInstanceDAO.getReleased(rel.getId(), nodeInstance.getReviewCycleNode().getId());
        int node_duration = relNodeInstance.getDuration();
        int node_duration_min = relNodeInstance.getDurationMin();
        Pair<Integer, Integer> remaining_cycle_durations = this.reviewCycleOperations.calculateReviewCycleInstanceRemainingDurations(relNodeInstance);
        int remaining_cycle_duration = (Integer)remaining_cycle_durations.getFirst();
        int remaining_cycle_duration_min = (Integer)remaining_cycle_durations.getSecond();
        this.generateTaskDeadlinesInner(newTask, project.getId(), unreleasedDocument.getId(), 0, 0, remaining_cycle_duration -= node_duration, remaining_cycle_duration_min -= node_duration_min, false);
        return newTask;
    }

    private void generateTaskDeadlines(DocumentVersionTaskBase task, Integer projectId, Integer unreleasedDocumentId, ReviewCycleNodeInstanceRelease nodeInstance, boolean usePDCStartDate) {
        Pair<Integer, Integer> remaining_cycle_durations = this.reviewCycleOperations.calculateReviewCycleInstanceRemainingDurations(nodeInstance);
        int remaining_cycle_duration = (Integer)remaining_cycle_durations.getFirst();
        int remaining_cycle_duration_min = (Integer)remaining_cycle_durations.getSecond();
        int node_duration = nodeInstance.getDuration();
        int node_duration_min = nodeInstance.getDurationMin();
        if (log.isDebugEnabled()) {
            log.debug("........ generateTaskDeadlines: remaining_cycle_duration [" + remaining_cycle_duration + "," + remaining_cycle_duration_min + "]; node_duration [" + node_duration + "," + node_duration_min + "]");
        }
        this.generateTaskDeadlinesInner(task, projectId, unreleasedDocumentId, node_duration, node_duration_min, remaining_cycle_duration, remaining_cycle_duration_min, usePDCStartDate);
    }

    private void generateTaskDeadlines(DocumentTask task, Integer projectId, Integer unreleasedDocumentId, int remainingCycleDuration, int cyclePreDuration) {
        this.generateTaskDeadlinesInner(task, projectId, unreleasedDocumentId, remainingCycleDuration, cyclePreDuration);
    }

    private String dateToDebugString(Date d) {
        if (d == null) {
            return "null";
        }
        return d.getDate() + "." + (d.getMonth() + 1) + "." + (d.getYear() + 1900);
    }

    private String calendarToDebugString(Calendar c) {
        if (c == null) {
            return "null";
        }
        return c.get(5) + "." + (c.get(2) + 1) + "." + c.get(1);
    }

    private void generateTaskDeadlinesInner(DocumentVersionTaskBase task, Integer projectId, Integer unreleasedDocumentId, int node_duration, int node_duration_min, int remaining_cycle_duration, int remaining_cycle_duration_min, boolean usePDCStartDate) {
        Project project = this.projectDAO.get(projectId);
        if (log.isDebugEnabled()) {
            log.debug(".......... generateTaskDeadlinesInner: project [" + projectId + "]; unreleasedDocId [" + unreleasedDocumentId + "]");
            log.debug(".......... remaining_cycle_duration [" + remaining_cycle_duration + "," + remaining_cycle_duration_min + "]; node_duration [" + node_duration + "," + node_duration_min + "]");
        }
        ReviewCycleNodeResult nodeResult = null;
        if (task.getDocumentVersion() != null) {
            nodeResult = this.reviewCycleNodeResultDAO.get(task.getDocumentVersion().getActualReviewCycleNode(), task.getDocumentVersion());
        }
        Calendar nodeArrivalDate = new GregorianCalendar();
        if (nodeResult != null && nodeResult.getDocumentArrivalDate() != null) {
            nodeArrivalDate.setTime(nodeResult.getDocumentArrivalDate());
        } else if (task.getBeginDate() != null) {
            nodeArrivalDate = task.getBeginDate();
        }
        HolidayCalculator hcalc = this.holidayCalculatorFactory.getInstance(project);
        ReleasedDocumentList releasedDocumentList = this.documentDAO.get(unreleasedDocumentId).getDocumentList().getSubProject().getActiveDocumentList();
        ReleasedDocument releasedDocument = null;
        Calendar pdcStartDate = null;
        if (releasedDocumentList != null) {
            releasedDocument = this.documentDAO.getReleased(unreleasedDocumentId, releasedDocumentList.getId());
            if (log.isDebugEnabled()) {
                log.debug("generateTaskDeadlinesInner: unreleasedDocumentId=" + unreleasedDocumentId + ", releasedDocumentList.getId()=" + releasedDocumentList.getId() + ", releasedDocumentStartDate=" + (releasedDocument != null ? (releasedDocument.getStartDate() != null ? releasedDocument.getStartDate().toString() : "releasedDocumentStartDate=null") : "releasedDocument=null"));
            }
            if (releasedDocument != null && releasedDocument.getStartDate() != null) {
                pdcStartDate = new GregorianCalendar();
                pdcStartDate.setTime(releasedDocument.getStartDate());
            }
        }
        Calendar begin = null;
        if (task.getBeginDate() == null) {
            begin = usePDCStartDate && pdcStartDate != null && pdcStartDate.after(Calendar.getInstance()) ? pdcStartDate : Calendar.getInstance();
            if (log.isDebugEnabled()) {
                log.debug(".......... Using current time [" + this.calendarToDebugString(begin) + "] as begin since task.beginDate == null");
            }
        } else {
            begin = usePDCStartDate && pdcStartDate != null && pdcStartDate.after(nodeArrivalDate) ? pdcStartDate : nodeArrivalDate;
            if (log.isDebugEnabled()) {
                log.debug(".......... Using task.begin = [" + this.calendarToDebugString(begin) + "] as begin.");
            }
        }
        task.setBeginDate(begin);
        task.setDeltaT(node_duration);
        task.setOverallEndDate(hcalc.addWorkingDays(begin, remaining_cycle_duration));
        task.setContractualDeadline(hcalc.addWorkingDays(begin, node_duration));
        task.setEndDate(task.getContractualDeadline());
        task.setMinimalDeadline(hcalc.addWorkingDays(begin, node_duration_min));
        if (log.isDebugEnabled()) {
            log.debug(".......... overallEndDate = [" + this.calendarToDebugString(task.getOverallEndDate()) + "]; contractualDeadline = [" + this.calendarToDebugString(task.getContractualDeadline()) + "]; minimalDeadLine = [" + this.calendarToDebugString(task.getMinimalDeadline()) + "]");
        }
        GregorianCalendar required_end_date = null;
        if (releasedDocument != null && releasedDocument.getEndDate() != null) {
            required_end_date = new GregorianCalendar();
            required_end_date.setTime(releasedDocument.getEndDate());
            if (log.isDebugEnabled()) {
                log.debug(".......... releasedDocList = [" + releasedDocumentList.getId() + "]; releasedDoc = [" + releasedDocument.getId() + "]; requiredEndDate = [" + this.calendarToDebugString(required_end_date) + "]");
            }
        }
        int required_duration = remaining_cycle_duration;
        if (required_end_date != null) {
            required_duration = hcalc.getWorkingDaysBetween(begin, required_end_date);
        }
        if (log.isDebugEnabled()) {
            log.debug(".......... required_duration [" + required_duration + "]");
        }
        if (remaining_cycle_duration <= required_duration) {
            task.setMinDeltaT(node_duration);
            task.setNodeOptimalDeadline(task.getContractualDeadline());
            task.setOptimalDeadline(task.getContractualDeadline());
            task.setUrgency(0);
            if (log.isDebugEnabled()) {
                log.debug(".......... Case 1: minDeltaT = " + task.getMinDeltaT() + "; optimalDeadLine = [" + this.calendarToDebugString(task.getOptimalDeadline()) + "]; urgency = [" + task.getUrgency() + "]");
            }
        } else {
            int my_duration = required_duration - (remaining_cycle_duration - node_duration);
            task.setNodeOptimalDeadline(hcalc.addWorkingDays(begin, my_duration));
            int remaining_cyle_duration_reduced_to_current_min_delta_t = remaining_cycle_duration - node_duration + node_duration_min;
            if (log.isDebugEnabled()) {
                log.debug(".......... Case 2/3: my_duration = " + my_duration + "; nodeOptimalDeadline = [" + this.calendarToDebugString(task.getNodeOptimalDeadline()) + "]; remaining_cycle_duration_reduced... = [" + remaining_cyle_duration_reduced_to_current_min_delta_t);
            }
            if (remaining_cyle_duration_reduced_to_current_min_delta_t <= required_duration) {
                task.setMinDeltaT(my_duration);
                task.setOptimalDeadline(task.getNodeOptimalDeadline());
                task.setUrgency(1);
                if (log.isDebugEnabled()) {
                    log.debug(".......... Case 2: minDeltaT = " + task.getMinDeltaT() + "; optimalDeadLine = [" + this.calendarToDebugString(task.getNodeOptimalDeadline()) + "]; urgency = [" + task.getUrgency() + "]");
                }
            } else {
                task.setMinDeltaT(node_duration_min);
                task.setOptimalDeadline(hcalc.addWorkingDays(begin, node_duration_min));
                if (remaining_cycle_duration_min <= required_duration) {
                    task.setUrgency(2);
                } else {
                    task.setUrgency(3);
                }
                if (log.isDebugEnabled()) {
                    log.debug(".......... Case 3: minDeltaT = " + task.getMinDeltaT() + "; optimalDeadLine = [" + this.calendarToDebugString(task.getNodeOptimalDeadline()) + "]; urgency = [" + task.getUrgency() + "]");
                }
            }
        }
        task.setLocalisation(project.getLocalisation());
    }

    private void generateTaskDeadlinesInner(DocumentTask task, Integer projectId, Integer unreleasedDocumentId, int remaining_cycle_duration, int cyclePreDuration) {
        ReleasedDocumentList releasedDocumentList = this.documentDAO.get(unreleasedDocumentId).getDocumentList().getSubProject().getActiveDocumentList();
        Calendar begin = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        Project project = this.projectDAO.get(projectId);
        HolidayCalculator hcalc = this.holidayCalculatorFactory.getInstance(project);
        if (releasedDocumentList == null) {
            return;
        }
        ReleasedDocument releasedDocument = this.documentDAO.getReleased(unreleasedDocumentId, releasedDocumentList.getId());
        if (releasedDocument == null || releasedDocument.getStartDate() == null) {
            return;
        }
        if (task.getBeginDate() == null) {
            begin.setTimeInMillis(System.currentTimeMillis());
        } else {
            begin = task.getBeginDate();
        }
        if (releasedDocument.getStartDate() != null) {
            end.setTime(releasedDocument.getStartDate());
        } else {
            end = task.getBeginDate() == null ? Calendar.getInstance() : task.getBeginDate();
        }
        task.setBeginDate(begin);
        if (cyclePreDuration == 0 || this.isReversePreduration()) {
            task.setEndDate(end);
        } else {
            task.setEndDate(hcalc.addWorkingDays(end, -cyclePreDuration));
        }
        long diff = end.getTimeInMillis() - begin.getTimeInMillis();
        task.setDeltaT((int)(diff / 1000L / 3600L / 24L));
        if (task instanceof ReviewCycleTask) {
            if (releasedDocument.getEndDate() != null) {
                ((ReviewCycleTask)((Object)task)).setOverallEndDate(end);
            } else {
                ((ReviewCycleTask)((Object)task)).setOverallEndDate(hcalc.addWorkingDays(end, remaining_cycle_duration));
            }
        }
    }

    private void generateTaskEMailSnippets(Task task, ProjectParticipation projectParticipation, int type) {
        Map participants;
        if (log.isDebugEnabled()) {
            log.debug("........ Called generateTaskEmailSnippets: task [" + task.getId() + "]; Participation [" + projectParticipation.getId() + "]; type = " + type);
        }
        if ((participants = projectParticipation.getProjectParticipants()) != null) {
            GregorianCalendar now = new GregorianCalendar();
            for (ProjectParticipant pp : participants.values()) {
                if (log.isDebugEnabled()) {
                    log.debug(".......... Processing Participant [" + pp.getId() + "]");
                }
                if (pp.getOrganisationPerson().isInActive()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug(".......... Ignoring it since OrgPerson [" + pp.getOrganisationPerson().getId() + "] is inactive.");
                    continue;
                }
                TaskEMailSnippet ts = new TaskEMailSnippet();
                ts.setOrganisationPersonId(pp.getOrganisationPerson().getId());
                ts.setSendTime(pp.getOrganisationPerson().getNextEMailSendTime(now));
                ts.setTask(task);
                ts.setType(type);
                if (log.isDebugEnabled()) {
                    log.debug(".......... Filling TaskEmailSnippet: OrgPerson [" + pp.getOrganisationPerson().getId() + "]; sendTime [" + this.calendarToDebugString(now) + "]; task [" + task.getId() + "]; type [" + type + "]");
                }
                this.generateTaskReminderFutureEMail(task, pp);
                if (ts.getSendTime() == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug(".......... inserting snippet for task [" + ts.getId() + "]");
                }
                this.mailDAO.insertSnippet(ts);
            }
        }
    }

    private void generateStatusEMailSnippetsForReviewTask(DocumentVersionTask task, int type) {
        ProjectParticipation projectParticipation = this.projectParticipationDAO.get(task.getProjectParticipationId());
        Map participants = projectParticipation.getProjectParticipants();
        if (participants != null) {
            GregorianCalendar now = new GregorianCalendar();
            for (ProjectParticipant pp : participants.values()) {
                StatusEMailSnippet st = new StatusEMailSnippet();
                st.setOrganisationPersonId(pp.getOrganisationPerson().getId());
                st.setSendTime(pp.getOrganisationPerson().getNextEMailSendTime(now));
                st.setDocumentVersion(task.getDocumentVersion());
                st.setType(type);
                if (type != 2 || type != 3) {
                    this.generateTaskReminderFutureEMail(task, pp);
                }
                if (st.getSendTime() == null) continue;
                this.mailDAO.insertSnippet(st);
            }
        }
    }

    @Override
    public void generateStatusEMailSnippetForOriginalDocumentOrderItem(OriginalDocumentOrderItem item, int type) {
        OrganisationPerson orgPerson = null;
        if (item.getReceiverType() == 2) {
            orgPerson = this.organisationPersonDAO.get(item.getReceiverId());
        }
        if (orgPerson == null) {
            return;
        }
        GregorianCalendar now = new GregorianCalendar();
        StatusEMailSnippet st = new StatusEMailSnippet();
        st.setOrganisationPersonId(orgPerson.getId());
        st.setSendTime(orgPerson.getNextEMailSendTime(now));
        st.setDocumentVersion(item.getDocumentVersion());
        st.setType(type);
        if (st.getSendTime() != null) {
            this.mailDAO.insertSnippet(st);
        }
    }

    private void generateTaskReminderFutureEMail(Task task, ProjectParticipant participant) {
        if (log.isDebugEnabled()) {
            log.debug("............ Called generateTaskReminderFutureEMail for task [" + task.getId() + "]; participant [" + participant.getId() + "]");
        }
        if (task.getEndDate() != null) {
            int warnBefore;
            HolidayCalculator holidayCalc = this.getHolidayCalculatorFactory().getInstance(participant.getParticipation().getProject());
            int diffDays = holidayCalc.getWorkingDaysBetween(task.getBeginDate(), task.getEndDate());
            int n = warnBefore = diffDays > 3 ? 3 : 1;
            if (log.isDebugEnabled()) {
                log.debug("............ task.endDate = [" + this.calendarToDebugString(task.getEndDate()) + "]; diffDays = " + diffDays + "; warnBefore = " + warnBefore);
            }
            Calendar sendTime = holidayCalc.addWorkingDays(task.getEndDate(), -warnBefore);
            Collection<TaskFutureEMail> futureMailsOfTask = this.mailDAO.getFutureMailsOfTask(task.getId());
            for (TaskFutureEMail femail : futureMailsOfTask) {
                if (log.isDebugEnabled()) {
                    log.debug("............ Processing TaskFutureEMail [" + femail.getId() + "]");
                }
                if (femail.getType() != -1 || !femail.getParticipationId().equals(participant.getParticipation().getId())) continue;
                if (log.isDebugEnabled()) {
                    log.debug(".............. Deleting it since type = " + femail.getType() + "; participation [" + participant.getParticipation().getId() + "] matches.");
                }
                this.mailDAO.deleteFutureEMail(femail);
            }
            if (log.isDebugEnabled()) {
                log.debug(".............. Considering to send it: " + this.calendarToDebugString(task.getBeginDate()) + "; sendTime = " + this.calendarToDebugString(sendTime));
            }
            if (CalendarHelper.daysBetween((Calendar)task.getBeginDate(), (Calendar)sendTime) > 0) {
                TaskFutureEMail ts = new TaskFutureEMail();
                ts.setType(-1);
                ts.setParticipationId(participant.getParticipation().getId());
                ts.setTask(task);
                ts.setSendTime(sendTime);
                if (log.isDebugEnabled()) {
                    log.debug("................ Sending it with type " + ts.getType() + "; Participation " + ts.getParticipationId() + "; task " + task.getId() + "; sendTime " + this.calendarToDebugString(sendTime));
                }
                this.mailDAO.insertFutureEMail(ts);
            }
        }
    }

    private void generateTaskLateFutureEMail(Task task, Project project) {
        if (log.isDebugEnabled()) {
            log.debug("........ Called generateTaskLateFutureEmail with task [" + task.getId() + "]; Project [" + project.getId() + "]");
        }
        Collection<TaskFutureEMail> futureMailsOfTask = this.mailDAO.getFutureMailsOfTask(task.getId());
        Collection projectParticipations = project.getProjectParticipations().values();
        for (ProjectParticipation pp : projectParticipations) {
            if (log.isDebugEnabled()) {
                log.debug("............ Processing Participation " + pp.getId());
            }
            if (pp.getRole().getType() == null || pp.getRole().getType().getType() != 2 || !pp.getRole().hasAction("monitorLateReviews")) continue;
            if (log.isDebugEnabled()) {
                log.debug("............ Case Project_surveillant");
            }
            for (TaskFutureEMail femail : futureMailsOfTask) {
                if (femail.getType() != -2 || !femail.getParticipationId().equals(pp.getId())) continue;
                if (log.isDebugEnabled()) {
                    log.debug("............ Deleting already existing futureEmail " + femail.getId());
                }
                this.mailDAO.deleteFutureEMail(femail);
            }
            if (log.isDebugEnabled()) {
                log.debug("............ createLateTaskFutureEmail for Participation " + pp.getId() + " and task " + task.getId());
            }
            this.mailOperations.createLateTaskFutureEmail(pp, task);
        }
    }

    private void obsoleteReviewableTask(ReviewableTask task) {
        this.generateStatusEMailSnippetsForReviewTask(task, 3);
        this.removeTask(task.getId());
    }

    private void invalidateReviewableTask(ReviewableTask task) {
        this.generateStatusEMailSnippetsForReviewTask(task, 2);
        this.removeTask(task.getId());
    }

    @Override
    public boolean generateReviewTask(DocumentVersion documentVersion, ProjectParticipation projectParticipation, ReviewCycleNodeInstanceRelease nextNodeInstance, Map reviewCyclePositionReleases, Integer nodeResultId, boolean fixMissingTasks, boolean checkAndRestore) {
        Project project;
        boolean usePDCStartDateForTasks;
        ReviewTask task = new ReviewTask();
        ReviewCycleNode node = nextNodeInstance.getReviewCycleNode();
        Collection positions = reviewCyclePositionReleases.values();
        List tasks = this.taskDAO.getProjectParticipationReviewTodos(projectParticipation.getId(), nextNodeInstance.getReviewCycleNodeInstance().getId(), documentVersion.getId());
        Iterator it = positions.iterator();
        boolean hasUnSignedPositionResult = false;
        HashMap<Integer, ReviewCyclePositionRelease> reviewCyclePositionsForTask = new HashMap<Integer, ReviewCyclePositionRelease>();
        while (it.hasNext()) {
            ReviewCyclePositionRelease pos = (ReviewCyclePositionRelease)it.next();
            for (ReviewTask reviewTask : tasks) {
                if (!reviewTask.getReviewCyclePositionReleases().containsKey(pos.getId())) continue;
                log.info("task already exists for documentVersion=[" + documentVersion.getName() + "] docVerId=[" + documentVersion.getId() + "] participationId=[" + projectParticipation.getId() + "]");
                return false;
            }
            ReviewCyclePositionResult res = this.reviewCyclePositionResultDAO.getSigned(pos.getRealm().getId(), node.getId(), documentVersion.getId(), pos.getProjectParticipation().getId(), nodeResultId);
            if (res != null) continue;
            hasUnSignedPositionResult = true;
            reviewCyclePositionsForTask.put(pos.getId(), pos);
        }
        if (!hasUnSignedPositionResult) {
            log.info("no unSignedPositionResult found for documentVersion=[" + documentVersion.getName() + "] docVerId=[" + documentVersion.getId() + "] participationId=[" + projectParticipation.getId() + "]");
            return false;
        }
        log.info("++++++++ generating " + (fixMissingTasks ? "missing " : "") + (checkAndRestore ? "" : "(only checkmode) ") + "reviewTask for documentVersion=[" + documentVersion.getName() + "], nodeName=[" + TapestryI18nHelper.getLocalizedString(node.getName()) + "], projectParticipationId=[" + projectParticipation.getId() + "]" + (checkAndRestore ? "" : " --> just a ceck!!"));
        if (!checkAndRestore) {
            return true;
        }
        ReviewCycleNodeResult nodeResult = null;
        boolean allPreviousNodesAreNotEmpty = true;
        if (nodeResultId != null) {
            nodeResult = this.reviewCycleNodeResultDAO.get(nodeResultId);
            if (fixMissingTasks && nodeResult.getDocumentArrivalDate() != null) {
                Calendar begin = Calendar.getInstance();
                begin.setTime(nodeResult.getDocumentArrivalDate());
                task.setBeginDate(begin);
            }
            ReviewCycleResultOption emptyNodeOption = nodeResult.getReviewCycleCellResult().getReviewCycleCell().getReviewCycle().getEmptyNodeOption();
            Map reviewCycleNodeResults = nodeResult.getReviewCycleCellResult().getReviewCycleNodeResults();
            for (ReviewCycleNodeResult reviewCycleNodeResult : reviewCycleNodeResults.values()) {
                if (!reviewCycleNodeResult.isFinished()) continue;
                allPreviousNodesAreNotEmpty &= reviewCycleNodeResult.getReviewCycleResultOption().getValue() != emptyNodeOption.getValue();
            }
        }
        boolean usePDCStart = (usePDCStartDateForTasks = (project = documentVersion.getDocument().getDocumentList().getSubProject().getProject()).isUsePDCStartDateForTasks()) && (nodeResultId == null || !allPreviousNodesAreNotEmpty) && documentVersion.getDocument().getDocumentVersions() != null && documentVersion.getDocument().getDocumentVersions().size() == 1;
        this.generateTaskDeadlines(task, projectParticipation.getProject().getId(), documentVersion.getDocument().getId(), nextNodeInstance, usePDCStart);
        task.setReviewCyclePositionReleases(reviewCyclePositionsForTask);
        task.setName(TapestryI18nHelper.getLocaleString(nextNodeInstance.getReviewCycleNode().getName(), project.getLocalisation().getLanguageCode()));
        task.setObjectPlanner(documentVersion.getDocument().getObjectPlanner());
        task.setDocumentVersion(documentVersion);
        task.setProjectParticipationId(projectParticipation.getId());
        task.makeRealmDescription();
        task.setReviewCycleNodeInstanceId(nextNodeInstance.getReviewCycleNodeInstance().getId());
        if (nextNodeInstance.getReviewCycleNode().getReviewCyclePositionType().getSampleControlReviewCyclePositionType() != null) {
            task.setSampleControlReview(true);
        } else {
            task.setSampleControlReview(false);
        }
        this.taskDAO.save(task);
        this.generateTaskEMailSnippets(task, projectParticipation, 1);
        this.generateTaskLateFutureEMail(task, projectParticipation.getProject());
        this.mailOperations.createAttachmentMailForProjectParticipation(documentVersion, projectParticipation);
        return true;
    }

    public boolean generateAttachedReviewTask(DocumentVersion documentVersion, ProjectParticipation projectParticipation, ReviewCycleNodeInstanceRelease nextNodeInstance, Map reviewCyclePositionReleases, Integer nodeResultId, boolean fixMissingTasks, boolean checkAndRestore) {
        AttachedReviewTask task = new AttachedReviewTask();
        ReviewCycleNode node = nextNodeInstance.getReviewCycleNode();
        ReviewCycleNodeResult nodeResult = null;
        Project project = documentVersion.getDocument().getDocumentList().getSubProject().getProject();
        if (nodeResultId != null) {
            nodeResult = this.reviewCycleNodeResultDAO.get(nodeResultId);
        }
        Collection positions = reviewCyclePositionReleases.values();
        List<AttachedReviewTask> tasks = this.taskDAO.getProjectParticipationAttachedReviewTodos(projectParticipation.getId(), nextNodeInstance.getReviewCycleNodeInstance().getId(), documentVersion.getId());
        Iterator it = positions.iterator();
        boolean hasUnSignedPositionResult = false;
        HashMap<Integer, AttachedReviewCyclePositionImpl> reviewCyclePositionsForTask = new HashMap<Integer, AttachedReviewCyclePositionImpl>();
        while (it.hasNext()) {
            AttachedReviewCyclePositionImpl pos = (AttachedReviewCyclePositionImpl)it.next();
            for (AttachedReviewTask reviewTask : tasks) {
                if (!reviewTask.getReviewCyclePositionReleases().containsKey(pos.getId())) continue;
                return false;
            }
            ReviewCyclePositionResult res = this.reviewCyclePositionResultDAO.getSigned(pos.getRealm().getId(), node.getId(), documentVersion.getId(), pos.getProjectParticipation().getId(), nodeResultId);
            if (res != null) continue;
            hasUnSignedPositionResult = true;
            reviewCyclePositionsForTask.put(pos.getId(), pos);
        }
        if (!hasUnSignedPositionResult) {
            return false;
        }
        log.info("++++++++ generating " + (fixMissingTasks ? "missing " : "") + (checkAndRestore ? "" : "(only checkmode) ") + "attachedReviewTask for documentVersion=[" + documentVersion.getName() + "] nodeName=[" + TapestryI18nHelper.getLocalizedString(node.getName()) + "]" + (checkAndRestore ? "" : " --> just a ceck!!"));
        if (!checkAndRestore) {
            return true;
        }
        if (fixMissingTasks && nodeResult != null && nodeResult.getDocumentArrivalDate() != null) {
            Calendar begin = Calendar.getInstance();
            begin.setTime(nodeResult.getDocumentArrivalDate());
            task.setBeginDate(begin);
        }
        this.generateTaskDeadlines(task, projectParticipation.getProject().getId(), documentVersion.getDocument().getId(), nextNodeInstance, false);
        task.setReviewCyclePositionReleases(reviewCyclePositionReleases);
        task.setName(TapestryI18nHelper.getLocaleString(nextNodeInstance.getReviewCycleNode().getName(), project.getLocalisation().getLanguageCode()));
        task.setObjectPlanner(documentVersion.getDocument().getObjectPlanner());
        task.setDocumentVersion(documentVersion);
        task.setProjectParticipationId(projectParticipation.getId());
        task.makeRealmDescription();
        task.setReviewCycleNodeInstanceId(nextNodeInstance.getReviewCycleNodeInstance().getId());
        if (nextNodeInstance.getReviewCycleNode().getReviewCyclePositionType().getSampleControlReviewCyclePositionType() != null) {
            task.setSampleControlReview(true);
        } else {
            task.setSampleControlReview(false);
        }
        this.taskDAO.save(task);
        this.generateTaskEMailSnippets(task, projectParticipation, 1);
        this.generateTaskLateFutureEMail(task, projectParticipation.getProject());
        this.mailOperations.createAttachmentMailForProjectParticipation(documentVersion, projectParticipation);
        return true;
    }

    @Override
    public int generateReviewTasks(DocumentVersion documentVersion, ReviewCycleNodeInstanceRelease nodeInstanceRel, Integer nodeResultId, boolean fixMissingTasks, boolean checkAndRestore) {
        ReviewCyclePositionRelease reviewCyclePosition;
        int count = 0;
        List<ReviewCyclePosition> reviewCyclePositions = ReviewCycleNodeInstanceHelper.getReviewCyclePositionsSortedByParticipation(nodeInstanceRel);
        Iterator<ReviewCyclePosition> it = reviewCyclePositions.iterator();
        ReviewCyclePositionRelease reviewCyclePositionRelease = reviewCyclePosition = it.hasNext() ? (ReviewCyclePositionRelease)it.next() : null;
        while (reviewCyclePosition != null) {
            ProjectParticipation lastParticipation = reviewCyclePosition.getProjectParticipation();
            HashMap<Integer, ReviewCyclePositionRelease> reviewCyclePositionReleases = new HashMap<Integer, ReviewCyclePositionRelease>();
            while (reviewCyclePosition != null && reviewCyclePosition.getProjectParticipation().getId().equals(lastParticipation.getId())) {
                reviewCyclePositionReleases.put(reviewCyclePosition.getId(), reviewCyclePosition);
                reviewCyclePosition = it.hasNext() ? (ReviewCyclePositionRelease)it.next() : null;
            }
            log.info("trying to generate reviewTask for documentVersion=[" + documentVersion.getName() + "] docVerId=[" + documentVersion.getId() + "] participationId=[" + lastParticipation.getId() + "]");
            boolean generated = this.generateReviewTask(documentVersion, lastParticipation, nodeInstanceRel, reviewCyclePositionReleases, nodeResultId, fixMissingTasks, checkAndRestore);
            if (!generated) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void checkForObsoleteReviewTasks(DocumentVersion documentVersion, ReviewCycleNodeInstanceRelease nodeInstanceRel, Integer nodeResultId, boolean checkAndRestore) {
        List<ReviewCyclePosition> reviewCyclePositions = ReviewCycleNodeInstanceHelper.getReviewCyclePositionsSortedByParticipation(nodeInstanceRel);
        ArrayList<Integer> projectParticipationIds = new ArrayList<Integer>();
        for (ReviewCyclePosition reviewCyclePosition : reviewCyclePositions) {
            projectParticipationIds.add(reviewCyclePosition.getProjectParticipation().getId());
        }
        Collection reviewTasks = this.taskDAO.getReviewTasksOfDocumentVersionAndNodeInstance(documentVersion.getId(), nodeInstanceRel.getReviewCycleNodeInstance().getId());
        for (ReviewTask task : reviewTasks) {
            if (projectParticipationIds.isEmpty() || projectParticipationIds.contains(task.getProjectParticipationId())) continue;
            if (checkAndRestore) {
                this.removeTask(task.getId());
            }
            log.info("-+-+-+- Obsolete reviewTask id= " + task.getId().toString() + " of documentVersionId= " + task.getDocumentVersion().getId().toString() + (checkAndRestore ? "was" : "should be") + " removed");
        }
    }

    @Override
    public boolean generateSelectCellTask(ReleasedObjectList objectList, DocumentVersion documentVersion, ReviewCycleNodeInstanceRelease nodeInstanceRelease, boolean fixMissingTasks, boolean evaluateCellConnections, boolean checkAndRestore) {
        ReviewCycleCellInstance cellInstance = nodeInstanceRelease.getReviewCycleCellInstance();
        Collection connections = cellInstance.getReviewCycleCell().getLeavingConnections().values();
        Iterator connIt = connections.iterator();
        HashMap<Integer, ReviewCycleCellConnection> destinationConnections = new HashMap<Integer, ReviewCycleCellConnection>();
        Collection cellInstances = cellInstance.getReviewCycleInstance().getReviewCycleCellInstances().values();
        block0: while (connIt.hasNext()) {
            ReviewCycleCellConnection connection = (ReviewCycleCellConnection)connIt.next();
            if (!this.evaluateConnection(documentVersion, connection)) continue;
            for (ReviewCycleCellInstance instance : cellInstances) {
                if (!instance.getReviewCycleCell().getId().equals(connection.getDestinationCell().getId())) continue;
                destinationConnections.put(connection.getId(), connection);
                continue block0;
            }
        }
        if (destinationConnections.isEmpty()) {
            if (evaluateCellConnections) {
                log.error("generateSelectCellTask: no valid cellConnections found. Check the connection rules!");
                throw new ReviewException(12);
            }
            log.warn("generateSelectCellTask: no valid cellConnections found. Check the connection rules!");
            return false;
        }
        ReleasedObjectPlanner op = this.objectPlannerDAO.getReleasedObjectPlanner(objectList.getId(), documentVersion.getDocument().getObjectPlanner().getId());
        ProjectParticipation projectParticipation = op.getPlanner();
        ReviewCycleInstance inst = op.getReviewCycleInstance();
        ReviewCycleNodeInstanceRelease nodeInstance = this.reviewCycleNodeInstanceDAO.getReleased(inst.getId(), documentVersion.getActualReviewCycleNode().getId());
        List<SelectCellConnectionTask> tasks = this.getSelectCellConnectionTasks(documentVersion.getId());
        boolean taskFound = false;
        if (!tasks.isEmpty()) {
            if (tasks.size() > 1) {
                log.warn("There are more than 1 SelectCellConnectionTasks for documentVersionId= " + documentVersion.getId());
            }
            for (SelectCellConnectionTask task : tasks) {
                if (task.getProjectParticipationId().equals(projectParticipation.getId())) {
                    taskFound = true;
                    continue;
                }
                this.removeTask(task.getId());
                log.warn("selectCellConnectionTask (id= " + task.getId() + ") for documentVersionId= " + documentVersion.getId() + " was removed");
            }
        }
        if (taskFound) {
            log.warn("No selectCellConnectionTask generated for documentVersionId= " + documentVersion.getId() + ", because already exists");
            return false;
        }
        log.info("+++++++ generating " + (fixMissingTasks ? "missing " : "") + (checkAndRestore ? "" : "(only checkmode) ") + "selectCellConnectionTask for documentVersion=[" + documentVersion.getName() + "] nodeName=[" + TapestryI18nHelper.getLocalizedString(documentVersion.getActualReviewCycleNode().getName()) + "]" + (checkAndRestore ? "" : " --> just a ceck!!"));
        if (!checkAndRestore) {
            return true;
        }
        SelectCellConnectionTask task = new SelectCellConnectionTask();
        Calendar calBegin = Calendar.getInstance();
        ReviewCycleNodeResult nodeResult = this.reviewOperations.getReviewCycleNodeResult(documentVersion.getActualReviewCycleNode(), documentVersion);
        if (fixMissingTasks && nodeResult != null && nodeResult.getDocumentArrivalDate() != null) {
            calBegin.setTime(nodeResult.getDocumentArrivalDate());
            task.setBeginDate(calBegin);
        }
        Locale locale = new Locale(projectParticipation.getMainParticipant().getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
        task.setName(I18nFactory.getI18n(locale).tr("Planupload"));
        task.setProjectParticipationId(projectParticipation.getId());
        task.setObjectPlanner(documentVersion.getDocument().getObjectPlanner());
        task.setDocumentVersion(documentVersion);
        task.setReviewCycleNodeInstanceId(nodeInstanceRelease.getId());
        this.generateTaskDeadlines(task, projectParticipation.getProject().getId(), documentVersion.getDocument().getId(), nodeInstance, false);
        task.setReviewCycleCellConnections(destinationConnections);
        this.taskDAO.save(task);
        this.generateTaskEMailSnippets(task, projectParticipation, 1);
        this.generateTaskLateFutureEMail(task, projectParticipation.getProject());
        this.mailOperations.createAttachmentMailForProjectParticipation(documentVersion, projectParticipation);
        return true;
    }

    @Override
    public void generateReviewCyclePlottTask(DocumentVersion documentVersion, PlottOrder order, OrderStep step, ProjectParticipation projectParticipation, boolean generateMail) {
        ReviewCyclePlottTask task = new ReviewCyclePlottTask();
        Locale locale = new Locale(projectParticipation.getMainParticipant().getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        task.setName(i18n.tr("Plotauftrag annehmen"));
        task.setProjectParticipationId(projectParticipation.getId());
        task.setObjectPlanner(documentVersion.getDocument().getObjectPlanner());
        task.setDocumentVersion(documentVersion);
        task.setBeginDate(Calendar.getInstance());
        task.setLocalisation(projectParticipation.getProject().getLocalisation());
        task.setOrder(order);
        task.setOrderStep(step);
        task.setUrgency(0);
        this.taskDAO.save(task);
        if (generateMail) {
            this.generateTaskEMailSnippets(task, projectParticipation, 1);
        }
    }

    @Override
    public void generateOriginalDocumentTask(DocumentVersion documentVersion, OriginalDocumentOrder order, OrderStep step, ProjectParticipation projectParticipation, boolean generateMail) {
        OriginalDocumentTask task = new OriginalDocumentTask();
        Locale locale = new Locale(projectParticipation.getMainParticipant().getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        task.setName(i18n.tr("Anforderung Originaldatei"));
        task.setProjectParticipationId(projectParticipation.getId());
        task.setObjectPlanner(documentVersion.getDocument().getObjectPlanner());
        task.setDocumentVersion(documentVersion);
        task.setBeginDate(Calendar.getInstance());
        task.setLocalisation(projectParticipation.getProject().getLocalisation());
        task.setOrder(order);
        task.setOrderStep(step);
        task.setUrgency(0);
        this.taskDAO.save(task);
        if (generateMail) {
            this.generateTaskEMailSnippets(task, projectParticipation, 1);
            this.mailOperations.createAttachmentMailForProjectParticipation(documentVersion, projectParticipation);
        }
    }

    @Override
    public void generateReviewCycleEntryTask(ReleasedObjectPlanner op, Document document) {
        ProjectParticipation projectParticipation = op.getPlanner();
        ReviewCycleEntryTask task = new ReviewCycleEntryTask();
        Locale locale = new Locale(projectParticipation.getMainParticipant().getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        task.setName(i18n.tr("Planupload"));
        task.setObjectPlanner(op.getObjectPlanner());
        task.setProjectParticipationId(projectParticipation.getId());
        task.setLocalisation(projectParticipation.getProject().getLocalisation());
        task.setDocument(document);
        this.generateTaskDeadlines(task, projectParticipation.getProject().getId(), document.getId(), op.getReviewCycleInstance().getDuration(), op.getReviewCycleInstance().getPreDuration());
        this.taskDAO.save(task);
        this.generateTaskEMailSnippets(task, projectParticipation, 1);
        this.generateTaskLateFutureEMail(task, projectParticipation.getProject());
    }

    @Override
    public void removeTasks(DocumentVersion version) {
        List tasks = this.taskDAO.getAll(version);
        if (tasks == null) {
            return;
        }
        for (Task task : tasks) {
            if (task instanceof ReviewCyclePlottTask || task instanceof PlotOrderAcceptanceTask) continue;
            if (task instanceof ReviewableTask) {
                this.invalidateReviewableTask((ReviewableTask)task);
                continue;
            }
            this.removeTask(task.getId());
        }
    }

    public boolean evaluateConnection(DocumentVersion version, ReviewCycleCellConnection connection) {
        ReviewCycleCellResult res = this.reviewCycleCellResultDAO.get(version.getActualReviewCycleNode().getReviewCycleCell().getId(), version.getId());
        try {
            return this.reviewCycleCellConnectionEvaluator.evaluateConnection(res, connection);
        }
        catch (EvaluationException evaluationException) {
            return false;
        }
    }

    @Override
    public void updateReviewTasks2(ReleasedObjectList oldObjectList, ReleasedObjectList newObjectList, Map<Integer, Pair<Integer, Integer>> detachedReviewCycleInstances) {
        this.updateAttachedReviewTasksOfDetachedReviewCycleInstances(detachedReviewCycleInstances);
        Map reviewCycleInstances = oldObjectList.getSubProject().getReviewCycleInstances();
        for (ReviewCycleInstanceImpl reviewCycleInstance : reviewCycleInstances.values()) {
            Object reviewCycleInstanceId = null;
            reviewCycleInstanceId = detachedReviewCycleInstances.get(reviewCycleInstance.getId()) != null ? (Integer)detachedReviewCycleInstances.get(reviewCycleInstance.getId()).getSecond() : reviewCycleInstance.getId();
            ReviewCycleInstanceRelease oldReviewCycleInstRel = this.reviewCycleOperations.getReleased(oldObjectList.getId(), (Integer)reviewCycleInstanceId);
            ReviewCycleInstanceRelease newReviewCycleInstRel = this.reviewCycleOperations.getReleased(newObjectList.getId(), reviewCycleInstance.getId());
            this.updateReviewTasksOfCycle(oldReviewCycleInstRel, newReviewCycleInstRel, newObjectList);
        }
        Collection oldObjects = oldObjectList.getObjects().values();
        for (ReleasedCDESObject oldObject : oldObjects) {
            if (oldObject.getObjectPlanners() == null || oldObject.getObjectPlanners().isEmpty()) continue;
            Collection oldObjectPlanners = oldObject.getObjectPlanners().values();
            for (ReleasedObjectPlanner oldObjectPlanner : oldObjectPlanners) {
                ReleasedObjectPlanner newObjectPlanner = this.objectPlannerDAO.getReleasedObjectPlanner(newObjectList.getId(), oldObjectPlanner.getObjectPlanner().getId());
                if (oldObjectPlanner == null || oldObjectPlanner.getPlanner() == null) continue;
                this.updateTasksOfObjectPlanner(oldObjectPlanner, newObjectPlanner, newObjectList);
            }
        }
        for (Pair<Integer, Integer> rciIdPair : detachedReviewCycleInstances.values()) {
            List detachedDocVersions = this.documentVersionDAO.getAllDetached((Integer)rciIdPair.getSecond(), (Integer)rciIdPair.getFirst());
            for (DocumentVersion detachedDocVersion : detachedDocVersions) {
                ReviewCycleInstanceImpl newReviewCycleInstance = this.reviewCycleInstanceDAO.get((Integer)rciIdPair.getFirst());
                ReviewCycleNodeInstanceImpl newNodeInstance = this.reviewCycleNodeInstanceDAO.getUnreleased(newReviewCycleInstance, detachedDocVersion.getActualReviewCycleNode());
                if (newNodeInstance == null) continue;
                detachedDocVersion.setActualReviewCycleNodeInstance(newNodeInstance);
                this.documentVersionDAO.update(detachedDocVersion);
            }
        }
        List<ReviewTask> signatureFolderTasks = this.taskDAO.getAllSignatureFolderReviewTasksForSubProject(oldObjectList.getSubProject().getId());
        for (ReviewTask task : signatureFolderTasks) {
            Iterator posIt = task.getReviewCyclePositionReleases().values().iterator();
            DocumentVersion dv = task.getDocumentVersion();
            ReviewCycleNodeResult nodeResult = this.reviewCycleNodeResultDAO.get(dv.getActualReviewCycleNode(), dv);
            boolean hasEmptyOrNullResult = false;
            boolean hasValidResult = false;
            while (posIt.hasNext()) {
                ReviewCyclePositionRelease positionRelease = (ReviewCyclePositionRelease)posIt.next();
                ReviewCyclePositionResult positionResult = this.reviewOperations.getReviewCyclePositionResult2(positionRelease, dv, nodeResult.getId());
                if (positionResult == null || positionResult.getReviewCycleResultOption() == null) {
                    hasEmptyOrNullResult = true;
                    continue;
                }
                if (positionResult.getSignature() != null) continue;
                hasValidResult = true;
            }
            if (hasValidResult || !hasEmptyOrNullResult) continue;
            task.setTaskStatus(0);
            this.taskDAO.update(task);
        }
    }

    public void updateTasksOfObjectPlanner(ReleasedObjectPlanner oldObjectPlanner, ReleasedObjectPlanner newObjectPlanner, ReleasedObjectList newObjectList) {
        Collection tasks = this.taskDAO.getObjectPlannerPlannerSelectCellConnectionTodos(oldObjectPlanner.getPlanner().getId(), oldObjectPlanner.getObjectPlanner().getId());
        for (SelectCellConnectionTask task : tasks) {
            if (newObjectPlanner != null && newObjectPlanner.getPlanner() != null && task.getProjectParticipationId().equals(newObjectPlanner.getPlanner().getId()) || !task.getObjectPlanner().getId().equals(oldObjectPlanner.getObjectPlanner().getId())) {
                this.updateRecalculatedTaskDeadlines(task.getId(), false);
                continue;
            }
            DocumentVersion documentVersion = task.getDocumentVersion();
            Integer reviewCycleNodeRelId = task.getReviewCycleNodeInstanceId();
            this.removeTask(task.getId());
            log.info("SelectCellConnectionTask id=" + task.getId().toString() + " was removed");
            if (newObjectPlanner == null || newObjectPlanner.getPlanner() == null) continue;
            ReviewCycleInstanceRelease reviewCycleInstanceRel = (ReviewCycleInstanceRelease)newObjectPlanner.getReviewCycleInstance();
            ReviewCycleNodeInstanceImpl actualNodeInstance = documentVersion.getActualReviewCycleNodeInstance();
            ReviewCycleNodeInstanceRelease actualNodeInstanceRel = this.reviewCycleNodeInstanceDAO.getReleased(reviewCycleInstanceRel.getId(), actualNodeInstance.getReviewCycleNode().getId());
            this.generateSelectCellTask(newObjectList, documentVersion, actualNodeInstanceRel, false, false, true);
            log.info("New SelectCellConnectionTask for deleted task_id=" + task.getId().toString() + " was generated");
        }
        List entryTasks = this.taskDAO.getObjectPlannerPlannerReviewCycleEntryTodos(oldObjectPlanner.getPlanner().getId(), oldObjectPlanner.getObjectPlanner().getId());
        for (ReviewCycleEntryTask task : entryTasks) {
            if (newObjectPlanner != null && newObjectPlanner.getPlanner() != null && task.getProjectParticipationId().equals(newObjectPlanner.getPlanner().getId())) continue;
            this.removeTask(task.getId());
            log.info("ReviewCycleEntryTask id=" + task.getId().toString() + " was removed");
            if (newObjectPlanner == null || newObjectPlanner.getPlanner() == null) continue;
            Document doc = task.getDocument();
            this.generateReviewCycleEntryTask(newObjectPlanner, doc);
        }
    }

    @Override
    public void updateReviewTasks(Collection documents, ReleasedObjectList objectList) {
        if (documents == null) {
            if (log.isDebugEnabled()) {
                log.debug("updateReviewTask: Called with documents == null.");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("updateReviewTask: Called with " + documents.size() + " documents; ReleasedObjectList-Id = [" + objectList.getId() + "]");
        }
        Iterator it = documents.iterator();
        Project project = objectList.getSubProject().getProject();
        while (it.hasNext()) {
            ReleasedDocument rd = (ReleasedDocument)it.next();
            if (log.isDebugEnabled()) {
                log.debug(".. Processing ReleasedDocument [" + rd.getId() + "]");
            }
            this.updateReviewTasksOfDocument(rd, objectList, project);
            this.updateDocumentTasksOfDocument(rd, objectList, project);
        }
    }

    private void updateReviewTasksOfDocument(ReleasedDocument document, ReleasedObjectList objectList, Project project) {
        List tasks = this.taskDAO.getAllReviewTasksByDocument(document.getDocument().getId());
        tasks.addAll(this.taskDAO.getAllAttachedReviewTasksByDocument(document.getDocument().getId()));
        if (log.isDebugEnabled()) {
            log.debug(".... Called updateReviewTasksOfDocument for " + tasks.size() + " tasks.");
        }
        Iterator it = tasks.iterator();
        boolean usePDCStartDateForTasks = project.isUsePDCStartDateForTasks();
        while (it.hasNext()) {
            DocumentVersionTaskBase task = (DocumentVersionTaskBase)it.next();
            ReviewCycleNodeInstanceImpl nodeInstance = task.getDocumentVersion().getActualReviewCycleNodeInstance();
            ReviewCycleInstanceRelease relCycleInstance = this.reviewCycleInstanceDAO.getReleased(objectList.getId(), nodeInstance.getReviewCycleCellInstance().getReviewCycleInstance().getId());
            ReviewCycleNodeInstanceRelease relNodeInstance = this.reviewCycleNodeInstanceDAO.getReleased(relCycleInstance.getId(), nodeInstance.getReviewCycleNode().getId());
            if (log.isDebugEnabled()) {
                log.debug("...... Processing task [" + task.getId() + "]; ReviewCycleNodeInstance [" + nodeInstance.getId() + "]; ReviewCycleInstanceRelease [" + relCycleInstance.getId() + "]; ReviewCycleNodeInstanceRelease [" + relNodeInstance.getId() + "]");
            }
            boolean isFirstDocumentVersion = false;
            if (task.getDocumentVersion().getDocument().getDocumentVersions() != null && task.getDocumentVersion().getDocument().getDocumentVersions().size() == 1) {
                isFirstDocumentVersion = true;
            }
            boolean usePDCStartDate = usePDCStartDateForTasks && isFirstDocumentVersion && relNodeInstance.getReviewCycleNode().getPosition().equals(1);
            this.generateTaskDeadlines(task, project.getId(), document.getDocument().getId(), relNodeInstance, usePDCStartDate);
            ProjectParticipation projectParticipation = this.projectParticipationDAO.get(task.getProjectParticipationId());
            this.generateTaskEMailSnippets(task, projectParticipation, 2);
            this.generateTaskLateFutureEMail(task, projectParticipation.getProject());
        }
    }

    private void updateDocumentTasksOfDocument(ReleasedDocument document, ReleasedObjectList objectList, Project project) {
        if (log.isDebugEnabled()) {
            log.debug(".... Called updateDocumentTasksOfDocument for document " + document.getId() + "; ReleasedObjectList " + objectList.getId() + "; project " + project.getId());
        }
        ArrayList<ReviewCycleEntryTask> tasks = new ArrayList<ReviewCycleEntryTask>();
        ReviewCycleEntryTask t = this.taskDAO.getReviewCycleEntryTaskByDocument(document.getDocument().getId());
        ReleasedObjectPlanner op = this.objectPlannerDAO.getReleasedObjectPlanner(objectList.getId(), document.getObjectPlanner().getId());
        if (log.isDebugEnabled()) {
            log.debug(".... Processing DocumentTask " + (t != null ? t.getId() : "null") + "; ReleasedObjectPlanner " + op.getId());
        }
        boolean noOp = false;
        if (op == null || op.getPlanner() == null || op.getPlanner().getId() == null) {
            noOp = true;
            if (log.isDebugEnabled()) {
                log.debug(".... Setting noOp to true");
            }
        }
        if (t != null) {
            tasks.add(t);
        }
        if (!noOp && tasks.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug(".... Considering to call generateReviewCycleEntryTask");
            }
            if (document.getStartDate() != null && !document.isVersionSet()) {
                if (log.isDebugEnabled()) {
                    log.debug(".... document.getStartDate = " + this.dateToDebugString(document.getStartDate()) + "; versionSet = " + document.isVersionSet());
                }
                this.generateReviewCycleEntryTask(op, document.getDocument());
            }
            return;
        }
        for (DocumentTask documentTask : tasks) {
            if (log.isDebugEnabled()) {
                log.debug(".... Processing DocumentTask " + documentTask.getId());
            }
            if (document.getStartDate() == null || op == null || noOp) {
                this.removeTask(documentTask.getId());
                log.error("No released objectPlanner found for taskId=" + documentTask.getId() + ". ProjectId:" + project.getId() + " -> task was removed!");
                return;
            }
            this.generateTaskDeadlines(documentTask, project.getId(), document.getDocument().getId(), op.getReviewCycleInstance().getDuration(), op.getReviewCycleInstance().getPreDuration());
            DocumentTask documentTask2 = (DocumentTask)this.taskDAO.update(documentTask);
            ProjectParticipation projectParticipation = this.projectParticipationDAO.get(documentTask2.getProjectParticipationId());
            this.generateTaskEMailSnippets(documentTask2, projectParticipation, 2);
            this.generateTaskLateFutureEMail(documentTask2, projectParticipation.getProject());
        }
    }

    private void updateReviewTasksOfNode(ReviewCycleNodeInstanceRelease oldReviewCycleNodeInstance, ReviewCycleNodeInstanceRelease newReviewCycleNodeInstance, ReleasedObjectList newObjectList) {
        Iterator<ReviewCyclePosition> newIt = null;
        ReviewCyclePositionRelease newPos = null;
        Iterator<ReviewCyclePosition> oldIt = null;
        ReviewCyclePositionRelease oldPos = null;
        List<ReviewCyclePosition> newReviewCycleNodePositionReleases = ReviewCycleNodeInstanceHelper.getReviewCyclePositionsSortedByParticipation(newReviewCycleNodeInstance);
        newIt = newReviewCycleNodePositionReleases.iterator();
        newPos = newIt.hasNext() ? (ReviewCyclePositionRelease)newIt.next() : null;
        List<ReviewCyclePosition> oldReviewCycleNodePositionReleases = null;
        if (oldReviewCycleNodeInstance != null) {
            oldReviewCycleNodePositionReleases = ReviewCycleNodeInstanceHelper.getReviewCyclePositionsSortedByParticipation(oldReviewCycleNodeInstance);
        }
        if (oldReviewCycleNodePositionReleases != null) {
            oldIt = oldReviewCycleNodePositionReleases.iterator();
            oldPos = oldIt.hasNext() ? (ReviewCyclePositionRelease)oldIt.next() : null;
        }
        boolean must_check_document_version_move = false;
        while (oldPos != null || newPos != null) {
            ArrayList reviewTasks;
            ProjectParticipation pp = null;
            HashMap<Integer, ReviewCyclePositionRelease> insert_positions = null;
            HashMap<Integer, ReviewCyclePositionRelease> remove_positions = null;
            if (newPos != null && (oldPos == null || newPos.getProjectParticipation().getId() < oldPos.getProjectParticipation().getId())) {
                pp = newPos.getProjectParticipation();
                insert_positions = new HashMap<Integer, ReviewCyclePositionRelease>();
                while (newPos != null && newPos.getProjectParticipation().getId().equals(pp.getId())) {
                    insert_positions.put(newPos.getId(), newPos);
                    newPos = newIt != null && newIt.hasNext() ? (ReviewCyclePositionRelease)newIt.next() : null;
                }
            } else if (oldPos != null && (newPos == null || oldPos.getProjectParticipation().getId() < newPos.getProjectParticipation().getId())) {
                pp = oldPos.getProjectParticipation();
                remove_positions = new HashMap<Integer, ReviewCyclePositionRelease>();
                while (oldPos != null && oldPos.getProjectParticipation().getId().equals(pp.getId())) {
                    remove_positions.put(oldPos.getId(), oldPos);
                    oldPos = oldIt != null && oldIt.hasNext() ? (ReviewCyclePositionRelease)oldIt.next() : null;
                }
            } else {
                if (oldPos == null || newPos == null || oldPos.getProjectParticipation().getId().intValue() != newPos.getProjectParticipation().getId().intValue()) break;
                pp = oldPos.getProjectParticipation();
                insert_positions = new HashMap();
                remove_positions = new HashMap();
                HashMap<Integer, ReviewCyclePositionRelease> insert_positions_by_realmid = new HashMap<Integer, ReviewCyclePositionRelease>();
                while (newPos != null && newPos.getProjectParticipation().getId().equals(pp.getId())) {
                    insert_positions.put(newPos.getId(), newPos);
                    insert_positions_by_realmid.put(newPos.getRealm().getId(), newPos);
                    newPos = newIt != null && newIt.hasNext() ? (ReviewCyclePositionRelease)newIt.next() : null;
                }
                while (oldPos != null && oldPos.getProjectParticipation().getId().equals(pp.getId())) {
                    if (insert_positions_by_realmid.containsKey(oldPos.getRealm().getId())) {
                        ReviewCyclePositionRelease np = (ReviewCyclePositionRelease)insert_positions_by_realmid.get(oldPos.getRealm().getId());
                        reviewTasks = new ArrayList();
                        reviewTasks.addAll(oldPos.getReviewTasks().values());
                        for (ReviewTask task : reviewTasks) {
                            Map pr;
                            if (!task.getObjectPlanner().getReviewCycleInstance().getId().equals(((ReviewCycleInstanceRelease)newReviewCycleNodeInstance.getReviewCycleCellInstance().getReviewCycleInstance()).getReviewCycleInstance().getId()) || (pr = task.getReviewCyclePositionReleases()) == null || !pr.containsKey(oldPos.getId())) continue;
                            pr.remove(oldPos.getId());
                            pr.put(np.getId(), np);
                            task.makeRealmDescription();
                            task.setReviewCycleNodeInstanceId(newReviewCycleNodeInstance.getReviewCycleNodeInstance().getId());
                            if (oldReviewCycleNodeInstance.getDuration() != newReviewCycleNodeInstance.getDuration()) {
                                this.generateTaskDeadlines(task, newObjectList.getSubProject().getProject().getId(), task.getDocumentVersion().getDocument().getId(), newReviewCycleNodeInstance, false);
                                ProjectParticipation projectParticipation = this.projectParticipationDAO.get(task.getProjectParticipationId());
                                this.generateTaskEMailSnippets(task, projectParticipation, 2);
                                this.generateTaskLateFutureEMail(task, newObjectList.getSubProject().getProject());
                            }
                            this.taskDAO.update(task);
                        }
                        insert_positions.remove(np.getId());
                    } else {
                        remove_positions.put(oldPos.getId(), oldPos);
                    }
                    oldPos = oldIt != null && oldIt.hasNext() ? (ReviewCyclePositionRelease)oldIt.next() : null;
                }
            }
            if (insert_positions != null && !insert_positions.isEmpty() && oldReviewCycleNodeInstance != null) {
                Map documentVersions = oldReviewCycleNodeInstance.getPendingDocumentVersions();
                for (DocumentVersion documentVersion : documentVersions.values()) {
                    if (!documentVersion.getDocument().getObjectPlanner().getReviewCycleInstance().getId().equals(((ReviewCycleInstanceRelease)newReviewCycleNodeInstance.getReviewCycleCellInstance().getReviewCycleInstance()).getReviewCycleInstance().getId())) continue;
                    this.generateReviewTask(documentVersion, pp, newReviewCycleNodeInstance, insert_positions, null, false, true);
                }
            }
            if (remove_positions == null) continue;
            if (remove_positions.size() > 0) {
                must_check_document_version_move = true;
            }
            for (ReviewCyclePositionRelease pos : remove_positions.values()) {
                reviewTasks = new ArrayList();
                reviewTasks.addAll(pos.getReviewTasks().values());
                for (ReviewTask task : reviewTasks) {
                    Map pr;
                    Integer taskId = task.getId();
                    if ((task = (ReviewTask)this.taskDAO.get(task.getId())) == null) {
                        log.error("task is NULL for taskId=" + taskId);
                        continue;
                    }
                    if (!task.getObjectPlanner().getReviewCycleInstance().getId().equals(((ReviewCycleInstanceRelease)newReviewCycleNodeInstance.getReviewCycleCellInstance().getReviewCycleInstance()).getReviewCycleInstance().getId()) || (pr = task.getReviewCyclePositionReleases()) == null || !pr.containsKey(pos.getId())) continue;
                    pr.remove(pos.getId());
                    if (pr.isEmpty()) {
                        log.warn("deleting taskId= [" + task.getId() + "] for ProjectParticipationId= [" + task.getProjectParticipationId() + "], task= [" + task.getName() + " realm: " + task.getRealmDescription() + "], documentVersion= [" + task.getDocumentVersion().getName() + "], documentVersionId= [" + task.getDocumentVersion().getId() + "] during objectList release");
                        this.obsoleteReviewableTask(task);
                        continue;
                    }
                    task.makeRealmDescription();
                    if (oldReviewCycleNodeInstance.getDuration() != newReviewCycleNodeInstance.getDuration()) {
                        this.generateTaskDeadlines(task, newObjectList.getSubProject().getProject().getId(), task.getDocumentVersion().getDocument().getId(), newReviewCycleNodeInstance, false);
                        ProjectParticipation projectParticipation = this.projectParticipationDAO.get(task.getProjectParticipationId());
                        this.generateTaskEMailSnippets(task, projectParticipation, 2);
                        this.generateTaskLateFutureEMail(task, newObjectList.getSubProject().getProject());
                    }
                    this.taskDAO.update(task);
                }
            }
        }
        if (oldReviewCycleNodeInstance == null || !must_check_document_version_move) {
            return;
        }
        Map documentVersions = oldReviewCycleNodeInstance.getPendingDocumentVersions();
        for (DocumentVersion documentVersion : documentVersions.values()) {
            ReviewCycleNodeResultImpl nodeResult;
            if (!documentVersion.getDocument().getObjectPlanner().getReviewCycleInstance().getId().equals(((ReviewCycleInstanceRelease)newReviewCycleNodeInstance.getReviewCycleCellInstance().getReviewCycleInstance()).getReviewCycleInstance().getId()) || newReviewCycleNodeInstance.getReviewCycleNode().isEndNode() || !this.reviewOperations.isNodeFinished(newReviewCycleNodeInstance, nodeResult = (ReviewCycleNodeResultImpl)this.reviewCycleNodeResultDAO.get(newReviewCycleNodeInstance.getReviewCycleNode(), documentVersion), documentVersion)) continue;
            this.reviewOperations.moveDocumentVersionToNextNode(newReviewCycleNodeInstance, newObjectList, nodeResult, documentVersion, false);
        }
    }

    private void updateReviewTasksOfCell(ReviewCycleCellInstanceRelease oldReviewCycleCellInstance, ReviewCycleCellInstanceRelease newReviewCycleCellInstance, ReleasedObjectList newObjectList) {
        Map newReviewCycleNodeInstances = newReviewCycleCellInstance.getReviewCycleNodeInstances();
        TreeMap<Integer, Pair> reviewCycleNodeInstancePairsByNodePos = new TreeMap<Integer, Pair>(new ReverseIntegerComparator());
        Iterator it = null;
        it = newReviewCycleNodeInstances.values().iterator();
        while (it != null && it.hasNext()) {
            ReviewCycleNodeInstanceRelease newReviewCycleNodeInstance = (ReviewCycleNodeInstanceRelease)it.next();
            Integer pos = newReviewCycleNodeInstance.getReviewCycleNode().getPosition();
            reviewCycleNodeInstancePairsByNodePos.put(pos, new Pair(null, (Object)newReviewCycleNodeInstance));
        }
        if (oldReviewCycleCellInstance != null && oldReviewCycleCellInstance.getReviewCycleNodeInstances() != null) {
            Map oldReviewCycleNodeInstances = oldReviewCycleCellInstance.getReviewCycleNodeInstances();
            for (ReviewCycleNodeInstanceRelease oldReviewCycleNodeInstance : oldReviewCycleNodeInstances.values()) {
                Integer pos = oldReviewCycleNodeInstance.getReviewCycleNode().getPosition();
                Pair reviewCycleNodeInstancePair = (Pair)reviewCycleNodeInstancePairsByNodePos.get(pos);
                reviewCycleNodeInstancePair.setFirst((Object)oldReviewCycleNodeInstance);
            }
        }
        for (Integer pos : reviewCycleNodeInstancePairsByNodePos.keySet()) {
            Pair reviewCycleNodeInstancePair = (Pair)reviewCycleNodeInstancePairsByNodePos.get(pos);
            this.updateReviewTasksOfNode((ReviewCycleNodeInstanceRelease)reviewCycleNodeInstancePair.getFirst(), (ReviewCycleNodeInstanceRelease)reviewCycleNodeInstancePair.getSecond(), newObjectList);
        }
    }

    private void updateReviewTasksOfCycle(ReviewCycleInstanceRelease oldReviewCycle, ReviewCycleInstanceRelease newReviewCycle, ReleasedObjectList newObjectList) {
        Map newReviewCycleCellInstances = newReviewCycle.getReviewCycleCellInstances();
        HashMap<Integer, ReviewCycleCellInstanceRelease> oldReviewCycleCellInstancesByCellId = new HashMap<Integer, ReviewCycleCellInstanceRelease>();
        Iterator it = null;
        if (oldReviewCycle != null) {
            Map oldReviewCycleCellInstances = oldReviewCycle.getReviewCycleCellInstances();
            for (ReviewCycleCellInstanceRelease oldReviewCycleCellInstance : oldReviewCycleCellInstances.values()) {
                oldReviewCycleCellInstancesByCellId.put(oldReviewCycleCellInstance.getReviewCycleCell().getId(), oldReviewCycleCellInstance);
            }
            it = newReviewCycleCellInstances.values().iterator();
        }
        while (it != null && it.hasNext()) {
            ReviewCycleCellInstanceRelease oldReviewCycleCellInstance;
            ReviewCycleCellInstanceRelease newReviewCycleCellInstance = (ReviewCycleCellInstanceRelease)it.next();
            oldReviewCycleCellInstance = (ReviewCycleCellInstanceRelease)oldReviewCycleCellInstancesByCellId.get(newReviewCycleCellInstance.getReviewCycleCell().getId());
            this.updateReviewTasksOfCell(oldReviewCycleCellInstance, newReviewCycleCellInstance, newObjectList);
        }
    }

    private void removeNodeTasks(DocumentVersionTask task) {
        if (!(task instanceof ReviewCycleNodeInstanceTaskQuery)) {
            return;
        }
        List tasks = this.taskDAO.getAll(task.getDocumentVersion());
        Integer rid = ((ReviewCycleNodeInstanceTaskQuery)((Object)task)).getReviewCycleNodeInstanceId();
        if (rid == null) {
            return;
        }
        for (Task delTask : tasks) {
            if (!(delTask instanceof ReviewCycleNodeInstanceTaskQuery) || !rid.equals(((ReviewCycleNodeInstanceTaskQuery)((Object)delTask)).getReviewCycleNodeInstanceId())) continue;
            this.removeTask(delTask.getId());
        }
    }

    public void setProjectDAO(ProjectDAO dao) {
        this.projectDAO = dao;
    }

    public void setTaskDAO(TaskDAO dao) {
        this.taskDAO = dao;
    }

    public void setObjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    public void setReviewCycleNodeInstanceDAO(ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO) {
        this.reviewCycleNodeInstanceDAO = reviewCycleNodeInstanceDAO;
    }

    public void setReviewCycleCellConnectionEvaluator(ReviewCycleCellConnectionEvaluator eval) {
        this.reviewCycleCellConnectionEvaluator = eval;
    }

    public void setReviewCycleCellResultDAO(ReviewCycleCellResultDAO reviewCycleCellResultDAO) {
        this.reviewCycleCellResultDAO = reviewCycleCellResultDAO;
    }

    public void setReviewCycleOperations(ReviewCycleOperations reviewCycleOperations) {
        this.reviewCycleOperations = reviewCycleOperations;
    }

    public void setHolidayCalculatorFactory(HolidayCalculatorFactory holidayCalculatorFactory) {
        this.holidayCalculatorFactory = holidayCalculatorFactory;
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setMailDAO(EMailDAO mailDAO) {
        this.mailDAO = mailDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setReviewCycleInstanceDAO(ReviewCycleInstanceDAO reviewCycleInstanceDAO) {
        this.reviewCycleInstanceDAO = reviewCycleInstanceDAO;
    }

    public void setReviewOperations(ReviewOperations reviewOperations) {
        this.reviewOperations = reviewOperations;
    }

    public void setObjectOperations(ObjectOperations objectOperations) {
        this.objectOperations = objectOperations;
    }

    public void setReviewCycleNodeResultDAO(ReviewCycleNodeResultDAO reviewCycleNodeResultDAO) {
        this.reviewCycleNodeResultDAO = reviewCycleNodeResultDAO;
    }

    public void setReviewCycleCellInstanceDAO(ReviewCycleCellInstanceDAO reviewCycleCellInstanceDAO) {
        this.reviewCycleCellInstanceDAO = reviewCycleCellInstanceDAO;
    }

    @Override
    public int generateAttachedReviewTasks(DocumentVersion documentVersion, ReviewCycleNodeInstanceRelease nodeInstance, Collection<AttachedReviewCyclePositionImpl> AttachedReviewPositions, Integer nodeResultId, boolean fixMissingTasks, boolean checkAndRestore) {
        AttachedReviewCyclePositionImpl r;
        int count = 0;
        List rps = null;
        rps = AttachedReviewPositions != null ? AttachedReviewPositions : this.reviewCyclePositionDAO.get(null, nodeInstance.getReviewCycleNodeInstance(), documentVersion, null);
        Iterator<AttachedReviewCyclePositionImpl> it = rps.iterator();
        AttachedReviewCyclePositionImpl attachedReviewCyclePositionImpl = r = it.hasNext() ? it.next() : null;
        while (r != null) {
            ProjectParticipation lastParticipation = r.getProjectParticipation();
            HashMap<Integer, AttachedReviewCyclePositionImpl> reviewCyclePositionReleases = new HashMap<Integer, AttachedReviewCyclePositionImpl>();
            while (r != null && r.getProjectParticipation().getId().equals(lastParticipation.getId())) {
                reviewCyclePositionReleases.put(r.getId(), r);
                r = it.hasNext() ? it.next() : null;
            }
            boolean generated = this.generateAttachedReviewTask(documentVersion, lastParticipation, nodeInstance, reviewCyclePositionReleases, nodeResultId, fixMissingTasks, checkAndRestore);
            if (!generated) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Collection<ReviewTask> getAllReviewTasks() {
        return this.taskDAO.getAllReviewTasks();
    }

    @Override
    public Collection<AttachedReviewTask> getAllAttachedReviewTasks() {
        return this.taskDAO.getAllAttachedReviewTasks();
    }

    @Override
    public Collection<SelectCellConnectionTask> getAllSelectCellConnectionTasks() {
        return this.taskDAO.getAllSelectCellConnectionTasks();
    }

    @Override
    public SelectCellConnectionTask getSelectCellConnectionTask(Integer id) {
        return (SelectCellConnectionTask)this.taskDAO.get(id);
    }

    @Override
    public List<SelectCellConnectionTask> getSelectCellConnectionTasks(Integer documentVersionId) {
        ArrayList<SelectCellConnectionTask> tasks = new ArrayList<SelectCellConnectionTask>();
        tasks.addAll(this.taskDAO.getAllSelectCellConnectionTasks(documentVersionId));
        return tasks;
    }

    @Override
    public List<DocumentVersionTask> getTasksOfDocumentVersion(Integer documentVersionId) {
        ArrayList<DocumentVersionTask> tasks = new ArrayList<DocumentVersionTask>();
        tasks.addAll(this.taskDAO.getAllAttachedReviewTasksByDocumentVersion(documentVersionId));
        tasks.addAll(this.taskDAO.getAllReviewTasksByDocumentVersion(documentVersionId));
        tasks.addAll(this.taskDAO.getAllSelectCellConnectionTasks(documentVersionId));
        return tasks;
    }

    @Override
    public ReviewCycleTask getFirstTaskOfDocumentVersion(Integer documentVersionId) {
        ArrayList<? extends Task> tasks = new ArrayList<Task>();
        tasks.addAll(this.taskDAO.getAllReviewTasksByDocumentVersion(documentVersionId));
        if (tasks.isEmpty()) {
            tasks.addAll(this.taskDAO.getAllAttachedReviewTasksByDocumentVersion(documentVersionId));
        }
        if (tasks.isEmpty()) {
            tasks.addAll(this.taskDAO.getAllSelectCellConnectionTasks(documentVersionId));
        }
        if (!tasks.isEmpty()) {
            return (ReviewCycleTask)tasks.get(0);
        }
        return null;
    }

    @Override
    public ReviewCycleEntryTask getReviewCycleEntryTask(Integer documentId) {
        return this.taskDAO.getReviewCycleEntryTaskByDocument(documentId);
    }

    @Override
    public void deleteDocumentTasks(Integer documentId) {
        ReviewCycleEntryTask t = this.taskDAO.getReviewCycleEntryTaskByDocument(documentId);
        if (t != null) {
            this.removeTask(t.getId());
        }
    }

    @Override
    public HolidayCalculatorFactory getHolidayCalculatorFactory() {
        return this.holidayCalculatorFactory;
    }

    @Override
    public Collection<TaskMonitoringResult> getTaskMonitoringResults() {
        return this.taskDAO.getTaskMonitoringResults();
    }

    @Override
    public void deleteAllTaskMonitoringResults() {
        this.taskDAO.deleteAllTaskMonitoringResults();
    }

    @Override
    public TaskMonitoringResult saveTaskMonitoringResult(TaskMonitoringResult res) {
        return this.taskDAO.save(res);
    }

    public void setReviewCyclePositionResultDAO(ReviewCyclePositionResultDAO reviewCyclePositionResultDAO) {
        this.reviewCyclePositionResultDAO = reviewCyclePositionResultDAO;
    }

    @Override
    public ReviewCyclePlottTask getReviewCyclePlottTask(Integer orderStepId) {
        return this.taskDAO.getReviewCyclePlottTask(orderStepId);
    }

    @Override
    public ReviewCyclePlottTaskDone getReviewCyclePlottTaskDone(Integer orderStepId) {
        return this.taskDAO.getReviewCyclePlottTaskDone(orderStepId);
    }

    @Override
    public Collection getPlottAcceptanceTasks(Integer plotOrderId) {
        return this.taskDAO.getPlotOrderAcceptanceTasksByPlotOrder(plotOrderId);
    }

    @Override
    public Collection getPlottAcceptanceTasksDone(Integer plotOrderId) {
        return this.taskDAO.getPlotOrderAcceptanceTasksDoneByPlotOrder(plotOrderId);
    }

    @Override
    public OriginalDocumentTask getOriginalDocumentTask(Integer orderStepId) {
        return this.taskDAO.getOriginalDocumentTask(orderStepId);
    }

    @Override
    public int getTabViewmode() {
        return this.tabViewmode;
    }

    public void setTabViewmode(int tabViewmode) {
        this.tabViewmode = tabViewmode;
    }

    @Override
    public Collection getReviewTasksOfDocumentVersion(Integer documentVersionId) {
        return this.taskDAO.getReviewTasksOfDocumentVersion(documentVersionId);
    }

    public void setDocumentVersionDAO(DocumentVersionDAO documentVersionDAO) {
        this.documentVersionDAO = documentVersionDAO;
    }

    public void setObjectListDAO(ObjectListDAO objectListDAO) {
        this.objectListDAO = objectListDAO;
    }

    @Override
    public int checkAndRestorePlannerEntryTasks(SubProject subProject, boolean checkAndRestore) {
        int countEt = 0;
        ReleasedObjectList objectListRel = null;
        ReleasedDocumentList documentListRel = null;
        objectListRel = subProject.getActiveObjectList();
        if (objectListRel == null) {
            return 0;
        }
        documentListRel = subProject.getActiveDocumentList();
        if (documentListRel != null) {
            Collection documents = documentListRel.getDocuments().values();
            for (ReleasedDocument document : documents) {
                if (document.getDocument().isInvalidated()) continue;
                ReleasedObjectPlanner objectPlannerRel = this.objectOperations.getReleasedObjectPlannerFromList(document.getObjectPlanner().getId(), objectListRel.getId());
                String object = document.getObjectPlanner().getObject().getCode() + " [" + document.getObjectPlanner().getCode() + "]";
                String planner = document.getObjectPlanner().getPlanner().getOrganisation().getName() + " (" + document.getObjectPlanner().getPlanner().getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName() + ")";
                List<DocumentVersion> docVersions = document.getDocumentVersionsSortedByVersion();
                if (objectPlannerRel == null || objectPlannerRel.getPlanner() == null || objectPlannerRel.getPlanner().getId() == null || document.getStartDate() == null || !docVersions.isEmpty()) continue;
                Calendar docsStartDate = Calendar.getInstance();
                docsStartDate.setTime(document.getStartDate());
                ReviewCycleEntryTask task = this.getReviewCycleEntryTask(document.getDocument().getId());
                if (task == null) {
                    ++countEt;
                    log.info("++++++++ " + (checkAndRestore ? "generating " : "generating (only checkmode) ") + "missing plannerEntryTask for planner " + planner + " in object " + object + " to document " + document.getDocument().getName() + " (id=" + document.getId() + ") documentListId=" + documentListRel.getId());
                    if (!checkAndRestore) continue;
                    this.generateReviewCycleEntryTask(objectPlannerRel, document.getDocument());
                    continue;
                }
                if (docsStartDate == null || task.getEndDate().equals(docsStartDate)) continue;
                Date ddocsStartDate = docsStartDate.getTime();
                Date dtaskEndDate = task.getEndDate().getTime();
                log.info((checkAndRestore ? "updating " : "updating (only checkmode) ") + "different dates of plannerEntryTask for planner " + planner + " in object " + object + " to document " + document.getDocument().getName() + " (id=" + document.getId() + ") documentListId=" + documentListRel.getId() + ") docsStartDate=" + ddocsStartDate + ") taskEndDate=" + dtaskEndDate);
                if (!checkAndRestore) continue;
                this.updateDocumentTasksOfDocument(document, objectListRel, subProject.getProject());
            }
        }
        if (countEt > 0) {
            log.info(countEt + " missing plannerEntryTask " + (checkAndRestore ? "restored!" : "!"));
        } else {
            log.info("no missing plannerTasks found");
        }
        return countEt;
    }

    @Override
    public Task updateTask(Task task) {
        return this.taskDAO.update(task);
    }

    @Override
    public List getDocumentVersionTasksOfDocumentVersion(DocumentVersion version) {
        return this.taskDAO.getAll(version);
    }

    @Override
    public List getSelectCellConnectionTasksDoneByConnectionResult(Integer cellConnectionResultId) {
        return this.taskDAO.getSelectCellConnectionTasksDoneByConnectionResult(cellConnectionResultId);
    }

    @Override
    public ReviewCycleEntryTaskDone getReviewCycleEntryTaskDoneByEntryResult(Integer entryResultId) {
        return this.taskDAO.getReviewCycleEntryTaskDoneByEntryResult(entryResultId);
    }

    public void setReviewCyclePositionDAO(ReviewCyclePositionDAO reviewCyclePositionDAO) {
        this.reviewCyclePositionDAO = reviewCyclePositionDAO;
    }

    @Override
    public Pair<Integer, Integer> checkAndRepairPlotOrderAcceptanceTasks(PlottOrder givenPlottOrder, boolean checkOnly) {
        log.info("starting checkAndRepairPlotOrderAcceptanceTasks");
        int numberOfRegeneratedTasks = 0;
        int numberOfDeletedTasks = 0;
        List plottOrders = null;
        if (givenPlottOrder == null) {
            plottOrders = this.orderDAO.getAll();
        } else {
            plottOrders.add(givenPlottOrder);
        }
        for (PlottOrder plottOrder : plottOrders) {
            OrderStepImpl completedOrderStep = plottOrder.getCompleted();
            if (completedOrderStep == null || completedOrderStep.getSignature() == null) {
                if (givenPlottOrder == null) continue;
                return new Pair((Object)-1, (Object)-1);
            }
            Calendar finished = Calendar.getInstance();
            finished.setTime(completedOrderStep.getFinished());
            ArrayList items = new ArrayList(plottOrder.getOrderItems().values());
            HashMap<Integer, Boolean> receiverAllStepsSignedMap = new HashMap<Integer, Boolean>();
            for (PlottOrderItem item : items) {
                if (item.getReceiverId() == null || item.getDocumentVersion().isInvalidatedOrDeleted()) continue;
                Integer receiverId = item.getReceiverId();
                ProjectParticipation pp = this.projectParticipationDAO.get(receiverId);
                if (!receiverAllStepsSignedMap.containsKey(receiverId)) {
                    receiverAllStepsSignedMap.put(receiverId, true);
                }
                DocumentVersion docVersion = item.getDocumentVersion();
                ObjectPlanner op = docVersion.getDocument().getObjectPlanner();
                Localisation localisation = docVersion.getDocument().getDocumentList().getSubProject().getProject().getLocalisation();
                OrderStepImpl orderStep = this.orderDAO.getOrderStepByOrderItemId(item.getId());
                if (orderStep == null) {
                    ProjectParticipationOrderStep step = new ProjectParticipationOrderStep();
                    step.setCreated(completedOrderStep.getFinished() != null ? completedOrderStep.getFinished() : new Date(System.currentTimeMillis()));
                    step.setProjectParticipation(pp);
                    step.setOrderItemId(item.getId());
                    log.info("orderstep restored for orderId= " + plottOrder.getId() + " and projectParticipationId= " + pp.getId());
                }
                if (orderStep == null || orderStep.getSignature() != null) continue;
                receiverAllStepsSignedMap.replace(receiverId, false);
            }
            for (Integer receiverId : receiverAllStepsSignedMap.keySet()) {
                boolean allStepsSigned = (Boolean)receiverAllStepsSignedMap.get(receiverId);
                PlotOrderAcceptanceTask acceptanceTask = this.taskDAO.getPlotOrderAcceptanceTaskByPlotOrderAndParticipation(plottOrder.getId(), receiverId);
                if (acceptanceTask != null && allStepsSigned) {
                    if (!checkOnly) {
                        log.info("Critical action during checkAndRepairPlotOrderAcceptanceTasks: action=[remove task] context=[" + acceptanceTask.getId() + "]");
                        this.removeTask(acceptanceTask.getId());
                    }
                    log.info("plotOrderAcceptanceTask #" + ++numberOfDeletedTasks + " deleted for orderId= " + plottOrder.getId() + " and projectParticipationId= " + receiverId);
                }
                if (acceptanceTask != null || allStepsSigned) continue;
                log.info("plotOrderAcceptanceTask #" + ++numberOfRegeneratedTasks + " restored for orderId= " + plottOrder.getId() + " and projectParticipationId= " + receiverId);
            }
        }
        log.info("finishing checkAndRepairPlotOrderAcceptanceTasks: numberOfRegeneratedTasks= " + numberOfRegeneratedTasks + " ,numberOfDeletedTasks= " + numberOfDeletedTasks);
        return new Pair((Object)numberOfRegeneratedTasks, (Object)numberOfDeletedTasks);
    }

    @Override
    public void generatePlotOrderAcceptanceTasks(ReviewCyclePlottTask task, Collection<ProjectParticipation> participants) {
        for (ProjectParticipation part : participants) {
            PlotOrderAcceptanceTask acceptanceTask = new PlotOrderAcceptanceTask();
            acceptanceTask.setProjectParticipationId(part.getId());
            Locale locale = new Locale(part.getMainParticipant().getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
            I18n i18n = I18nFactory.getI18n(locale);
            acceptanceTask.setBeginDate(new GregorianCalendar());
            acceptanceTask.setDocumentVersion(task.getDocumentVersion());
            acceptanceTask.setName(i18n.tr("Plotauftrag Lieferbest\u00e4tigung"));
            acceptanceTask.setOrder(task.getOrder());
            acceptanceTask.setObjectPlanner(task.getObjectPlanner());
            acceptanceTask.setOrderStep(task.getOrderStep());
            acceptanceTask.setLocalisation(task.getLocalisation());
            this.taskDAO.save(acceptanceTask);
        }
    }

    @Override
    public void doPlotOrderAcceptanceTask(PlotOrderAcceptanceTask task) {
        PlotOrderAcceptanceTaskDone doneTask = new PlotOrderAcceptanceTaskDone();
        doneTask.setProjectParticipationId(task.getProjectParticipationId());
        ProjectParticipation part = this.projectParticipationDAO.get(task.getProjectParticipationId());
        Locale locale = new Locale(part.getMainParticipant().getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        doneTask.setBeginDate(task.getBeginDate());
        doneTask.setDocumentVersion(task.getDocumentVersion());
        doneTask.setName(i18n.tr("Plotauftrag Lieferbest\u00e4tigung"));
        doneTask.setOrder(task.getOrder());
        doneTask.setObjectPlanner(task.getObjectPlanner());
        doneTask.setOrderStep(task.getOrderStep());
        doneTask.setLocalisation(task.getLocalisation());
        doneTask.setDone(true);
        doneTask.setDoneDate(new GregorianCalendar());
        doneTask.setObsoletedDate(new GregorianCalendar());
        this.taskDAO.delete(task.getId());
        this.taskDAO.save(doneTask);
    }

    @Override
    public Collection<ReviewableTask> getAllLateReviewTasks(List<Integer> allowedProjects) {
        GregorianCalendar today = new GregorianCalendar();
        List allTasks = new ArrayList();
        ArrayList<ReviewableTask> tasks = new ArrayList<ReviewableTask>();
        allTasks = this.taskDAO.getAllLateReviewTasks(today, null);
        for (ReviewableTask t : allTasks) {
            Integer projectId = t.getDocumentVersion().getDocument().getDocumentList().getSubProject().getProject().getId();
            if (!allowedProjects.contains(projectId)) continue;
            tasks.add(t);
        }
        return tasks;
    }

    @Override
    public Collection getAllLateUploadTasks(List<Integer> allowedProjects) {
        GregorianCalendar today = new GregorianCalendar();
        List allTasks = new ArrayList();
        ArrayList<Task> tasks = new ArrayList<Task>();
        allTasks = this.taskDAO.getAllLateUploadTasks(today, null);
        for (Task t : allTasks) {
            Integer projectId = t.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getId();
            if (!allowedProjects.contains(projectId)) continue;
            tasks.add(t);
        }
        return tasks;
    }

    private void updateAttachedReviewTasksOfDetachedReviewCycleInstances(Map<Integer, Pair<Integer, Integer>> detachedReviewCycleInstances) {
        for (Pair<Integer, Integer> rciIdPair : detachedReviewCycleInstances.values()) {
            List attRevTasks = this.taskDAO.getAttachedReviewTasksOfReviewCycleInstance(this.reviewCycleInstanceDAO.get((Integer)rciIdPair.getSecond()));
            for (AttachedReviewTask attRevTask : attRevTasks) {
                if (!attRevTask.getDocumentVersion().getDocument().getObjectPlanner().getReviewCycleInstance().getId().equals(rciIdPair.getFirst())) continue;
                ReviewCycleNodeInstanceImpl newReviewCycleNodeInstance = this.reviewCycleNodeInstanceDAO.getUnreleased(this.reviewCycleInstanceDAO.get((Integer)rciIdPair.getFirst()), this.reviewCycleNodeInstanceDAO.get(attRevTask.getReviewCycleNodeInstanceId()).getReviewCycleNode());
                attRevTask.setReviewCycleNodeInstanceId(newReviewCycleNodeInstance.getId());
                this.taskDAO.update(attRevTask);
                Collection attachedPositions = attRevTask.getReviewCyclePositionReleases().values();
                for (AttachedReviewCyclePositionImpl attachedPos : attachedPositions) {
                    attachedPos.setReviewCycleNodeInstance(newReviewCycleNodeInstance);
                    this.reviewCyclePositionDAO.update(attachedPos);
                }
            }
        }
    }

    @Override
    public List<SelectCellConnectionTask> getSelectCellConnectionTasksForDocument(Integer documentImplId) {
        return this.taskDAO.getSelectCellConnectionTasksForDocument(documentImplId);
    }

    @Override
    public boolean hasPlotTaskReferences(Integer projectParticipationId) {
        if (this.taskDAO.hasPlotTasks(projectParticipationId)) {
            return true;
        }
        Integer projectId = this.projectParticipationDAO.get(projectParticipationId).getProject().getId();
        List allPlottTasksOfProject = this.taskDAO.getAllPlottTasksOfProject(projectId);
        for (ReviewCyclePlottTask task : allPlottTasksOfProject) {
            OrderStepImpl itemsStep;
            PlottOrderItem orderItem;
            if (task.getOrderStep().getOrderItemId() == null || !(orderItem = this.orderDAO.getPlottOrderItem(task.getOrderStep().getOrderItemId())).getOrderContract().getTemplate().getTemplateResolver().equals("ProjectParticipationPlotTemplate") || orderItem.getReceiverId() == null || !orderItem.getReceiverId().equals(projectParticipationId) || (itemsStep = this.orderDAO.getOrderStepByOrderItemId(orderItem.getId())).getFinished() != null) continue;
            return true;
        }
        List orderItems = this.orderDAO.getAllOrderItemsOfReceiverAndPlottOrder(projectParticipationId, null);
        for (PlottOrderItem orderItem : orderItems) {
            OrderStepImpl orderStep = this.orderDAO.getOrderStepByOrderItemId(orderItem.getId());
            if (orderStep == null || orderStep.getFinished() != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<AttachedReviewTask> getAllAttachedReviewTasksByParticipation(Integer projectParticipationId) {
        return this.taskDAO.getAllAttachedReviewTasksByParticipation(projectParticipationId);
    }

    public void setOrderDAO(OrderDAO orderDAO) {
        this.orderDAO = orderDAO;
    }

    @Override
    public List<Task> getAllDeletableTasksOfSubProject(Integer subProjectId) {
        return this.taskDAO.getAllDeletableTasksOfSubProject(subProjectId);
    }

    @Override
    public boolean isAttachedReviewPositionResult(Integer reviewCyclePositionResultId) {
        return this.taskDAO.isAttachedPositionResult(reviewCyclePositionResultId);
    }

    @Override
    public void updateRecalculatedTaskDeadlines(Integer taskId, boolean testOnly) {
        Integer reviewCycleInstanceId;
        DocumentVersionTaskBase task = (DocumentVersionTaskBase)this.taskDAO.get(taskId);
        SubProject sp = task.getDocumentVersion().getDocument().getDocumentList().getSubProject();
        ReviewCycleNodeInstanceImpl actualReviewCycleNodeInstance = task.getDocumentVersion().getActualReviewCycleNodeInstance();
        Integer actualNodesReviewCycleInstanceId = actualReviewCycleNodeInstance.getReviewCycleCellInstance().getReviewCycleInstance().getId();
        if (!actualNodesReviewCycleInstanceId.equals(reviewCycleInstanceId = task.getDocumentVersion().getDocument().getObjectPlanner().getReviewCycleInstance().getId())) {
            log.error("actualNodesReviewCycleInstanceId not equal reviewCycleInstanceId!!!...... Processing task [" + task.getId() + "]; actualReviewCycleNodeInstance [" + actualReviewCycleNodeInstance.getId() + "]; documentVersionId [" + task.getDocumentVersion().getId() + "]; documentVersionName [" + task.getDocumentVersion().getName() + "]");
        }
        ReviewCycleInstanceRelease reviewCycleInstanceRel = this.reviewCycleInstanceDAO.getReleased(sp.getActiveObjectList().getId(), reviewCycleInstanceId);
        ReviewCycleNodeInstanceRelease reviewCycleNodeInstanceRel = this.reviewCycleNodeInstanceDAO.getReleased(reviewCycleInstanceRel.getId(), actualReviewCycleNodeInstance.getReviewCycleNode().getId());
        Calendar oldStart = task.getBeginDate();
        Calendar oldEnd = task.getEndDate();
        Project project = sp.getProject();
        boolean usePDCStartDateForTasks = project.isUsePDCStartDateForTasks();
        ReviewCycleNodeInstanceImpl nodeInstance = task.getDocumentVersion().getActualReviewCycleNodeInstance();
        ReviewCycleInstanceRelease relCycleInstance = this.reviewCycleInstanceDAO.getReleased(sp.getActiveObjectList().getId(), nodeInstance.getReviewCycleCellInstance().getReviewCycleInstance().getId());
        ReviewCycleNodeInstanceRelease relNodeInstance = this.reviewCycleNodeInstanceDAO.getReleased(relCycleInstance.getId(), nodeInstance.getReviewCycleNode().getId());
        if (log.isDebugEnabled()) {
            log.debug("...... Processing task [" + task.getId() + "]; actualReviewCycleNodeInstance [" + actualReviewCycleNodeInstance.getId() + "]; ReviewCycleInstanceRelease [" + reviewCycleInstanceRel.getId() + "]; ReviewCycleNodeInstanceRelease [" + reviewCycleNodeInstanceRel.getId() + "]");
        }
        boolean isFirstDocumentVersion = false;
        if (task.getDocumentVersion().getDocument().getDocumentVersions() != null && task.getDocumentVersion().getDocument().getDocumentVersions().size() == 1) {
            isFirstDocumentVersion = true;
        }
        boolean usePDCStartDate = usePDCStartDateForTasks && task instanceof ReviewableTask && isFirstDocumentVersion && reviewCycleNodeInstanceRel.getReviewCycleNode().getPosition().equals(1);
        this.generateTaskDeadlines(task, sp.getProject().getId(), task.getDocumentVersion().getDocument().getId(), reviewCycleNodeInstanceRel, usePDCStartDate);
        if (task.getBeginDate().compareTo(oldStart) != 0 || task.getEndDate().compareTo(oldEnd) != 0) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            log.info("found deadlines to update for task with id=[" + taskId + "]: oldStart=[" + oldStart.getTime() + "] newStart=[" + task.getBeginDate().getTime() + "] oldEnd=[" + oldEnd.getTime() + "] newEnd=[" + task.getEndDate().getTime() + "]");
            if (!testOnly) {
                ProjectParticipation projectParticipation = this.projectParticipationDAO.get(task.getProjectParticipationId());
                this.generateTaskEMailSnippets(task, projectParticipation, 2);
                this.generateTaskLateFutureEMail(task, sp.getProject());
                this.taskDAO.update(task);
            }
        } else {
            log.info("deadlines for task with id=[" + taskId + "] seem correct and do not need an update.");
        }
    }

    private void updateRecalculatedDocumentTaskDeadlines(Integer taskId, boolean testOnly) {
        DocumentTask task = (DocumentTask)this.taskDAO.get(taskId);
        SubProject sp = task.getDocument().getDocumentList().getSubProject();
        ReleasedObjectPlanner op = this.objectPlannerDAO.getReleasedObjectPlanner(sp.getActiveObjectList().getId(), task.getDocument().getObjectPlanner().getId());
        Calendar oldStart = task.getBeginDate();
        Calendar oldEnd = task.getEndDate();
        this.generateTaskDeadlines(task, sp.getProject().getId(), task.getDocument().getId(), op.getReviewCycleInstance().getDuration(), op.getReviewCycleInstance().getPreDuration());
        if (task.getBeginDate().compareTo(oldStart) != 0 || task.getEndDate().compareTo(oldEnd) != 0) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            log.info("found deadlines to update for task with id=[" + taskId + "]: oldStart=[" + oldStart.getTime() + "] newStart=[" + task.getBeginDate().getTime() + "] oldEnd=[" + oldEnd.getTime() + "] newEnd=[" + task.getEndDate().getTime() + "]");
            if (!testOnly) {
                ProjectParticipation projectParticipation = this.projectParticipationDAO.get(task.getProjectParticipationId());
                this.generateTaskEMailSnippets(task, projectParticipation, 2);
                this.generateTaskLateFutureEMail(task, sp.getProject());
                this.taskDAO.update(task);
            }
        } else {
            log.info("deadlines for task with id=[" + taskId + "] seem correct and do not need an update.");
        }
    }

    @Override
    public void updateRecalculateProjectTaskDeadlines(Integer projectId) {
        List<Task> allTasks = this.taskDAO.getAllTasksOfProject(projectId);
        Project project = this.projectDAO.get(projectId);
        ArrayList holidays = new ArrayList(project.getHolidays().values());
        HolidayCalculator holicalc = this.holidayCalculatorFactory.getInstance(project);
        for (Task task : allTasks) {
            if (!(task instanceof ReviewCycleEntryTask) && !(task instanceof SelectCellConnectionTask) && !(task instanceof ReviewTask) && !(task instanceof AttachedReviewTask)) continue;
            if (task instanceof ReviewCycleEntryTask) {
                this.updateRecalculatedDocumentTaskDeadlines(task.getId(), false);
                continue;
            }
            this.updateRecalculatedTaskDeadlines(task.getId(), false);
        }
    }

    @Override
    public TaskTOContainer evalGetAllTaskTOs(Integer orgPersonId, String viewMode, String proxyMode, Locale locale, boolean isOOOMode, boolean showProxySignatureFolderTasks, boolean gwtRendering, boolean isTimeFilteredGWT, Date startDateFilterGWT, Date endDateFilterGWT) {
        int doneInLastXDaysTasks;
        int signatureFolderTasks;
        int overrideTasks;
        int mainParticipantTasks;
        int proxyTasks;
        int datelessTasks;
        int distantTasks;
        int todaysTasks;
        int delayedTasks;
        int allTasks;
        TaskTOContainer container;
        block60: {
            List<Project> monitoringProjects;
            ArrayList<Integer> ownLateTaskIds;
            Calendar now;
            I18n i18n;
            block61: {
                i18n = I18nFactory.getI18n(locale);
                container = new TaskTOContainer();
                List pps = this.projectOperations.getWriteableProjectParticipations(orgPersonId);
                OrganisationPerson op = this.organisationPersonDAO.get(orgPersonId);
                ArrayList taskTOs = new ArrayList();
                now = Calendar.getInstance();
                ownLateTaskIds = new ArrayList<Integer>();
                allTasks = 0;
                delayedTasks = 0;
                todaysTasks = 0;
                distantTasks = 0;
                datelessTasks = 0;
                proxyTasks = 0;
                mainParticipantTasks = 0;
                overrideTasks = 0;
                signatureFolderTasks = 0;
                doneInLastXDaysTasks = 0;
                Calendar today = Calendar.getInstance();
                Calendar fromX = Calendar.getInstance();
                fromX.add(6, -1 * op.getPerson().getPersonVariables(false).getDisplayedDaysOfDoneTasks());
                for (ProjectParticipation pp : pps) {
                    HolidayCalculator holicalc = this.holidayCalculatorFactory.getInstance(pp.getProject());
                    Calendar personalDeadline = holicalc.addWorkingDays(now, op.getPerson().getPersonVariables(false).getDisplayedDaysUntilDue() + 1);
                    ArrayList<Task> tasks = new ArrayList<Task>();
                    if (!gwtRendering || gwtRendering && (viewMode.equals("all") || viewMode.equals("7")) && !isTimeFilteredGWT) {
                        tasks.addAll(this.taskDAO.getAllProjectParticipationAttachedReviewTodos(pp.getId()));
                        tasks.addAll(this.taskDAO.getAllProjectParticipationReviewTodos(pp.getId()));
                        tasks.addAll(this.taskDAO.getAllProjectParticipationSelectCellConnectionTodos(pp.getId()));
                        tasks.addAll(this.taskDAO.getAllProjectParticipationReviewCycleEntryTodos(pp.getId()));
                        tasks.addAll(this.taskDAO.getAllProjectParticipationReviewCyclePlottTodos(pp.getId()));
                        tasks.addAll(this.taskDAO.getAllProjectParticipationOriginalDocumentTodos(pp.getId()));
                        tasks.addAll(this.taskDAO.getAllPlotOrderAcceptanceTodos(pp.getId()));
                    } else if (viewMode.equals("all") || viewMode.equals("7")) {
                        tasks.addAll(this.taskDAO.getTasksBetween(AttachedReviewTask.class, pp.getId(), startDateFilterGWT, endDateFilterGWT, null));
                        tasks.addAll(this.taskDAO.getTasksBetween(ReviewTask.class, pp.getId(), startDateFilterGWT, endDateFilterGWT, null));
                        tasks.addAll(this.taskDAO.getTasksBetween(SelectCellConnectionTask.class, pp.getId(), startDateFilterGWT, endDateFilterGWT, null));
                        tasks.addAll(this.taskDAO.getTasksBetween(ReviewCycleEntryTask.class, pp.getId(), startDateFilterGWT, endDateFilterGWT, null));
                        tasks.addAll(this.taskDAO.getTasksBetween(ReviewCyclePlottTask.class, pp.getId(), startDateFilterGWT, endDateFilterGWT, null));
                        tasks.addAll(this.taskDAO.getTasksBetween(OriginalDocumentTask.class, pp.getId(), startDateFilterGWT, endDateFilterGWT, null));
                        tasks.addAll(this.taskDAO.getTasksBetween(PlotOrderAcceptanceTask.class, pp.getId(), startDateFilterGWT, endDateFilterGWT, null));
                    }
                    for (Task task : tasks) {
                        Integer objectPlannerId;
                        Integer subProjectId = null;
                        ReleasedObjectPlanner relObjectPlanner = null;
                        if (task instanceof DocumentTask) {
                            if (((DocumentTask)task).getDocument().getDocumentList().getSubProject().isReadOnly() || ((DocumentTask)task).getObjectPlanner().getObject().isReadOnly()) continue;
                            subProjectId = ((DocumentTask)task).getDocument().getDocumentList().getSubProject().getId();
                            objectPlannerId = ((DocumentTask)task).getDocument().getObjectPlanner().getId();
                        } else {
                            if (((DocumentVersionTaskBase)task).getDocumentVersion().getDocument().getDocumentList().getSubProject().isReadOnly() || !(task instanceof ReviewCyclePlottTask) && !(task instanceof PlotOrderAcceptanceTask) && ((DocumentVersionTaskBase)task).getDocumentVersion().getDocument().getObjectPlanner().getObject().isReadOnly()) continue;
                            subProjectId = ((DocumentVersionTaskBase)task).getDocumentVersion().getDocument().getDocumentList().getSubProject().getId();
                            objectPlannerId = ((DocumentVersionTaskBase)task).getDocumentVersion().getDocument().getObjectPlanner().getId();
                        }
                        if (objectPlannerId != null && subProjectId != null) {
                            relObjectPlanner = this.objectOperations.getReleasedObjectPlannerFromActiveObjectList(objectPlannerId, subProjectId);
                        }
                        boolean addToContainer = false;
                        boolean isMainParticipantTask = orgPersonId.equals(pp.getMainParticipant().getOrganisationPerson().getId());
                        int diff = 0;
                        boolean isOwnSignatureFolderTask = false;
                        if (viewMode.equals("7") && task instanceof ReviewableTask && ((ReviewableTask)task).isTaskInSignatureFolder()) {
                            isOwnSignatureFolderTask = this.taskOverviewTaskTOGenerator.isOwnSignatureFolderTask((ReviewableTask)task, orgPersonId);
                            if (!isOwnSignatureFolderTask) {
                                container.setContainingProxySignatureFolderTasks(true);
                            }
                            if (proxyMode.equals("4") && isOwnSignatureFolderTask || proxyMode.equals("5") && !isOwnSignatureFolderTask) continue;
                            ++signatureFolderTasks;
                            if (!viewMode.equals("7")) continue;
                            addToContainer = true;
                        } else if (!(viewMode.equals("7") || task instanceof ReviewableTask && ((ReviewableTask)task).isTaskInSignatureFolder())) {
                            if (task instanceof ReviewableTask || task instanceof ReviewCycleEntryTask || task instanceof SelectCellConnectionTask) {
                                diff = holicalc.getWorkingDaysBetween(task.getEndDate(), now);
                                boolean isBelatedOrWithinConfiguredTimespan = personalDeadline.after(task.getEndDate());
                                if (isBelatedOrWithinConfiguredTimespan) {
                                    if (viewMode.equals("0")) {
                                        addToContainer = true;
                                    }
                                    ++delayedTasks;
                                    ownLateTaskIds.add(task.getId());
                                }
                                if (diff < 0) {
                                    if (viewMode.equals("2")) {
                                        addToContainer = true;
                                    }
                                    ++distantTasks;
                                } else if (diff == 0) {
                                    if (viewMode.equals("1")) {
                                        addToContainer = true;
                                    }
                                    ++todaysTasks;
                                }
                            } else {
                                if (viewMode.equals("3")) {
                                    addToContainer = true;
                                }
                                ++datelessTasks;
                            }
                            if (isMainParticipantTask) {
                                if (proxyMode.equals("5")) {
                                    addToContainer = true;
                                }
                                ++mainParticipantTasks;
                            } else {
                                if (proxyMode.equals("4")) {
                                    addToContainer = true;
                                }
                                ++proxyTasks;
                            }
                            if (proxyMode.equals("all")) {
                                addToContainer = true;
                            }
                            ++allTasks;
                        }
                        if (!addToContainer) continue;
                        TaskTO taskTO = this.taskOverviewTaskTOGenerator.generateTaskTO(task, now, holicalc, isMainParticipantTask, i18n, isOOOMode);
                        if (relObjectPlanner != null) {
                            taskTO.setSubGroup(relObjectPlanner.getObject().getCode());
                            taskTO.setSubGroupDetails(relObjectPlanner.getObject().getName());
                        }
                        taskTO.setOwnSignatureFolderTask(isOwnSignatureFolderTask);
                        container.addTaskTO(taskTO);
                    }
                    ArrayList<Task> doneTasks = new ArrayList<Task>();
                    if (!gwtRendering) {
                        doneTasks.addAll(this.taskDAO.getAllDoneTasksBetween(pp.getId(), fromX.getTime(), today.getTime()));
                    } else if (viewMode.equals("8")) {
                        doneTasks.addAll(this.taskDAO.getAllDoneTasksBetween(pp.getId(), startDateFilterGWT, endDateFilterGWT));
                    }
                    for (Task doneTask : doneTasks) {
                        Integer objectPlannerId;
                        Integer subProjectId = null;
                        ReleasedObjectPlanner relObjectPlanner = null;
                        if (doneTask instanceof DocumentTask) {
                            subProjectId = ((DocumentTask)doneTask).getDocument().getDocumentList().getSubProject().getId();
                            objectPlannerId = ((DocumentTask)doneTask).getDocument().getObjectPlanner().getId();
                        } else {
                            subProjectId = ((DocumentVersionTaskBase)doneTask).getDocumentVersion().getDocument().getDocumentList().getSubProject().getId();
                            objectPlannerId = ((DocumentVersionTaskBase)doneTask).getDocumentVersion().getDocument().getObjectPlanner().getId();
                        }
                        if (objectPlannerId != null && subProjectId != null) {
                            relObjectPlanner = this.objectOperations.getReleasedObjectPlannerFromActiveObjectList(objectPlannerId, subProjectId);
                        }
                        boolean isOwnSignature = false;
                        if (doneTask instanceof ReviewableTaskDone) {
                            Collection results = null;
                            results = doneTask instanceof ReviewTaskDone ? ((ReviewTaskDone)doneTask).getReviewCyclePositionResults().values() : ((AttachedReviewTaskDone)doneTask).getReviewCyclePositionResults().values();
                            for (ReviewCyclePositionResult result : results) {
                                if (result.getSignature().getProjectParticipant().getOrganisationPerson().getId().equals(orgPersonId)) {
                                    isOwnSignature = true;
                                }
                                if (!isOwnSignature) continue;
                                break;
                            }
                        } else if (doneTask instanceof SelectCellConnectionTaskDone) {
                            isOwnSignature = ((SelectCellConnectionTaskDone)doneTask).getReviewCycleCellConnectionResult().getSignature().getProjectParticipant().getOrganisationPerson().getId().equals(orgPersonId);
                        } else if (doneTask instanceof ReviewCycleEntryTaskDone) {
                            isOwnSignature = ((ReviewCycleEntryTaskDone)doneTask).getReviewCycleEntryResult().getSignature().getProjectParticipant().getOrganisationPerson().getId().equals(orgPersonId);
                        } else if (doneTask instanceof OriginalDocumentTaskDone) {
                            isOwnSignature = true;
                        } else if (doneTask instanceof PlotOrderAcceptanceTaskDone) {
                            isOwnSignature = ((PlotOrderAcceptanceTaskDone)doneTask).getOrderStep().getSignature().getProjectParticipant().getOrganisationPerson().getId().equals(orgPersonId);
                        } else if (doneTask instanceof ReviewCyclePlottTaskDone) {
                            isOwnSignature = ((ReviewCyclePlottTaskDone)doneTask).getOrderStep().getSignature().getProjectParticipant().getOrganisationPerson().getId().equals(orgPersonId);
                        }
                        if (!isOwnSignature) continue;
                        ++doneInLastXDaysTasks;
                        if (!viewMode.equals("8")) continue;
                        boolean isMainParticipantTask = orgPersonId.equals(pp.getMainParticipant().getOrganisationPerson().getId());
                        TaskTO taskTO = this.taskOverviewTaskTOGenerator.generateDoneTaskTO(doneTask, isMainParticipantTask, i18n, isOOOMode);
                        if (relObjectPlanner != null) {
                            taskTO.setSubGroup(relObjectPlanner.getObject().getCode());
                            taskTO.setSubGroupDetails(relObjectPlanner.getObject().getName());
                        }
                        container.addTaskTO(taskTO);
                    }
                }
                monitoringProjects = this.projectDAO.getAllProjectsWithMonitoringParticipation(orgPersonId);
                if (monitoringProjects == null || monitoringProjects.isEmpty()) break block60;
                if (!gwtRendering) break block61;
                if (!viewMode.equals("6")) break block60;
            }
            for (Project p : monitoringProjects) {
                ArrayList monitoredTasks = new ArrayList();
                if (!gwtRendering) {
                    monitoredTasks.addAll(this.taskDAO.getAllLateReviewTasks(now, p.getId()));
                    monitoredTasks.addAll(this.taskDAO.getAllLateUploadTasks(now, p.getId()));
                } else if (viewMode.equals("6")) {
                    monitoredTasks.addAll(this.taskDAO.getAllLateReviewTasks(now, p.getId()));
                    monitoredTasks.addAll(this.taskDAO.getAllLateUploadTasks(now, p.getId()));
                }
                for (Task task : monitoredTasks) {
                    if (task instanceof DocumentTask ? ((DocumentTask)task).getDocument().getDocumentList().getSubProject().isReadOnly() : task instanceof DocumentVersionTaskBase && ((DocumentVersionTaskBase)task).getDocumentVersion().getDocument().getDocumentList().getSubProject().isReadOnly()) continue;
                    ++overrideTasks;
                    if (!viewMode.equals("6")) continue;
                    ProjectParticipation projectParticipation = this.projectParticipationDAO.get(((ReviewCycleTask)task).getProjectParticipationId());
                    ProjectParticipant mainParticipant = projectParticipation.getMainParticipant();
                    boolean isMainParticipantTask = mainParticipant.getOrganisationPerson().getId().equals(orgPersonId);
                    boolean isOwnLateTask = ownLateTaskIds.contains(task.getId());
                    TaskTO taskTO = this.taskOverviewTaskTOGenerator.generateSurveillanceTaskTO(task, now, this.holidayCalculatorFactory.getInstance(projectParticipation.getProject()), isOwnLateTask, isMainParticipantTask, i18n, isOOOMode);
                    container.addTaskTO(taskTO);
                }
            }
        }
        container.setAllTasks(allTasks);
        container.setDelayedTasks(delayedTasks);
        container.setTodaysTasks(todaysTasks);
        container.setDistantTasks(distantTasks);
        container.setDatelessTasks(datelessTasks);
        container.setProxyTasks(proxyTasks);
        container.setMainParticipantTasks(mainParticipantTasks);
        container.setOverrideTasks(overrideTasks);
        container.setSignatureFolderTasks(signatureFolderTasks);
        container.setDoneTasks(doneInLastXDaysTasks);
        return container;
    }

    @Override
    public TaskTO evalGetTaskTO(Integer taskId, Integer orgPersonId, boolean isSurveillanceTask, Locale locale, boolean isOOOMode) {
        I18n i18n = I18nFactory.getI18n(locale);
        ReviewCycleTask task = (ReviewCycleTask)this.taskDAO.get(taskId);
        Calendar now = Calendar.getInstance();
        HolidayCalculator holicalc = this.holidayCalculatorFactory.getInstance(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject());
        ProjectParticipation pp = this.projectParticipationDAO.get(task.getProjectParticipationId());
        boolean isMainParticipant = pp.getMainParticipant().getOrganisationPerson().equals(orgPersonId);
        if (!isSurveillanceTask) {
            TaskTO taskTO = this.taskOverviewTaskTOGenerator.generateTaskTO(task, now, holicalc, isMainParticipant, i18n, isOOOMode);
            if (task instanceof ReviewableTask) {
                taskTO.setOwnSignatureFolderTask(this.taskOverviewTaskTOGenerator.isOwnSignatureFolderTask((ReviewableTask)task, orgPersonId));
            }
            return taskTO;
        }
        if (isMainParticipant) {
            return this.taskOverviewTaskTOGenerator.generateSurveillanceTaskTO(task, now, holicalc, true, isMainParticipant, i18n, isOOOMode);
        }
        for (ProjectParticipant p : pp.getProjectParticipants().values()) {
            if (!p.getOrganisationPerson().getId().equals(orgPersonId)) continue;
            return this.taskOverviewTaskTOGenerator.generateSurveillanceTaskTO(task, now, holicalc, true, isMainParticipant, i18n, isOOOMode);
        }
        return this.taskOverviewTaskTOGenerator.generateSurveillanceTaskTO(task, now, holicalc, false, isMainParticipant, i18n, isOOOMode);
    }

    public void setProjectOperations(ProjectOperations projectOperations) {
        this.projectOperations = projectOperations;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setTaskOverviewTaskTOGenerator(TaskOverviewTaskTOGenerator taskOverviewTaskTOGenerator) {
        this.taskOverviewTaskTOGenerator = taskOverviewTaskTOGenerator;
    }

    public void setMailOperations(MailOperations mailOperations) {
        this.mailOperations = mailOperations;
    }

    @Override
    public SubProjectCopyContainer insertCopiesOfTaskForSubProject(SubProject sourceSubProject, SubProject sp, SubProjectCopyContainer subProjectCopyContainer) {
        HashMap<Integer, TaskBase> taskIds = new HashMap<Integer, TaskBase>();
        List<Task> sourceTasks = this.taskDAO.getAllTasksBySubProject(sourceSubProject.getId());
        for (Task st : sourceTasks) {
            ReviewCyclePositionRelease destPosition;
            ArrayList sourcePositions;
            HashMap<Integer, ReviewCyclePositionRelease> destPositions;
            TaskBase destTask;
            ObjectPlannerImpl destObjectPlanner = null;
            if (st.getObjectPlanner() != null) {
                destObjectPlanner = this.objectPlannerDAO.getObjectPlanner(subProjectCopyContainer.getObjectPlannerImplIds().get(st.getObjectPlanner().getId()));
            }
            DocumentVersion destDocumentVersion = null;
            if (st instanceof DocumentVersionTaskBase) {
                destDocumentVersion = this.documentVersionDAO.get(subProjectCopyContainer.getDocumentVersionIds().get(((DocumentVersionTaskBase)st).getDocumentVersion().getId()));
            }
            if (st instanceof ReviewCycleEntryTask) {
                destTask = new ReviewCycleEntryTask();
                destTask.setBeginDate(st.getBeginDate());
                destTask.setBeginDelay(st.getBeginDelay());
                destTask.setDeltaT(st.getDeltaT());
                ((DocumentTask)destTask).setDocument(this.documentDAO.get(subProjectCopyContainer.getDocumentImplIds().get(((ReviewCycleEntryTask)st).getDocument().getId())));
                destTask.setDone(st.isDone());
                destTask.setEndDate(st.getEndDate());
                destTask.setLocalisation(st.getLocalisation());
                destTask.setName(st.getName());
                ((DocumentTask)destTask).setObjectPlanner(destObjectPlanner);
                ((ReviewCycleEntryTask)destTask).setOverallEndDate(((ReviewCycleEntryTask)st).getOverallEndDate());
                ((DocumentTask)destTask).setProjectParticipationId(((ReviewCycleEntryTask)st).getProjectParticipationId());
                ((ReviewCycleEntryTask)destTask).setReviewCycleId(((ReviewCycleEntryTask)st).getReviewCycleId());
                ((ReviewCycleEntryTask)destTask).setUrgency(((ReviewCycleEntryTask)st).getUrgency());
                destTask = (ReviewCycleEntryTask)this.taskDAO.save(destTask);
                taskIds.put(st.getId(), destTask);
                continue;
            }
            if (st instanceof SelectCellConnectionTask) {
                destTask = new SelectCellConnectionTask();
                destTask.setBeginDate(st.getBeginDate());
                destTask.setBeginDelay(st.getBeginDelay());
                destTask.setDeltaT(st.getDeltaT());
                destTask.setDone(st.isDone());
                destTask.setEndDate(st.getEndDate());
                destTask.setLocalisation(st.getLocalisation());
                destTask.setName(st.getName());
                ((DocumentVersionTaskBase)destTask).setObjectPlanner(destObjectPlanner);
                ((DocumentVersionTaskBase)destTask).setContractualDeadline(((DocumentVersionTaskBase)st).getContractualDeadline());
                ((DocumentVersionTaskBase)destTask).setDocumentVersion(destDocumentVersion);
                ((DocumentVersionTaskBase)destTask).setMinDeltaT(((DocumentVersionTaskBase)st).getMinDeltaT());
                ((DocumentVersionTaskBase)destTask).setMinimalDeadline(((DocumentVersionTaskBase)st).getMinimalDeadline());
                ((DocumentVersionTaskBase)destTask).setNodeOptimalDeadline(((DocumentVersionTaskBase)st).getNodeOptimalDeadline());
                ((DocumentVersionTaskBase)destTask).setOptimalDeadline(((DocumentVersionTaskBase)st).getOptimalDeadline());
                ((DocumentVersionTaskBase)destTask).setOverallEndDate(((DocumentVersionTaskBase)st).getOverallEndDate());
                ((DocumentVersionTaskBase)destTask).setProjectParticipationId(((DocumentVersionTaskBase)st).getProjectParticipationId());
                ((DocumentVersionTaskBase)destTask).setUrgency(((DocumentVersionTaskBase)st).getUrgency());
                if (((SelectCellConnectionTask)st).getReviewCycleNodeInstanceId() != null) {
                    ((SelectCellConnectionTask)destTask).setReviewCycleNodeInstanceId(this.reviewCycleNodeInstanceDAO.get(subProjectCopyContainer.getReviewCycleNodeInstanceImplIds().get(((SelectCellConnectionTask)st).getReviewCycleNodeInstanceId())).getId());
                }
                ((SelectCellConnectionTask)destTask).setTargetDescription(((SelectCellConnectionTask)st).getTargetDescription());
                ArrayList sourceCellConnections = new ArrayList(((SelectCellConnectionTask)st).getReviewCycleCellConnections().values());
                HashMap<Integer, ReviewCycleCellConnection> destConnections = new HashMap<Integer, ReviewCycleCellConnection>();
                for (ReviewCycleCellConnection sourceCellConnection : sourceCellConnections) {
                    destConnections.put(sourceCellConnection.getId(), sourceCellConnection);
                }
                ((SelectCellConnectionTask)destTask).setReviewCycleCellConnections(destConnections);
                destTask = (SelectCellConnectionTask)this.taskDAO.save(destTask);
                taskIds.put(st.getId(), destTask);
                continue;
            }
            if (st instanceof ReviewTask) {
                destTask = new ReviewTask();
                destTask.setBeginDate(st.getBeginDate());
                destTask.setBeginDelay(st.getBeginDelay());
                destTask.setDeltaT(st.getDeltaT());
                destTask.setDone(st.isDone());
                destTask.setEndDate(st.getEndDate());
                destTask.setLocalisation(st.getLocalisation());
                destTask.setName(st.getName());
                ((DocumentVersionTaskBase)destTask).setObjectPlanner(destObjectPlanner);
                ((DocumentVersionTaskBase)destTask).setContractualDeadline(((DocumentVersionTaskBase)st).getContractualDeadline());
                ((DocumentVersionTaskBase)destTask).setDocumentVersion(destDocumentVersion);
                ((DocumentVersionTaskBase)destTask).setMinDeltaT(((DocumentVersionTaskBase)st).getMinDeltaT());
                ((DocumentVersionTaskBase)destTask).setMinimalDeadline(((DocumentVersionTaskBase)st).getMinimalDeadline());
                ((DocumentVersionTaskBase)destTask).setNodeOptimalDeadline(((DocumentVersionTaskBase)st).getNodeOptimalDeadline());
                ((DocumentVersionTaskBase)destTask).setOptimalDeadline(((DocumentVersionTaskBase)st).getOptimalDeadline());
                ((DocumentVersionTaskBase)destTask).setOverallEndDate(((DocumentVersionTaskBase)st).getOverallEndDate());
                ((DocumentVersionTaskBase)destTask).setProjectParticipationId(((DocumentVersionTaskBase)st).getProjectParticipationId());
                ((DocumentVersionTaskBase)destTask).setUrgency(((DocumentVersionTaskBase)st).getUrgency());
                ((ReviewTask)destTask).setRealmDescription(((ReviewTask)st).getRealmDescription());
                if (((ReviewTask)st).getReviewCycleNodeInstanceId() != null) {
                    ((ReviewTask)destTask).setReviewCycleNodeInstanceId(this.reviewCycleNodeInstanceDAO.get(subProjectCopyContainer.getReviewCycleNodeInstanceImplIds().get(((ReviewTask)st).getReviewCycleNodeInstanceId())).getId());
                }
                ((ReviewTask)destTask).setSampleControlReview(((ReviewTask)st).isSampleControlReview());
                destPositions = new HashMap();
                sourcePositions = new ArrayList(((ReviewTask)st).getReviewCyclePositionReleases().values());
                for (ReviewCyclePositionRelease sourcePosition : sourcePositions) {
                    destPosition = this.reviewCyclePositionDAO.getReleased(subProjectCopyContainer.getReviewCycleNodePositionReleaseIds().get(((ReviewCyclePositionReleaseImpl)sourcePosition).getId()));
                    destPositions.put(((ReviewCyclePositionReleaseImpl)destPosition).getId(), destPosition);
                }
                ((ReviewTask)destTask).setReviewCyclePositionReleases(destPositions);
                destTask = (ReviewTask)this.taskDAO.save(destTask);
                taskIds.put(st.getId(), destTask);
                continue;
            }
            if (st instanceof AttachedReviewTask) {
                destTask = new AttachedReviewTask();
                destTask.setBeginDate(st.getBeginDate());
                destTask.setBeginDelay(st.getBeginDelay());
                destTask.setDeltaT(st.getDeltaT());
                destTask.setDone(st.isDone());
                destTask.setEndDate(st.getEndDate());
                destTask.setLocalisation(st.getLocalisation());
                destTask.setName(st.getName());
                ((DocumentVersionTaskBase)destTask).setObjectPlanner(destObjectPlanner);
                ((DocumentVersionTaskBase)destTask).setContractualDeadline(((DocumentVersionTaskBase)st).getContractualDeadline());
                ((DocumentVersionTaskBase)destTask).setDocumentVersion(destDocumentVersion);
                ((DocumentVersionTaskBase)destTask).setMinDeltaT(((DocumentVersionTaskBase)st).getMinDeltaT());
                ((DocumentVersionTaskBase)destTask).setMinimalDeadline(((DocumentVersionTaskBase)st).getMinimalDeadline());
                ((DocumentVersionTaskBase)destTask).setNodeOptimalDeadline(((DocumentVersionTaskBase)st).getNodeOptimalDeadline());
                ((DocumentVersionTaskBase)destTask).setOptimalDeadline(((DocumentVersionTaskBase)st).getOptimalDeadline());
                ((DocumentVersionTaskBase)destTask).setOverallEndDate(((DocumentVersionTaskBase)st).getOverallEndDate());
                ((DocumentVersionTaskBase)destTask).setProjectParticipationId(((DocumentVersionTaskBase)st).getProjectParticipationId());
                ((DocumentVersionTaskBase)destTask).setUrgency(((DocumentVersionTaskBase)st).getUrgency());
                ((AttachedReviewTask)destTask).setRealmDescription(((AttachedReviewTask)st).getRealmDescription());
                if (((AttachedReviewTask)st).getReviewCycleNodeInstanceId() != null) {
                    ((AttachedReviewTask)destTask).setReviewCycleNodeInstanceId(this.reviewCycleNodeInstanceDAO.get(subProjectCopyContainer.getReviewCycleNodeInstanceImplIds().get(((AttachedReviewTask)st).getReviewCycleNodeInstanceId())).getId());
                }
                ((AttachedReviewTask)destTask).setSampleControlReview(((AttachedReviewTask)st).isSampleControlReview());
                destPositions = new HashMap<Integer, ReviewCyclePositionRelease>();
                sourcePositions = new ArrayList(((AttachedReviewTask)st).getReviewCyclePositionReleases().values());
                for (ReviewCyclePositionRelease sourcePosition : sourcePositions) {
                    destPosition = this.reviewCyclePositionDAO.getAttached(subProjectCopyContainer.getAttachedReviewCyclePositoinIds().get(((AttachedReviewCyclePositionImpl)sourcePosition).getId()));
                    destPositions.put(((AttachedReviewCyclePositionImpl)destPosition).getId(), destPosition);
                }
                ((AttachedReviewTask)destTask).setReviewCyclePositionReleases(destPositions);
                destTask = (AttachedReviewTask)this.taskDAO.save(destTask);
                taskIds.put(st.getId(), destTask);
                continue;
            }
            if (!(st instanceof OriginalDocumentTask)) continue;
            destTask = new OriginalDocumentTask();
            destTask.setBeginDate(st.getBeginDate());
            destTask.setBeginDelay(st.getBeginDelay());
            destTask.setDeltaT(st.getDeltaT());
            destTask.setDone(st.isDone());
            destTask.setEndDate(st.getEndDate());
            destTask.setLocalisation(st.getLocalisation());
            destTask.setName(st.getName());
            ((DocumentVersionTaskBase)destTask).setObjectPlanner(destObjectPlanner);
            ((DocumentVersionTaskBase)destTask).setContractualDeadline(((DocumentVersionTaskBase)st).getContractualDeadline());
            ((DocumentVersionTaskBase)destTask).setDocumentVersion(destDocumentVersion);
            ((DocumentVersionTaskBase)destTask).setMinDeltaT(((DocumentVersionTaskBase)st).getMinDeltaT());
            ((DocumentVersionTaskBase)destTask).setMinimalDeadline(((DocumentVersionTaskBase)st).getMinimalDeadline());
            ((DocumentVersionTaskBase)destTask).setNodeOptimalDeadline(((DocumentVersionTaskBase)st).getNodeOptimalDeadline());
            ((DocumentVersionTaskBase)destTask).setOptimalDeadline(((DocumentVersionTaskBase)st).getOptimalDeadline());
            ((DocumentVersionTaskBase)destTask).setOverallEndDate(((DocumentVersionTaskBase)st).getOverallEndDate());
            ((DocumentVersionTaskBase)destTask).setProjectParticipationId(((DocumentVersionTaskBase)st).getProjectParticipationId());
            ((DocumentVersionTaskBase)destTask).setUrgency(((DocumentVersionTaskBase)st).getUrgency());
            ((OriginalDocumentTask)destTask).setOrder(this.orderDAO.getOriginalDocumentOrder(subProjectCopyContainer.getOriginalDocumentOrderIds().get(((OriginalDocumentTask)st).getOrder().getId())));
            if (((OriginalDocumentTask)st).getOrderStep() != null) {
                ((OriginalDocumentTask)destTask).setOrderStep(this.orderDAO.getOrderStep(subProjectCopyContainer.getOriginalDocumentOrderOrderStepIds().get(((OriginalDocumentTask)st).getOrderStep().getId())));
            }
            destTask = (OriginalDocumentTask)this.taskDAO.save(destTask);
            taskIds.put(st.getId(), destTask);
        }
        for (Integer sourceTaskId : taskIds.keySet()) {
            HashMap<Integer, TaskEMailSnippet> destinationSnippets = new HashMap<Integer, TaskEMailSnippet>();
            TaskBase destinationTask = (TaskBase)taskIds.get(sourceTaskId);
            Collection<TaskEMailSnippet> sourceSnippets = this.mailDAO.getSnippetsOfTask(sourceTaskId);
            for (TaskEMailSnippet sourceSnippet : sourceSnippets) {
                TaskEMailSnippet destSnippet = new TaskEMailSnippet();
                destSnippet.setOrganisationPersonId(sourceSnippet.getOrganisationPersonId());
                destSnippet.setSendTime(sourceSnippet.getSendTime());
                destSnippet.setTask(destinationTask);
                destSnippet.setType(sourceSnippet.getType());
                destSnippet = (TaskEMailSnippet)this.mailDAO.insertSnippet(destSnippet);
                destinationSnippets.put(destSnippet.getId(), destSnippet);
            }
            Collection<TaskFutureEMail> sourceFutureMails = this.mailDAO.getFutureMailsOfTask(sourceTaskId);
            for (TaskFutureEMail sourceFutureMail : sourceFutureMails) {
                TaskFutureEMail destFutureMail = new TaskFutureEMail();
                destFutureMail.setMainParticipantOnly(sourceFutureMail.isMainParticipantOnly());
                destFutureMail.setParticipationId(sourceFutureMail.getParticipationId());
                destFutureMail.setSendTime(sourceFutureMail.getSendTime());
                destFutureMail.setTask(destinationTask);
                destFutureMail.setType(sourceFutureMail.getType());
                this.mailDAO.insertFutureEMail(destFutureMail);
            }
            if (destinationSnippets.isEmpty()) continue;
            destinationTask.setMailSnippets(destinationSnippets);
            this.taskDAO.update(destinationTask);
        }
        return subProjectCopyContainer;
    }

    @Override
    public void updateTaskStatus(Integer taskId, int taskStatus) {
        ReviewableTask task = (ReviewableTask)this.getTask(taskId);
        task.setTaskStatus(taskStatus);
        this.taskDAO.update(task);
    }

    @Override
    public boolean isReversePreduration() {
        return this.reversePreduration;
    }

    public void setReversePreduration(boolean reversePreduration) {
        this.reversePreduration = reversePreduration;
    }

    @Override
    public List<TaskTO> getTaskTOs(Collection<Integer> taskIds, Integer organisationPersonId, Locale locale) {
        ArrayList<TaskTO> tasks = new ArrayList<TaskTO>();
        for (Integer taskId : taskIds) {
            tasks.add(this.evalGetTaskTO(taskId, organisationPersonId, false, locale, false));
        }
        return tasks;
    }

    @Override
    public void deleteAllTasksOfSubProject(Integer subProjectId) {
        List<Task> allTasksBySubProject = this.taskDAO.getAllTasksBySubProject(subProjectId);
        for (Task task : allTasksBySubProject) {
            this.removeTask(task.getId());
        }
    }

    @Override
    public TaskTOContainer evalNumberOfTaskTOs(Integer orgPersonId) {
        TaskTOContainer container = new TaskTOContainer();
        List pps = this.projectOperations.getWriteableProjectParticipations(orgPersonId);
        OrganisationPerson op = this.organisationPersonDAO.get(orgPersonId);
        ArrayList taskTOs = new ArrayList();
        Calendar now = Calendar.getInstance();
        int allTasks = 0;
        int proxyTasks = 0;
        int mainParticipantTasks = 0;
        int overrideTasks = 0;
        int signatureFolderTasks = 0;
        int doneTasks = 0;
        int proxySignatureFolderTasks = 0;
        ArrayList<Integer> ppIds = new ArrayList<Integer>();
        for (Object pp : pps) {
            ppIds.add(((ProjectParticipation)pp).getId());
        }
        ArrayList<Task> tasks = new ArrayList<Task>();
        tasks.addAll(this.taskDAO.getAllTasksBetweenDates(ppIds, null, null, 0));
        tasks.addAll(this.taskDAO.getAllTasksBetweenDates(ppIds, null, null, 1));
        for (Task task : tasks) {
            boolean isMainParticipantTask;
            if (task instanceof DocumentTask ? ((DocumentTask)task).getDocument().getDocumentList().getSubProject().isReadOnly() || ((DocumentTask)task).getObjectPlanner().getObject().isReadOnly() : ((DocumentVersionTaskBase)task).getDocumentVersion().getDocument().getDocumentList().getSubProject().isReadOnly() || !(task instanceof ReviewCyclePlottTask) && !(task instanceof PlotOrderAcceptanceTask) && ((DocumentVersionTaskBase)task).getDocumentVersion().getDocument().getObjectPlanner().getObject().isReadOnly()) continue;
            ProjectParticipation pp = null;
            if (task instanceof DocumentTask) {
                pp = this.projectParticipationDAO.get(((DocumentTask)task).getProjectParticipationId());
                isMainParticipantTask = pp.getMainParticipant().getOrganisationPerson().getId().equals(orgPersonId);
            } else {
                pp = this.projectParticipationDAO.get(((DocumentVersionTaskBase)task).getProjectParticipationId());
                isMainParticipantTask = pp.getMainParticipant().getOrganisationPerson().getId().equals(orgPersonId);
            }
            boolean isOwnSignatureFolderTask = false;
            if (task instanceof ReviewableTask && ((ReviewableTask)task).isTaskInSignatureFolder()) {
                isOwnSignatureFolderTask = this.taskOverviewTaskTOGenerator.isOwnSignatureFolderTask((ReviewableTask)task, orgPersonId);
                container.setContainingProxySignatureFolderTasks(!isOwnSignatureFolderTask);
                ++signatureFolderTasks;
                if (isOwnSignatureFolderTask) continue;
                ++proxySignatureFolderTasks;
                continue;
            }
            if (isMainParticipantTask) {
                ++mainParticipantTasks;
            } else {
                ++proxyTasks;
            }
            ++allTasks;
        }
        List<Project> monitoringProjects = this.projectDAO.getAllProjectsWithMonitoringParticipation(orgPersonId);
        if (monitoringProjects != null && !monitoringProjects.isEmpty()) {
            for (Project project : monitoringProjects) {
                ArrayList monitoredTasks = new ArrayList();
                monitoredTasks.addAll(this.taskDAO.getAllLateReviewTasks(now, project.getId()));
                monitoredTasks.addAll(this.taskDAO.getAllLateUploadTasks(now, project.getId()));
                for (Task monitoredTask : monitoredTasks) {
                    if (monitoredTask instanceof DocumentTask ? ((DocumentTask)monitoredTask).getDocument().getDocumentList().getSubProject().isReadOnly() : monitoredTask instanceof DocumentVersionTaskBase && ((DocumentVersionTaskBase)monitoredTask).getDocumentVersion().getDocument().getDocumentList().getSubProject().isReadOnly()) continue;
                    ++overrideTasks;
                }
            }
        }
        container.setAllTasks(allTasks);
        container.setProxyTasks(proxyTasks);
        container.setMainParticipantTasks(mainParticipantTasks);
        container.setOverrideTasks(overrideTasks);
        container.setSignatureFolderTasks(signatureFolderTasks);
        container.setDoneTasks(doneTasks);
        container.setProxySignatureFolderTasks(proxySignatureFolderTasks);
        return container;
    }
}

