/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.oldGwtDto;

import at.cdes.oldGwtDto.RoleMapEntryGWT;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RoleMapGWT
implements Serializable {
    private static final long serialVersionUID = -163734864955711149L;
    private List<RoleMapEntryGWT> roles = new ArrayList<RoleMapEntryGWT>();

    public void add(Integer id, Integer networkId, Integer projectId, Integer projectParticipantId, Integer organisationPersonId) {
        this.roles.add(new RoleMapEntryGWT(id, networkId, projectId, projectParticipantId, null, organisationPersonId));
    }

    public List<RoleMapEntryGWT> getAllRoles() {
        return this.roles;
    }

    public RoleMapEntryGWT getGlobalRole() {
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntryGWT entry = this.roles.get(i);
            if (entry.getNetworkId() != null || entry.getProjectId() != null || entry.getProjectParticipantId() != null) continue;
            return entry;
        }
        return null;
    }

    public List<RoleMapEntryGWT> getNetworkRoles(Integer networkId) {
        if (networkId == null) {
            return new ArrayList<RoleMapEntryGWT>();
        }
        ArrayList<RoleMapEntryGWT> l = new ArrayList<RoleMapEntryGWT>();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntryGWT entry = this.roles.get(i);
            if (entry.getNetworkId() == null || entry.getProjectId() != null || entry.getProjectParticipantId() != null || !entry.getNetworkId().equals(networkId)) continue;
            l.add(entry);
        }
        return l;
    }

    public List<RoleMapEntryGWT> getNetworkRoles(Integer networkId, Integer organisationPersonId) {
        if (networkId == null) {
            return new ArrayList<RoleMapEntryGWT>();
        }
        ArrayList<RoleMapEntryGWT> l = new ArrayList<RoleMapEntryGWT>();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntryGWT entry = this.roles.get(i);
            if (entry.getNetworkId() == null || entry.getProjectId() != null || entry.getProjectParticipantId() != null || !entry.getNetworkId().equals(networkId) || entry.getOrganisationPersonId() != null && !entry.getOrganisationPersonId().equals(organisationPersonId)) continue;
            l.add(entry);
        }
        return l;
    }

    public List<RoleMapEntryGWT> getNetworks(Integer organisationPersonId) {
        if (organisationPersonId == null) {
            return new ArrayList<RoleMapEntryGWT>();
        }
        ArrayList<RoleMapEntryGWT> l = new ArrayList<RoleMapEntryGWT>();
        ArrayList<Integer> added = new ArrayList<Integer>();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntryGWT entry = this.roles.get(i);
            if (entry.getNetworkId() == null || entry.getOrganisationPersonId() != null && !entry.getOrganisationPersonId().equals(organisationPersonId) || added.contains(entry.getNetworkId())) continue;
            l.add(entry);
            added.add(entry.getNetworkId());
        }
        return l;
    }

    public List<RoleMapEntryGWT> getProjectRoles(Integer projectId, Integer organisationPersonId) {
        if (projectId == null) {
            return new ArrayList<RoleMapEntryGWT>();
        }
        ArrayList<RoleMapEntryGWT> l = new ArrayList<RoleMapEntryGWT>();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntryGWT entry = this.roles.get(i);
            if (entry.getProjectId() == null || entry.getProjectParticipantId() == null || !entry.getProjectId().equals(projectId) || !entry.getOrganisationPersonId().equals(organisationPersonId)) continue;
            l.add(entry);
        }
        return l;
    }

    public List<RoleMapEntryGWT> getProjects(Integer organisationPersonId) {
        if (organisationPersonId == null) {
            return new ArrayList<RoleMapEntryGWT>();
        }
        ArrayList<RoleMapEntryGWT> l = new ArrayList<RoleMapEntryGWT>();
        ArrayList<Integer> added = new ArrayList<Integer>();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntryGWT entry = this.roles.get(i);
            if (entry.getProjectId() == null || !entry.getOrganisationPersonId().equals(organisationPersonId) || added.contains(entry.getProjectId())) continue;
            l.add(entry);
            added.add(entry.getProjectId());
        }
        return l;
    }

    public List<RoleMapEntryGWT> getSubProjects(Integer organisationPersonId) {
        if (organisationPersonId == null) {
            return new ArrayList<RoleMapEntryGWT>();
        }
        ArrayList<RoleMapEntryGWT> l = new ArrayList<RoleMapEntryGWT>();
        ArrayList<Integer> added = new ArrayList<Integer>();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntryGWT entry = this.roles.get(i);
            if (entry.getProjectId() == null || !entry.getOrganisationPersonId().equals(organisationPersonId) || added.contains(entry.getProjectId())) continue;
            l.add(entry);
            added.add(entry.getProjectId());
        }
        return l;
    }

    public List<RoleMapEntryGWT> getProjectRoles(Integer projectId) {
        if (projectId == null) {
            return new ArrayList<RoleMapEntryGWT>();
        }
        ArrayList<RoleMapEntryGWT> l = new ArrayList<RoleMapEntryGWT>();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntryGWT entry = this.roles.get(i);
            if (entry.getProjectId() == null || entry.getProjectParticipantId() == null || !entry.getProjectId().equals(projectId)) continue;
            l.add(entry);
        }
        return l;
    }

    public List<RoleMapEntryGWT> getAllProjectRoles() {
        ArrayList<RoleMapEntryGWT> l = new ArrayList<RoleMapEntryGWT>();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntryGWT entry = this.roles.get(i);
            if (entry.getProjectId() == null || entry.getProjectParticipantId() == null || entry.getProjectId() == null) continue;
            l.add(entry);
        }
        return l;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.roles.size(); ++i) {
            RoleMapEntryGWT entry = this.roles.get(i);
            buf.append(entry.toString());
        }
        return buf.toString();
    }
}

