/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.util;

import at.cdes.service.exception.ActionException;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;

public class OgnlComparator
implements Comparator {
    private OgnlContext context = new OgnlContext();
    private Object expression;
    private boolean ascending = false;

    public OgnlComparator(String rule, boolean ascending) {
        try {
            String comp = ascending ? "" : "-";
            String exp = comp + "a." + rule + ".compareTo(b." + rule + ")";
            this.expression = Ognl.parseExpression(exp);
            this.ascending = ascending;
        }
        catch (OgnlException e) {
            throw new ActionException("Parse Exception", e);
        }
    }

    public OgnlComparator(String rule, boolean ascending, Locale locale) {
        try {
            String comp = ascending ? "c.compare(" : "-c.compare(";
            String exp = comp + "a." + rule + ",b." + rule + ")";
            this.expression = Ognl.parseExpression(exp);
            Collator coll = Collator.getInstance(locale);
            coll.setStrength(3);
            this.context.put("c", coll);
            this.ascending = ascending;
        }
        catch (OgnlException e) {
            throw new ActionException("Parse Exception", e);
        }
    }

    public int compare(Object a, Object b) {
        if (a == null) {
            return b == null ? 0 : (this.ascending ? -1 : 1);
        }
        if (b == null) {
            return this.ascending ? 1 : -1;
        }
        this.context.put("a", a);
        this.context.put("b", b);
        try {
            Object res = Ognl.getValue(this.expression, (Map)this.context, (Object)this.context);
            if (res == null) {
                return 0;
            }
            return ((Number)res).intValue();
        }
        catch (OgnlException e) {
            throw new ActionException("Evaluate Exception", e);
        }
    }
}

