/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.documentNumber;

import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentNumberComparator;
import at.cdes.bo.data.number.DocumentNumberPart;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.pdc.PDCNumberRegistry;
import at.cdes.service.exception.DocumentNameNotUniqueException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DocumentNumberRegistry
implements PDCNumberRegistry {
    @Override
    public void checkUniqueness(List<? extends Document> docs) {
        ArrayList<String> collected = new ArrayList<String>();
        Collections.sort(docs, new DocumentNumberComparator());
        for (Document document : docs) {
            if (!collected.contains(document.getName())) {
                collected.add(document.getName());
                continue;
            }
            if (document.isVersionSet()) continue;
            throw new DocumentNameNotUniqueException(document);
        }
    }

    @Override
    public int getMaxNumber(Project project) {
        List parts = project.getDocumentNumberPartGroup().getPartsSortedByPosition();
        for (DocumentNumberPart part : parts) {
            if (!part.getRule().contains("document.number")) continue;
            String format = part.getFormat();
            String length = format.substring(format.length() - 2, format.length() - 1);
            int l = Integer.parseInt(length);
            int res = (int)Math.pow(10.0, l);
            return res - 1;
        }
        return 0;
    }

    @Override
    public boolean isObjectPlannerUniqueKey(Project project) {
        List parts = project.getDocumentNumberPartGroup().getPartsSortedByPosition();
        for (DocumentNumberPart part : parts) {
            if (!part.getRule().contains("document.objectPlanner.code") || !part.isUniqueKey()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void sortDocuments(List<Document> docs) {
        Collections.sort(docs, new DocumentNumberComparator());
    }
}

