/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.cycle.AttachedReviewCyclePositionImpl;
import at.cdes.bo.data.cycle.Realm;
import at.cdes.bo.data.cycle.ReviewCycleInstance;
import at.cdes.bo.data.cycle.ReviewCyclePosition;
import at.cdes.bo.data.cycle.ReviewCyclePositionImpl;
import at.cdes.bo.data.cycle.ReviewCyclePositionReleaseImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstance;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.data.task.AttachedReviewTask;
import at.cdes.bo.data.task.ReviewTask;
import at.cdes.db.dao.ReviewCyclePositionDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class ReviewCyclePositionDAOHibernate
extends HibernateDaoSupport
implements ReviewCyclePositionDAO {
    @Override
    public ReviewCyclePositionImpl get(Integer id) {
        return (ReviewCyclePositionImpl)this.getSession().load(ReviewCyclePositionImpl.class, (Serializable)id);
    }

    @Override
    public ReviewCyclePositionImpl save(ReviewCyclePositionImpl cons) {
        return this.get((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public ReviewCyclePositionImpl update(ReviewCyclePositionImpl cons) {
        this.getSession().merge((Object)cons);
        return cons;
    }

    @Override
    public void delete(ReviewCyclePositionImpl cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public ReviewCyclePositionReleaseImpl getReleased(Integer id) {
        return (ReviewCyclePositionReleaseImpl)this.getSession().load(ReviewCyclePositionReleaseImpl.class, (Serializable)id);
    }

    @Override
    public List getReleasedByProjectParticipation(Integer projectParticipationId, Integer releasedObjectListId) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionReleaseImpl.class);
        crit.createCriteria("projectParticipation").add(Restrictions.idEq((Object)projectParticipationId));
        crit.createCriteria("reviewCycleNodeInstance").createCriteria("reviewCycleCellInstance").createCriteria("reviewCycleInstance").createCriteria("objectList").add(Restrictions.idEq((Object)releasedObjectListId));
        return crit.list();
    }

    @Override
    public List getUnreleasedByProjectParticipation(Integer projectParticipationId, Integer unreleasedObjectListId) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionImpl.class);
        crit.createCriteria("projectParticipation").add(Restrictions.idEq((Object)projectParticipationId));
        crit.createCriteria("reviewCycleNodeInstance").createCriteria("reviewCycleCellInstance").createCriteria("reviewCycleInstance").createCriteria("subProject").createCriteria("editObjectList").add(Restrictions.idEq((Object)unreleasedObjectListId));
        return crit.list();
    }

    @Override
    public ReviewCyclePositionReleaseImpl save(ReviewCyclePositionReleaseImpl cons) {
        return this.getReleased((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public ReviewCyclePositionReleaseImpl update(ReviewCyclePositionReleaseImpl cons) {
        ArrayList reviewTasks = new ArrayList(cons.getReviewTasks().values());
        cons = (ReviewCyclePositionReleaseImpl)this.getSession().merge((Object)cons);
        for (ReviewTask reviewTask : reviewTasks) {
            cons.getReviewTasks().put(reviewTask.getId(), reviewTask);
        }
        this.getSession().update((Object)cons);
        return cons;
    }

    @Override
    public void delete(ReviewCyclePositionReleaseImpl cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public List getAll(ReviewCycleNodeInstance nodeInstance, ProjectParticipation projectParticipation) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionReleaseImpl.class);
        crit.createCriteria("reviewCycleNodeInstance").add(Restrictions.idEq((Object)nodeInstance.getId()));
        crit.createCriteria("projectParticipation").add(Restrictions.idEq((Object)projectParticipation.getId()));
        return crit.list();
    }

    @Override
    public ReviewCyclePosition getByNodeInstancePpRealm(ReviewCycleNodeInstance nodeInstance, Integer projectParticipationId, Integer realmId) {
        Criteria crit = null;
        if (nodeInstance instanceof ReviewCycleNodeInstanceImpl) {
            crit = this.getSession().createCriteria(ReviewCyclePositionImpl.class);
        } else if (nodeInstance instanceof ReviewCycleNodeInstanceRelease) {
            crit = this.getSession().createCriteria(ReviewCyclePositionReleaseImpl.class);
        }
        crit.createCriteria("reviewCycleNodeInstance").add(Restrictions.idEq((Object)nodeInstance.getId()));
        crit.createCriteria("projectParticipation").add(Restrictions.idEq((Object)projectParticipationId));
        crit.createCriteria("realm").add(Restrictions.idEq((Object)realmId));
        return (ReviewCyclePosition)crit.uniqueResult();
    }

    @Override
    public AttachedReviewCyclePositionImpl getAttached(Integer id) {
        return (AttachedReviewCyclePositionImpl)this.getSession().load(AttachedReviewCyclePositionImpl.class, (Serializable)id);
    }

    @Override
    public List get(Realm realm, ReviewCycleNodeInstance nodeInstance, DocumentVersion documentVersion, ProjectParticipation projectParticipation) {
        Criteria crit = this.getSession().createCriteria(AttachedReviewCyclePositionImpl.class);
        if (realm != null) {
            crit.createCriteria("realm").add(Restrictions.idEq((Object)realm.getId()));
        }
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)documentVersion.getId()));
        crit.createCriteria("reviewCycleNodeInstance").add(Restrictions.idEq((Object)nodeInstance.getId()));
        if (projectParticipation != null) {
            crit.createCriteria("projectParticipation").add(Restrictions.idEq((Object)projectParticipation.getId()));
        }
        crit.addOrder(Order.desc((String)"projectParticipation"));
        return crit.list();
    }

    @Override
    public AttachedReviewCyclePositionImpl save(AttachedReviewCyclePositionImpl cons) {
        return this.getAttached((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public AttachedReviewCyclePositionImpl update(AttachedReviewCyclePositionImpl cons) {
        ArrayList reviewTasks = new ArrayList(cons.getReviewTasks().values());
        cons = (AttachedReviewCyclePositionImpl)this.getSession().merge((Object)cons);
        for (AttachedReviewTask rt : reviewTasks) {
            cons.getReviewTasks().put(rt.getId(), rt);
        }
        this.getSession().update((Object)cons);
        return cons;
    }

    @Override
    public void delete(AttachedReviewCyclePositionImpl cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public boolean getHasReleased(Realm realm) {
        List res = this.getSession().createCriteria(ReviewCyclePositionReleaseImpl.class).createCriteria("realm").add(Restrictions.idEq((Object)realm.getId())).setFetchSize(1).list();
        return res != null && !res.isEmpty();
    }

    @Override
    public boolean getHasUnReleased(Realm realm) {
        List res = this.getSession().createCriteria(ReviewCyclePositionImpl.class).createCriteria("realm").add(Restrictions.idEq((Object)realm.getId())).setFetchSize(1).list();
        return res != null && !res.isEmpty();
    }

    @Override
    public boolean getOccursInPreviosObjectListRelease(Realm realm) {
        if (realm.getProject() == null || realm.getProject().getId() == null) {
            return false;
        }
        List subProjects = this.getSession().createCriteria(SubProject.class).createCriteria("project").add(Restrictions.idEq((Object)realm.getProject().getId())).list();
        Date newestObjectListVersionDate = null;
        List releasedObjectLists = null;
        for (SubProject subProject : subProjects) {
            releasedObjectLists = this.getSession().createCriteria(ReleasedObjectList.class).createCriteria("subProject").add(Restrictions.idEq((Object)subProject.getId())).list();
            for (ReleasedObjectList releasedObjectList : releasedObjectLists) {
                if (newestObjectListVersionDate != null && !releasedObjectList.getSignature().getTime().after(newestObjectListVersionDate)) continue;
                newestObjectListVersionDate = releasedObjectList.getSignature().getTime();
            }
        }
        return newestObjectListVersionDate != null && (realm.getValidFromDate() == null || realm.getValidFromDate().compareTo(newestObjectListVersionDate) <= 0);
    }

    @Override
    public List<ReviewCyclePositionImpl> getPositionByRoleType(Integer roleTypeId, ProjectParticipation pp) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionImpl.class);
        crit.createCriteria("projectParticipation").add(Restrictions.idEq((Object)pp.getId()));
        crit = crit.createCriteria("reviewCycleNodeInstance");
        crit.createCriteria("reviewCycleNode").createCriteria("roleType").add(Restrictions.idEq((Object)roleTypeId));
        crit.createCriteria("reviewCycleCellInstance").createCriteria("reviewCycleInstance").createCriteria("subProject").createCriteria("project").add(Restrictions.idEq((Object)pp.getProject().getId()));
        return crit.list();
    }

    @Override
    public void deleteReviewCyclePositionsByRealm(Realm realm) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionImpl.class);
        crit.createCriteria("realm").add(Restrictions.idEq((Object)realm.getId()));
        List positions = crit.list();
        for (ReviewCyclePositionImpl position : positions) {
            this.delete(position);
        }
    }

    @Override
    public List getAll(OrganisationPerson orgPerson, ReviewCycleInstance rci) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePosition.class);
        crit.createCriteria("projectParticipation").createCriteria("projectParticipants").createCriteria("organisationPerson").add(Restrictions.idEq((Object)orgPerson.getId()));
        crit.createCriteria("reviewCycleNodeInstance").createCriteria("reviewCycleCellInstance").createCriteria("reviewCycleInstance").add(Restrictions.idEq((Object)rci.getId()));
        return crit.list();
    }

    @Override
    public boolean hasPositionSignaturesOnLabel(Integer reviewCycleCellInstanceReleaseId) {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionReleaseImpl.class);
        crit.createCriteria("realm").add((Criterion)Restrictions.like((String)"signatureOnLabel", (Object)Boolean.TRUE));
        crit.createCriteria("reviewCycleNodeInstance").createCriteria("reviewCycleCellInstance").add(Restrictions.idEq((Object)reviewCycleCellInstanceReleaseId));
        List positions = crit.list();
        return !positions.isEmpty();
    }

    @Override
    public List getReleasedPositionsForAdditionalRoleTypeEvaluation() {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionReleaseImpl.class);
        crit.createCriteria("reviewCycleNodeInstance").createCriteria("reviewCycleNode").add(Restrictions.idEq((Object)11211));
        crit.createCriteria("projectParticipation").createCriteria("role").createCriteria("type").add((Criterion)Restrictions.or((Criterion)Restrictions.idEq((Object)1), (Criterion)Restrictions.idEq((Object)7)));
        return crit.list();
    }

    @Override
    public List getUnreleasedPositionsForAdditionalRoleTypeEvaluation() {
        Criteria crit = this.getSession().createCriteria(ReviewCyclePositionImpl.class);
        crit.createCriteria("reviewCycleNodeInstance").createCriteria("reviewCycleNode").add(Restrictions.idEq((Object)11211));
        crit.createCriteria("projectParticipation").createCriteria("role").createCriteria("type").add((Criterion)Restrictions.or((Criterion)Restrictions.idEq((Object)1), (Criterion)Restrictions.idEq((Object)7)));
        return crit.list();
    }

    @Override
    public List<AttachedReviewCyclePositionImpl> getAllAttachedPositionsOfSubProject(Integer subProjectId) {
        Criteria crit = this.getSession().createCriteria(AttachedReviewCyclePositionImpl.class);
        crit.createCriteria("documentVersion").createCriteria("document").createCriteria("documentList").createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId));
        return crit.list();
    }

    @Override
    public List<AttachedReviewCyclePositionImpl> getAllAttachedByNodeInstance(Integer nodeInstanceId, Integer documentVersionId) {
        Criteria crit = this.getSession().createCriteria(AttachedReviewCyclePositionImpl.class);
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)documentVersionId));
        crit.createCriteria("reviewCycleNodeInstance").add(Restrictions.idEq((Object)nodeInstanceId));
        return crit.list();
    }
}

