/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.svg;

import at.cdes.batik.BatikSvgException;
import at.cdes.batik.BatikSvgRendererOperations;
import at.cdes.bo.data.cycle.ReviewCycleEntryResult;
import at.cdes.bo.data.cycle.ReviewCycleInstanceRelease;
import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.data.cycle.ReviewCycleResultOption;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnectionResult;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstance;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstanceRelease;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellResult;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstance;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.document.ReleasedDocument;
import at.cdes.bo.data.document.ReleasedDocumentList;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.svg.SvgDataContainer;
import at.cdes.bo.date.HolidayCalculator;
import at.cdes.bo.date.HolidayCalculatorFactory;
import at.cdes.bo.plot.SimpleBoundingBox;
import at.cdes.bo.service.ReviewCycleNodeInstanceHelper;
import at.cdes.service.ObjectOperations;
import at.cdes.service.PlanDeliverCatalogueOperations;
import at.cdes.service.ReviewOperations;
import at.cdes.service.TaskOperations;
import at.cdes.service.exception.ActionException;
import at.cdes.svg.IMarkupWriter;
import at.cdes.svg.SvgRenderKit;
import at.cdes.svg.SvgReviewHelper;
import at.cdes.util.DateHelper;
import at.cdes.util.TapestryI18nHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.clazzes.util.lang.Triple;

public class ReviewProtocollSvgRenderer {
    private double width;
    private double height;
    private ReviewOperations reviewOp;
    private TaskOperations taskOp;
    private PlanDeliverCatalogueOperations pdcOp;
    private ObjectOperations objectOperations;
    private static String lineStyle = "stroke:black; stroke-width:1px;";
    private static final Logger log = Logger.getLogger(ReviewProtocollSvgRenderer.class);
    private BatikSvgRendererOperations renderer;
    private HolidayCalculatorFactory holifactory;
    private static int MIN_SPACE_DRAW_WEEKS = 120;
    private static int SPACE_FOR_XAXIS_LABEL = 140;
    private static int SIZE_OF_VERSION_LABEL = 20;
    private static int HEIGHT_OUTER_LABEL = 20;
    private static int HEIGHT_OF_NODE = 20;
    private double yBasic = 0.0;
    private Calendar startOfAxis;
    private Calendar endOfAxis;
    private Calendar startOfAxis2;
    private Calendar endOfAxis2;
    private Calendar plannedEnd;
    private Calendar plannedStart;
    private ArrayList<TextWithPosition> cellsVersionString;
    Calendar toDay;
    Calendar actualStartOfReviewCycle;
    Calendar actualEndOfReviewCycle;
    boolean drawWeeks;
    boolean drawPlannedRCycle;
    boolean calcNewAxis;
    double maxWidth;
    int emptyNodeId;
    private HolidayCalculator holicalc;
    private Project project;
    SimpleDateFormat df = null;

    public ReviewProtocollSvgRenderer(ReviewOperations reviewOp, TaskOperations taskOp, PlanDeliverCatalogueOperations pdcOp, ObjectOperations oop, HolidayCalculatorFactory holiFact) {
        this.reviewOp = reviewOp;
        this.taskOp = taskOp;
        this.pdcOp = pdcOp;
        this.objectOperations = oop;
        this.holifactory = holiFact;
    }

    private void setGlobalVariables(List<ReviewCycleCellResult> cellResults, ReleasedDocument releasedDocument, Project project) {
        this.df = new SimpleDateFormat("dd.MM.yy");
        this.drawPlannedRCycle = false;
        this.calcNewAxis = false;
        this.plannedStart = null;
        this.actualStartOfReviewCycle = DateHelper.getCalendar(cellResults.get(0).getDocumentArrivalDate());
        this.actualEndOfReviewCycle = SvgReviewHelper.getActualEndDateOfReviewCycle(cellResults);
        int test = SvgReviewHelper.calculateWeeksToDraw(this.actualStartOfReviewCycle, this.actualEndOfReviewCycle);
        if (test < 4) {
            this.actualEndOfReviewCycle.add(2, 1);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("real date start " + SvgReviewHelper.getDateFormat(this.df, this.actualStartOfReviewCycle) + " real date end " + SvgReviewHelper.getDateFormat(this.df, this.actualEndOfReviewCycle)));
        }
        this.toDay = Calendar.getInstance();
        this.startOfAxis = DateHelper.getCalendar(cellResults.get(0).getDocumentArrivalDate());
        this.endOfAxis = (Calendar)this.actualEndOfReviewCycle.clone();
        this.startOfAxis2 = null;
        this.endOfAxis2 = null;
        this.yBasic = this.height - (double)SIZE_OF_VERSION_LABEL;
        this.holicalc = this.holifactory.getInstance(project);
    }

    public SvgDataContainer render(IMarkupWriter writer, double inheight, double inwidth, DocumentVersion docVersion, List<ReviewCycleCellResult> cellResults) {
        this.height = inheight;
        this.width = inwidth;
        if (log.isDebugEnabled()) {
            log.debug((Object)("************ start SvgReviewProtocoll for " + docVersion.getDocument().getName() + " ***************************"));
        }
        Document doc = docVersion.getDocument();
        ReleasedDocument releasedDocument = null;
        ReleasedDocumentList activeDocumentList = doc.getObjectPlanner().getObject().getObjectList().getSubProject().getActiveDocumentList();
        if (activeDocumentList != null) {
            releasedDocument = this.pdcOp.getReleasedDocumentFromList(doc.getId(), activeDocumentList.getId());
        }
        ReleasedObjectList activeObjectList = doc.getObjectPlanner().getObject().getObjectList().getSubProject().getActiveObjectList();
        this.project = doc.getObjectPlanner().getObject().getObjectList().getSubProject().getProject();
        boolean usePDCStartDate = this.project.isUsePDCStartDateForTasks();
        ReviewCycleInstanceRelease cycleInstanceRel = (ReviewCycleInstanceRelease)this.objectOperations.getReleasedObjectPlannerFromList(doc.getObjectPlanner().getId(), activeObjectList.getId()).getReviewCycleInstance();
        this.drawBoxDefinition(writer);
        this.setGlobalVariables(cellResults, releasedDocument, this.project);
        AxisCalculationResult axisData = this.drawAxis(writer, releasedDocument, cycleInstanceRel);
        int heightofAxis = axisData.heightofAxis;
        this.yBasic -= (double)heightofAxis;
        int spaceForRealReviewCylce = this.drawRealReviewCyle(writer, axisData, cellResults, cycleInstanceRel, usePDCStartDate);
        int actualheight = heightofAxis;
        this.yBasic = this.height - (double)(actualheight += spaceForRealReviewCylce);
        double plannedHeight = 0.0;
        if (this.drawPlannedRCycle && releasedDocument != null) {
            plannedHeight = this.drawPlannedReviewCyle(writer, axisData, cellResults, cycleInstanceRel, releasedDocument);
            actualheight = (int)((double)actualheight + plannedHeight);
        }
        String recStyle = "fill:grey; stroke:grey; stroke-size:1px";
        if (this.drawPlannedRCycle) {
            double underPlanned = this.height - (double)actualheight + plannedHeight;
            int subText = 10;
            if (heightofAxis <= 20) {
                subText = 5;
            }
            double height = underPlanned - (this.height - (double)actualheight + 5.0);
            SvgRenderKit.addRec(writer, 0.0, this.height - (double)actualheight + 5.0, HEIGHT_OUTER_LABEL, height, recStyle, null);
            SvgRenderKit.addRec(writer, HEIGHT_OUTER_LABEL - 1, this.height - (double)actualheight + 5.0 + height - (double)heightofAxis, SPACE_FOR_XAXIS_LABEL - HEIGHT_OUTER_LABEL + 1, heightofAxis, recStyle, null);
            double yText = underPlanned - (double)subText;
            SvgRenderKit.addText(writer, HEIGHT_OUTER_LABEL + 5, yText, "fill:white; font-family:verdana; font-size:12px; font-weight:bold;", "SOLL", null);
            height = this.height - (underPlanned + 10.0);
            SvgRenderKit.addRec(writer, 0.0, underPlanned + 10.0, HEIGHT_OUTER_LABEL, height, recStyle, null);
            SvgRenderKit.addRec(writer, HEIGHT_OUTER_LABEL - 1, this.height - (double)heightofAxis, SPACE_FOR_XAXIS_LABEL - HEIGHT_OUTER_LABEL + 1, heightofAxis, recStyle, null);
            yText = this.height - (double)subText;
            SvgRenderKit.addText(writer, HEIGHT_OUTER_LABEL + 5, yText, "fill:white; font-family:verdana; font-size:12px; font-weight:bold;", "IST", null);
        } else {
            double height = this.height - (this.height - (double)actualheight + 5.0);
            SvgRenderKit.addRec(writer, 0.0, this.height - (double)actualheight + 5.0, HEIGHT_OUTER_LABEL, height, recStyle, null);
            SvgRenderKit.addRec(writer, HEIGHT_OUTER_LABEL - 1, this.height - (double)heightofAxis, SPACE_FOR_XAXIS_LABEL - HEIGHT_OUTER_LABEL + 1, heightofAxis, recStyle, null);
            SvgRenderKit.addText(writer, HEIGHT_OUTER_LABEL + 5, this.height - (double)(heightofAxis <= 20 ? 5 : 10), "fill:white; font-family:verdana; font-size:12px; font-weight:bold;", "IST", null);
        }
        SimpleBoundingBox box = SvgReviewHelper.getSimpleBoundingBox(0.0, this.height - (double)actualheight, this.width, this.height);
        return new SvgDataContainer("", box);
    }

    private AxisCalculationResult drawAxis(IMarkupWriter writer, ReleasedDocument relDoc, ReviewCycleInstanceRelease cycleInstanceRel) {
        int weeksNew;
        double widthOfGraphic = this.width - (double)SPACE_FOR_XAXIS_LABEL;
        int newDuration = this.calculateAxis(relDoc, cycleInstanceRel, widthOfGraphic);
        if (log.isDebugEnabled()) {
            log.debug((Object)("calculateAxis: startOfAxis= " + SvgReviewHelper.getDateFormat(this.df, this.startOfAxis) + " endOfAxis= " + SvgReviewHelper.getDateFormat(this.df, this.endOfAxis)));
        }
        int projectDurationinMonth = newDuration > 0 ? newDuration : SvgReviewHelper.calculateMonthToDraw(this.startOfAxis, this.endOfAxis);
        int projectDurationInDays = SvgReviewHelper.calculateDaysToDraw(this.modifyDate(this.startOfAxis, 1, null), this.modifyDate(this.endOfAxis, this.endOfAxis.getActualMaximum(5), null));
        int projectDurationinWeeks = SvgReviewHelper.calculateWeeksToDraw(this.startOfAxis, this.endOfAxis);
        if (this.calcNewAxis && (weeksNew = SvgReviewHelper.calculateWeeksToDraw(this.startOfAxis2, this.endOfAxis2)) > projectDurationinWeeks) {
            projectDurationinWeeks = weeksNew;
        }
        double spacePerTimeUnit = 0.0;
        int heightofAxis = 0;
        this.drawWeeks = widthOfGraphic / (double)projectDurationinMonth > (double)MIN_SPACE_DRAW_WEEKS;
        SimpleBoundingBox box = SvgReviewHelper.getSimpleBoundingBox(SPACE_FOR_XAXIS_LABEL, 0.0, this.width, this.height);
        if (this.drawWeeks) {
            this.endOfAxis = this.modifyDate(this.endOfAxis, this.endOfAxis.getFirstDayOfWeek() + 6, 7);
            spacePerTimeUnit = Math.floor(widthOfGraphic / (double)projectDurationinWeeks);
            this.maxWidth = spacePerTimeUnit * (double)projectDurationinWeeks;
            heightofAxis = SvgReviewHelper.drawDateWeeks(writer, this.renderer, projectDurationinWeeks, this.startOfAxis, box, this.holifactory, this.project);
        } else {
            heightofAxis = SvgReviewHelper.drawDate(writer, projectDurationInDays, this.startOfAxis, box);
            spacePerTimeUnit = widthOfGraphic / (double)projectDurationInDays;
            this.maxWidth = spacePerTimeUnit * (double)projectDurationInDays;
        }
        AxisCalculationResult result = new AxisCalculationResult();
        result.heightofAxis = heightofAxis;
        result.projectDurationInDays = projectDurationInDays;
        result.projectDurationinMonth = projectDurationinMonth;
        result.projectDurationinWeeks = projectDurationinWeeks;
        result.spacePerTimeUnit = spacePerTimeUnit;
        return result;
    }

    private int calculateAxis(ReleasedDocument relDoc, ReviewCycleInstanceRelease cycleInstanceRel, double widthOfGraphic) {
        if (relDoc != null && relDoc.getEndDate() != null) {
            this.plannedEnd = DateHelper.getCalendar(relDoc.getEndDate());
            if (relDoc.getStartDate() != null) {
                this.plannedStart = DateHelper.getCalendar(relDoc.getStartDate());
            } else {
                this.plannedStart = (Calendar)this.plannedEnd.clone();
                this.plannedStart = this.holicalc.addWorkingDays(this.plannedStart, -cycleInstanceRel.getDuration());
            }
            int preDuration = cycleInstanceRel.getPreDuration();
            if (log.isDebugEnabled()) {
                log.debug((Object)("reviewCycleInstance duration : " + cycleInstanceRel.getDuration()));
                log.debug((Object)(" planned start= " + SvgReviewHelper.getDateFormat(this.df, this.plannedStart) + " planned end= " + SvgReviewHelper.getDateFormat(this.df, this.plannedEnd)));
            }
            Calendar startDate = this.plannedStart.before(this.plannedEnd) ? (this.actualStartOfReviewCycle.before(this.plannedStart) ? (Calendar)this.actualStartOfReviewCycle.clone() : (Calendar)this.plannedStart.clone()) : (this.plannedEnd.before(this.actualStartOfReviewCycle) ? (Calendar)this.plannedEnd.clone() : (Calendar)this.actualStartOfReviewCycle.clone());
            Calendar endDate = this.actualEndOfReviewCycle.after(this.plannedEnd) ? (Calendar)this.actualEndOfReviewCycle.clone() : (Calendar)this.plannedEnd.clone();
            this.drawPlannedRCycle = true;
            int durationBetweenPlannedAndReal = 0;
            if (this.plannedStart.before(this.actualStartOfReviewCycle)) {
                durationBetweenPlannedAndReal = SvgReviewHelper.calculateMonthToDraw(this.plannedStart, this.actualStartOfReviewCycle);
            }
            if (durationBetweenPlannedAndReal > 6) {
                long tmp2;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"draw new axis");
                }
                this.startOfAxis2 = (Calendar)this.plannedStart.clone();
                this.endOfAxis2 = (Calendar)this.plannedEnd.clone();
                this.calcNewAxis = true;
                long tmp = this.endOfAxis2.getTimeInMillis() - this.startOfAxis2.getTimeInMillis();
                if (tmp > (tmp2 = this.endOfAxis.getTimeInMillis() - this.startOfAxis.getTimeInMillis())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"calc new time for end of axis");
                    }
                    long newTime = this.endOfAxis.getTimeInMillis() + (tmp - tmp2);
                    this.endOfAxis.setTimeInMillis(newTime);
                } else {
                    Calendar end;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"calc new time for end of axis2");
                    }
                    long newTime = this.endOfAxis2.getTimeInMillis() + (tmp2 - tmp);
                    if (widthOfGraphic / (double)SvgReviewHelper.calculateMonthToDraw(this.startOfAxis, this.endOfAxis) > (double)MIN_SPACE_DRAW_WEEKS) {
                        end = this.modifyDate(this.startOfAxis, -this.startOfAxis.get(7), null);
                    } else {
                        end = this.modifyDate(this.startOfAxis, -1, 2);
                        end.set(5, end.getActualMaximum(5));
                    }
                    if (newTime > end.getTimeInMillis()) {
                        this.endOfAxis2 = end;
                        this.startOfAxis2.setTimeInMillis(this.endOfAxis2.getTimeInMillis() - tmp2);
                    } else {
                        this.endOfAxis2.setTimeInMillis(newTime);
                    }
                }
                if (preDuration > 0 && !this.taskOp.isReversePreduration()) {
                    this.startOfAxis = this.holicalc.addWorkingDays(this.startOfAxis, -preDuration);
                    this.startOfAxis2 = this.holicalc.addWorkingDays(this.startOfAxis2, -preDuration);
                }
                if (this.holicalc.isHolidayOrWeekend(this.endOfAxis)) {
                    this.endOfAxis = this.holicalc.addWorkingDays(this.endOfAxis, 1);
                }
                if (this.holicalc.isHolidayOrWeekend(this.endOfAxis2)) {
                    this.endOfAxis2 = this.holicalc.addWorkingDays(this.endOfAxis2, 1);
                }
                return -1;
            }
            int newDuration = SvgReviewHelper.calculateMonthToDraw(startDate, endDate);
            this.startOfAxis = (Calendar)startDate.clone();
            if (preDuration > 0 && !this.taskOp.isReversePreduration()) {
                this.startOfAxis = this.holicalc.addWorkingDays(this.startOfAxis, -preDuration);
            }
            this.endOfAxis = (Calendar)endDate.clone();
            if (this.holicalc.isHolidayOrWeekend(this.endOfAxis)) {
                this.endOfAxis = this.holicalc.addWorkingDays(this.endOfAxis, 1);
            }
            return newDuration;
        }
        return -1;
    }

    private double drawPlannedReviewCyle(IMarkupWriter writer, AxisCalculationResult axisData, List<ReviewCycleCellResult> cellResults, ReviewCycleInstanceRelease cycleInstanceRel, ReleasedDocument releasedDocument) {
        double sx;
        Calendar s;
        double theStart;
        if (log.isDebugEnabled()) {
            log.debug((Object)"--------------draw planned values --------------");
        }
        double plannedHeight = 0.0;
        double heightofAxis = axisData.heightofAxis;
        double spacePerTimeUnit = axisData.spacePerTimeUnit;
        SimpleBoundingBox box = SvgReviewHelper.getSimpleBoundingBox(SPACE_FOR_XAXIS_LABEL, 0.0, this.width, this.yBasic);
        if (this.drawWeeks) {
            SvgReviewHelper.drawDateWeeks(writer, this.renderer, axisData.projectDurationinWeeks, this.calcNewAxis ? this.startOfAxis2 : this.startOfAxis, box, this.holifactory, this.project);
        } else {
            SvgReviewHelper.drawDate(writer, axisData.projectDurationInDays, this.calcNewAxis ? this.startOfAxis2 : this.startOfAxis, box);
        }
        this.yBasic -= heightofAxis;
        ArrayList<TextWithPosition> versionStrings = new ArrayList<TextWithPosition>();
        ArrayList<SeparateBoxLabel> nodeNames = new ArrayList<SeparateBoxLabel>();
        double yValue = this.yBasic - (double)SIZE_OF_VERSION_LABEL - 20.0;
        double nodeXStart = theStart = SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.calcNewAxis ? this.startOfAxis2 : this.startOfAxis, this.plannedStart, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL;
        int preDuration = cycleInstanceRel.getPreDuration();
        if (preDuration > 0 && !this.taskOp.isReversePreduration()) {
            Calendar preDurationStart = this.holicalc.addWorkingDays(this.plannedStart, -preDuration);
            double preDurationXStart = SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.calcNewAxis ? this.startOfAxis2 : this.startOfAxis, preDurationStart, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL;
            double preDurationXEnd = nodeXStart;
            this.drawNode(writer, preDurationXStart, preDurationXEnd, yValue + (double)(HEIGHT_OF_NODE / 2), HEIGHT_OF_NODE / 2, "#ffff00", false, preDuration, 3);
        }
        boolean firstNode = true;
        ArrayList cellInstances = (ArrayList)cycleInstanceRel.getReviewCycleCellInstancesDefault();
        for (ReviewCycleCellInstance cellInstRel : cellInstances) {
            if (cellInstRel.getReviewCycleCell().getPosition() == null) continue;
            String color = cellInstRel.getReviewCycleCell().getSvgColor();
            TextWithPosition versionString = new TextWithPosition();
            versionString.text = cellInstRel.getReviewCycleCell().getCode() != null ? cellInstRel.getReviewCycleCell().getCode() : TapestryI18nHelper.getLocalizedString(cellInstRel.getReviewCycleCell().getName());
            versionString.xStartOfCell = nodeXStart;
            versionString.color = color;
            ArrayList nodes = (ArrayList)cellInstRel.getReviewCycleNodeInstancesSortedByPosition();
            for (ReviewCycleNodeInstance nodeInstRel : nodes) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("name " + TapestryI18nHelper.getLocalizedString(nodeInstRel.getReviewCycleNode().getName()) + "duration " + nodeInstRel.getDuration() + "duration Min " + nodeInstRel.getDurationMin()));
                    log.debug((Object)("size of positions " + nodeInstRel.getReviewCyclePositions().size()));
                    log.debug((Object)("empty node " + nodeInstRel.getReviewCycleNode().isEndNode()));
                    log.debug((Object)("is free " + nodeInstRel.getReviewCycleNode().isFree()));
                }
                if (nodeInstRel.getReviewCyclePositions().size() > 0 || !cellInstRel.getReviewCycleCell().isEndCell() && nodeInstRel.getReviewCycleNode().isEndNode()) {
                    int addDelta = 0;
                    if (firstNode && nodeInstRel.getDuration() > 0) {
                        addDelta = 1;
                        firstNode = false;
                    }
                    this.plannedStart = this.holicalc.addWorkingDays(this.plannedStart, nodeInstRel.getDuration() + addDelta);
                    double nodeXEnd = SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.calcNewAxis ? this.startOfAxis2 : this.startOfAxis, this.plannedStart, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL;
                    double cellsize = this.drawNode(writer, nodeXStart, nodeXEnd, yValue, this.yBasic - yValue, color, nodeInstRel.getReviewCycleNode());
                    firstNode = false;
                    if (cellsize > 10.0) {
                        SvgRenderKit.addText(writer, nodeXStart + 5.0, yValue + 10.0, "font-family:verdana; font-size:8px", String.valueOf(nodeInstRel.getDuration()), null);
                    }
                    SeparateBoxLabel boxLabel = new SeparateBoxLabel();
                    boxLabel.text = TapestryI18nHelper.getLocalizedString(nodeInstRel.getReviewCycleNode().getName());
                    boxLabel.boxName = "#arrow";
                    boxLabel.xPositionOfBox = nodeXStart;
                    boxLabel.yPositionOfBox = yValue;
                    boxLabel.drawCircle = false;
                    nodeNames.add(boxLabel);
                    nodeXStart = nodeXEnd;
                    continue;
                }
                if (preDuration <= 0 || !this.taskOp.isReversePreduration() || !nodeInstRel.getReviewCycleNode().isEndOfReviewCycle()) continue;
                Calendar preDurationEnd = this.holicalc.addWorkingDays(this.plannedStart, preDuration);
                double preDurationXStart = nodeXStart;
                double preDurationXEnd = SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.calcNewAxis ? this.startOfAxis2 : this.startOfAxis, preDurationEnd, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL;
                this.drawNode(writer, preDurationXStart, preDurationXEnd, yValue + (double)(HEIGHT_OF_NODE / 2), HEIGHT_OF_NODE / 2, "#ffffff", true, preDuration, 3);
            }
            versionString.xEndOfCell = nodeXStart;
            versionStrings.add(versionString);
        }
        int delta = 0;
        if (this.holicalc.isHolidayOrWeekend(this.plannedEnd)) {
            ++delta;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("plannedEnd + delta = " + SvgReviewHelper.getDateFormat(this.df, this.plannedEnd) + " + " + delta + " ,isHolidayOrWeekend=" + this.holicalc.isHolidayOrWeekend(this.plannedEnd) + " ,DAY_OF_WEEK=" + 7));
        }
        double theEnd = SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.calcNewAxis ? this.startOfAxis2 : this.startOfAxis, this.holicalc.addWorkingDays(this.plannedEnd, delta), spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL;
        SvgRenderKit.addRec(writer, SvgReviewHelper.createRectangleDefinitions(theEnd, yValue + 21.0, 0.0, 0.0, -axisData.spacePerTimeUnit / 7.0, 9.0, axisData.spacePerTimeUnit / 7.0, 18.0), "fill:#000000; opacity:.5;", false, false);
        SvgRenderKit.addText(writer, theEnd - 40.0, yValue + 29.0, "font-family:verdana; font-size:8px", SvgReviewHelper.getDateFormat(this.df, this.plannedEnd), null);
        SvgRenderKit.addText(writer, theEnd - 23.0, yValue + 37.0, "font-family:verdana; font-size:8px", "Ende", null);
        if (releasedDocument != null && (s = DateHelper.getCalendar(releasedDocument.getStartDate())) != null && ((sx = SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.calcNewAxis ? this.startOfAxis2 : this.startOfAxis, s, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL) < theEnd - 5.0 || sx > theEnd + 5.0)) {
            SvgRenderKit.addRec(writer, SvgReviewHelper.createRectangleDefinitions(sx, yValue + 21.0, -axisData.spacePerTimeUnit / 7.0, 9.0, 0.0, 0.0, axisData.spacePerTimeUnit / 7.0, 18.0), "fill:#000000; opacity:.5;", false, false);
            SvgRenderKit.addText(writer, sx - 40.0, yValue + 29.0, "font-family:verdana; font-size:8px", SvgReviewHelper.getDateFormat(this.df, s), null);
            SvgRenderKit.addText(writer, sx - 23.0, yValue + 37.0, "font-family:verdana; font-size:8px", "Start", null);
        }
        box = SvgReviewHelper.getSimpleBoundingBox(SPACE_FOR_XAXIS_LABEL, yValue - 25.0 - heightofAxis, this.maxWidth + (double)SPACE_FOR_XAXIS_LABEL, yValue);
        int labelsize = this.calcSeparateBoxLabels(writer, nodeNames, box);
        SvgRenderKit.addRec(writer, HEIGHT_OUTER_LABEL, this.yBasic - (double)SIZE_OF_VERSION_LABEL, theStart - (double)HEIGHT_OUTER_LABEL, 20.0, "stroke:none; fill:grey; opacity:.1;", null);
        SvgRenderKit.addLine(writer, HEIGHT_OUTER_LABEL, this.yBasic - (double)SIZE_OF_VERSION_LABEL, this.maxWidth + (double)SPACE_FOR_XAXIS_LABEL, this.yBasic - (double)SIZE_OF_VERSION_LABEL, lineStyle);
        SvgRenderKit.addText(writer, HEIGHT_OUTER_LABEL + 5, this.yBasic - (double)SIZE_OF_VERSION_LABEL + 15.0, "font-family:verdana; font-size:10px", "Status", null);
        this.drawStatusBar(writer, versionStrings, this.yBasic - (double)SIZE_OF_VERSION_LABEL);
        plannedHeight = 50.0 + heightofAxis + (double)labelsize;
        return plannedHeight;
    }

    private int drawRealReviewCyle(IMarkupWriter writer, AxisCalculationResult axisData, List<ReviewCycleCellResult> cellResults, ReviewCycleInstanceRelease cycleInstanceRel, boolean usePDCStartDate) {
        double xStartCycle;
        if (log.isDebugEnabled()) {
            log.debug((Object)"[drawRealReviewCyle] Start");
        }
        int widthOfNodesToDraw = this.getVAreaOfNodesToDraw(cellResults, 20);
        double spacePerTimeUnit = axisData.spacePerTimeUnit;
        int heightofAxis = axisData.heightofAxis;
        int yPositionOfCell = widthOfNodesToDraw;
        ArrayList<SeparateBoxLabel> seperateBoxLabels = new ArrayList<SeparateBoxLabel>();
        this.cellsVersionString = new ArrayList();
        int nodeLabel = 1;
        boolean firstNotEmptyNode = true;
        boolean firstOpenNode = true;
        boolean endOfReviewCycle = false;
        boolean isEndOfReviewCycleInvalidated = false;
        boolean isNodeResultInvalidatedAll = false;
        boolean lastCellResultIsInvalidated = false;
        double XnodeStart = xStartCycle = SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.startOfAxis, this.actualStartOfReviewCycle, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL;
        double XnodeEnd = -1.0;
        Calendar nodeEnd = null;
        ReviewCycleNodeResult lastNodeResult = null;
        Document document = null;
        if (cellResults.size() > 0) {
            ReviewCycleCellResult firstCellResult = cellResults.get(0);
            document = firstCellResult.getDocumentVersion().getDocument();
        }
        boolean lastDocumentVersionHasCellResult = false;
        if (cellResults.size() > 0) {
            lastDocumentVersionHasCellResult = cellResults.get(cellResults.size() - 1).getDocumentVersion().isLastDocumentVersion();
        }
        Calendar nodeStart = null;
        if (usePDCStartDate && (this.plannedStart == null || !this.plannedStart.after(this.actualStartOfReviewCycle))) {
            usePDCStartDate = false;
        }
        for (ReviewCycleCellResult cellResult : cellResults) {
            if (!cellResult.isFinished() && cellResult.getPreviousReviewCycleCell() == null && cellResult.getNextReviewCycleCell() == null && cellResults.size() > 1) continue;
            endOfReviewCycle = false;
            ReviewCycleCellInstanceRelease cellInstanceRel = (ReviewCycleCellInstanceRelease)cycleInstanceRel.getReviewCycleCellInstanceByCellId(cellResult.getReviewCycleCell().getId());
            ReviewCycleResultOption cellResultOption = cellResult.getReviewCycleResultOption();
            String color = cellResult.getReviewCycleCell().getSvgColor();
            int documentInvalidId = cellResult.getReviewCycleCell().getReviewCycle().getDocumentInvalidationOption().getId();
            int documentVersionInvalidId = cellResult.getReviewCycleCell().getReviewCycle().getDocumentVersionInvalidationOption().getId();
            this.emptyNodeId = cellResult.getReviewCycleCell().getReviewCycle().getEmptyNodeOption().getId();
            int deletedVersionId = cellResult.getReviewCycleCell().getReviewCycle().getDocumentVersionDeletedOption().getId();
            ReviewCycleEntryResult entry = this.reviewOp.getReviewCycleEntryResultByDocumentVersion(cellResult.getDocumentVersion().getId());
            SimpleDateFormat df2 = new SimpleDateFormat("(dd.MM.yy)");
            if (entry != null) {
                SeparateBoxLabel boxLabel = new SeparateBoxLabel();
                boxLabel.drawCircle = true;
                boxLabel.UrxNode = -1.0;
                boxLabel.LlyNode = this.yBasic - (double)yPositionOfCell;
                String name = entry.getProjectParticipant().getOrganisationPerson().getPerson().getSurName();
                boxLabel.text = name != null ? name + " " + df2.format(entry.getResultDate()) : "";
                boxLabel.boxName = "#firstUploadBox";
                boxLabel.xPositionOfBox = XnodeStart;
                boxLabel.yPositionOfBox = this.yBasic - (double)(yPositionOfCell - 10);
                seperateBoxLabels.add(boxLabel);
            } else {
                ReviewCycleCellConnectionResult conn = this.reviewOp.getReviewCycleCellConnectionResultByDocumentVersion(cellResult.getDocumentVersion().getId());
                if (conn != null && conn.getResultDate() != null) {
                    SeparateBoxLabel boxLabel = new SeparateBoxLabel();
                    boxLabel.UrxNode = -1.0;
                    boxLabel.drawCircle = true;
                    boxLabel.LlyNode = this.yBasic - (double)yPositionOfCell + 20.0;
                    String name = conn.getProjectParticipant().getOrganisationPerson().getPerson().getSurName();
                    String date = " " + df2.format(conn.getResultDate());
                    boxLabel.text = name != null ? name + date : "";
                    boxLabel.boxName = "#uploadBox";
                    boxLabel.xPositionOfBox = SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.startOfAxis, DateHelper.getCalendar(conn.getResultDate()), spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL;
                    boxLabel.yPositionOfBox = this.yBasic - (double)(yPositionOfCell - 10 + 20);
                    seperateBoxLabels.add(boxLabel);
                }
            }
            TextWithPosition versionString = new TextWithPosition();
            versionString.text = cellResult.getDocumentVersion().getVersionPart();
            versionString.xStartOfCell = XnodeStart;
            versionString.color = color;
            ArrayList nodeResults = (ArrayList)cellResult.getReviewCycleNodeResultsSortedByPosition(true);
            for (ReviewCycleNodeResult nodeResult : nodeResults) {
                double size;
                if (nodeResult.getReviewCycleNode().isEndOfReviewCycle() && nodeResult.getDocumentVersion().isLastDocumentVersion()) {
                    endOfReviewCycle = true;
                }
                if (endOfReviewCycle && (cellResultOption == null || cellResultOption != null && !cellResultOption.isFinishCell()) || nodeResult.getReviewCycleResultOption() != null && nodeResult.getReviewCycleResultOption().getId() == this.emptyNodeId) continue;
                isEndOfReviewCycleInvalidated = false;
                if (nodeResult.getReviewCycleNode().isEndOfReviewCycle() && nodeResult.getReviewCycleResultOption() != null && (nodeResult.getReviewCycleResultOption().getId() == documentVersionInvalidId || nodeResult.getReviewCycleResultOption().getId() == documentInvalidId || nodeResult.getReviewCycleResultOption().getId() == deletedVersionId)) {
                    isEndOfReviewCycleInvalidated = true;
                }
                isNodeResultInvalidatedAll = nodeResult.getReviewCycleResultOption() != null && nodeResult.getReviewCycleResultOption().getId() == documentInvalidId;
                ArrayList<ReviewCyclePositionResult> positionResults = new ArrayList<ReviewCyclePositionResult>();
                Map m = nodeResult.getReviewCycleNodePositionResults();
                positionResults.addAll(m.values());
                positionResults = ReviewCycleNodeInstanceHelper.sortPositionListByDate(positionResults);
                ReviewCycleNodeInstanceRelease nodeInstanceRel = this.reviewOp.getReleasedReviewCycleNodeInstance3(nodeResult.getReviewCycleNode().getId(), cycleInstanceRel.getId());
                if (nodeResult.getReviewCycleNode().isFree()) {
                    for (ReviewCyclePositionResult positionResult : positionResults) {
                        Calendar actualDate = DateHelper.getCalendar(positionResult.getResultDate());
                        double Xposition = SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.startOfAxis, actualDate, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL;
                        if (positionResult.getReviewCycleResultOption() == null || positionResult.getSignature() == null) continue;
                        String toDraw = this.getPostionType(positionResult, documentInvalidId, documentVersionInvalidId, deletedVersionId);
                        SeparateBoxLabel boxLabel = new SeparateBoxLabel();
                        boxLabel.drawCircle = true;
                        boxLabel.UrxNode = XnodeStart;
                        boxLabel.LlyNode = this.yBasic - (double)yPositionOfCell;
                        boxLabel.text = positionResult.getProjectParticipant().getOrganisationPerson().getPerson().getSurName() + " " + df2.format(positionResult.getResultDate());
                        boxLabel.boxName = toDraw;
                        boxLabel.xPositionOfBox = Xposition;
                        boxLabel.yPositionOfBox = this.yBasic - (double)(yPositionOfCell - 10);
                        seperateBoxLabels.add(boxLabel);
                    }
                    continue;
                }
                double XnodeInvalidatedStart = -1.0;
                nodeStart = nodeStart == null ? this.actualStartOfReviewCycle : DateHelper.getCalendar(nodeResult.getDocumentArrivalDate());
                if (isEndOfReviewCycleInvalidated) {
                    for (ReviewCyclePositionResult positionResult : positionResults) {
                        if (positionResult.getReviewCycleResultOption() == null || positionResult.getReviewCycleResultOption().getId() != documentVersionInvalidId && positionResult.getReviewCycleResultOption().getId() != documentInvalidId && positionResult.getReviewCycleResultOption().getId() != deletedVersionId) continue;
                        XnodeInvalidatedStart = nodeStart != null ? SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.startOfAxis, nodeStart, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL : (double)SPACE_FOR_XAXIS_LABEL;
                        nodeStart = DateHelper.getCalendar(positionResult.getResultDate());
                    }
                } else if (!nodeResult.isFinished() && firstNotEmptyNode && usePDCStartDate) {
                    XnodeInvalidatedStart = nodeStart != null ? SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.startOfAxis, nodeStart, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL : (double)SPACE_FOR_XAXIS_LABEL;
                    nodeStart = this.plannedStart;
                }
                Calendar actualNodeEnd = ReviewCycleNodeInstanceHelper.verifyDocumentDepartureDate(nodeResult);
                int nodesDelay = 0;
                int daysInNode = -1;
                ReleasedObjectList relObjectList = nodeResult.getActiveObjectListOfDocumentDeparture() != null ? (ReleasedObjectList)nodeResult.getActiveObjectListOfDocumentDeparture() : cycleInstanceRel.getObjectList();
                Triple<Calendar, Integer, Integer> nodesData = ReviewCycleNodeInstanceHelper.calcDelayOfActualNode(this.objectOperations, this.taskOp, this.reviewOp, this.holicalc, nodeResult, nodeStart, false, relObjectList);
                Calendar contractualDeadline = (Calendar)nodesData.getFirst();
                nodesDelay = (Integer)nodesData.getSecond();
                int duration = (Integer)nodesData.getThird();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Knoten " + TapestryI18nHelper.getLocalizedString(nodeResult.getReviewCycleNode().getName()) + ":"));
                    log.debug((Object)("actualNodeEnd: " + SvgReviewHelper.getDateFormat(this.df, actualNodeEnd)));
                }
                if (actualNodeEnd == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("calcDelayOfActualNode: node delay= " + nodesDelay + " contractualDeadline= " + SvgReviewHelper.getDateFormat(this.df, contractualDeadline)));
                    }
                    nodeEnd = nodesDelay < 0 || usePDCStartDate ? contractualDeadline : this.toDay;
                } else {
                    nodeEnd = nodesDelay < 0 ? contractualDeadline : actualNodeEnd;
                }
                daysInNode = actualNodeEnd == null ? this.holicalc.getWorkingDaysBetween(nodeStart, this.toDay) : this.holicalc.getWorkingDaysBetween(nodeStart, actualNodeEnd);
                XnodeStart = nodeStart != null ? SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.startOfAxis, nodeStart, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL : (double)SPACE_FOR_XAXIS_LABEL;
                XnodeEnd = nodeEnd != null ? SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.startOfAxis, nodeEnd, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL : this.maxWidth;
                int addDelta = 0;
                if (firstOpenNode && actualNodeEnd == null) {
                    addDelta = 1;
                    XnodeEnd = (nodeEnd = this.holicalc.addWorkingDays(nodeEnd, addDelta)) != null ? SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.startOfAxis, nodeEnd, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL : this.maxWidth;
                    firstOpenNode = false;
                }
                firstNotEmptyNode = false;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("nodeStart: " + SvgReviewHelper.getDateFormat(this.df, nodeStart) + " nodeEnd: " + SvgReviewHelper.getDateFormat(this.df, nodeEnd) + " postition " + nodeResult.getReviewCycleNode().getPosition() + " duration: " + duration + " XnodeStart: " + XnodeStart + " XnodeEnd: " + XnodeEnd));
                }
                if (XnodeInvalidatedStart != -1.0 && XnodeInvalidatedStart < XnodeStart) {
                    SvgRenderKit.addLine(writer, XnodeInvalidatedStart, this.yBasic - (double)yPositionOfCell, XnodeInvalidatedStart, this.yBasic - (double)yPositionOfCell + (double)(HEIGHT_OF_NODE / 2), "stroke:black; stroke-width:1px;");
                    SvgRenderKit.addLine(writer, XnodeInvalidatedStart, this.yBasic - (double)yPositionOfCell + (double)(HEIGHT_OF_NODE / 2), XnodeStart, this.yBasic - (double)yPositionOfCell + (double)(HEIGHT_OF_NODE / 2), "stroke:black; stroke-width:1px;");
                }
                int typeOfEdges = SvgReviewHelper.calculateTypeOfEdges(nodeResult.getReviewCycleNode(), "[drawRealReviewCyle] ", nodesDelay < 0 || actualNodeEnd == null && !nodeResult.getReviewCycleNode().isEndNode());
                if (nodeEnd != null) {
                    XnodeStart = this.drawNode(writer, XnodeStart, XnodeEnd, this.yBasic - (double)yPositionOfCell + (double)(HEIGHT_OF_NODE / 2), HEIGHT_OF_NODE, color, false, duration, typeOfEdges);
                }
                XnodeStart = XnodeEnd;
                if (nodesDelay < 0) {
                    nodeEnd = actualNodeEnd != null ? actualNodeEnd : this.holicalc.addWorkingDays(this.toDay, 1);
                    XnodeEnd = SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.startOfAxis, nodeEnd, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL;
                    int typeOfEdges2 = SvgReviewHelper.calculateTypeOfEdges(nodeResult.getReviewCycleNode(), "[drawRealReviewCyle] ", false);
                    XnodeStart = this.drawNode(writer, XnodeStart, XnodeEnd, this.yBasic - (double)yPositionOfCell + (double)(HEIGHT_OF_NODE / 2), HEIGHT_OF_NODE, "#ff0000; opacity:0.7", false, nodesDelay, typeOfEdges2 - typeOfEdges);
                }
                boolean isLastNodeResult = nodeResults.lastIndexOf(nodeResult) == nodeResults.size() - 1;
                boolean lastCellResult = cellResults.lastIndexOf(cellResult) == cellResults.size() - 1;
                boolean bl = lastCellResultIsInvalidated = lastCellResult && nodeResult.getReviewCycleResultOption() != null && (nodeResult.getReviewCycleResultOption().getId().equals(documentVersionInvalidId) || nodeResult.getReviewCycleResultOption().getId().equals(deletedVersionId)) || lastCellResult && !lastDocumentVersionHasCellResult;
                if (lastCellResultIsInvalidated && isLastNodeResult) {
                    nodeStart = nodeEnd;
                    contractualDeadline = this.holicalc.addWorkingDays(actualNodeEnd, duration);
                    nodesDelay = this.holicalc.getWorkingDaysBetween(this.toDay, contractualDeadline);
                    nodeEnd = nodesDelay < 0 ? contractualDeadline : this.holicalc.addWorkingDays(this.toDay, 1);
                    XnodeEnd = SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.startOfAxis, nodeEnd, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL;
                    XnodeStart = this.drawNode(writer, XnodeStart, XnodeEnd, this.yBasic - (double)yPositionOfCell + (double)(HEIGHT_OF_NODE / 2), HEIGHT_OF_NODE, color, false, duration, typeOfEdges);
                    if (nodesDelay < 0) {
                        nodeEnd = this.holicalc.addWorkingDays(this.toDay, 1);
                        XnodeEnd = SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.startOfAxis, nodeEnd, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL;
                        int typeOfEdges2 = SvgReviewHelper.calculateTypeOfEdges(nodeResult.getReviewCycleNode(), "[drawRealReviewCyle] ", false);
                        XnodeStart = this.drawNode(writer, XnodeStart, XnodeEnd, this.yBasic - (double)yPositionOfCell + (double)(HEIGHT_OF_NODE / 2), HEIGHT_OF_NODE, "#ff0000; opacity:0.7", false, nodesDelay, typeOfEdges2 - typeOfEdges);
                    }
                }
                if (nodeLabel % 2 == 0) {
                    SvgRenderKit.addRec(writer, xStartCycle, this.yBasic - (double)yPositionOfCell, XnodeStart - xStartCycle, 20.0, "stroke:black; stroke:none; fill:white; opacity:.3;", null);
                } else {
                    SvgRenderKit.addRec(writer, HEIGHT_OUTER_LABEL, this.yBasic - (double)yPositionOfCell, xStartCycle - (double)HEIGHT_OUTER_LABEL, 20.0, "stroke:none; fill:grey; opacity:.1;", null);
                }
                String nodeStatusText = TapestryI18nHelper.getLocalizedString(nodeResult.getReviewCycleNode().getName());
                String wt = " (" + (daysInNode >= 0 ? Integer.valueOf(daysInNode) : "0") + "/" + duration + " WT)";
                try {
                    size = this.renderer.getTextWidth("Verdana", nodeStatusText) * 10.0;
                    size += this.renderer.getTextWidth("Verdana", wt) * 10.0;
                }
                catch (BatikSvgException e) {
                    throw new ActionException("error getting text width", e);
                }
                if (size > xStartCycle - (double)HEIGHT_OUTER_LABEL) {
                    int diff = (int)(Math.floor(size - (xStartCycle - (double)HEIGHT_OUTER_LABEL)) / 5.0);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Diff = " + diff));
                    }
                    nodeStatusText = nodeStatusText.substring(0, nodeStatusText.length() - diff);
                    nodeStatusText = nodeStatusText + "... ";
                }
                nodeStatusText = nodeStatusText + wt;
                SvgRenderKit.addText(writer, HEIGHT_OUTER_LABEL + 5, this.yBasic - (double)yPositionOfCell + 15.0, "font-family:verdana; font-size:8px", nodeStatusText, null);
                ++nodeLabel;
                for (ReviewCyclePositionResult positionResult : positionResults) {
                    Calendar positionResultDate = DateHelper.getCalendar(positionResult.getResultDate());
                    double Xposition = SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.startOfAxis, positionResultDate, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL;
                    if (positionResult.getReviewCycleResultOption() == null || positionResult.getSignature() == null) continue;
                    String labelType = this.getPostionType(positionResult, documentInvalidId, documentVersionInvalidId, deletedVersionId);
                    SeparateBoxLabel boxLabel = new SeparateBoxLabel();
                    boxLabel.drawCircle = true;
                    boxLabel.UrxNode = XnodeEnd;
                    boxLabel.LlyNode = this.yBasic - (double)yPositionOfCell;
                    boxLabel.text = positionResult.getProjectParticipant().getOrganisationPerson().getPerson().getSurName() + " " + df2.format(positionResult.getResultDate());
                    boxLabel.boxName = labelType;
                    boxLabel.xPositionOfBox = Xposition;
                    boxLabel.yPositionOfBox = this.yBasic - (double)(yPositionOfCell - 10);
                    seperateBoxLabels.add(boxLabel);
                }
                if (positionResults.size() <= 0) {
                    SeparateBoxLabel boxLabel = new SeparateBoxLabel();
                    boxLabel.UrxNode = XnodeEnd;
                    boxLabel.LlyNode = this.yBasic - (double)yPositionOfCell;
                    boxLabel.text = null;
                    seperateBoxLabels.add(boxLabel);
                }
                yPositionOfCell -= 20;
                if (XnodeEnd - XnodeStart >= 2.0) {
                    XnodeStart = XnodeEnd;
                }
                if ((nodeStart = actualNodeEnd) != null) {
                    nodeStart.add(5, 1);
                }
                lastNodeResult = nodeResult;
                if (!isNodeResultInvalidatedAll) continue;
                break;
            }
            versionString.xEndOfCell = XnodeStart;
            this.cellsVersionString.add(versionString);
        }
        if (!endOfReviewCycle && Calendar.getInstance().before(this.endOfAxis) && !isNodeResultInvalidatedAll) {
            this.drawRemainingCells(writer, lastNodeResult, document, nodeEnd, XnodeEnd, cycleInstanceRel.getObjectList(), spacePerTimeUnit, lastCellResultIsInvalidated, usePDCStartDate);
        }
        SvgRenderKit.addRec(writer, HEIGHT_OUTER_LABEL, this.yBasic, xStartCycle - (double)HEIGHT_OUTER_LABEL, 20.0, "stroke:none; fill:grey; fill-opacity:.1;", null);
        SvgRenderKit.addLine(writer, HEIGHT_OUTER_LABEL, this.yBasic, this.maxWidth + (double)SPACE_FOR_XAXIS_LABEL, this.yBasic, lineStyle);
        SvgRenderKit.addText(writer, HEIGHT_OUTER_LABEL + 5, this.yBasic + 15.0, "font-family:verdana; font-size:10px", "Version", null);
        this.drawStatusBar(writer, this.cellsVersionString, this.yBasic);
        int spaceForSeperateLabels = 0;
        if (seperateBoxLabels.size() > 0) {
            spaceForSeperateLabels = this.calcSeparateBoxLabels(writer, seperateBoxLabels, SvgReviewHelper.getSimpleBoundingBox(SPACE_FOR_XAXIS_LABEL, this.height - (double)(widthOfNodesToDraw + heightofAxis + 30), this.width, this.height - (double)heightofAxis - 20.0));
        }
        int actualheight = widthOfNodesToDraw;
        actualheight += spaceForSeperateLabels;
        return actualheight += 50;
    }

    private Calendar drawRemainingCells(IMarkupWriter writer, ReviewCycleNodeResult lastNodeResult, Document document, Calendar lastNodeEnd, double lastXnodeEnd, ReleasedObjectList objectList, double spacePerTimeUnit, boolean lastCellResultIsInvalidated, boolean usePDCStartDate) {
        double XnodeEnd;
        if (log.isDebugEnabled()) {
            log.debug((Object)"[drawRemainingCells]");
        }
        Calendar plannedNodeEnd = lastNodeEnd;
        double XnodeStart = lastXnodeEnd;
        double yValue = this.yBasic - (double)SIZE_OF_VERSION_LABEL - 20.0;
        ReviewCycleInstanceRelease cycleInstanceRel = (ReviewCycleInstanceRelease)this.objectOperations.getReleasedObjectPlannerFromList(document.getObjectPlanner().getId(), objectList.getId()).getReviewCycleInstance();
        ReviewCycleCellInstanceRelease cellInstanceRelease = null;
        int preDuration = cycleInstanceRel.getPreDuration();
        String cellColor = null;
        int nodeDelay = 0;
        int typeOfEdges = 0;
        if (lastNodeResult != null) {
            cellInstanceRelease = (ReviewCycleCellInstanceRelease)cycleInstanceRel.getReviewCycleCellInstanceByCellId(lastNodeResult.getReviewCycleNode().getReviewCycleCell().getId());
            cellColor = cellInstanceRelease.getReviewCycleCell().getSvgColor();
            if (lastCellResultIsInvalidated) {
                Calendar actualNodeEnd = ReviewCycleNodeInstanceHelper.verifyDocumentDepartureDate(lastNodeResult);
                ReviewCycleNodeInstanceRelease nodeInstanceRel = this.reviewOp.getReleasedReviewCycleNodeInstance3(lastNodeResult.getReviewCycleNode().getId(), cycleInstanceRel.getId());
                int duration = nodeInstanceRel.getDuration();
                Calendar contractualDeadline = this.holicalc.addWorkingDays(actualNodeEnd, duration);
                nodeDelay = this.holicalc.getWorkingDaysBetween(this.toDay, contractualDeadline);
            } else if (!usePDCStartDate) {
                nodeDelay = (Integer)ReviewCycleNodeInstanceHelper.calcDelayOfActualNode(this.objectOperations, this.taskOp, this.reviewOp, this.holicalc, lastNodeResult, null, false, objectList).getSecond();
            }
            int n = typeOfEdges = lastNodeResult.getReviewCycleNode().isEndOfCell() ? 1 : 0;
        }
        if (lastNodeResult != null && !lastNodeResult.getReviewCycleNode().isFree()) {
            TextWithPosition versionString = new TextWithPosition();
            versionString.text = "";
            versionString.xStartOfCell = XnodeStart;
            versionString.color = cellColor;
            if (nodeDelay > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("node in time, delay=" + nodeDelay));
                }
                plannedNodeEnd = this.holicalc.addWorkingDays(plannedNodeEnd, nodeDelay);
                XnodeEnd = SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.startOfAxis, plannedNodeEnd, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL;
                XnodeStart = this.drawNode(writer, XnodeStart, XnodeEnd, this.yBasic - (double)(HEIGHT_OF_NODE / 2), HEIGHT_OF_NODE, cellColor + "; opacity:0.7", true, nodeDelay, typeOfEdges);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("node delayed, delay=" + nodeDelay));
            }
            versionString.xEndOfCell = XnodeStart;
            this.cellsVersionString.add(versionString);
        }
        ArrayList nodeInstances = null;
        if (lastNodeResult != null && cellInstanceRelease != null) {
            TextWithPosition versionString = new TextWithPosition();
            versionString.text = "";
            versionString.xStartOfCell = XnodeStart;
            versionString.color = cellColor;
            nodeInstances = (ArrayList)cellInstanceRelease.getReviewCycleNodeInstancesSortedByPosition();
            for (int i = lastNodeResult.getReviewCycleNode().getPosition().intValue(); i < nodeInstances.size(); ++i) {
                ReviewCycleNodeInstanceRelease nodeInstanceRel = (ReviewCycleNodeInstanceRelease)nodeInstances.get(i);
                if (nodeInstanceRel.getReviewCyclePositions().size() <= 0 && (cellInstanceRelease.getReviewCycleCell().isEndCell() || !nodeInstanceRel.getReviewCycleNode().isEndNode())) continue;
                plannedNodeEnd = this.holicalc.addWorkingDays(plannedNodeEnd, nodeInstanceRel.getDuration());
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Knoten " + TapestryI18nHelper.getLocalizedString(nodeInstanceRel.getReviewCycleNode().getName()) + " desiredEnd: " + SvgReviewHelper.getDateFormat(this.df, plannedNodeEnd) + " isEndnode " + nodeInstanceRel.getReviewCycleNode().isEndNode()));
                }
                typeOfEdges = nodeInstanceRel.getReviewCycleNode().isEndOfCell() ? 1 : 0;
                XnodeEnd = SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.startOfAxis, plannedNodeEnd, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL;
                XnodeStart = this.drawNode(writer, XnodeStart, XnodeEnd, this.yBasic - (double)(HEIGHT_OF_NODE / 2), HEIGHT_OF_NODE, cellColor + "; opacity:0.3", true, nodeInstanceRel.getDuration(), typeOfEdges);
            }
            versionString.xEndOfCell = XnodeStart;
            this.cellsVersionString.add(versionString);
        }
        ArrayList restOfCells = (ArrayList)cycleInstanceRel.getReviewCycleCellInstancesDefault();
        boolean start = false;
        for (ReviewCycleCellInstance restCellInst : restOfCells) {
            TextWithPosition versionString = new TextWithPosition();
            if (start) {
                cellColor = restCellInst.getReviewCycleCell().getSvgColor();
                versionString.text = restCellInst.getReviewCycleCell().getCode();
                versionString.xStartOfCell = XnodeStart;
                versionString.color = cellColor;
                nodeInstances = (ArrayList)restCellInst.getReviewCycleNodeInstancesSortedByPosition();
                for (ReviewCycleNodeInstance restNodeInstanceRel : nodeInstances) {
                    if (restNodeInstanceRel.getReviewCycleNode().isFree() || restNodeInstanceRel.getReviewCyclePositions().size() <= 0 && (restCellInst.getReviewCycleCell().isEndCell() || !restNodeInstanceRel.getReviewCycleNode().isEndNode())) continue;
                    plannedNodeEnd = this.holicalc.addWorkingDays(plannedNodeEnd, restNodeInstanceRel.getDuration());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Knoten " + TapestryI18nHelper.getLocalizedString(restNodeInstanceRel.getReviewCycleNode().getName()) + " desiredEnd: " + SvgReviewHelper.getDateFormat(this.df, plannedNodeEnd)));
                    }
                    typeOfEdges = SvgReviewHelper.calculateTypeOfEdges(restNodeInstanceRel.getReviewCycleNode(), "rest ", false);
                    XnodeEnd = SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.startOfAxis, plannedNodeEnd, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL;
                    XnodeStart = this.drawNode(writer, XnodeStart, XnodeEnd, this.yBasic - (double)(HEIGHT_OF_NODE / 2), HEIGHT_OF_NODE, cellColor + "; opacity:0.3", true, restNodeInstanceRel.getDuration(), typeOfEdges);
                }
                versionString.xEndOfCell = XnodeStart;
                this.cellsVersionString.add(versionString);
            }
            if (!restCellInst.equals(cellInstanceRelease)) continue;
            start = true;
        }
        if (preDuration > 0 && this.taskOp.isReversePreduration()) {
            Calendar preDurationEnd = this.holicalc.addWorkingDays(plannedNodeEnd, preDuration);
            double preDurationXStart = XnodeStart;
            double preDurationXEnd = SvgReviewHelper.getXPositionFromStart(this.drawWeeks, this.calcNewAxis ? this.startOfAxis2 : this.startOfAxis, preDurationEnd, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL;
            XnodeStart = this.drawNode(writer, preDurationXStart, preDurationXEnd, this.yBasic - (double)(HEIGHT_OF_NODE / 2), HEIGHT_OF_NODE / 2, "#ffffff", true, preDuration, 3);
        }
        return plannedNodeEnd;
    }

    private double drawNode(IMarkupWriter writer, double nodeXStart, double nodeXEnd, double nodeYValue, double hight, String color, ReviewCycleNode node) {
        double width = 0.0;
        if (nodeXEnd - nodeXStart < 2.0) {
            SvgRenderKit.addRec(writer, nodeXStart - 5.0, nodeYValue, 10.0, 20.0, "stroke:none; fill:white;", null);
            SvgRenderKit.addRec(writer, nodeXStart - 5.0, nodeYValue, 10.0, 20.0, "stroke:none; fill:" + color + "; opacity:.4;", null);
            SvgRenderKit.addLine(writer, nodeXStart, nodeYValue, nodeXStart, nodeYValue + 20.0, "stroke:black; stroke-width:1px;");
        } else {
            width = nodeXEnd - nodeXStart;
            int styleOfEdges = node.getPosition() == 1 ? 1 : 0;
            this.switchNodeStyle(writer, styleOfEdges += node.isEndOfCell() ? 2 : 0, nodeXStart, nodeYValue, width, "fill:" + color + "; stroke:black; stroke-width:0.5px;");
        }
        return width;
    }

    private void switchNodeStyle(IMarkupWriter writer, int styleOfEdges, double x, double y, double width, String style) {
        switch (styleOfEdges) {
            case 0: {
                SvgRenderKit.addRec(writer, x, y, width, HEIGHT_OF_NODE, style, null);
                break;
            }
            case 1: {
                SvgRenderKit.addRec(writer, SvgReviewHelper.createRectangleDefinitions(x, y, -HEIGHT_OF_NODE / 4, HEIGHT_OF_NODE / 2, 0.0, 0.0, width, HEIGHT_OF_NODE), style, false, true);
                break;
            }
            case 2: {
                SvgRenderKit.addRec(writer, SvgReviewHelper.createRectangleDefinitions(x, y, 0.0, 0.0, HEIGHT_OF_NODE / 4, HEIGHT_OF_NODE / 2, width, HEIGHT_OF_NODE), style, true, false);
                break;
            }
            case 3: {
                SvgRenderKit.addRec(writer, SvgReviewHelper.createRectangleDefinitions(x, y, -HEIGHT_OF_NODE / 4, HEIGHT_OF_NODE / 2, HEIGHT_OF_NODE / 4, HEIGHT_OF_NODE / 2, width, HEIGHT_OF_NODE), style, false, false);
            }
        }
    }

    private double drawNode(IMarkupWriter writer, double XstartNode, double XendNode, double posCenter, double height, String fill, boolean dashed, int duration, int typeEdges) {
        if (XendNode - XstartNode < 2.0) {
            SvgRenderKit.addRec(writer, XstartNode - 5.0, posCenter - height / 2.0, 10.0, 20.0, "stroke:none; fill:white;", null);
            SvgRenderKit.addRec(writer, XstartNode - 5.0, posCenter - height / 2.0, 10.0, 20.0, "stroke:none; fill:" + fill + "; opacity:.4;", null);
            SvgRenderKit.addLine(writer, XstartNode, posCenter - height / 2.0, XstartNode, posCenter - height / 2.0 + 20.0, "stroke:black; stroke-width:1px;");
        } else {
            String style = "fill:" + fill + ";stroke:black;";
            switch (typeEdges) {
                case 0: {
                    SvgRenderKit.addRec(writer, XstartNode, posCenter - height / 2.0, 0.0, 0.0, XendNode - XstartNode, height, style, null);
                    break;
                }
                case 2: {
                    SvgRenderKit.addRec(writer, SvgReviewHelper.createRectangleDefinitions(XstartNode, posCenter - height / 2.0, -height / 4.0, height / 2.0, 0.0, 0.0, XendNode - XstartNode, height), style, false, false);
                    break;
                }
                case 1: {
                    SvgRenderKit.addRec(writer, SvgReviewHelper.createRectangleDefinitions(XstartNode, posCenter - height / 2.0, 0.0, 0.0, height / 4.0, height / 2.0, XendNode - XstartNode, height), style, false, false);
                    break;
                }
                case 3: {
                    SvgRenderKit.addRec(writer, SvgReviewHelper.createRectangleDefinitions(XstartNode, posCenter - height / 2.0, -height / 4.0, height / 2.0, height / 4.0, height / 2.0, XendNode - XstartNode, height), style, false, false);
                    break;
                }
                case -3: {
                    SvgRenderKit.addRec(writer, SvgReviewHelper.createRectangleDefinitions(XstartNode, posCenter - height / 2.0, -height / 4.0, height / 2.0, -height / 4.0, height / 2.0, XendNode - XstartNode, height), style, false, false);
                }
            }
        }
        SvgRenderKit.addText(writer, XstartNode + 5.0, posCenter, "font-family:verdana; font-size:8px;", Integer.toString(duration), null);
        return XendNode;
    }

    private String getPostionType(ReviewCyclePositionResult p, int documentInvalide, int documentVersionInvalid, int deletedVersionId) {
        String toDraw = "#okBox";
        if (documentInvalide == p.getReviewCycleResultOption().getId()) {
            toDraw = "#cancelBox";
        } else if (documentVersionInvalid == p.getReviewCycleResultOption().getId()) {
            toDraw = "#xBox";
        } else if (deletedVersionId == p.getReviewCycleResultOption().getId()) {
            toDraw = "#deletedBox";
        } else if (p.getReviewCycleResultOption().getReviewCyclePositionType() != null && p.getReviewCycleResultOption().getReviewCyclePositionType().getReviewCycleResultOptions() != null) {
            if (p.getReviewCycleResultOption().getReviewCyclePositionType().getReviewCycleResultOptions().size() >= 2) {
                toDraw = p.getReviewCycleResultOption().getValue() == 1 || p.getReviewCycleResultOption().isSampleControlReview() ? "#posBox" : "#negBox";
            }
        } else {
            toDraw = !p.getReviewCycleResultOption().isFinishCell() ? "#posBox" : "#negBox";
        }
        return toDraw;
    }

    private void drawStatusBar(IMarkupWriter writer, ArrayList<TextWithPosition> text, double topLine) {
        int position = 0;
        for (TextWithPosition v : text) {
            boolean fitsIntoCellWidth;
            double textWidth;
            try {
                textWidth = this.renderer.getTextWidth("Verdana", v.text) * 10.0;
            }
            catch (BatikSvgException e) {
                throw new ActionException("error getting text width", e);
            }
            boolean bl = fitsIntoCellWidth = v.xEndOfCell - (v.xStartOfCell + 5.0) > textWidth;
            if (fitsIntoCellWidth && position == 0) {
                SvgRenderKit.addText(writer, v.xStartOfCell + 5.0, topLine + 15.0, "font-family:verdana; font-size:10px", v.text, null);
            } else if (fitsIntoCellWidth && position > 0) {
                SvgRenderKit.addText(writer, v.xStartOfCell + 5.0, topLine + (double)(position == 1 ? 18 : 9), "font-family:verdana; font-size:10px", v.text, null);
                position = 0;
            } else if (!fitsIntoCellWidth) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("position " + position));
                }
                SvgRenderKit.addText(writer, v.xStartOfCell + 5.0, topLine + (double)(position == 1 ? 18 : 9), "font-family:verdana; font-size:10px", v.text, null);
                position = position == 1 ? 2 : 1;
            }
            SvgRenderKit.addRec(writer, v.xStartOfCell, topLine + 1.0, v.xEndOfCell - v.xStartOfCell, 18.0, "stroke:none; fill:" + v.color + "; opacity:.3;", null);
            SvgRenderKit.addLine(writer, v.xStartOfCell, topLine, v.xStartOfCell, topLine + 5.0, lineStyle);
            if (text.indexOf(v) != text.size() - 1) continue;
            SvgRenderKit.addLine(writer, v.xEndOfCell, topLine, v.xEndOfCell, topLine + 5.0, lineStyle);
        }
    }

    private int findMaxNeededPlaces(ArrayList<SeparateBoxLabel> separateBoxLabels) {
        int STEP_WIDTH = 150;
        int places = (int)(this.width - (double)SPACE_FOR_XAXIS_LABEL) / 150 + 1;
        int[] position = new int[places];
        for (int i = 0; i < places; ++i) {
            position[i] = 150 * i;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("[" + i + "] places " + 150 * i));
        }
        int[] neededPlaces = new int[places];
        block1: for (SeparateBoxLabel label : separateBoxLabels) {
            int add;
            if (label.text == null) continue;
            int n = add = label.additionalText != null ? 2 : 1;
            if (label.xPositionOfBox >= (double)position[places - 2]) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("1. [" + (places - 1) + "[label.xposition = " + label.xPositionOfBox));
                }
                int n2 = places - 1;
                neededPlaces[n2] = neededPlaces[n2] + add;
                continue;
            }
            for (int i = 0; i < places - 2; ++i) {
                if (!(label.xPositionOfBox > (double)position[i]) || !(label.xPositionOfBox <= (double)position[i + 1])) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("2. [" + (i + 1) + "] label.xposition = " + label.xPositionOfBox));
                }
                int n3 = i + 1;
                neededPlaces[n3] = neededPlaces[n3] + add;
                continue block1;
            }
        }
        int ret = 0;
        for (int i = 0; i < neededPlaces.length; ++i) {
            if (neededPlaces[i] <= ret) continue;
            ret = neededPlaces[i];
        }
        return ret;
    }

    private int calcSeparateBoxLabels(IMarkupWriter writer, ArrayList<SeparateBoxLabel> separateBoxLabels, SimpleBoundingBox box) {
        if (log.isDebugEnabled()) {
            for (SeparateBoxLabel boxLabel : separateBoxLabels) {
                log.debug((Object)("SeparateBoxLabel: " + boxLabel.text));
            }
        }
        int STEP_HEIGHT = 13;
        int STEP_WIDTH = 25;
        int maxAmountOfNeededPlaces = this.findMaxNeededPlaces(separateBoxLabels);
        double width = box.getUrx() - box.getLlx();
        double height = box.getUry() - box.getLly() + (double)(maxAmountOfNeededPlaces * 13);
        int canvasColumns = (int)Math.ceil(width / 25.0);
        int canvasRows = (int)Math.floor(height / 13.0);
        double yStartOfCanvas = box.getUry() - height;
        double xStartOfCanvas = box.getLlx();
        int[][] canvas = new int[canvasRows][canvasColumns];
        int highestNodeRow = canvasRows;
        int lastColumnEnd = 0;
        for (SeparateBoxLabel label : separateBoxLabels) {
            double endOfNodeX;
            int columnEnd;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Processing label [" + label.text + "] with urxnode = [" + label.UrxNode + "]"));
            }
            if (!(label.UrxNode > 0.0) || (columnEnd = (int)Math.ceil((endOfNodeX = label.UrxNode - xStartOfCanvas) / 25.0)) == lastColumnEnd) continue;
            double endOfNodeY = label.LlyNode - yStartOfCanvas;
            int rowEnd = (int)Math.floor(endOfNodeY / 13.0);
            if (rowEnd < highestNodeRow) {
                highestNodeRow = rowEnd;
            }
            if (columnEnd > canvasRows) {
                columnEnd = canvasRows;
            }
            for (int row = rowEnd; row < canvasRows; ++row) {
                for (int column = lastColumnEnd; column < columnEnd; ++column) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("First loop: Canvas [" + row + "][" + column + "] = 1 for label [" + label.text + "]"));
                    }
                    canvas[row][column] = 1;
                }
            }
            lastColumnEnd = columnEnd;
        }
        int highestSeparateLabelRow = canvasRows;
        for (int i = separateBoxLabels.size() - 1; i >= 0; --i) {
            int j;
            int k;
            int rowStart;
            int columnStart;
            int columnEnd;
            double lengthOfText;
            SeparateBoxLabel label = separateBoxLabels.get(i);
            if (label.text == null) continue;
            try {
                lengthOfText = this.renderer.getTextWidth("Verdana", label.text) * 8.0;
            }
            catch (BatikSvgException e) {
                throw new ActionException("error getting text width", e);
            }
            label.lengthOfText = lengthOfText;
            if (label.boxName != null) {
                lengthOfText += 12.0;
            }
            if ((columnEnd = (int)Math.ceil((label.xPositionOfBox + lengthOfText - xStartOfCanvas) / 25.0)) > canvasColumns - 1) {
                columnEnd = canvasColumns - 1;
                columnStart = columnEnd - (int)Math.ceil(lengthOfText / 25.0);
            } else {
                columnStart = (int)Math.max(0.0, Math.ceil((label.xPositionOfBox - xStartOfCanvas) / 25.0));
            }
            int rowEnd = rowStart = (int)Math.ceil((label.yPositionOfBox - yStartOfCanvas) / 13.0);
            if (label.additionalText == null) {
                if (rowStart >= canvasRows - 1) {
                    rowEnd = rowStart = canvasRows - 1;
                }
            } else if (++rowEnd >= canvasRows - 1) {
                rowEnd = canvasRows - 1;
                rowStart = rowEnd - 1;
            }
            boolean notFree = true;
            while (notFree) {
                notFree = false;
                if (rowStart < 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Fix this bug");
                    }
                    rowStart = 0;
                    break;
                }
                block8: for (k = rowStart; k <= rowEnd; ++k) {
                    for (j = columnStart; j <= columnEnd; ++j) {
                        if (canvas[k][j] != 1) continue;
                        notFree = true;
                        --rowStart;
                        --rowEnd;
                        continue block8;
                    }
                }
            }
            if (highestSeparateLabelRow > rowStart) {
                highestSeparateLabelRow = rowStart;
            }
            label.row = rowStart;
            label.column = columnStart;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will place label [" + label.text + "] to row = [" + label.row + "] and column = [" + label.column + "]"));
            }
            for (k = rowStart; k <= rowEnd; ++k) {
                for (j = columnStart; j <= columnEnd; ++j) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Marking canvas [" + k + "][" + j + "] occupied for label = [" + label.text));
                    }
                    canvas[k][j] = 1;
                }
            }
        }
        double rememberLastXPos = 0.0;
        double rememberLastYPos = 0.0;
        int rememberLastAddToBox = 0;
        for (SeparateBoxLabel label : separateBoxLabels) {
            if (label.text == null) continue;
            if (label.xPositionOfBox == rememberLastXPos && rememberLastYPos != label.yPositionOfBox) {
                label.addToXBox = rememberLastAddToBox + 3;
            }
            String ls = "stroke:black; stroke-width:0.5px;";
            double xStart = xStartOfCanvas + (double)(label.column * 25);
            double yStart = yStartOfCanvas + (double)((label.row + 1) * 13);
            int placeForNode = 2;
            if (label.boxName != null) {
                placeForNode = 12;
                SvgRenderKit.addUse(writer, label.boxName, "translate(" + xStart + "," + (yStart - 10.0) + ") ");
            }
            if (label.drawCircle) {
                SvgRenderKit.addCircle(writer, label.xPositionOfBox, label.yPositionOfBox, 2.0, null);
            }
            SvgRenderKit.addRec(writer, xStart + (double)placeForNode, yStart - 10.0, label.lengthOfText, 10.0, "stroke:none; fill:white; opacity:0.6", null);
            SvgRenderKit.addText(writer, xStart + (double)placeForNode, yStart, "font-family:verdana; font-size:8px", label.text, null);
            if (label.additionalText != null) {
                SvgRenderKit.addText(writer, xStart, yStart + 13.0 - 3.0, "font-family:verdana; font-size:8px", label.additionalText, null);
            }
            if (label.xPositionOfBox > xStart && label.xPositionOfBox < xStart + (double)placeForNode + label.lengthOfText) {
                SvgRenderKit.addLine(writer, label.xPositionOfBox + (double)label.addToXBox, label.yPositionOfBox, label.xPositionOfBox + (double)label.addToXBox, yStart, ls);
            } else {
                SvgRenderKit.addLine(writer, label.xPositionOfBox + (double)label.addToXBox, yStart - 5.0, xStart + (double)placeForNode + label.lengthOfText < label.xPositionOfBox ? xStart + (double)placeForNode + label.lengthOfText : xStart, yStart - 5.0, ls);
                SvgRenderKit.addLine(writer, label.xPositionOfBox + (double)label.addToXBox, label.yPositionOfBox, label.xPositionOfBox + (double)label.addToXBox, yStart - 5.0, ls);
            }
            if (label.addToXBox > 0) {
                SvgRenderKit.addLine(writer, label.xPositionOfBox, label.yPositionOfBox, label.xPositionOfBox + (double)label.addToXBox, label.yPositionOfBox, ls);
            }
            rememberLastXPos = label.xPositionOfBox;
            rememberLastYPos = label.yPositionOfBox;
            rememberLastAddToBox = label.addToXBox;
        }
        return highestSeparateLabelRow < highestNodeRow ? (highestNodeRow - highestSeparateLabelRow + 1) * 13 : 0;
    }

    private int getVAreaOfNodesToDraw(List<ReviewCycleCellResult> cellResults, int iHeight) {
        int ret = 0;
        for (ReviewCycleCellResult cellResult : cellResults) {
            ArrayList nodeResults = (ArrayList)cellResult.getReviewCycleNodeResultsSortedByPosition(true);
            int emptyNodeId2 = cellResult.getReviewCycleCell().getReviewCycle().getEmptyNodeOption().getId();
            int amount = 0;
            for (ReviewCycleNodeResult nodeResult : nodeResults) {
                if (nodeResult.getReviewCycleResultOption() != null && nodeResult.getReviewCycleResultOption().getId() == emptyNodeId2 || nodeResult.getReviewCycleNode().isFree()) continue;
                ++amount;
            }
            ret += amount;
        }
        return ret * iHeight;
    }

    private void drawBoxDefinition(IMarkupWriter writer) {
        writer.begin("defs");
        SvgRenderKit.addRec(writer, 0.0, 0.0, 10.0, 10.0, lineStyle + " fill:white;", "box");
        writer.begin("symbol");
        writer.attribute("id", "posBox");
        SvgRenderKit.addUse(writer, "#box", null);
        SvgRenderKit.addLine(writer, 2.5, 5.0, 7.5, 5.0, "stroke:green; stroke-width:1px;");
        SvgRenderKit.addLine(writer, 5.0, 2.5, 5.0, 7.5, "stroke:green; stroke-width:1px;");
        writer.end("symbol");
        writer.begin("symbol");
        writer.attribute("id", "negBox");
        SvgRenderKit.addUse(writer, "#box", null);
        SvgRenderKit.addLine(writer, 2.5, 5.0, 7.5, 5.0, "stroke:red; stroke-width:1px;");
        writer.end("symbol");
        writer.begin("symbol");
        writer.attribute("id", "okBox");
        SvgRenderKit.addUse(writer, "#box", null);
        SvgRenderKit.addLine(writer, 7.5, 2.5, 3.8, 7.5, "stroke:green; stroke-width:1px;");
        SvgRenderKit.addLine(writer, 3.8, 7.5, 2.5, 5.0, "stroke:green; stroke-width:1px;");
        writer.end("symbol");
        writer.begin("symbol");
        writer.attribute("id", "cancelBox");
        SvgRenderKit.addUse(writer, "#box", null);
        SvgRenderKit.addLine(writer, 2.5, 2.5, 7.5, 7.5, "stroke:red; stroke-width:1px;");
        SvgRenderKit.addLine(writer, 2.5, 7.5, 7.5, 2.5, "stroke:red; stroke-width:1px;");
        writer.end("symbol");
        writer.begin("symbol");
        writer.attribute("id", "xBox");
        SvgRenderKit.addUse(writer, "#box", null);
        SvgRenderKit.addLine(writer, 2.5, 2.5, 7.5, 7.5, "stroke:blue; stroke-width:1px;");
        SvgRenderKit.addLine(writer, 2.5, 7.5, 7.5, 2.5, "stroke:blue; stroke-width:1px;");
        writer.end("symbol");
        writer.begin("symbol");
        writer.attribute("id", "uploadBox");
        SvgRenderKit.addUse(writer, "#box", null);
        SvgRenderKit.addCircle(writer, 5.0, 5.0, 2.5, "fill:none; stroke:blue; stroke-width:2px;");
        SvgRenderKit.addRec(writer, 3.75, 0.5, 1.2, 4.3349, "fill:white;", null);
        double[] point = new double[]{4.85, 1.3359, 8.15, 1.3349, 4.85, 4.3349, 4.85, 1.3359};
        SvgRenderKit.addPolygon(writer, point, "fill:blue;");
        writer.end("symbol");
        writer.begin("symbol");
        writer.attribute("id", "deletedBox");
        SvgRenderKit.addUse(writer, "#box", null);
        SvgRenderKit.addCircle(writer, 5.0, 5.0, 2.5, "fill:none; stroke:red; stroke-width:2px;");
        SvgRenderKit.addRec(writer, 3.75, 0.5, 1.2, 4.3349, "fill:white;", null);
        double[] point2 = new double[]{4.85, 1.3359, 8.15, 1.3349, 4.85, 4.3349, 4.85, 1.3359};
        SvgRenderKit.addPolygon(writer, point2, "fill:red;");
        writer.end("symbol");
        writer.begin("symbol");
        writer.attribute("id", "firstUploadBox");
        SvgRenderKit.addUse(writer, "#box", null);
        SvgRenderKit.addRec(writer, 4.0, 5.0, 2.0, 3.0, "fill:blue;", null);
        point = new double[]{5.0, 2.0, 8.0, 5.0, 2.0, 5.0, 5.0, 2.0};
        SvgRenderKit.addPolygon(writer, point, "fill:blue;");
        writer.end("symbol");
        writer.begin("symbol");
        writer.attribute("id", "arrow");
        double[] p = new double[]{0.0, 2.5, 0.0, 7.5, 7.5, 5.0, 0.0, 2.5};
        SvgRenderKit.addPolygon(writer, p, "fill:black;");
        writer.end("symbol");
        writer.begin("symbol");
        writer.attribute("id", "stopArrow");
        SvgRenderKit.addUse(writer, "#arrow", null);
        SvgRenderKit.addLine(writer, 8.5, 0.0, 8.5, 10.0, "stroke:black; stroke-width:2px;");
        writer.end("symbol");
        writer.end("defs");
    }

    private Calendar modifyDate(Calendar clone, int value, Integer field) {
        Calendar cal = (Calendar)clone.clone();
        if (field == null) {
            cal.add(5, value);
        } else {
            cal.add(field, value);
        }
        return cal;
    }

    public void setRenderer(BatikSvgRendererOperations renderer) {
        this.renderer = renderer;
    }

    public String getSvgHeaderGWT(SvgDataContainer svgData) {
        double svgWidth = this.width;
        double svgHeight = this.height;
        if (svgData.getBox() != null) {
            svgWidth = svgData.getBox().getUrx() - svgData.getBox().getLlx();
            svgHeight = svgData.getBox().getUry() - svgData.getBox().getLly();
        }
        svgData.setWidth(svgWidth);
        svgData.setHeight(svgHeight);
        return "<?xml version='1.0' encoding='utf-8'?><svg width='" + svgWidth + "' height= '" + svgHeight + "' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='" + svgData.getBox().getLlx() + " " + svgData.getBox().getLly() + " " + (svgWidth + 10.0) + " " + (svgHeight + 10.0) + "'>";
    }

    private class AxisCalculationResult {
        int projectDurationinMonth;
        int projectDurationInDays;
        int projectDurationinWeeks;
        double spacePerTimeUnit;
        int heightofAxis;

        private AxisCalculationResult() {
        }
    }

    class TextWithPosition {
        String text;
        double xStartOfCell;
        double xEndOfCell;
        double x;
        double y;
        String rotate;
        String color;

        TextWithPosition() {
        }
    }

    class SeparateBoxLabel {
        double UrxNode;
        double LlyNode;
        public String additionalText;
        String text;
        double lengthOfText;
        String boxName;
        double xPositionOfBox;
        double yPositionOfBox;
        int addToXBox = 0;
        boolean drawCircle;
        int row;
        int column;

        SeparateBoxLabel() {
        }
    }
}

