/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.order.plott;

import at.cdes.bo.data.cycle.ReviewCyclePosition;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstanceRelease;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstance;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.object.ObjectPlannerImpl;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.order.OrderAddress;
import at.cdes.bo.data.order.OrderAddressExtractorVisitorImpl;
import at.cdes.bo.data.order.plott.PlottOrder;
import at.cdes.bo.data.order.plott.PlottOrderItem;
import at.cdes.bo.data.order.plott.PlottOrderItemTemplate;
import at.cdes.bo.data.order.plott.PlottOrderTemplate;
import at.cdes.bo.data.order.plott.PlottProperties;
import at.cdes.bo.data.order.plott.TemplatePropertyResolver;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.data.project.SubProject;
import at.cdes.db.dao.ObjectPlannerDAO;
import at.cdes.db.dao.OrderDAO;
import at.cdes.db.dao.ProjectParticipationDAO;
import at.cdes.db.dao.ReviewCycleNodeInstanceDAO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class ReviewCyclePlottOrderProjectTemplatePropertyResolver
implements TemplatePropertyResolver,
Serializable {
    private static final long serialVersionUID = 1L;
    private ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO;
    private ObjectPlannerDAO objectPlannerDAO;
    private ProjectParticipationDAO projectParticipationDAO;
    private OrderDAO orderDAO;
    private static Logger logger = Logger.getLogger(ReviewCyclePlottOrderProjectTemplatePropertyResolver.class);

    @Override
    public PlottOrder resolveProperties(DocumentVersion version, PlottOrder order, PlottOrderTemplate template, boolean onlyItems) {
        ObjectPlannerImpl objectPlanner = (ObjectPlannerImpl)version.getDocument().getObjectPlanner();
        ReviewCycleNode node = version.getActualReviewCycleNode();
        SubProject subProject = objectPlanner.getObject().getObjectList().getSubProject();
        ReleasedObjectList releasedObjectList = subProject.getActiveObjectList();
        ReleasedObjectPlanner releasedObjectPlanner = this.objectPlannerDAO.getReleasedObjectPlanner(releasedObjectList.getId(), objectPlanner.getId());
        ReviewCycleNodeInstanceRelease releasedNodeInstance = this.reviewCycleNodeInstanceDAO.getReleased(releasedObjectPlanner.getReviewCycleInstance().getId(), node.getId());
        if (!onlyItems) {
            order.setOrderItems(new HashMap());
            order.setBillingAddress(this.orderDAO.getOrderAddress(template.getBillingAddressId()));
            order.setPlotter(this.projectParticipationDAO.get(template.getPlotterId()).getOrganisation());
            order.setTemplate(template);
            order.setProject(template.getProject());
            order.setComment(template.getComment());
            order.setKindOfDelivery(template.getKindOfDelivery());
        }
        return this.resolveProperties(releasedNodeInstance, version, order, template, releasedObjectPlanner);
    }

    private PlottOrder resolveProperties(ReviewCycleNodeInstanceRelease nodeInstanceRelease, DocumentVersion version, PlottOrder order, PlottOrderTemplate template, ReleasedObjectPlanner releasedObjectPlanner) {
        Collection items = template.getOrderItems().values();
        ReviewCycleCellInstanceRelease cellInstance = (ReviewCycleCellInstanceRelease)nodeInstanceRelease.getReviewCycleCellInstance();
        OrderAddressExtractorVisitorImpl visitor = new OrderAddressExtractorVisitorImpl();
        HashMap<Integer, PlottOrderItem> newItems = new HashMap<Integer, PlottOrderItem>();
        int id = -1;
        for (PlottOrderItemTemplate item : items) {
            ReviewCycleNodeInstance deliveryNodeInstance;
            Integer nodeId = item.getDeliveryAddressId();
            if (nodeId == null || item.isInvalidated() || (deliveryNodeInstance = cellInstance.getNodeInstance(nodeId)) == null) continue;
            if (!deliveryNodeInstance.getReviewCycleNode().isEndNode()) {
                List<ReviewCyclePosition> positions = this.reviewCycleNodeInstanceDAO.getRelevantReviewCyclePositions(deliveryNodeInstance, version);
                ArrayList<Integer> alreadyReceiving = new ArrayList<Integer>();
                for (ReviewCyclePosition position : positions) {
                    ProjectParticipation receiver = position.getProjectParticipation();
                    if (alreadyReceiving.contains(receiver.getId()) || item.isEvaluateMailReceivers() && !receiver.isMailReciever()) continue;
                    alreadyReceiving.add(receiver.getId());
                    PlottOrderItem newItem = new PlottOrderItem();
                    newItem.setDocumentVersion(version);
                    newItem.setOrderContract(order);
                    newItem.setNodeInstanceRelease(nodeInstanceRelease);
                    newItem.setReceiverId(receiver.getId());
                    newItem.setReceiverType(0);
                    newItem.setTemplate(item);
                    OrderAddress address = position.getProjectParticipation().accept(visitor);
                    newItem.setDeliveryAddress(address);
                    newItem.setPlottProperties(new PlottProperties(item.getPlottProperties()));
                    newItem.getPlottProperties().setLlx(version.getLlx());
                    newItem.getPlottProperties().setLly(version.getLly());
                    newItem.getPlottProperties().setUrx(version.getUrx());
                    newItem.getPlottProperties().setUry(version.getUry());
                    newItem.getPlottProperties().setUserUnit(version.getUserUnit());
                    newItems.put(id, newItem);
                    --id;
                }
                continue;
            }
            ProjectParticipation receiver = releasedObjectPlanner.getPlanner();
            PlottOrderItem newItem = new PlottOrderItem();
            newItem.setDocumentVersion(version);
            newItem.setOrderContract(order);
            newItem.setNodeInstanceRelease(nodeInstanceRelease);
            newItem.setReceiverId(receiver.getId());
            newItem.setReceiverType(0);
            newItem.setTemplate(item);
            OrderAddress address = receiver.accept(visitor);
            newItem.setDeliveryAddress(address);
            newItem.setPlottProperties(new PlottProperties(item.getPlottProperties()));
            newItem.getPlottProperties().setLlx(version.getLlx());
            newItem.getPlottProperties().setLly(version.getLly());
            newItem.getPlottProperties().setUrx(version.getUrx());
            newItem.getPlottProperties().setUry(version.getUry());
            newItem.getPlottProperties().setUserUnit(version.getUserUnit());
            newItems.put(id, newItem);
            --id;
        }
        if (newItems.isEmpty()) {
            logger.info((Object)"An error occured while creating a plot order: No valid items could be generated!");
            return null;
        }
        order.setOrderItems(newItems);
        return order;
    }

    public void setObjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    public void setReviewCycleNodeInstanceDAO(ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO) {
        this.reviewCycleNodeInstanceDAO = reviewCycleNodeInstanceDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setOrderDAO(OrderDAO orderDAO) {
        this.orderDAO = orderDAO;
    }

    public ProjectParticipation resolveProjectParticipation(Integer receiverId) {
        return this.projectParticipationDAO.get(receiverId);
    }

    @Override
    public PlottOrderItem resolvePlottOrderItem(Integer orderItemId) {
        if (orderItemId == null) {
            return null;
        }
        return this.orderDAO.getPlottOrderItem(orderItemId);
    }

    @Override
    public String getName() {
        return "ReviewCyclePlotProjectTemplate";
    }
}

