/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.organisation.Organisation;
import at.cdes.db.dao.ConsortiumDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ConsortiumDAOHibernate
extends HibernateDaoSupport
implements ConsortiumDAO {
    @Override
    public Organisation get(Integer id) {
        return (Organisation)this.getSession().load(Organisation.class, (Serializable)id);
    }

    @Override
    public List getAll(Integer networkId, Integer networkMemberId, String filter) {
        Criteria crit = this.getSession().createCriteria(Organisation.class).add((Criterion)Restrictions.eq((String)"consortiumHead", (Object)true));
        if (filter != null) {
            crit.add((Criterion)Restrictions.like((String)"name", (Object)(filter + "%")));
        }
        if (networkId != null) {
            crit.createCriteria("networks").add(Restrictions.idEq((Object)networkId));
        } else if (networkMemberId != null) {
            crit.createCriteria("networks").createCriteria("organisations").add(Restrictions.idEq((Object)networkMemberId));
        }
        return crit.list();
    }

    @Override
    public Organisation save(Organisation cons) {
        Integer id = (Integer)this.getSession().save((Object)cons);
        return this.get(id);
    }

    @Override
    public void delete(Organisation cons) {
        cons.setNetworks(null);
        this.getSession().merge((Object)cons);
        this.getSession().delete((Object)cons);
    }

    @Override
    public Organisation merge(Organisation cons) {
        ArrayList networks = new ArrayList(cons.getNetworks().values());
        cons = (Organisation)this.getSession().merge((Object)cons);
        for (Network net : networks) {
            cons.getNetworks().put(net.getId(), net);
        }
        this.getSession().update((Object)cons);
        return cons;
    }

    @Override
    public List<Organisation> getOtherNetworksAllConsortiums(Integer networkId, String filter) {
        Criteria crit = this.getSession().createCriteria(Organisation.class).add((Criterion)Restrictions.eq((String)"consortiumHead", (Object)true));
        if (filter != null) {
            crit.add((Criterion)Restrictions.like((String)"name", (Object)(filter + "%")));
        }
        if (networkId != null) {
            crit.createCriteria("networks").add(Restrictions.not((Criterion)Restrictions.idEq((Object)networkId)));
        }
        crit.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return crit.list();
    }

    @Override
    public Organisation update(Organisation cons) {
        this.getSession().update((Object)cons);
        return (Organisation)this.getSession().get(Organisation.class, (Serializable)cons.getId());
    }
}

