/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.mail.EMail;
import at.cdes.bo.data.mail.EMailSnippet;
import at.cdes.bo.data.mail.FutureEMail;
import at.cdes.bo.data.mail.NodeListenerEMailSnippet;
import at.cdes.bo.data.mail.StatusEMailSnippet;
import at.cdes.bo.data.mail.TaskEMailSnippet;
import at.cdes.bo.data.mail.TaskFutureEMail;
import at.cdes.db.dao.EMailDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class EMailDAOHibernate
extends HibernateDaoSupport
implements EMailDAO {
    @Override
    public EMail get(Integer id) {
        return (EMail)this.getSession().load(EMail.class, (Serializable)id);
    }

    @Override
    public EMail insert(EMail mail) {
        return this.get((Integer)this.getSession().save((Object)mail));
    }

    @Override
    public EMail update(EMail mail) {
        this.getSession().merge((Object)mail);
        return mail;
    }

    @Override
    public void delete(EMail mail) {
        this.getSession().delete((Object)mail);
    }

    @Override
    public List getNextToSend() {
        return this.getSession().createCriteria(EMail.class).add((Criterion)Restrictions.eq((String)"status", (Object)2)).addOrder(Order.asc((String)"id")).list();
    }

    @Override
    public EMailSnippet insertSnippet(EMailSnippet s) {
        return this.getSnippet((Integer)this.getSession().save((Object)s));
    }

    @Override
    public EMailSnippet getSnippet(Integer id) {
        return (EMailSnippet)this.getSession().load(EMailSnippet.class, (Serializable)id);
    }

    @Override
    public EMailSnippet updateSnippet(EMailSnippet s) {
        this.getSession().merge((Object)s);
        return s;
    }

    @Override
    public void deleteSnippet(EMailSnippet s) {
        this.getSession().delete((Object)s);
    }

    @Override
    public List getSnippetsToSend(Calendar now) {
        return this.getSession().createCriteria(EMailSnippet.class).add((Criterion)Restrictions.lt((String)"sendTime", (Object)now)).addOrder(Order.asc((String)"organisationPersonId")).list();
    }

    @Override
    public Collection<TaskEMailSnippet> getSnippetsOfTask(Integer taskId) {
        return this.getSession().createCriteria(TaskEMailSnippet.class).createCriteria("task").add(Restrictions.idEq((Object)taskId)).list();
    }

    @Override
    public List getEmails(String receiverAddress, Integer status, Date from, Date to, Integer limit, Date createdFrom, Date createdTo, String sortColumn, boolean ascending) {
        Criteria crit = this.getSession().createCriteria(EMail.class);
        if (receiverAddress != null && receiverAddress.length() > 0) {
            if (receiverAddress.contains(" ")) {
                String[] addresses = receiverAddress.split(" ");
                for (int i = 0; i < addresses.length; ++i) {
                    addresses[i] = "%" + addresses[i] + "%";
                }
                Disjunction disjunction = Restrictions.disjunction();
                for (int i = 0; i < addresses.length; ++i) {
                    disjunction.add((Criterion)Restrictions.like((String)"toAdr", (Object)addresses[i]));
                }
                crit.add((Criterion)disjunction);
            } else {
                crit.add((Criterion)Restrictions.like((String)"toAdr", (Object)('%' + receiverAddress + '%')));
            }
        }
        if (status != null) {
            crit.add((Criterion)Restrictions.like((String)"status", (Object)status));
        }
        Calendar cal = Calendar.getInstance();
        if (from != null) {
            cal.setTime(from);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            crit.add((Criterion)Expression.ge((String)"sentAt", (Object)cal.getTime()));
        }
        if (to != null) {
            cal.setTime(to);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            crit.add((Criterion)Expression.le((String)"sentAt", (Object)cal.getTime()));
        }
        if (createdFrom != null) {
            cal.setTime(createdFrom);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            crit.add((Criterion)Expression.ge((String)"created", (Object)cal.getTime()));
        }
        if (createdTo != null) {
            cal.setTime(createdTo);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 999);
            crit.add((Criterion)Expression.le((String)"created", (Object)cal.getTime()));
        }
        if (sortColumn != null && sortColumn.length() > 0) {
            if (sortColumn.equals("receiver")) {
                if (ascending) {
                    crit.createCriteria("OrganisationPerson").createCriteria("person").addOrder(Order.asc((String)"givenName"));
                } else {
                    crit.createCriteria("OrganisationPerson").createCriteria("person").addOrder(Order.desc((String)"givenName"));
                }
            } else if (sortColumn.equals("recAdr")) {
                if (ascending) {
                    crit.addOrder(Order.asc((String)"toAdr"));
                } else {
                    crit.addOrder(Order.desc((String)"toAdr"));
                }
            } else if (sortColumn.equals("status")) {
                if (ascending) {
                    crit.addOrder(Order.asc((String)"status"));
                } else {
                    crit.addOrder(Order.desc((String)"status"));
                }
            } else if (sortColumn.equals("sentAt")) {
                if (ascending) {
                    crit.addOrder(Order.asc((String)"sentAt"));
                } else {
                    crit.addOrder(Order.desc((String)"sentAt"));
                }
            } else if (sortColumn.equals("created")) {
                if (ascending) {
                    crit.addOrder(Order.asc((String)"created"));
                } else {
                    crit.addOrder(Order.desc((String)"created"));
                }
            } else if (sortColumn.equals("subject")) {
                if (ascending) {
                    crit.addOrder(Order.asc((String)"subject"));
                } else {
                    crit.addOrder(Order.desc((String)"subject"));
                }
            }
        }
        if (limit != null) {
            crit.setMaxResults(limit.intValue());
        }
        return crit.list();
    }

    @Override
    public void deleteTaskEmailSnippet(TaskEMailSnippet s) {
        this.getSession().delete((Object)s);
    }

    @Override
    public void deleteFutureEMail(FutureEMail f) {
        this.getSession().delete((Object)((TaskFutureEMail)f));
    }

    @Override
    public FutureEMail getFutureEMail(Integer id) {
        return (FutureEMail)this.getSession().load(TaskFutureEMail.class, (Serializable)id);
    }

    @Override
    public Collection<TaskFutureEMail> getFutureMailsOfTask(Integer taskId) {
        return this.getSession().createCriteria(TaskFutureEMail.class).createCriteria("task").add(Restrictions.idEq((Object)taskId)).list();
    }

    @Override
    public Collection<TaskFutureEMail> getFutureMailsOfProjectParticipation(Integer projectParticipationId) {
        return this.getSession().createCriteria(TaskFutureEMail.class).add((Criterion)Restrictions.eq((String)"participationId", (Object)projectParticipationId)).list();
    }

    @Override
    public List<FutureEMail> getFutureMailsToSend(Calendar now) {
        return this.getSession().createCriteria(TaskFutureEMail.class).add((Criterion)Restrictions.le((String)"sendTime", (Object)now)).list();
    }

    @Override
    public FutureEMail insertFutureEMail(FutureEMail f) {
        return this.getFutureEMail((Integer)this.getSession().save((Object)((TaskFutureEMail)f)));
    }

    @Override
    public FutureEMail updateFutureEMail(FutureEMail f) {
        this.getSession().merge((Object)f);
        return this.getFutureEMail(f.getId());
    }

    @Override
    public List<EMail> getAllEmailsForOrganisationPerson(Integer orgPersonId) {
        return this.getSession().createCriteria(EMail.class).createCriteria("OrganisationPerson").add(Restrictions.idEq((Object)orgPersonId)).list();
    }

    @Override
    public List<StatusEMailSnippet> getStatusEmailSnippets(Integer documentVersionId) {
        return this.getSession().createCriteria(StatusEMailSnippet.class).createCriteria("documentVersion").add(Restrictions.idEq((Object)documentVersionId)).list();
    }

    @Override
    public List<NodeListenerEMailSnippet> getNodeListenerEmailSnippets(Integer documentVersionId) {
        return this.getSession().createCriteria(NodeListenerEMailSnippet.class).createCriteria("documentVersion").add(Restrictions.idEq((Object)documentVersionId)).list();
    }

    @Override
    public List<StatusEMailSnippet> getAllStatusEmailSnippetsForSubProject(Integer subProjectId) {
        return this.getSession().createCriteria(StatusEMailSnippet.class).createCriteria("documentVersion").createCriteria("document").createCriteria("documentList").createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId)).list();
    }

    @Override
    public List<NodeListenerEMailSnippet> getAllNodeListenerEmailSnippetsForSubProject(Integer subProjectId) {
        return this.getSession().createCriteria(NodeListenerEMailSnippet.class).createCriteria("documentVersion").createCriteria("document").createCriteria("documentList").createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId)).list();
    }
}

