/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.label.LabelContent;
import at.cdes.bo.file.FileFinder;
import at.cdes.db.dao.LabelDAO;
import at.cdes.db.dao.NetworkDAO;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.exception.FileHandleException;
import at.cdes.util.ImplContextHelper;
import java.io.File;
import org.clazzes.util.http.osgi.DefaultHttpContext;

public class LabelMimeSource
implements VisitlessMimeSource {
    private FileFinder fileFinder;
    private NetworkDAO networkDAO;
    private LabelDAO labelDAO;

    public String getActionName() {
        return "labelsOverview";
    }

    public boolean isEditable() {
        return false;
    }

    public Object getDestinationObject(Object[] parameters) {
        return ImplContextHelper.getContextNetworkId() != null ? this.networkDAO.get(ImplContextHelper.getContextNetworkId()) : null;
    }

    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        String unique;
        File file;
        Integer id = (Integer)parameters[0];
        LabelContent label = this.labelDAO.getLabelContent(id);
        try {
            file = this.fileFinder.findFile(label.getOrigFileName(), CDESFileRepository.LABELREPOSITORY);
            unique = this.fileFinder.makeUniqueName(label.getOrigFileName(), CDESFileRepository.LABELREPOSITORY);
        }
        catch (FileHandleException e) {
            throw new IOError("Invalid file handle when fetching the label", (Throwable)e);
        }
        return new FileMimeInputStream(file, unique, label.getName() + "." + label.getOrigFileType(), DefaultHttpContext.getInstance().getMimeType(label.getOrigFileName()));
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setLabelDAO(LabelDAO labelDAO) {
        this.labelDAO = labelDAO;
    }
}

