/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.order.orig.OriginalDocumentOrder;
import at.cdes.bo.data.order.orig.OriginalDocumentOrderItem;
import at.cdes.bo.file.FileFinder;
import at.cdes.db.dao.OrderDAO;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.exception.FileHandleException;
import at.cdes.util.ImplContextHelper;
import java.io.File;
import org.clazzes.util.http.osgi.DefaultHttpContext;
import org.clazzes.util.io.IOUtil;

public class OriginalDocumentMimeSource
implements VisitlessMimeSource {
    private OrderDAO orderDAO;
    private ProjectDAO projectDAO;
    private FileFinder fileFinder;

    public String getActionName() {
        return "downloadDocumentVersion";
    }

    public boolean isEditable() {
        return false;
    }

    public Object getDestinationObject(Object[] parameters) {
        return ImplContextHelper.getContextProjectId() != null ? this.projectDAO.get(ImplContextHelper.getContextProjectId()) : null;
    }

    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        String unique;
        File file;
        Integer id = (Integer)parameters[0];
        OriginalDocumentOrder order = this.orderDAO.getOriginalDocumentOrder(id);
        try {
            file = this.fileFinder.findFile(order.getFileName(), CDESFileRepository.ORIGINALDOCUMENTSREPOSITORY);
            unique = this.fileFinder.makeUniqueName(order.getFileName(), CDESFileRepository.ORIGINALDOCUMENTSREPOSITORY);
        }
        catch (FileHandleException e) {
            throw new IOError("Invalid file handle when fetching the documentversion", (Throwable)e);
        }
        OriginalDocumentOrderItem item = (OriginalDocumentOrderItem)order.getOrderItems().values().iterator().next();
        String fileType = IOUtil.getFileExtension((String)order.getFileName());
        DocumentVersion dv = item.getDocumentVersion();
        return new FileMimeInputStream(file, unique, dv.getName() + "." + fileType, DefaultHttpContext.getInstance().getMimeType(order.getFileName()));
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setOrderDAO(OrderDAO orderDAO) {
        this.orderDAO = orderDAO;
    }
}

