/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.object;

import at.cdes.bo.data.object.CDESObject;
import at.cdes.bo.data.object.ObjectList;
import at.cdes.bo.data.object.ObjectPlanner;
import at.cdes.bo.data.object.ObjectPlannerImpl;
import at.cdes.bo.data.object.ObjectType;
import at.cdes.bo.data.person.OrganisationPerson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class CDESObjectImpl
implements CDESObject {
    static final long serialVersionUID = 1L;
    public static final int STATUS_UNCHANGED = 0;
    public static final int STATUS_CHANGED = 1;
    public static final int STATUS_NEW = 2;
    private Integer id;
    private Date modifiedDate;
    private String codeWithoutType;
    private float stretchKmTo;
    private float stretchKmFrom;
    private boolean inactive;
    private String name;
    private String comment;
    private OrganisationPerson modifiedBy;
    private int modified;
    private ObjectList objectList;
    private Map releasedVersions;
    private Map objectPlanners;
    private Map inactivatedObjectPlanners;
    private ObjectType objectType;
    private CDESObjectImpl asBuiltReference;
    private boolean readOnly;

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    @Override
    public String getKms() {
        return String.format(Locale.US, "%.3f", Float.valueOf(this.stretchKmFrom)) + " - " + String.format(Locale.US, "%.3f", Float.valueOf(this.stretchKmTo));
    }

    @Override
    public String getPlannerReviewCycleString() {
        String res = "";
        Collection objectPlanners = this.getObjectPlanners().values();
        for (ObjectPlanner objectPlanner : objectPlanners) {
            res = res + objectPlanner.getCode() + " " + objectPlanner.getArea() + " ";
            res = res + objectPlanner.getReviewCycleInstance().getName() + " ";
            res = res + objectPlanner.getPlanner().getMainParticipant().getOrganisationPerson().getOrganisation().getName() + " ";
            res = res + objectPlanner.getPlanner().getMainParticipant().getOrganisationPerson().getPerson().getCommonName() + " ";
        }
        return res;
    }

    @Override
    public String getCode() {
        if (this.objectType != null) {
            return this.codeWithoutType + this.objectType.getCode();
        }
        return this.codeWithoutType;
    }

    @Override
    public String getCodeWithoutType() {
        return this.codeWithoutType;
    }

    @Override
    public void setCodeWithoutType(String code) {
        this.codeWithoutType = code;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public boolean isInactive() {
        return this.inactive;
    }

    @Override
    public void setInactive(boolean inactive) {
        this.inactive = inactive;
    }

    @Override
    public int getModified() {
        return this.modified;
    }

    @Override
    public void setModified(int modified) {
        this.modified = modified;
    }

    public OrganisationPerson getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(OrganisationPerson modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ObjectList getObjectList() {
        return this.objectList;
    }

    @Override
    public void setObjectList(ObjectList objectList) {
        this.objectList = objectList;
    }

    @Override
    public float getStretchKmFrom() {
        return this.stretchKmFrom;
    }

    @Override
    public void setStretchKmFrom(float stretchKmFrom) {
        this.stretchKmFrom = stretchKmFrom;
    }

    @Override
    public float getStretchKmTo() {
        return this.stretchKmTo;
    }

    @Override
    public void setStretchKmTo(float stretchKmTo) {
        this.stretchKmTo = stretchKmTo;
    }

    public Map getReleasedVersions() {
        return this.releasedVersions;
    }

    public void setReleasedVersions(Map releasedVersions) {
        this.releasedVersions = releasedVersions;
    }

    @Override
    public Map getObjectPlanners() {
        return this.objectPlanners;
    }

    @Override
    public void setObjectPlanners(Map objectPlanners) {
        this.objectPlanners = objectPlanners;
    }

    public Map getInactivatedObjectPlanners() {
        return this.inactivatedObjectPlanners;
    }

    public void setInactivatedObjectPlanners(Map inactivatedObjectPlanners) {
        this.inactivatedObjectPlanners = inactivatedObjectPlanners;
    }

    public Collection<ObjectPlannerImpl> getAllObjectPlanners() {
        ArrayList<ObjectPlannerImpl> ret = new ArrayList<ObjectPlannerImpl>();
        ret.addAll(this.getObjectPlanners().values());
        ret.addAll(this.getInactivatedObjectPlanners().values());
        return ret;
    }

    public void setAsBuiltReference(CDESObjectImpl asBuiltReference) {
        this.asBuiltReference = asBuiltReference;
    }

    public CDESObjectImpl getAsBuiltReference() {
        return this.asBuiltReference;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!CDESObjectImpl.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        CDESObjectImpl other = (CDESObjectImpl)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

