/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.api.dto.PlanDeliverSearchModel;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentDateHistoryPart;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.DocumentType;
import at.cdes.bo.data.document.ReleasedDocument;
import at.cdes.bo.data.search.ReviewCycleStatusSearch;
import at.cdes.bo.search.ReviewCycleStatusSearchInterpreter;
import at.cdes.controller.helper.SearchHelper;
import at.cdes.db.dao.DocumentDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;
import org.xnap.commons.i18n.I18n;

public class DocumentDAOHibernate
extends HibernateDaoSupport
implements DocumentDAO {
    static Logger logger = Logger.getLogger(DocumentDAOHibernate.class);
    private ReviewCycleStatusSearchInterpreter reviewCycleStatusSearchInterpreter = null;

    @Override
    public DocumentImpl get(Integer id) {
        return (DocumentImpl)this.getSession().load(DocumentImpl.class, (Serializable)id);
    }

    @Override
    public DocumentImpl save(DocumentImpl document) {
        return this.get((Integer)this.getSession().save((Object)document));
    }

    @Override
    public DocumentImpl update(DocumentImpl document) {
        this.getSession().merge((Object)document);
        return document;
    }

    @Override
    public void delete(DocumentImpl document) {
        this.getSession().delete((Object)document);
    }

    @Override
    public ReleasedDocument getReleased(Integer id) {
        return (ReleasedDocument)this.getSession().load(ReleasedDocument.class, (Serializable)id);
    }

    @Override
    public ReleasedDocument save(ReleasedDocument document) {
        return this.getReleased((Integer)this.getSession().save((Object)document));
    }

    @Override
    public ReleasedDocument update(ReleasedDocument document) {
        this.getSession().merge((Object)document);
        return document;
    }

    @Override
    public boolean isDocumentReleased(Integer docId) {
        Criteria crit = this.getSession().createCriteria(ReleasedDocument.class);
        crit.createCriteria("document").add(Restrictions.idEq((Object)docId));
        return !crit.list().isEmpty();
    }

    @Override
    public List getAllReleased(Integer documentListId) {
        Criteria crit = this.getSession().createCriteria(ReleasedDocument.class);
        crit.createCriteria("documentList").add(Restrictions.idEq((Object)documentListId));
        return crit.list();
    }

    @Override
    public List getReleasedPlanDeliverCataloguePart(Integer objectPlannerId, Integer documentListId, PlanDeliverSearchModel pdcSearchModel) {
        Timestamp timeStamp;
        List<String> searchedNames;
        List<String> searchedNumbers;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Criteria crit = this.getSession().createCriteria(ReleasedDocument.class);
        if (pdcSearchModel != null && pdcSearchModel.getDocumentNumber() != null && pdcSearchModel.getDocumentNumber().length() > 0 && (searchedNumbers = SearchHelper.extractAndConvertSearchTokens(pdcSearchModel.getDocumentNumber())).size() > 0) {
            Disjunction numbersCriterion = Restrictions.disjunction();
            for (String searchedNumber : searchedNumbers) {
                numbersCriterion.add((Criterion)Restrictions.like((String)"name", (Object)searchedNumber));
            }
            crit.add((Criterion)numbersCriterion);
        }
        if (pdcSearchModel != null && pdcSearchModel.getDocumentName() != null && pdcSearchModel.getDocumentName().length() > 0 && (searchedNames = SearchHelper.extractAndConvertSearchTokens(pdcSearchModel.getDocumentName())).size() > 0) {
            Disjunction namesCriterion = Restrictions.disjunction();
            for (String searchedName : searchedNames) {
                namesCriterion.add((Criterion)Restrictions.like((String)"content", (Object)searchedName));
            }
            crit.add((Criterion)namesCriterion);
        }
        if (pdcSearchModel != null && pdcSearchModel.getDocumentVersionFrom() != null) {
            long utcMillis = (long)(pdcSearchModel.getDocumentVersionFrom() * 1000.0);
            timeStamp = new Timestamp(utcMillis);
            Calendar uploadedFrom = Calendar.getInstance();
            uploadedFrom.setTime(timeStamp);
            uploadedFrom.set(11, 0);
            uploadedFrom.set(12, 0);
            uploadedFrom.set(13, 0);
            crit.add((Criterion)Restrictions.or((Criterion)Restrictions.ge((String)"startDate", (Object)uploadedFrom.getTime()), (Criterion)Restrictions.ge((String)"endDate", (Object)uploadedFrom.getTime())));
        }
        if (pdcSearchModel != null && pdcSearchModel.getDocumentVersionTo() != null) {
            long utcMillis = (long)(pdcSearchModel.getDocumentVersionTo() * 1000.0);
            timeStamp = new Timestamp(utcMillis);
            Calendar uploadedTo = Calendar.getInstance();
            uploadedTo.setTime(timeStamp);
            uploadedTo.set(11, 23);
            uploadedTo.set(12, 59);
            uploadedTo.set(13, 59);
            crit.add((Criterion)Restrictions.or((Criterion)Restrictions.le((String)"startDate", (Object)uploadedTo.getTime()), (Criterion)Restrictions.le((String)"endDate", (Object)uploadedTo.getTime())));
        }
        crit.createCriteria("documentList").add(Restrictions.idEq((Object)documentListId));
        crit.createCriteria("objectPlanner").add(Restrictions.idEq((Object)objectPlannerId));
        return crit.list();
    }

    @Override
    public List getUnReleasedPlanDeliverCataloguePart(Integer objectPlannerId, Integer documentListId, PlanDeliverSearchModel pdcSearchModel) {
        Timestamp timeStamp;
        List<String> searchedNames;
        List<String> searchedNumbers;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Criteria crit = this.getSession().createCriteria(DocumentImpl.class);
        if (pdcSearchModel != null && pdcSearchModel.getDocumentNumber() != null && pdcSearchModel.getDocumentNumber().length() > 0 && (searchedNumbers = SearchHelper.extractAndConvertSearchTokens(pdcSearchModel.getDocumentNumber())).size() > 0) {
            Disjunction numbersCriterion = Restrictions.disjunction();
            for (String searchedNumber : searchedNumbers) {
                numbersCriterion.add((Criterion)Restrictions.like((String)"name", (Object)searchedNumber));
            }
            crit.add((Criterion)numbersCriterion);
        }
        if (pdcSearchModel != null && pdcSearchModel.getDocumentName() != null && pdcSearchModel.getDocumentName().length() > 0 && (searchedNames = SearchHelper.extractAndConvertSearchTokens(pdcSearchModel.getDocumentName())).size() > 0) {
            Disjunction namesCriterion = Restrictions.disjunction();
            for (String searchedName : searchedNames) {
                namesCriterion.add((Criterion)Restrictions.like((String)"content", (Object)searchedName));
            }
            crit.add((Criterion)namesCriterion);
        }
        if (pdcSearchModel != null && pdcSearchModel.getDocumentVersionFrom() != null) {
            long utcMillis = (long)(pdcSearchModel.getDocumentVersionFrom() * 1000.0);
            timeStamp = new Timestamp(utcMillis);
            Calendar uploadedFrom = Calendar.getInstance();
            uploadedFrom.setTime(timeStamp);
            uploadedFrom.set(11, 0);
            uploadedFrom.set(12, 0);
            uploadedFrom.set(13, 0);
            crit.add((Criterion)Restrictions.ge((String)"startDate", (Object)uploadedFrom.getTime()));
        }
        if (pdcSearchModel != null && pdcSearchModel.getDocumentVersionTo() != null) {
            long utcMillis = (long)(pdcSearchModel.getDocumentVersionTo() * 1000.0);
            timeStamp = new Timestamp(utcMillis);
            Calendar uploadedTo = Calendar.getInstance();
            uploadedTo.setTime(timeStamp);
            uploadedTo.set(11, 23);
            uploadedTo.set(12, 59);
            uploadedTo.set(13, 59);
            crit.add((Criterion)Restrictions.le((String)"endDate", (Object)uploadedTo.getTime()));
        }
        crit.createCriteria("documentList").add(Restrictions.idEq((Object)documentListId));
        crit.createCriteria("objectPlanner").add(Restrictions.idEq((Object)objectPlannerId));
        crit.add((Criterion)Restrictions.eq((String)"invalidated", (Object)false));
        return crit.list();
    }

    @Override
    public List getUploadPossibilties(Integer id, int filter) {
        switch (filter) {
            case 2: {
                return this.getSession().createCriteria(DocumentImpl.class).add((Criterion)Restrictions.eq((String)"invalidated", (Object)false)).createCriteria("objectPlanner").add(Restrictions.idEq((Object)id)).list();
            }
            case 1: {
                return this.getSession().createCriteria(DocumentImpl.class).add((Criterion)Restrictions.eq((String)"invalidated", (Object)false)).createCriteria("objectPlanner").createCriteria("object").add(Restrictions.idEq((Object)id)).list();
            }
            case 0: {
                return this.getSession().createCriteria(DocumentImpl.class).add((Criterion)Restrictions.eq((String)"invalidated", (Object)false)).createCriteria("documentList").createCriteria("subProject").add(Restrictions.idEq((Object)id)).list();
            }
        }
        return null;
    }

    @Override
    public ReleasedDocument getReleased(Integer unreleasedDocumentId, Integer releasedDocumentListId) {
        if (releasedDocumentListId == null) {
            return null;
        }
        Criteria crit = this.getSession().createCriteria(ReleasedDocument.class);
        crit.createCriteria("document").add(Restrictions.idEq((Object)unreleasedDocumentId));
        crit.createCriteria("documentList").add(Restrictions.idEq((Object)releasedDocumentListId));
        return (ReleasedDocument)crit.uniqueResult();
    }

    @Override
    public List getUploaded(Integer id, int filter) {
        Criteria crit = this.getSession().createCriteria(DocumentImpl.class);
        crit.add((Criterion)Restrictions.eq((String)"invalidated", (Object)false));
        switch (filter) {
            case 2: {
                return crit.createCriteria("objectPlanner").add(Restrictions.idEq((Object)id)).list();
            }
            case 1: {
                return crit.createCriteria("objectPlanner").createCriteria("object").add(Restrictions.idEq((Object)id)).list();
            }
            case 0: {
                return crit.createCriteria("documentList").createCriteria("subProject").add(Restrictions.idEq((Object)id)).list();
            }
        }
        return null;
    }

    @Override
    public List getCompactReviewStatus(Integer activeObjectListId, Integer activeDocumentListId, ReviewCycleStatusSearch search, I18n i18n, String hibernateDialect, Integer subProjectId) {
        if (activeObjectListId == null) {
            return new ArrayList();
        }
        boolean evalDelay = search.getDaysOfDelay() > 0;
        StringBuffer query = new StringBuffer();
        query.append("SELECT d.id AS documentId, d.name AS documentName, d.content AS documentContent, d.number AS documentNumber, d.startDate AS documentStartDate, d.endDate AS documentEndDate, v.id AS dvId, v.name AS dvName, v.uploaded AS uploadDate, v.status AS dvStatus, rop.code AS opRelCode, rop.area AS opRelName, op.code AS opCode, op.area AS opName, rci.name AS rciName, rcirel.name AS rciRelName, pp.id AS ppId, rcn.name AS activeNodeName, rcc.name AS activeCellName, rcnres.arrivalDate AS nodeResultArrivalDate");
        if (evalDelay) {
            query.append(", rcnirel.duration AS nodeDuration, rccirel.id AS reviewCycleCellInstanceReleaseId, rcnirel.id AS reviewCycleNodeInstanceReleaseId");
        }
        query.append(" FROM document d");
        if (hibernateDialect != null && hibernateDialect.equals("org.hibernate.dialect.SQLServerDialect")) {
            query.append(" LEFT JOIN document_version v ON v.id = (SELECT TOP 1 v2.id FROM document_version v2 WHERE v2.document_id = d.id ORDER BY v2.uploaded DESC)");
        } else {
            query.append(" LEFT JOIN document_version v ON v.id = (SELECT v2.id FROM document_version v2 WHERE v2.document_id = d.id ORDER BY v2.uploaded DESC LIMIT 1)");
        }
        query.append(" LEFT JOIN document_release rd ON rd.document_id=d.id AND rd.document_list_id=" + activeDocumentListId);
        query.append(" JOIN object_planner op ON d.object_planner_id=op.id");
        query.append(" JOIN object o ON op.object_id = o.id");
        query.append(" JOIN object_list ol ON ol.id = o.object_list_id AND ol.sub_project_id=" + subProjectId);
        query.append(" LEFT JOIN object_release ro ON ro.object_list_release_id=" + activeObjectListId + " AND ro.object_id=op.object_id");
        query.append(" LEFT JOIN object_planner_release rop ON rop.object_id=ro.id AND rop.object_planner_id=op.id");
        query.append(" LEFT JOIN review_cycle_instance rci ON rci.id=op.review_cycle_instance_id");
        query.append(" LEFT JOIN review_cycle_instance_released rcirel ON rcirel.review_cycle_instance_id=rci.id AND rcirel.object_list_id=" + activeObjectListId);
        query.append(" LEFT JOIN review_cycle_node_instance rcni ON rcni.id=v.active_node_instance_id");
        query.append(" LEFT JOIN review_cycle_node rcn ON rcn.id=rcni.review_cycle_node_id");
        query.append(" LEFT JOIN review_cycle_cell rcc ON rcc.id=rcn.review_cycle_cell_id");
        query.append(" LEFT JOIN project_participation pp ON pp.id=rop.planner_id");
        query.append(" LEFT JOIN review_cycle_node_result rcnres ON rcnres.document_version_id=v.id AND rcnres.review_cycle_node_id=rcn.id");
        if (evalDelay) {
            query.append(" LEFT JOIN review_cycle_cell_instance_released rccirel ON rccirel.review_cycle_instance_id=rcirel.id AND rccirel.review_cycle_cell_id=rcc.id");
            query.append(" LEFT JOIN review_cycle_node_instance_released rcnirel ON rcnirel.review_cycle_cell_instance_id=rccirel.id AND rcnirel.review_cycle_node_instance_id=rcni.id");
        }
        if (!search.isWithInactivatedObjects()) {
            query.append(" WHERE d.invalidated=0");
        } else {
            query.append(" WHERE d.id IS NOT NULL");
        }
        if (!search.isEmpty()) {
            String searchString;
            int i;
            ArrayList<String> searchSubstrings;
            if (search.getProjectParticipationId() != null && search.getProjectParticipationId() > 0) {
                query.append(" AND pp.id=" + search.getProjectParticipationId());
            }
            if (search.getObjectId() != null && search.getObjectId() > 0) {
                query.append(" AND op.object_id=" + search.getObjectId());
            }
            if (search.getDocumentVersionName() != null && search.getDocumentVersionName().length() > 0) {
                if (this.reviewCycleStatusSearchInterpreter == null) {
                    this.reviewCycleStatusSearchInterpreter = new ReviewCycleStatusSearchInterpreter();
                }
                searchSubstrings = this.reviewCycleStatusSearchInterpreter.getSearchSubstrings(search.getDocumentVersionName());
                query.append(" AND (");
                for (i = 0; i < searchSubstrings.size(); ++i) {
                    searchString = searchSubstrings.get(i);
                    query.append("((rd.id IS NOT NULL AND rd.name like '%" + searchString + "%') OR (rd.id IS NULL AND d.name like '%" + searchString + "%') OR v.name like '%" + searchString + "%')");
                    if (i >= searchSubstrings.size() - 1) continue;
                    query.append(" OR ");
                }
                query.append(")");
            }
            if (search.getDocumentContent() != null && search.getDocumentContent().length() > 0) {
                if (this.reviewCycleStatusSearchInterpreter == null) {
                    this.reviewCycleStatusSearchInterpreter = new ReviewCycleStatusSearchInterpreter();
                }
                searchSubstrings = this.reviewCycleStatusSearchInterpreter.getSearchSubstrings(search.getDocumentContent());
                query.append(" AND (");
                for (i = 0; i < searchSubstrings.size(); ++i) {
                    searchString = searchSubstrings.get(i);
                    query.append("((rd.id IS NOT NULL AND rd.content like '%" + searchString + "%') OR (rd.id IS NULL AND d.content like '%" + searchString + "%'))");
                    if (i >= searchSubstrings.size() - 1) continue;
                    query.append(" OR ");
                }
                query.append(")");
            }
            if (search.getDocumentTypeId() != null) {
                query.append(" AND ((rd.id IS NULL AND d.document_type_id=" + search.getDocumentTypeId() + ") OR rd.document_type_id=" + search.getDocumentTypeId() + ")");
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (search.getUploadedFrom() != null && !search.isUseReleaseDate()) {
                Calendar uploadedFrom = Calendar.getInstance();
                uploadedFrom.setTime(search.getUploadedFrom());
                uploadedFrom.set(11, 0);
                uploadedFrom.set(12, 0);
                uploadedFrom.set(13, 0);
                query.append(" AND v.uploaded>'" + df.format(uploadedFrom.getTime()) + "'");
            }
            if (search.getUploadedTo() != null && !search.isUseReleaseDate()) {
                Calendar uploadedTo = Calendar.getInstance();
                uploadedTo.setTime(search.getUploadedTo());
                uploadedTo.set(11, 23);
                uploadedTo.set(12, 59);
                uploadedTo.set(13, 59);
                query.append(" AND v.uploaded<'" + df.format(uploadedTo.getTime()) + "'");
            }
            if (search.getReviewCycleCellId() != null && search.getReviewCycleCellId2() != null) {
                query.append(" AND (rcc.id=" + search.getReviewCycleCellId() + " OR rcc.id=" + search.getReviewCycleCellId2() + ")");
            } else if (search.getReviewCycleCellId() != null) {
                query.append(" AND rcc.id=" + search.getReviewCycleCellId());
            } else if (search.getReviewCycleCellId2() != null) {
                query.append(" AND rcc.id=" + search.getReviewCycleCellId2());
            }
            if (search.getDocumentStatus() > 0 && !search.isUseReleaseDate()) {
                switch (search.getDocumentStatus()) {
                    case 9: {
                        query.append(" AND (v.id IS NULL OR (v.status!=7 AND v.status!=4 AND v.status!=5)OR v.revised_document_version_id IS NOT NULL)");
                        break;
                    }
                    case 6: {
                        query.append(" AND v.id IS NOT NULL AND v.status!=2 AND v.status!=5 AND v.status!=7 AND v.status!=8 AND v.status!=11");
                        break;
                    }
                    case 11: {
                        query.append(" AND v.id IS NULL");
                        break;
                    }
                    default: {
                        query.append(" AND v.id IS NOT NULL AND v.status=" + search.getDocumentStatus());
                        break;
                    }
                }
            } else if (search.isUseReleaseDate()) {
                query.append(" AND v.id IS NOT NULL and v.status=2");
            }
        }
        query.append(" GROUP BY d.id, d.name, d.content, d.startDate, d.endDate, d.number, v.id, v.name, v.uploaded, v.status , op.code, op.area, rop.code, rop.area, rci.name, rcirel.name, pp.id, rcn.name, rcc.name, rcnres.arrivalDate");
        if (evalDelay) {
            query.append(", rcnirel.duration, rccirel.id, rcnirel.id");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing query: \n\n" + query.toString() + "\n\n"));
        }
        SQLQuery sqlQuery = this.getSession().createSQLQuery(query.toString()).addScalar("documentId", (Type)Hibernate.INTEGER).addScalar("documentName", (Type)Hibernate.STRING).addScalar("documentContent", (Type)Hibernate.STRING).addScalar("documentNumber", (Type)Hibernate.INTEGER).addScalar("documentStartDate", (Type)Hibernate.DATE).addScalar("documentEndDate", (Type)Hibernate.DATE).addScalar("dvId", (Type)Hibernate.INTEGER).addScalar("dvName", (Type)Hibernate.STRING).addScalar("uploadDate", (Type)Hibernate.DATE).addScalar("dvStatus", (Type)Hibernate.INTEGER).addScalar("opCode", (Type)Hibernate.STRING).addScalar("opName", (Type)Hibernate.STRING).addScalar("opRelCode", (Type)Hibernate.STRING).addScalar("opRelName", (Type)Hibernate.STRING).addScalar("rciName", (Type)Hibernate.STRING).addScalar("rciRelName", (Type)Hibernate.STRING).addScalar("ppId", (Type)Hibernate.INTEGER).addScalar("activeNodeName", (Type)Hibernate.STRING).addScalar("activeCellName", (Type)Hibernate.STRING).addScalar("nodeResultArrivalDate", (Type)Hibernate.DATE);
        if (evalDelay) {
            sqlQuery.addScalar("nodeDuration", (Type)Hibernate.INTEGER).addScalar("reviewCycleCellInstanceReleaseId", (Type)Hibernate.INTEGER).addScalar("reviewCycleNodeInstanceReleaseId", (Type)Hibernate.INTEGER);
        }
        List mappedResults = sqlQuery.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        return mappedResults;
    }

    @Override
    public List getDocumentsForReviewStatus(Integer subProjectId, Date uploadedFrom, Date uploadedTo, Integer documentTypeId, Integer objectId, boolean mustHaveDocumentVersions, boolean showDocumentsOfDeletedObjectPlanners) {
        Criteria crit = this.getSession().createCriteria(DocumentImpl.class);
        if (mustHaveDocumentVersions || uploadedFrom != null || uploadedTo != null) {
            crit.add((Criterion)Restrictions.like((String)"hasDocumentVersions", (Object)Boolean.TRUE));
        }
        Criteria opCrit = crit.createCriteria("objectPlanner");
        if (objectId != null) {
            opCrit.createCriteria("object").add(Restrictions.idEq((Object)objectId));
        } else {
            crit.createCriteria("documentList").createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId));
        }
        if (documentTypeId != null) {
            crit.createCriteria("documentType").add(Restrictions.idEq((Object)documentTypeId));
        }
        if (!showDocumentsOfDeletedObjectPlanners) {
            opCrit.add((Criterion)Restrictions.like((String)"inactive", (Object)Boolean.FALSE));
        }
        if (uploadedFrom != null || uploadedTo != null) {
            Criteria dvCrit = crit.createCriteria("documentVersions");
            Calendar cal = Calendar.getInstance();
            if (uploadedFrom != null) {
                cal.setTime(uploadedFrom);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                dvCrit.add((Criterion)Restrictions.ge((String)"uploaded", (Object)cal.getTime()));
            }
            if (uploadedTo != null) {
                cal.setTime(uploadedTo);
                cal.set(11, 23);
                cal.set(12, 59);
                cal.set(13, 59);
                cal.set(14, 999);
                dvCrit.add((Criterion)Restrictions.le((String)"uploaded", (Object)cal.getTime()));
            }
        }
        return crit.list();
    }

    @Override
    public List getUploaded(Integer id, int filter, Date uploadedFrom, Date uploadedTo, Serializable documentTypeId, Serializable projectParticipationId, Integer activeDocumentListId, boolean isWithInvalidatedObjects) {
        Criteria crit = this.getSession().createCriteria(DocumentImpl.class);
        if (!isWithInvalidatedObjects) {
            crit.add((Criterion)Restrictions.eq((String)"invalidated", (Object)false));
        }
        if (uploadedFrom != null || uploadedTo != null) {
            Criteria dvCrit = null;
            dvCrit = crit.createCriteria("documentVersions");
            Calendar cal = Calendar.getInstance();
            if (uploadedFrom != null) {
                cal.setTime(uploadedFrom);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                dvCrit.add((Criterion)Restrictions.ge((String)"uploaded", (Object)cal.getTime()));
            }
            if (uploadedTo != null) {
                cal.setTime(uploadedTo);
                cal.set(11, 23);
                cal.set(12, 59);
                cal.set(13, 59);
                cal.set(14, 999);
                dvCrit.add((Criterion)Restrictions.le((String)"uploaded", (Object)cal.getTime()));
            }
        }
        if (Integer.valueOf(0).equals(documentTypeId)) {
            documentTypeId = null;
        }
        if (documentTypeId != null) {
            crit.createCriteria("documentType").add(Restrictions.idEq((Object)documentTypeId));
        }
        Criteria opCrit = null;
        if (Integer.valueOf(0).equals(projectParticipationId)) {
            projectParticipationId = null;
        }
        if (projectParticipationId != null) {
            opCrit = crit.createCriteria("objectPlanner");
            opCrit.createCriteria("planner").add(Restrictions.idEq((Object)projectParticipationId));
        }
        crit.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        if (!isWithInvalidatedObjects) {
            if (opCrit == null) {
                opCrit = crit.createCriteria("objectPlanner");
            }
            opCrit.add((Criterion)Restrictions.eq((String)"inactive", (Object)false));
        }
        List results = new ArrayList();
        ArrayList<Document> resultsWithRelDocs = new ArrayList<Document>();
        switch (filter) {
            case 2: {
                if (opCrit == null) {
                    results = crit.createCriteria("objectPlanner").add(Restrictions.idEq((Object)id)).list();
                    break;
                }
                results = opCrit.add(Restrictions.idEq((Object)id)).list();
                break;
            }
            case 1: {
                if (opCrit == null) {
                    results = crit.createCriteria("objectPlanner").createCriteria("object").add(Restrictions.idEq((Object)id)).list();
                    break;
                }
                results = opCrit.createCriteria("object").add(Restrictions.idEq((Object)id)).list();
                break;
            }
            case 0: {
                results = crit.createCriteria("documentList").createCriteria("subProject").add(Restrictions.idEq((Object)id)).list();
            }
        }
        Document releasedOrImplDocument = null;
        for (Document result : results) {
            releasedOrImplDocument = ((DocumentImpl)result).getLastReleasedOrImplDocument();
            if (activeDocumentListId >= 0 && releasedOrImplDocument instanceof ReleasedDocument && !((ReleasedDocument)releasedOrImplDocument).getDocumentList().getId().equals(activeDocumentListId)) continue;
            resultsWithRelDocs.add(releasedOrImplDocument);
        }
        return resultsWithRelDocs;
    }

    @Override
    public DocumentDateHistoryPart getDocumentDateHistoryPart(Integer id) {
        return (DocumentDateHistoryPart)this.getSession().get(DocumentDateHistoryPart.class, (Serializable)id);
    }

    @Override
    public DocumentDateHistoryPart insert(DocumentDateHistoryPart part) {
        return this.getDocumentDateHistoryPart((Integer)this.getSession().save((Object)part));
    }

    @Override
    public void delete(DocumentDateHistoryPart part) {
        this.getSession().delete((Object)part);
    }

    @Override
    public Collection<DocumentImpl> getAllUnreleased() {
        return this.loadAllHibernate(DocumentImpl.class);
    }

    @Override
    public List getDocumentsByDocumentType(DocumentType type) {
        Criteria crit = this.getSession().createCriteria(DocumentImpl.class);
        crit.createCriteria("documentType").add(Restrictions.idEq((Object)type.getId()));
        return crit.list();
    }

    @Override
    public List getReleasedDocumentsByDocumentType(DocumentType type) {
        Criteria crit = this.getSession().createCriteria(ReleasedDocument.class);
        crit.createCriteria("documentType").add(Restrictions.idEq((Object)type.getId()));
        return crit.list();
    }

    @Override
    public List getAllUnreleasedByObjectPlanner(Integer objectPlannerImplId) {
        return this.getSession().createCriteria(DocumentImpl.class).createCriteria("objectPlanner").add(Restrictions.idEq((Object)objectPlannerImplId)).list();
    }

    @Override
    public List getAllUnreleasedBySubProject(Integer subProjectId, boolean invalidated) {
        Criteria crit = this.getSession().createCriteria(DocumentImpl.class);
        crit.createCriteria("documentList").createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId));
        crit.add((Criterion)Restrictions.eq((String)"invalidated", (Object)invalidated));
        return crit.list();
    }

    @Override
    public DocumentImpl getForAsBuiltReference(Integer sourceDocumentId, Integer objectPlannerId) {
        Criteria crit = this.getSession().createCriteria(DocumentImpl.class);
        crit.createCriteria("asBuiltReference").add(Restrictions.idEq((Object)sourceDocumentId));
        crit.createCriteria("objectPlanner").add(Restrictions.idEq((Object)objectPlannerId));
        return (DocumentImpl)crit.uniqueResult();
    }
}

