/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.planningNotification.PlanningNotificationAttachment;
import at.cdes.bo.data.workflow.WorkflowActivity;
import at.cdes.bo.data.workflow.WorkflowActivityHistoryEntry;
import at.cdes.bo.data.workflow.WorkflowActivityPositionResult;
import at.cdes.db.dao.WorkflowActivityDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Restrictions;

public class WorkflowActivityDAOHibernate
extends HibernateDaoSupport
implements WorkflowActivityDAO {
    @Override
    public WorkflowActivity get(Integer id) {
        return (WorkflowActivity)this.getSession().get(WorkflowActivity.class, (Serializable)id);
    }

    @Override
    public WorkflowActivity save(WorkflowActivity activity) {
        return this.get((Integer)this.getSession().save((Object)activity));
    }

    @Override
    public WorkflowActivity update(WorkflowActivity activity) {
        this.getSession().merge((Object)activity);
        return activity;
    }

    @Override
    public WorkflowActivity merge(WorkflowActivity activity) {
        return (WorkflowActivity)this.getSession().merge((Object)activity);
    }

    @Override
    public void delete(WorkflowActivity activity) {
        this.getSession().delete((Object)activity);
    }

    @Override
    public void delete(WorkflowActivityPositionResult activityPositionResult) {
        this.getSession().delete((Object)activityPositionResult);
    }

    @Override
    public List<WorkflowActivity> getByWorkflow(Integer workflowId) {
        Criteria crit = this.getSession().createCriteria(WorkflowActivity.class);
        crit.createCriteria("workflow").add(Restrictions.idEq((Object)workflowId));
        return crit.list();
    }

    @Override
    public List<WorkflowActivityPositionResult> getPositionResultsByWorkflow(Integer workflowId) {
        Criteria crit = this.getSession().createCriteria(WorkflowActivityPositionResult.class);
        crit.createCriteria("workflow").add(Restrictions.idEq((Object)workflowId));
        List list = crit.list();
        for (WorkflowActivityPositionResult w : list) {
            Criteria c = this.getSession().createCriteria(PlanningNotificationAttachment.class);
            c.createCriteria("results").add(Restrictions.idEq((Object)w.getId()));
            List pnaList = c.list();
            HashMap<Integer, PlanningNotificationAttachment> map = new HashMap<Integer, PlanningNotificationAttachment>();
            for (PlanningNotificationAttachment p : pnaList) {
                map.put(p.getId(), p);
            }
            w.setPlanningNotificationAttachments(map);
        }
        return list;
    }

    @Override
    public List<WorkflowActivityHistoryEntry> getWorkflowActivityHistoryEntriesByWorkflow(Integer workflowId) {
        Criteria crit = this.getSession().createCriteria(WorkflowActivityHistoryEntry.class);
        crit.createCriteria("workflow").add(Restrictions.idEq((Object)workflowId));
        return crit.list();
    }

    @Override
    public List<WorkflowActivityPositionResult> getPositionResultsByInitiator(Integer initiatorId) {
        Criteria crit = this.getSession().createCriteria(WorkflowActivityPositionResult.class);
        crit.createCriteria("tokenInitiatorObj").add(Restrictions.idEq((Object)initiatorId));
        List list = crit.list();
        for (WorkflowActivityPositionResult w : list) {
            Criteria c = this.getSession().createCriteria(PlanningNotificationAttachment.class);
            c.createCriteria("results").add(Restrictions.idEq((Object)w.getId()));
            List pnaList = c.list();
            HashMap<Integer, PlanningNotificationAttachment> map = new HashMap<Integer, PlanningNotificationAttachment>();
            for (PlanningNotificationAttachment p : pnaList) {
                map.put(p.getId(), p);
            }
            w.setPlanningNotificationAttachments(map);
        }
        return list;
    }
}

