/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.aop;

import at.cdes.service.exception.LockedException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LockManager
implements Serializable {
    static Logger logger = Logger.getLogger(LockManager.class);
    private static final long serialVersionUID = 1L;
    private Map locks = new HashMap();

    public synchronized void lock(Object id) throws LockedException {
        if (this.locks.containsKey(id)) {
            logger.warn((Object)("object [" + id + "] is already locked."));
            throw new LockedException();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Locking object [" + id + "]"));
        }
        this.locks.put(id, System.currentTimeMillis());
    }

    public synchronized void unlock(Object id) throws LockedException {
        if (!this.locks.containsKey(id)) {
            logger.error((Object)("Cannot unlock stale object [" + id + "]."));
            throw new LockedException();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unlocking object [" + id + "]"));
        }
        this.locks.remove(id);
    }
}

