/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.schema;

import at.cdes.db.SchemaUpdateSnippet;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.IndexInfo;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUpdate_0_229
implements SchemaUpdateSnippet {
    private static final Logger log = LoggerFactory.getLogger(SchemaUpdate_0_229.class);

    @Override
    public String getTargetVersion() {
        return "0.229";
    }

    @Override
    public String getUpdateComment() {
        return "Add foreign key to network to certificate_request";
    }

    @Override
    public void performUpdate(ISchemaEngine schemaEngine) throws SQLException {
        TableInfo certificateRequestTableInfo = schemaEngine.fetchTableInfo("certificate_request", null);
        schemaEngine.addColumn(certificateRequestTableInfo, new ColumnInfo("network_id", -5, Integer.valueOf(20), null, true, null));
        certificateRequestTableInfo.addIndex(new IndexInfo("CERTIFICATE_REQUEST_NETWORK_ID_INDEX", "network_id", false, ""));
        String certificateSQL = "SELECT certificate.id, certificate_request.id, ca.id, ca.network_id FROM     ((certificate JOIN ca                        ON certificate.ca_cert_id = ca.id) JOIN certificate_request       ON certificate.certificate_request_id = certificate_request.id) ";
        PreparedStatement certificateSelect = schemaEngine.getConnection().prepareStatement(certificateSQL);
        String updateSQL = "UPDATE certificate_request SET network_id = ? WHERE id = ?";
        PreparedStatement updateStatement = schemaEngine.getConnection().prepareStatement(updateSQL);
        ResultSet certificateResultSet = certificateSelect.executeQuery();
        while (certificateResultSet.next()) {
            Long networkId;
            int currIndex = 1;
            Long certificateId = JDBCHelper.getLong((ResultSet)certificateResultSet, (int)currIndex++);
            Long certificateRequestId = JDBCHelper.getLong((ResultSet)certificateResultSet, (int)currIndex++);
            Long caId = JDBCHelper.getLong((ResultSet)certificateResultSet, (int)currIndex++);
            if ((networkId = JDBCHelper.getLong((ResultSet)certificateResultSet, (int)currIndex++)) == null) continue;
            currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)updateStatement, (int)currIndex++, (Number)networkId);
            JDBCHelper.setLong((PreparedStatement)updateStatement, (int)currIndex++, (Number)certificateRequestId);
            if (log.isInfoEnabled()) {
                log.info("Populating certificate_request.network_id: For certificate = [" + certificateId + "] ca [" + caId + "], certificate_request [" + certificateRequestId + "], setting network_id = [" + networkId + "]");
            }
            updateStatement.addBatch();
        }
        updateStatement.executeBatch();
    }
}

