/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.file;

import at.cdes.gwtdto.GWTSessionFile;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SessionFileUploadRegistry {
    private Map<String, GWTSessionFile> sessionFiles = new HashMap<String, GWTSessionFile>();

    public GWTSessionFile getSessionFile(String id) {
        return this.sessionFiles.get(id);
    }

    public GWTSessionFile registerSessionFile(String id, String fileName, String fileType, String filePath, Calendar expirationDate) {
        return this.registerSessionFile(new GWTSessionFile(id, fileName, fileType, filePath, expirationDate));
    }

    public GWTSessionFile registerSessionFile(GWTSessionFile sessionFile) {
        this.sessionFiles.put(sessionFile.getId(), sessionFile);
        return sessionFile;
    }

    public void removeSessionFile(String id) {
        this.sessionFiles.remove(id);
    }

    public int getItemCount() {
        return this.sessionFiles.size();
    }

    public List<GWTSessionFile> getExpiredSessionFiles() {
        ArrayList<GWTSessionFile> ret = new ArrayList<GWTSessionFile>();
        Calendar now = Calendar.getInstance();
        for (GWTSessionFile sessionFile : this.sessionFiles.values()) {
            if (!sessionFile.getExpirationDate().before(now)) continue;
            ret.add(sessionFile);
        }
        return ret;
    }
}

