/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec.certificate;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class CertificateHelper {
    public static String PEM_HEADER = "-----BEGIN CERTIFICATE-----";
    public static String PEM_FOOTER = "-----END CERTIFICATE-----";

    public static X509Certificate parseCertificate(String pem) throws CertificateException {
        ByteArrayInputStream is;
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        try {
            String realPem = pem.trim();
            if (realPem.startsWith(PEM_HEADER) && !Character.isWhitespace(realPem.charAt(PEM_HEADER.length()))) {
                realPem = PEM_HEADER + "\n" + realPem.substring(PEM_HEADER.length());
            }
            realPem = realPem.endsWith(PEM_FOOTER) && !Character.isWhitespace(realPem.charAt(realPem.length() - 1 - PEM_FOOTER.length())) ? realPem.substring(0, realPem.length() - PEM_FOOTER.length()) + "\n" + PEM_FOOTER + "\n" : realPem + "\n";
            is = new ByteArrayInputStream(realPem.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new CertificateException("PEM string is not ASCII-encoded", e);
        }
        return (X509Certificate)certFactory.generateCertificate(is);
    }
}

