/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec.digest;

import at.cdes.bo.data.workflow.WorkflowActivityPositionResult;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.WorkflowActivityPositionResultDigestCalculator;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.DigestOutputStream;
import java.text.DateFormat;
import org.bouncycastle.util.encoders.Base64;

public class WorkflowActivityPositionResultDigesterV1
extends WorkflowActivityPositionResultDigestCalculator {
    @Override
    public String getPositionResultHash(WorkflowActivityPositionResult o) throws DigestCalculatorException {
        if (o.getDigest() != null) {
            return o.getDigest();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream osd = new DataOutputStream(os);
        DigestOutputStream dos = new DigestOutputStream(osd, this.getMessageDigest());
        try {
            dos.write(("id=" + o.getId()).getBytes());
            dos.write(("workflowId=" + o.getWorkflow().getId()).getBytes());
            if (o.getAttachmentFilePath() != null) {
                dos.write(("AttachmentFilePath=" + o.getAttachmentFilePath()).getBytes());
            }
            dos.write(("Comment=" + o.getComment()).getBytes());
            dos.write(("Description=" + o.getDescription()).getBytes());
            dos.write(("EntityStatus=" + o.getEntityStatus()).getBytes());
            dos.write(("Result=" + o.getResult()).getBytes());
            dos.write(("Reviewer=" + o.getReviewer()).getBytes());
            dos.write(("TokenInitiator=" + o.getTokenInitiator()).getBytes());
            dos.write(("TokenOwner=" + o.getTokenOwner()).getBytes());
            dos.write(("WorkflowNodeName=" + o.getWorkflowNodeName()).getBytes());
            if (o.getIssued() != null) {
                dos.write(("Issued=" + DateFormat.getDateTimeInstance().format(o.getIssued())).getBytes());
            }
        }
        catch (IOException e) {
            throw new DigestCalculatorException("Hashing Document = ", e);
        }
        String res = new String(Base64.encode((byte[])dos.getMessageDigest().digest()));
        return res;
    }
}

