/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.TemporaryDocumentVersion;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.label.LabelContent;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.file.FileFinder;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.preview.api.Annotation;
import at.cdes.preview.api.IHPGLRenderer;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.PDFProperty;
import at.cdes.preview.api.PDFPropertyType;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.ByteArrayMimeInputStream;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.LabelOperations;
import at.cdes.service.ObjectOperations;
import at.cdes.service.ReviewOperations;
import at.cdes.util.ImplContextHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.clazzes.util.http.osgi.DefaultHttpContext;
import org.clazzes.util.io.IOUtil;
import org.xnap.commons.i18n.I18n;

public class TemporaryDocumentVersionPdfMimeSource
implements VisitlessMimeSource {
    private IHPGLRenderer hpglRenderer;
    private LabelOperations labelOperations;
    private ObjectOperations objectOperations;
    private ReviewOperations reviewOperations;
    private FileFinder fileFinder;

    protected ObjectOperations getObjectOperations() {
        return this.objectOperations;
    }

    public void setObjectOperations(ObjectOperations objectOperations) {
        this.objectOperations = objectOperations;
    }

    protected FileFinder getFileFinder() {
        return this.fileFinder;
    }

    protected IHPGLRenderer getHpglRenderer() {
        return this.hpglRenderer;
    }

    protected LabelOperations getLabelOperations() {
        return this.labelOperations;
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public void setHpglRenderer(IHPGLRenderer hpglRenderer) {
        this.hpglRenderer = hpglRenderer;
    }

    public void setLabelOperations(LabelOperations labelOperations) {
        this.labelOperations = labelOperations;
    }

    public String getActionName() {
        return "uploadDocument";
    }

    public boolean isEditable() {
        return false;
    }

    public Object getDestinationObject(Object[] parameters) {
        DocumentImpl document = this.reviewOperations.getDocument(ImplContextHelper.getTemporaryDocumentVersion().getDocumentId());
        SubProject subProject = document.getObjectPlanner().getObject().getObjectList().getSubProject();
        return this.objectOperations.getReleasedObjectPlannerFromList(document.getObjectPlanner().getId(), subProject.getActiveObjectList().getId());
    }

    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        TemporaryDocumentVersion tdv = ImplContextHelper.getTemporaryDocumentVersion();
        LabelContent label = null;
        if (tdv.getLabelContentId() != null) {
            label = this.labelOperations.getLabelContent(tdv.getLabelContentId());
        }
        FileMimeInputStream labelStream = null;
        try (FileMimeInputStream stream = null;){
            FileMimeInputStream ret;
            File file = new File(tdv.getFileName());
            String unique = this.getFileFinder().makeUniqueName(tdv.getFileName(), CDESFileRepository.TEMPREPOSITORY);
            String fileType = IOUtil.getFileExtension((String)tdv.getFileName());
            stream = new FileMimeInputStream(file, unique, tdv.getName() + "." + fileType, DefaultHttpContext.getInstance().getMimeType(tdv.getFileName()));
            if ("pdf".equalsIgnoreCase(tdv.getFileType()) && label == null) {
                ret = stream;
                stream = null;
            } else {
                DocumentImpl doc = this.reviewOperations.getDocument(tdv.getDocumentId());
                Locale locale = new Locale(doc.getDocumentList().getSubProject().getProject().getLocalisation().getCountry().getCode2());
                I18n i18n = I18nFactory.getI18n(locale);
                ArrayList<PDFProperty> properties = new ArrayList<PDFProperty>();
                properties.add(new PDFProperty(PDFPropertyType.ANNOTATION, i18n.tr("Automatisch generiert durch die Planpr\u00fcfplattform c.des")));
                properties.add(new PDFProperty(PDFPropertyType.TITLE, tdv.getName()));
                ArrayList<Annotation> annotations = null;
                if (label != null) {
                    annotations = new ArrayList<Annotation>();
                    Date creationDate = new Date();
                    creationDate.setTime(file.lastModified());
                    if (tdv.getLabelXOffset() == null) {
                        tdv.setLabelXOffset(0.0);
                    }
                    if (tdv.getLabelYOffset() == null) {
                        tdv.setLabelYOffset(0.0);
                    }
                    byte[] fdf_data = this.labelOperations.formatFDFPreview(tdv, true);
                    ByteArrayMimeInputStream fdf_is = new ByteArrayMimeInputStream(fdf_data, 0.001 * (double)file.lastModified(), label.getName(), "application/vnd.fdf");
                    annotations.add(new Annotation((IMimeInputStream)fdf_is, "", "", "", 2));
                }
                if (tdv.getLabelContentId() != null && tdv.getLabelCorrelation() == null) {
                    String stamp = null;
                    file = this.getFileFinder().findFile(label.getFileName(), CDESFileRepository.LABELREPOSITORY);
                    unique = this.getFileFinder().makeUniqueName(label.getFileName(), CDESFileRepository.LABELREPOSITORY);
                    labelStream = new FileMimeInputStream(file, unique, label.getName() + "." + label.getFileType(), DefaultHttpContext.getInstance().getMimeType(label.getFileName()));
                    ret = this.hpglRenderer.mergePdfWithAnnotations((IMimeInputStream)labelStream, label.getRotationAngle(), (IMimeInputStream)stream, tdv.getPreviewRotation(), annotations, stamp, properties);
                } else {
                    ret = this.hpglRenderer.renderPdf((IMimeInputStream)stream, properties, tdv.getPreviewRotation(), "", annotations);
                }
            }
            FileMimeInputStream fileMimeInputStream = ret;
            return fileMimeInputStream;
        }
    }

    public void setReviewOperations(ReviewOperations reviewOperations) {
        this.reviewOperations = reviewOperations;
    }
}

