/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview.seed;

import java.io.Serializable;
import java.util.Arrays;

public class SeedItem
implements Comparable<SeedItem>,
Serializable {
    private static final long serialVersionUID = -5128337258492803070L;
    private final String mimeSource;
    private final Object[] parameters;
    private final long seq;
    private final int priority;
    private static long lastSeq = 0L;

    private static synchronized long getNextSeq() {
        return ++lastSeq;
    }

    public SeedItem(int priority, String mimeSource, Object ... parameters) {
        this.priority = priority;
        this.mimeSource = mimeSource;
        this.parameters = parameters;
        this.seq = SeedItem.getNextSeq();
    }

    public String getMimeSource() {
        return this.mimeSource;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public long getSeq() {
        return this.seq;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(SeedItem o) {
        if (this.getPriority() < o.getPriority()) {
            return -1;
        }
        if (this.getPriority() > o.getPriority()) {
            return 1;
        }
        if (this.getSeq() < o.getSeq()) {
            return -1;
        }
        if (this.getSeq() > o.getSeq()) {
            return 1;
        }
        int r = this.mimeSource.compareTo(o.mimeSource);
        if (r != 0) {
            return r;
        }
        int l1 = this.parameters.length;
        int l2 = o.parameters.length;
        int l = Math.min(l1, l2);
        for (int i = 0; i < l; ++i) {
            Object o1 = this.parameters[i];
            Object o2 = o.parameters[i];
            if (o1.equals(o2)) continue;
            if (o1 instanceof Comparable && o1.getClass().isAssignableFrom(o2.getClass())) {
                Comparable c1 = (Comparable)o1;
                r = c1.compareTo(o2);
            } else {
                r = o1.hashCode() - o2.hashCode();
            }
            if (r == 0) continue;
            return r;
        }
        return l1 - l2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.mimeSource);
        sb.append('[');
        for (int i = 0; i < this.parameters.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.parameters[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mimeSource == null ? 0 : this.mimeSource.hashCode());
        result = 31 * result + Arrays.hashCode(this.parameters);
        result = 31 * result + this.priority;
        result = 31 * result + (int)(this.seq ^ this.seq >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SeedItem other = (SeedItem)obj;
        if (this.mimeSource == null ? other.mimeSource != null : !this.mimeSource.equals(other.mimeSource)) {
            return false;
        }
        if (!Arrays.equals(this.parameters, other.parameters)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        return this.seq == other.seq;
    }
}

