/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.hibernate;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.clazzes.util.aop.ThreadLocalManager;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;

public abstract class HibernateDaoSupport {
    private String hibernateThreadLocalKey;

    public String getHibernateThreadLocalKey() {
        return this.hibernateThreadLocalKey;
    }

    public void setHibernateThreadLocalKey(String hibernateThreadLocalKey) {
        this.hibernateThreadLocalKey = hibernateThreadLocalKey;
    }

    protected Session getSession() {
        return (Session)ThreadLocalManager.getBoundResource((String)this.hibernateThreadLocalKey);
    }

    protected <T> List<T> loadAllHibernate(Class<T> entityClass) {
        Criteria criteria = this.getSession().createCriteria(entityClass);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    protected void deleteAllHibernate(Collection entities) {
        Iterator it = entities.iterator();
        while (it.hasNext()) {
            this.getSession().delete(it.next());
        }
    }

    public List findHibernate(String queryString) {
        return this.findHibernate(queryString, null);
    }

    public List findHibernate(String queryString, Object value) {
        return this.findHibernate(queryString, new Object[]{value});
    }

    public List findHibernate(String queryString, Object[] values) {
        Query queryObject = this.getSession().createQuery(queryString);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                queryObject.setParameter(i, values[i]);
            }
        }
        return queryObject.list();
    }
}

