/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.hibernate;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.clazzes.util.aop.ThreadLocalManager;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateJdbcConnectionProvider
implements ConnectionProvider {
    private static final Logger log = LoggerFactory.getLogger(HibernateJdbcConnectionProvider.class);
    private Map<Connection, Boolean> isPassthrough = Collections.synchronizedMap(new IdentityHashMap());

    public void configure(Properties props) throws HibernateException {
    }

    public Connection getConnection() throws SQLException {
        Connection jdbcConnection = (Connection)ThreadLocalManager.getBoundResource((String)"at.cdes.dojo-impl::DataSource");
        if (jdbcConnection != null) {
            if (log.isTraceEnabled()) {
                this.printStackTraceToLog();
            }
            if (this.isPassthrough.get(jdbcConnection) != null) {
                throw new Error("HibernateJdbcConnectionProvider is not re-entrant, calling it with jdbcConnection [" + jdbcConnection.toString() + "]");
            }
            this.isPassthrough.put(jdbcConnection, true);
            if (log.isTraceEnabled()) {
                log.trace("... Mapping connection [" + jdbcConnection + "] to true");
            }
            return jdbcConnection;
        }
        DataSource dataSource = (DataSource)ThreadLocalManager.getBoundResource((String)"at.cdes::DataSourceInstance");
        if (log.isTraceEnabled()) {
            this.printStackTraceToLog();
        }
        Connection connection = dataSource.getConnection();
        this.isPassthrough.put(connection, false);
        if (log.isTraceEnabled()) {
            log.trace("... Mapping connection [" + jdbcConnection + "] to false");
        }
        return connection;
    }

    private void printStackTraceToLog() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        log.trace("getConnection called with stack trace:");
        for (int n = 0; n < stackTrace.length; ++n) {
            log.trace("====> " + stackTrace[n].toString());
        }
        log.trace("======================================");
    }

    public void closeConnection(Connection connection) throws SQLException {
        if (log.isTraceEnabled()) {
            log.trace("Closing connection [" + connection + "]");
        }
        if (!this.isPassthrough.remove(connection).booleanValue()) {
            connection.close();
        }
    }

    public void close() throws HibernateException {
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }
}

