/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.hibernate;

import at.cdes.bo.data.CdesDataObject;
import at.cdes.hibernate.HibernateDaoSupport;
import at.cdes.service.SessionOptimizer;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.ThreadLocalManager;
import org.hibernate.FlushMode;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateSessionOptimizer
extends HibernateDaoSupport
implements SessionOptimizer {
    private static final Logger log = LoggerFactory.getLogger(HibernateSessionOptimizer.class);
    private DataSource dataSource;
    private String jdbcThreadLocalKey;
    private String hibernateTransactionThreadLocalKey;
    private String contextClassLoaderThreadLocalKey;
    private String dataSourceThreadLocalKey;
    private SessionFactory sessionFactory;
    private Boolean enableLongTransactions;
    private FlushMode flushMode;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setJdbcThreadLocalKey(String jdbcThreadLocalString) {
        this.jdbcThreadLocalKey = jdbcThreadLocalString;
    }

    public void setHibernateTransactionThreadLocalKey(String hibernateTransactionThreadLocalKey) {
        this.hibernateTransactionThreadLocalKey = hibernateTransactionThreadLocalKey;
    }

    public void setContextClassLoaderThreadLocalKey(String contextClassLoaderThreadLocalKey) {
        this.contextClassLoaderThreadLocalKey = contextClassLoaderThreadLocalKey;
    }

    public void setDataSourceThreadLocalKey(String dataSourceThreadLocalKey) {
        this.dataSourceThreadLocalKey = dataSourceThreadLocalKey;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setEnableLongTransactions(Boolean enableLongTransactions) {
        this.enableLongTransactions = enableLongTransactions;
    }

    public void setFlushMode(String flushMode) {
        this.flushMode = "COMMIT".equals(flushMode) ? FlushMode.COMMIT : ("AUTO".equals(flushMode) ? FlushMode.AUTO : ("ALWAYS".equals(flushMode) ? FlushMode.ALWAYS : FlushMode.ALWAYS));
    }

    @Override
    public void clearSession() {
        org.hibernate.Session session = this.getSession();
        if (session != null) {
            session.clear();
        }
    }

    @Override
    public void openSession() {
        Session session;
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new DAOException("Error retrieving connection from DataSource", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Opening transaction for datasource [" + this.dataSource + "].");
        }
        try {
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(4);
        }
        catch (Throwable e) {
            block22: {
                try {
                    connection.close();
                }
                catch (SQLException sqle) {
                    if (!log.isWarnEnabled()) break block22;
                    log.warn("Exception caught closing JDBC transaction upon connection setup error.", (Throwable)sqle);
                }
            }
            throw new DAOException("Error starting jdbc transaction", e);
        }
        if (log.isDebugEnabled()) {
            log.debug("bindResource, will openSession(connection)");
        }
        try {
            session = this.sessionFactory.openSession();
            session.setFlushMode(this.flushMode);
        }
        catch (Throwable e) {
            try {
                connection.close();
            }
            catch (SQLException sqle) {
                log.warn("Closing connection failed", (Throwable)sqle);
            }
            throw new DAOException("Error opening hibernate sesssion", e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Opened session, will beginTransaction()");
        }
        Transaction transaction = null;
        ThreadLocalManager.bindResource((String)this.dataSourceThreadLocalKey, (Object)this.dataSource);
        try {
            if (this.enableLongTransactions == null || this.enableLongTransactions.booleanValue()) {
                transaction = session.beginTransaction();
            }
            if (log.isDebugEnabled()) {
                log.debug("beginTransaction() succeeded");
            }
        }
        catch (Throwable e) {
            try {
                session.close();
            }
            catch (Throwable he) {
                log.warn("Closing session failed", he);
            }
            try {
                connection.close();
            }
            catch (Throwable ce) {
                log.warn("Closing connection failed", ce);
            }
            throw new DAOException("Error starting hibernate transaction", e);
        }
        ThreadLocalManager.bindResource((String)this.jdbcThreadLocalKey, (Object)connection);
        ThreadLocalManager.bindResource((String)this.getHibernateThreadLocalKey(), (Object)session);
        if (this.enableLongTransactions == null || this.enableLongTransactions.booleanValue()) {
            ThreadLocalManager.bindResource((String)this.hibernateTransactionThreadLocalKey, (Object)transaction);
        }
    }

    @Override
    public void commitSession() {
        org.hibernate.Session session;
        if (this.enableLongTransactions == null || this.enableLongTransactions.booleanValue()) {
            Transaction transaction = (Transaction)ThreadLocalManager.unbindResource((String)this.hibernateTransactionThreadLocalKey);
            if (transaction == null) {
                log.warn("unbindResource did not find a hibernateTransactionThreadLocalKey");
            } else {
                try {
                    transaction.commit();
                }
                catch (Throwable e) {
                    throw new DAOException("Error while committing transaction", e);
                }
            }
        }
        if ((session = (org.hibernate.Session)ThreadLocalManager.unbindResource((String)this.getHibernateThreadLocalKey())) == null) {
            log.warn("unbindResource did not find a hibernateThreadLocalKey");
        } else {
            try {
                session.close();
            }
            catch (Throwable e) {
                throw new DAOException("Error while closing session", e);
            }
        }
        Connection connection = (Connection)ThreadLocalManager.unbindResource((String)this.jdbcThreadLocalKey);
        if (connection == null) {
            log.warn("unbindResource did not find a jdbcThreadLocalKey");
        } else {
            try {
                connection.commit();
            }
            catch (Throwable e) {
                throw new DAOException("Error while committing connection", e);
            }
            try {
                connection.close();
            }
            catch (Throwable e) {
                throw new DAOException("Error while closing connection", e);
            }
        }
        ThreadLocalManager.unbindResource((String)this.dataSourceThreadLocalKey);
    }

    @Override
    public void rollbackSession() {
        org.hibernate.Session session;
        if (this.enableLongTransactions == null || this.enableLongTransactions.booleanValue()) {
            Transaction transaction = (Transaction)ThreadLocalManager.unbindResource((String)this.hibernateTransactionThreadLocalKey);
            if (transaction == null) {
                ThreadLocalManager.unbindResource((String)this.dataSourceThreadLocalKey);
                log.warn("unbindResource did not find a hibernateTransactionThreadLocalKey");
            } else {
                try {
                    transaction.rollback();
                }
                catch (Throwable e) {
                    throw new DAOException("Error while rollbacking transaction", e);
                }
                finally {
                    ThreadLocalManager.unbindResource((String)this.dataSourceThreadLocalKey);
                }
            }
        }
        if ((session = (org.hibernate.Session)ThreadLocalManager.unbindResource((String)this.getHibernateThreadLocalKey())) == null) {
            log.warn("unbindResource did not find a hibernateThreadLocalKey");
        } else {
            try {
                session.close();
            }
            catch (Throwable e) {
                throw new DAOException("Error while closing session", e);
            }
        }
        Connection connection = (Connection)ThreadLocalManager.unbindResource((String)this.jdbcThreadLocalKey);
        if (connection == null) {
            log.warn("unbindResource did not find a jdbcThreadLocalKey");
        } else {
            try {
                connection.rollback();
            }
            catch (Throwable e) {
                throw new DAOException("Error while rollbacking connection", e);
            }
            try {
                connection.close();
            }
            catch (Throwable e) {
                throw new DAOException("Error while closing connection", e);
            }
        }
    }

    @Override
    public <T extends CdesDataObject> void evict(Class<T> entityClass, T object) {
        org.hibernate.Session session = this.getSession();
        if (session == null) {
            return;
        }
        session.evict(object);
    }

    @Override
    public <T extends CdesDataObject> void evictAll(Class<T> entityClass, Collection<? extends T> objects) {
        org.hibernate.Session session = this.getSession();
        if (session == null) {
            return;
        }
        for (T object : objects) {
            session.evict(object);
        }
    }

    @Override
    public <T extends CdesDataObject> void evictAllIds(Class<T> entityClass, Collection<Integer> ids) {
        org.hibernate.Session session = this.getSession();
        if (session == null) {
            return;
        }
        for (Integer id : ids) {
            Object entity = session.get(entityClass, (Serializable)id);
            session.evict(entity);
        }
    }

    @Override
    public <T extends CdesDataObject> void evictId(Class<T> entityClass, Integer id) {
        org.hibernate.Session session = this.getSession();
        if (session == null) {
            return;
        }
        Object entity = session.get(entityClass, (Serializable)id);
        session.evict(entity);
    }
}

