/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.date;

import at.cdes.bo.date.TimeUnit;
import java.io.Serializable;
import java.text.ParseException;
import java.util.EnumMap;

public class ISO8601Interval
implements Serializable {
    private static final long serialVersionUID = -7739123520829052766L;
    private TimeUnit intervalUnit;
    private int intervalAmount;
    private EnumMap<TimeUnit, Integer> start = new EnumMap(TimeUnit.class);
    private Integer repeatCount;

    public ISO8601Interval() {
        this.start.put(TimeUnit.Hour, 0);
        this.start.put(TimeUnit.Minute, 0);
        this.start.put(TimeUnit.Second, 0);
        this.intervalUnit = TimeUnit.Day;
    }

    public ISO8601Interval(String s) throws ParseException {
        this.fromString(s);
    }

    public void fromString(String s) throws ParseException {
        int pos = 0;
        try {
            boolean timePart;
            if (s.charAt(pos) == 'R') {
                if (s.charAt(++pos) == '/') {
                    this.repeatCount = null;
                } else {
                    int npos = pos;
                    while (++npos < s.length() && s.charAt(npos) != '/') {
                    }
                    if (npos >= s.length()) {
                        throw new ParseException(s, npos);
                    }
                    this.repeatCount = Integer.valueOf(s.substring(pos, npos));
                    pos = npos;
                }
                ++pos;
            } else {
                this.repeatCount = 0;
            }
            int m = 0;
            int d = 0;
            Integer w = null;
            int y = Integer.parseInt(s.substring(pos, pos + 4));
            if (s.charAt(pos += 4) != '-') {
                throw new ParseException(s, pos);
            }
            if (s.charAt(++pos) == 'W') {
                w = Integer.valueOf(s.substring(pos, pos + 2));
                if (s.charAt(pos += 2) != '-') {
                    throw new ParseException(s, pos);
                }
                d = Integer.parseInt(s.substring(++pos, pos + 1));
                ++pos;
            } else {
                m = Integer.parseInt(s.substring(pos, pos + 2));
                if (s.charAt(pos += 2) != '-') {
                    throw new ParseException(s, pos);
                }
                d = Integer.parseInt(s.substring(++pos, pos + 2));
                pos += 2;
            }
            this.setStartField(TimeUnit.Year, y == 0 ? null : Integer.valueOf(y));
            this.setStartField(TimeUnit.Month, m == 0 ? null : Integer.valueOf(m));
            this.setStartField(TimeUnit.Day, d == 0 ? null : Integer.valueOf(d));
            this.setStartField(TimeUnit.Week, w);
            int hh = 0;
            int mm = 0;
            int ss = 0;
            if (pos < s.length() && s.charAt(pos) == 'T') {
                hh = Integer.parseInt(s.substring(++pos, pos + 2));
                if ((pos += 2) < s.length() && s.charAt(pos) == ':') {
                    mm = Integer.parseInt(s.substring(++pos, pos + 2));
                    if ((pos += 2) < s.length() && s.charAt(pos) == ':') {
                        ss = Integer.parseInt(s.substring(++pos, pos + 2));
                        pos += 2;
                    }
                }
            }
            this.setStartField(TimeUnit.Hour, hh);
            this.setStartField(TimeUnit.Minute, mm);
            this.setStartField(TimeUnit.Second, ss);
            if (pos >= s.length() || s.charAt(pos) != '/') {
                throw new ParseException(s, pos);
            }
            if (++pos >= s.length() || s.charAt(pos) != 'P') {
                throw new ParseException(s, pos);
            }
            boolean bl = timePart = s.charAt(++pos) == 'T';
            if (timePart) {
                ++pos;
            }
            int npos = pos;
            while (++npos < s.length() && s.charAt(npos) >= '0' && s.charAt(npos) <= '9') {
            }
            this.intervalAmount = Integer.parseInt(s.substring(pos, npos));
            pos = npos;
            if (pos >= s.length()) {
                throw new ParseException(s, pos);
            }
            TimeUnit tu = TimeUnit.fromISO8601Duration(s.charAt(pos), timePart);
            if (tu != null) {
                this.intervalUnit = tu;
            }
        }
        catch (NumberFormatException e) {
            throw new ParseException(s, pos);
        }
    }

    public String toString() {
        int ss_v;
        StringBuffer sb = new StringBuffer();
        if (this.repeatCount == null) {
            sb.append("R/");
        } else if (this.repeatCount > 0) {
            sb.append('R');
            sb.append(this.repeatCount);
            sb.append('/');
        }
        Integer y = this.start.get((Object)TimeUnit.Year);
        Integer m = this.start.get((Object)TimeUnit.Month);
        Integer w = this.start.get((Object)TimeUnit.Week);
        Integer d = this.start.get((Object)TimeUnit.Day);
        if (w != null) {
            sb.append(String.format("%04d-W%02d-%d", y == null ? 0 : y, (int)w, d == null ? 0 : d));
        } else {
            sb.append(String.format("%04d-%02d-%02d", y == null ? 0 : y, m == null ? 0 : m, d == null ? 0 : d));
        }
        Integer hh = this.start.get((Object)TimeUnit.Hour);
        Integer mm = this.start.get((Object)TimeUnit.Minute);
        Integer ss = this.start.get((Object)TimeUnit.Second);
        int hh_v = hh == null ? 0 : hh;
        int mm_v = mm == null ? 0 : mm;
        int n = ss_v = ss == null ? 0 : ss;
        if (hh_v > 0 || mm_v > 0 || ss_v > 0) {
            sb.append(String.format("T%02d:%02d:%02d", hh_v, mm_v, ss_v));
        }
        if (this.intervalUnit != null) {
            if (this.intervalUnit.isTimePart()) {
                sb.append("/PT");
            } else {
                sb.append("/P");
            }
            sb.append(this.intervalAmount);
            sb.append(this.intervalUnit.toISO8601Duration());
        }
        return sb.toString();
    }

    public TimeUnit getIntervalUnit() {
        return this.intervalUnit;
    }

    public void setIntervalUnit(TimeUnit intervalUnit) {
        this.intervalUnit = intervalUnit;
    }

    public int getIntervalAmount() {
        return this.intervalAmount;
    }

    public void setIntervalAmount(int intervalAmount) {
        this.intervalAmount = intervalAmount;
    }

    public Integer getStartField(TimeUnit tu) {
        return this.start.get((Object)tu);
    }

    public void setStartField(TimeUnit tu, Integer value) {
        this.start.put(tu, value);
    }

    public Integer getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(Integer repeatCount) {
        this.repeatCount = repeatCount;
    }
}

