/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.organisation.Organisation;
import at.cdes.bo.data.organisation.OrganisationWrapper;
import at.cdes.db.dao.ConsortiumDAO;
import at.cdes.db.dao.NetworkDAO;
import at.cdes.db.dao.OrganisationDAO;
import at.cdes.db.dao.OrganisationPersonDAO;
import at.cdes.service.ConsortiumOperations;
import at.cdes.service.exception.ConsortiumNoOrganisationException;
import at.cdes.util.DLStringMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class ConsortiumOperationsImpl
implements ConsortiumOperations {
    private ConsortiumDAO consortiumDAO;
    private OrganisationDAO organisationDAO;
    private NetworkDAO networkDAO;
    private OrganisationPersonDAO organisationPersonDAO;

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    @Override
    public Organisation getConsortium(Integer id) {
        return this.consortiumDAO.get(id);
    }

    @Override
    public List getConsortiums(Integer networkId, Integer organisationPersonId, String filter) {
        Integer organisationId = null;
        if (organisationPersonId != null) {
            organisationId = this.organisationPersonDAO.get(organisationPersonId).getOrganisation().getId();
        }
        return this.consortiumDAO.getAll(networkId, organisationId, filter);
    }

    @Override
    public Organisation insertConsortium(Organisation con, List orgs, Integer networkId) throws RuntimeException {
        boolean selected = false;
        if (networkId != null) {
            Network network = this.networkDAO.get(networkId);
            con.setNetworks(new HashMap());
            con.getNetworks().put(network.getId(), network);
            network.getOrganisations().put(null, con);
        }
        con = this.consortiumDAO.save(con);
        con.setConsortiumHead(true);
        con.setConsortiumMembers(new HashMap());
        for (OrganisationWrapper wrap : orgs) {
            if (!wrap.isSelected()) continue;
            selected = true;
            Organisation member = this.organisationDAO.get(wrap.getId());
            member.getConsortiums().put(con.getId(), con);
            con.getConsortiumMembers().put(member.getId(), member);
            this.organisationDAO.update(member);
        }
        if (selected) {
            return this.consortiumDAO.merge(con);
        }
        throw new ConsortiumNoOrganisationException("Insert failed. No organisation was chosen for the consortium!");
    }

    @Override
    public void deleteConsortium(Organisation org) {
        this.consortiumDAO.delete(org);
    }

    @Override
    public Organisation updateConsortium(Organisation localCon, List orgs) {
        boolean selected = false;
        Organisation con = this.consortiumDAO.merge(localCon);
        con.setConsortiumHead(true);
        con.getConsortiumMembers().clear();
        for (OrganisationWrapper wrap : orgs) {
            if (!wrap.isSelected()) continue;
            selected = true;
            Organisation member = this.organisationDAO.get(wrap.getId());
            member.getConsortiums().put(con.getId(), con);
            con.getConsortiumMembers().put(member.getId(), member);
        }
        if (selected) {
            return this.consortiumDAO.update(con);
        }
        throw new ConsortiumNoOrganisationException("Update failed for consortium " + con.getName() + ". No organisation was chosen for the consortium!");
    }

    public void setConsortiumDAO(ConsortiumDAO consortiumDAO) {
        this.consortiumDAO = consortiumDAO;
    }

    public void setOrganisationDAO(OrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    private void copyConsortium(Organisation localCon, Organisation con) {
        con.setConsortiumHead(localCon.isConsortiumHead());
        con.setConsortiums(localCon.getConsortiums());
        con.setEmailAddress(localCon.getEmailAddress());
        con.setFacsimileNumber(localCon.getFacsimileNumber());
        con.setCountry(localCon.getCountry());
        con.setLocalityName(localCon.getLocalityName());
        con.setMobileTelephoneNumber(localCon.getMobileTelephoneNumber());
        con.setName(localCon.getName());
        con.setNetworks(localCon.getNetworks());
        con.setOrganisationPersons(localCon.getAllOrganisationPersons());
        con.setOwnNetworks(localCon.getOwnNetworks());
        con.setPostalAddress(localCon.getPostalAddress());
        con.setPostalCode(localCon.getPostalCode());
        con.setStateOrProvinceName(localCon.getStateOrProvinceName());
        con.setTelephoneNumber(localCon.getTelephoneNumber());
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    @Override
    public List getOtherNetworksConsortiums(Integer networkId, String filter) {
        List<Organisation> organisations = this.consortiumDAO.getOtherNetworksAllConsortiums(networkId, filter);
        ArrayList<Organisation> excludedOwn = new ArrayList<Organisation>();
        for (Organisation organisation : organisations) {
            if (organisation.getNetworks() == null || organisation.getNetworks().keySet().contains(networkId)) continue;
            excludedOwn.add(organisation);
        }
        return excludedOwn;
    }

    @Override
    public void addConsortiumToNetwork(Integer consortiumId, Integer networkId) {
        Organisation consortium = this.getConsortium(consortiumId);
        Network network = this.networkDAO.get(networkId);
        if (consortium.getNetworks() == null) {
            consortium.setNetworks(new HashMap());
        }
        consortium.getNetworks().put(networkId, network);
        if (network.getOrganisations() == null) {
            network.setOrganisations(new HashMap());
        }
        network.getOrganisations().put(consortiumId, consortium);
        Collection members = consortium.getConsortiumMembers().values();
        for (Organisation member : members) {
            network.getOrganisations().put(member.getId(), member);
        }
        this.networkDAO.merge(network);
        this.consortiumDAO.update(consortium);
    }

    @Override
    public List<Organisation> getPotentialConsortiaWithMatchingNames(String orgName, int maxDistance, Integer networkId, Integer activeConsId) {
        ArrayList<Organisation> ret = new ArrayList<Organisation>();
        List allOrgs = this.consortiumDAO.getAll(activeConsId == null ? null : networkId, null, null);
        for (Organisation org : allOrgs) {
            if (org.getId().equals(activeConsId) || !DLStringMatcher.valdiateDistance(org.getName().toLowerCase(), orgName.toLowerCase(), maxDistance)) continue;
            ret.add(org);
        }
        return ret;
    }
}

