/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.api.document.NumberCalculatorException;
import at.cdes.bo.data.HashedObject;
import at.cdes.bo.data.certificate.CDESCertificate;
import at.cdes.bo.data.cycle.ReviewCycleInstance;
import at.cdes.bo.data.cycle.ReviewCycleInstanceImpl;
import at.cdes.bo.data.cycle.ReviewCycleInstanceRelease;
import at.cdes.bo.data.cycle.cell.ReviewCycleCell;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstance;
import at.cdes.bo.data.document.AsBuiltDocumentTO;
import at.cdes.bo.data.document.BaseDocumentVersion;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.DocumentListImpl;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.label.LabelContent;
import at.cdes.bo.data.label.TextField;
import at.cdes.bo.data.network.MasterDataSet;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.network.NetworkType;
import at.cdes.bo.data.number.DocumentNumberPart;
import at.cdes.bo.data.object.AsBuiltObjectTO;
import at.cdes.bo.data.object.CDESObject;
import at.cdes.bo.data.object.CDESObjectImpl;
import at.cdes.bo.data.object.ObjectCodeComparator;
import at.cdes.bo.data.object.ObjectList;
import at.cdes.bo.data.object.ObjectListImpl;
import at.cdes.bo.data.object.ObjectPlanner;
import at.cdes.bo.data.object.ObjectPlannerDefinition;
import at.cdes.bo.data.object.ObjectPlannerDefinitionTemplate;
import at.cdes.bo.data.object.ObjectPlannerImpl;
import at.cdes.bo.data.object.ObjectPlannerPosition;
import at.cdes.bo.data.object.ObjectPlannerPositionDefinition;
import at.cdes.bo.data.object.ObjectPlannerPositionDefinitionTemplate;
import at.cdes.bo.data.object.ObjectPlannerPositionImpl;
import at.cdes.bo.data.object.ObjectType;
import at.cdes.bo.data.object.ObjectTypeDefault;
import at.cdes.bo.data.object.ReleasedCDESObject;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.object.ReleasedObjectListVersionComparator;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.object.ReleasedObjectPlannerPosition;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.data.role.Role;
import at.cdes.bo.data.sec.CDESSignature;
import at.cdes.bo.data.sec.DigestCalculatorType;
import at.cdes.bo.number.NumberCalculator;
import at.cdes.bo.object.ObjectListHelper;
import at.cdes.bo.sec.digest.DigestCalculator;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.DigestCalculatorFactory;
import at.cdes.bo.sec.signature.SignatureCalculator;
import at.cdes.bo.sec.signature.SignatureCalculatorException;
import at.cdes.bo.sec.signature.SignatureCalculatorFactory;
import at.cdes.controller.apiHelper.SubProjectCopyContainer;
import at.cdes.db.dao.DigestCalculatorDAO;
import at.cdes.db.dao.MasterDataSetDAO;
import at.cdes.db.dao.NetworkDAO;
import at.cdes.db.dao.ObjectDAO;
import at.cdes.db.dao.ObjectListDAO;
import at.cdes.db.dao.ObjectPlannerDAO;
import at.cdes.db.dao.ObjectPlannerDefinitionDAO;
import at.cdes.db.dao.ObjectTypeDAO;
import at.cdes.db.dao.OrganisationPersonDAO;
import at.cdes.db.dao.ProjectParticipationDAO;
import at.cdes.db.dao.SignatureDAO;
import at.cdes.db.dao.SubProjectDAO;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.service.ObjectOperations;
import at.cdes.service.PersonOperations;
import at.cdes.service.PlanDeliverCatalogueOperations;
import at.cdes.service.ProjectOperations;
import at.cdes.service.ReviewCycleOperations;
import at.cdes.service.ReviewOperations;
import at.cdes.service.TaskOperations;
import at.cdes.service.exception.ActionException;
import at.cdes.service.exception.DuplicateEntryException;
import at.cdes.service.exception.FrontendException;
import at.cdes.service.exception.MissingContractorRoleException;
import at.cdes.service.exception.ObjectListException;
import at.cdes.service.exception.WrongPasswordException;
import at.cdes.util.ConfigurationHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.clazzes.util.comparators.InvalidExpressionSyntaxException;
import org.clazzes.util.comparators.POJOComparatorFactory;
import org.clazzes.util.lang.Pair;
import org.xnap.commons.i18n.I18n;

public class ObjectOperationsImpl
implements ObjectOperations {
    private ObjectListDAO objectListDAO;
    private SubProjectDAO subProjectDAO;
    private ObjectDAO objectDAO;
    private DigestCalculatorFactory digestCalculatorFactory;
    private SignatureCalculatorFactory signatureCalculatorFactory;
    private SignatureDAO signatureDAO;
    private ObjectPlannerDAO objectPlannerDAO;
    private ReviewCycleOperations reviewCycleOperations;
    private TaskOperations taskOperations;
    private DigestCalculatorDAO digestCalculatorDAO;
    private ObjectPlannerDefinitionDAO objectPlannerDefinitionDAO;
    private NetworkDAO networkDAO;
    private ReviewOperations reviewOperations;
    private PlanDeliverCatalogueOperations planDeliverCatalogueOperations;
    private ObjectTypeDAO objectTypeDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private MasterDataSetDAO masterDataSetDAO;
    private ProjectOperations projectOperations;
    private PersonOperations personOperations;
    private ProjectParticipationDAO projectParticipationDAO;
    static Logger log = Logger.getLogger(ObjectOperationsImpl.class);

    public void setObjectTypeDAO(ObjectTypeDAO objectTypeDAO) {
        this.objectTypeDAO = objectTypeDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO orgPersonDAO) {
        this.organisationPersonDAO = orgPersonDAO;
    }

    public void setObjectListDAO(ObjectListDAO objectListDAO) {
        this.objectListDAO = objectListDAO;
    }

    public void setObjectDAO(ObjectDAO objectDAO) {
        this.objectDAO = objectDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setSignatureDAO(SignatureDAO signatureDAO) {
        this.signatureDAO = signatureDAO;
    }

    public void setObjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    public void setMasterDataSetDAO(MasterDataSetDAO masterDataSetDAO) {
        this.masterDataSetDAO = masterDataSetDAO;
    }

    public void setDigestCalculatorFactory(DigestCalculatorFactory digestCalculatorFactory) {
        this.digestCalculatorFactory = digestCalculatorFactory;
    }

    public void setSignatureCalculatorFactory(SignatureCalculatorFactory signatureCalculatorFactory) {
        this.signatureCalculatorFactory = signatureCalculatorFactory;
    }

    @Override
    public ObjectListImpl getObjectList(Integer objectListId) {
        return this.objectListDAO.getObjectListImpl(objectListId);
    }

    @Override
    public ReleasedObjectList getReleasedObjectList(Integer objectListId) {
        return this.objectListDAO.getReleasedObjectList(objectListId);
    }

    @Override
    public ReleasedObjectList getActiveObjectList(Integer subProjectId) {
        SubProject subProject = this.subProjectDAO.get(subProjectId);
        ReleasedObjectList list = subProject.getActiveObjectList();
        if (list == null) {
            return null;
        }
        return subProject.getActiveObjectList();
    }

    @Override
    public ObjectListImpl getUnreleasedObjectList(Integer subProjectId) {
        SubProject subProject = this.subProjectDAO.get(subProjectId);
        return subProject.getEditObjectList();
    }

    @Override
    public ObjectListImpl updateObjectList(ObjectListImpl objectList, List<CDESObjectImpl> updates, List<CDESObjectImpl> inserts, Integer organisationPersonId) {
        CDESObjectImpl object;
        Iterator<CDESObjectImpl> it = updates.iterator();
        OrganisationPerson orgPerson = this.organisationPersonDAO.get(organisationPersonId);
        while (it.hasNext()) {
            object = it.next();
            if (object.getModified() != 2) {
                object.setModified(1);
            }
            object.setModifiedDate(new Date(System.currentTimeMillis()));
            object.setModifiedBy(orgPerson);
            object.setComment("");
            this.objectDAO.update(object);
        }
        it = inserts.iterator();
        if (objectList.getObjects() == null || objectList.getObjects().isEmpty()) {
            objectList.setObjects(new HashMap());
        }
        while (it.hasNext()) {
            object = it.next();
            object.setObjectList(objectList);
            object.setModified(2);
            object.setInactive(false);
            object.setModifiedDate(new Date(System.currentTimeMillis()));
            object.setModifiedBy(orgPerson);
            object.setComment("");
            this.objectDAO.save(object);
            objectList.getObjects().put(object.getId(), object);
        }
        return objectList;
    }

    @Override
    public void releaseObjectList(ReleasedObjectList newReleasedObjectList, List reviewCyleInstances, CDESCertificate cert, ProjectParticipant signer, String password) throws WrongPasswordException, FrontendException {
        log.info((Object)("starting releaseObjectList id: [" + newReleasedObjectList.getId() + "], orgPersonId: [" + signer.getOrganisationPerson().getId() + " **********************"));
        ReleasedObjectList previous_release = this.subProjectDAO.get(newReleasedObjectList.getSubProject().getId()).getActiveObjectList();
        NumberCalculator numCalc = this.planDeliverCatalogueOperations.getDocumentNumberCalculator();
        boolean hasDocumentNumberPart = false;
        if (newReleasedObjectList.getSubProject().getProject().getDocumentNumberPartGroup() != null) {
            ArrayList docNumbers = new ArrayList(newReleasedObjectList.getSubProject().getProject().getDocumentNumberPartGroup().getParts().values());
            for (DocumentNumberPart docNumber : docNumbers) {
                if (!docNumber.getRule().contains(".object.codeWithoutType") && !docNumber.getRule().contains(".object.code") && !docNumber.getRule().contains(".object.objectType")) continue;
                hasDocumentNumberPart = true;
                break;
            }
        }
        ObjectListImpl actualObjectList = this.objectListDAO.getObjectListImpl(newReleasedObjectList.getObjectList().getId());
        Network network = actualObjectList.getSubProject().getProject().getNetwork();
        Iterator<Object> releasedObjectIt = newReleasedObjectList.getObjects().values().iterator();
        newReleasedObjectList.setSubProject(actualObjectList.getSubProject());
        newReleasedObjectList.setObjectList(actualObjectList);
        newReleasedObjectList.setDigest(null);
        newReleasedObjectList = this.objectListDAO.save(newReleasedObjectList);
        newReleasedObjectList.setObjects(new HashMap());
        log.info((Object)("ongoing releaseObjectList id: [" + newReleasedObjectList.getId() + "], project: [" + newReleasedObjectList.getSubProject().getProject().getName() + "], subProject: [" + newReleasedObjectList.getSubProject().getCode() + " " + newReleasedObjectList.getSubProject().getName()));
        reviewCyleInstances = this.reviewCycleOperations.releaseReviewCycleInstances(reviewCyleInstances, newReleasedObjectList);
        HashMap<Integer, Pair<Integer, Integer>> detachedReviewCycleInstances = new HashMap<Integer, Pair<Integer, Integer>>();
        int counterReleasedObjectIt = 0;
        while (releasedObjectIt.hasNext()) {
            ++counterReleasedObjectIt;
            ReleasedCDESObject newReleasedObject = (ReleasedCDESObject)releasedObjectIt.next();
            CDESObjectImpl objectImpl = this.objectDAO.getCDESObject(newReleasedObject.getObject().getId());
            newReleasedObject.setModified(objectImpl.getModified());
            newReleasedObject.setObjectList(newReleasedObjectList);
            newReleasedObject.setDigest(null);
            newReleasedObject.setObject(objectImpl);
            if (objectImpl.isInactive()) {
                ObjectPlannerImpl iOpImpl;
                log.info((Object)("ongoing releaseObjectList id: [" + newReleasedObjectList.getId() + "], objectImpl.isInactive: invalidateDocumentsVersionOfObject: id[" + objectImpl.getId() + "]"));
                this.reviewOperations.invalidateDocumentsVersionOfObject(objectImpl, cert, signer, password);
                Iterator iOpIt = null;
                iOpIt = objectImpl.getObjectPlanners().values().iterator();
                while (iOpIt != null && iOpIt.hasNext()) {
                    iOpImpl = (ObjectPlannerImpl)iOpIt.next();
                    this.planDeliverCatalogueOperations.invalidateDocumentsOfObjectPlanner(iOpImpl);
                }
                iOpIt = objectImpl.getInactivatedObjectPlanners().values().iterator();
                while (iOpIt != null && iOpIt.hasNext()) {
                    iOpImpl = (ObjectPlannerImpl)iOpIt.next();
                    this.planDeliverCatalogueOperations.invalidateDocumentsOfObjectPlanner(iOpImpl);
                }
                continue;
            }
            newReleasedObject.setId(null);
            newReleasedObjectList.getObjects().remove(objectImpl.getId());
            Iterator newReleasedObjectPlannerIt = null;
            if (newReleasedObject.getObjectPlanners() != null) {
                newReleasedObjectPlannerIt = newReleasedObject.getObjectPlanners().values().iterator();
                newReleasedObject.setObjectPlanners(new HashMap());
            }
            newReleasedObject = this.objectDAO.save(newReleasedObject);
            if (objectImpl.getReleasedVersions() == null) {
                objectImpl.setReleasedVersions(new HashMap());
            }
            objectImpl.getReleasedVersions().put(newReleasedObject.getId(), newReleasedObject);
            objectImpl.setModified(0);
            this.objectDAO.update(objectImpl);
            newReleasedObjectList.getObjects().put(newReleasedObject.getId(), newReleasedObject);
            ReleasedCDESObject oldReleasedObject = null;
            if (previous_release != null) {
                Collection prevReleasedObjects = previous_release.getObjects().values();
                for (ReleasedCDESObject prevRelObj : prevReleasedObjects) {
                    if (!prevRelObj.getObject().getId().equals(objectImpl.getId())) continue;
                    oldReleasedObject = prevRelObj;
                }
            }
            int counterReleasedObjectPlannerIt = 0;
            while (newReleasedObjectPlannerIt != null && newReleasedObjectPlannerIt.hasNext()) {
                ++counterReleasedObjectPlannerIt;
                ReleasedObjectPlanner newReleasedObjectPlanner = (ReleasedObjectPlanner)newReleasedObjectPlannerIt.next();
                ObjectPlannerImpl objectPlannerImpl = this.objectPlannerDAO.getObjectPlanner(newReleasedObjectPlanner.getObjectPlanner().getId());
                if (oldReleasedObject != null) {
                    boolean updateDocumentNames = false;
                    if (hasDocumentNumberPart && (oldReleasedObject.getCode() != null && !oldReleasedObject.getCode().equals(newReleasedObject.getCode()) || oldReleasedObject.getCodeWithoutType() != null && !oldReleasedObject.getCodeWithoutType().equals(newReleasedObject.getCodeWithoutType()) || oldReleasedObject.getObjectType() != null && !oldReleasedObject.getObjectType().equals(newReleasedObject.getObjectType()))) {
                        updateDocumentNames = true;
                    }
                    Collection prevReleasedObjectPlanners = oldReleasedObject.getObjectPlanners().values();
                    for (ReleasedObjectPlanner prevRelOP : prevReleasedObjectPlanners) {
                        if (prevRelOP.getObjectPlanner().getId().equals(objectPlannerImpl.getId()) && prevRelOP.getReviewCycleInstance() != null && objectPlannerImpl.getReviewCycleInstance() != null && !((ReviewCycleInstanceRelease)prevRelOP.getReviewCycleInstance()).getReviewCycleInstance().getId().equals(objectPlannerImpl.getReviewCycleInstance().getId())) {
                            detachedReviewCycleInstances.put(objectPlannerImpl.getReviewCycleInstance().getId(), new Pair((Object)objectPlannerImpl.getReviewCycleInstance().getId(), (Object)((ReviewCycleInstanceRelease)prevRelOP.getReviewCycleInstance()).getReviewCycleInstance().getId()));
                        }
                        if (!updateDocumentNames) continue;
                        for (DocumentImpl doc : prevRelOP.getDocuments().values()) {
                            try {
                                String oldName = doc.getName();
                                String newName = numCalc.getNumber((Document)doc, newReleasedObjectList.getSubProject().getProject(), newReleasedObjectPlanner, false);
                                doc.setName(newName);
                                log.info((Object)("document name was changed from " + oldName + " to " + newName));
                            }
                            catch (NumberCalculatorException e) {
                                log.error((Object)e);
                            }
                        }
                    }
                }
                if (objectPlannerImpl.isInactive()) {
                    log.info((Object)("ongoing releaseObjectList id: [" + newReleasedObjectList.getId() + "], objectPlannerImpl.isInactive: invalidateDocumentsVersionOfObjectPlanner id[" + objectPlannerImpl.getId() + "]"));
                    this.reviewOperations.invalidateDocumentsVersionOfObjectPlanner(objectPlannerImpl, cert, signer, password);
                    continue;
                }
                newReleasedObjectPlanner.setObject(newReleasedObject);
                newReleasedObjectPlanner.setObjectPlanner(objectPlannerImpl);
                newReleasedObjectPlanner.setPlanner(objectPlannerImpl.getPlanner());
                newReleasedObjectPlanner.setChanged(objectPlannerImpl.getChanged());
                newReleasedObjectPlanner.setId(null);
                if (objectPlannerImpl.getReviewCycleInstance() == null) {
                    log.error((Object)("Found no reviewCycleInstance for objectPlanner [" + objectPlannerImpl.getId() + "]"));
                    throw new ObjectListException(4);
                }
                ReviewCycleInstanceRelease instance = this.reviewCycleOperations.getReleased(newReleasedObjectList.getId(), objectPlannerImpl.getReviewCycleInstance().getId());
                newReleasedObjectPlanner.setReviewCycleInstance(instance);
                newReleasedObject.getObjectPlanners().remove(objectPlannerImpl.getId());
                ArrayList positions = new ArrayList();
                if (objectPlannerImpl.getPositions() != null) {
                    positions.addAll(objectPlannerImpl.getPositions().values());
                }
                newReleasedObjectPlanner.setPositions(new HashMap());
                newReleasedObjectPlanner = this.objectPlannerDAO.save(newReleasedObjectPlanner);
                for (ObjectPlannerPositionImpl pos : positions) {
                    ReleasedObjectPlannerPosition posRel = new ReleasedObjectPlannerPosition();
                    posRel.setObjectPlanner(newReleasedObjectPlanner);
                    posRel.setObjectPlannerPositionDefinition(pos.getObjectPlannerPositionDefinition());
                    posRel.setProjectParticipation(pos.getProjectParticipation());
                    posRel.setRole(pos.getRole());
                    posRel = this.objectPlannerDAO.save(posRel);
                    if (newReleasedObjectPlanner.getPositions() == null) {
                        newReleasedObjectPlanner.setPositions(new HashMap());
                    }
                    newReleasedObjectPlanner.getPositions().put(posRel.getId(), posRel);
                    newReleasedObjectPlanner = this.objectPlannerDAO.update(newReleasedObjectPlanner);
                }
                if (objectPlannerImpl.getReleasedVersions() == null) {
                    objectPlannerImpl.setReleasedVersions(new HashMap());
                }
                objectPlannerImpl.getReleasedVersions().put(newReleasedObjectPlanner.getId(), newReleasedObjectPlanner);
                objectPlannerImpl.setChanged(0);
                this.objectPlannerDAO.update(objectPlannerImpl);
                newReleasedObjectPlanner.setDigest(null);
                if (newReleasedObject.getObjectPlanners() == null) {
                    newReleasedObject.setObjectPlanners(new HashMap());
                }
                newReleasedObject.getObjectPlanners().put(newReleasedObjectPlanner.getId(), newReleasedObjectPlanner);
                this.objectDAO.update(newReleasedObject);
            }
            log.info((Object)("ongoing releaseObjectList id: [" + newReleasedObjectList.getId() + "], finished newReleasedObjectPlannerIt, counter:[" + counterReleasedObjectPlannerIt + "]"));
            if (objectImpl.getInactivatedObjectPlanners() == null) continue;
            Iterator iOpIt = null;
            iOpIt = objectImpl.getInactivatedObjectPlanners().values().iterator();
            while (iOpIt != null && iOpIt.hasNext()) {
                ObjectPlannerImpl iOpImpl = (ObjectPlannerImpl)iOpIt.next();
                if (!iOpImpl.isInactive()) continue;
                log.info((Object)("ongoing releaseObjectList id: [" + newReleasedObjectList.getId() + "], iOpImpl.isInactive, invalidateDocumentsVersionOfObjectPlanner iOpImplId:[" + iOpImpl.getId() + "]"));
                this.reviewOperations.invalidateDocumentsVersionOfObjectPlanner(iOpImpl, cert, signer, password);
                this.planDeliverCatalogueOperations.invalidateDocumentsOfObjectPlanner(iOpImpl);
            }
        }
        log.info((Object)("ongoing releaseObjectList id: [" + newReleasedObjectList.getId() + "], finished releasedObjectIt, counter:[" + counterReleasedObjectIt + "]"));
        log.info((Object)("ongoing releaseObjectList id: [" + newReleasedObjectList.getId() + "], starting createSignature"));
        try {
            DigestCalculator hc = this.digestCalculatorFactory.getDigestCalculator(network, newReleasedObjectList);
            DigestCalculatorType type = this.digestCalculatorDAO.get(hc.getClass().getName());
            newReleasedObjectList.setDigest(hc.getDigest(newReleasedObjectList));
            newReleasedObjectList.setDigestCalculatorType(type);
            this.objectListDAO.update(newReleasedObjectList);
            for (HashedObject object : newReleasedObjectList.getObjects().values()) {
                ((ReleasedCDESObject)object).setDigest(hc.getDigest(object));
                ((ReleasedCDESObject)object).setDigestCalculatorType(type);
                this.objectDAO.update((ReleasedCDESObject)object);
                Iterator obIt = null;
                if (((ReleasedCDESObject)object).getObjectPlanners() != null && !((ReleasedCDESObject)object).getObjectPlanners().isEmpty()) {
                    obIt = ((ReleasedCDESObject)object).getObjectPlanners().values().iterator();
                }
                while (obIt != null && obIt.hasNext()) {
                    ReleasedObjectPlanner releaseOp = (ReleasedObjectPlanner)obIt.next();
                    releaseOp.setDigest(hc.getDigest(releaseOp));
                    releaseOp.setDigestCalculatorType(type);
                    this.objectPlannerDAO.update(releaseOp);
                }
            }
            for (HashedObject object : reviewCyleInstances) {
                ((ReviewCycleInstanceRelease)object).setDigest(hc.getDigest(object));
                ((ReviewCycleInstanceRelease)object).setDigestCalculatorType(type);
                this.reviewCycleOperations.updateReviewCycleInstanceRelease((ReviewCycleInstanceRelease)object);
            }
            String toSign = new String(hc.getSignableContent(newReleasedObjectList));
            toSign = toSign + hc.getSignableContent(reviewCyleInstances);
            SignatureCalculator sc = this.signatureCalculatorFactory.getSignatureCalculator(network, newReleasedObjectList);
            CDESSignature signature = sc.createSignature(signer, toSign, cert, password);
            signature = this.signatureDAO.save(signature);
            newReleasedObjectList.setSignature(signature);
            newReleasedObjectList = this.objectListDAO.update(newReleasedObjectList);
        }
        catch (DigestCalculatorException e) {
            throw new ActionException("ObjectList Release", e);
        }
        catch (SignatureCalculatorException e) {
            throw new ActionException("ObjectList Release", e);
        }
        log.info((Object)("ongoing releaseObjectList id: [" + newReleasedObjectList.getId() + "], finished createSignature"));
        actualObjectList.setVersion(actualObjectList.getVersion() + 1);
        this.objectListDAO.update(actualObjectList);
        SubProject subProject = newReleasedObjectList.getSubProject();
        if (subProject.getReleasedObjectLists() == null) {
            subProject.setReleasedObjectLists(new TreeSet(new ReleasedObjectListVersionComparator()));
        }
        subProject.getReleasedObjectLists().add(newReleasedObjectList);
        this.subProjectDAO.update(subProject);
        log.info((Object)("ongoing releaseObjectList id: [" + newReleasedObjectList.getId() + "], starting updateReviewTasks2"));
        if (previous_release != null) {
            this.taskOperations.updateReviewTasks2(previous_release, newReleasedObjectList, detachedReviewCycleInstances);
        }
        log.info((Object)("ongoing releaseObjectList id: [" + newReleasedObjectList.getId() + "], finished updateReviewTasks2"));
        log.info((Object)("ongoing releaseObjectList id: [" + newReleasedObjectList.getId() + "], starting invalidateAllMarkedProjectParticipations"));
        log.info((Object)("ongoing releaseObjectList id: [" + newReleasedObjectList.getId() + "], finished releaseObjectList **********************"));
    }

    @Override
    public ReleasedObjectList createReleaseable(ObjectListImpl objectList) {
        ReleasedObjectList released = new ReleasedObjectList();
        released.initRelease(objectList);
        Iterator<CDESObject> it = ObjectListHelper.getAllObjectsSortedByCode(objectList).iterator();
        released.setDigest(null);
        released.setObjects(new HashMap());
        while (it.hasNext()) {
            CDESObjectImpl oldObject = (CDESObjectImpl)it.next();
            ReleasedCDESObject object = new ReleasedCDESObject(oldObject);
            object.setObjectList(released);
            object.setDigest(null);
            released.getObjects().put(-oldObject.getId().intValue(), object);
            for (ObjectPlannerImpl opImpl : oldObject.getObjectPlanners().values()) {
                ReleasedObjectPlanner releaseOp = new ReleasedObjectPlanner(opImpl);
                releaseOp.setObject(object);
                releaseOp.setDigest(null);
                if (object.getObjectPlanners() == null) {
                    object.setObjectPlanners(new HashMap());
                }
                object.getObjectPlanners().put(-opImpl.getId().intValue(), releaseOp);
                Collection positions = opImpl.getPositions().values();
                for (ObjectPlannerPositionImpl position : positions) {
                    ReleasedObjectPlannerPosition releasePos = new ReleasedObjectPlannerPosition(position);
                    releasePos.setObjectPlanner(releaseOp);
                    if (releaseOp.getPositions() == null) {
                        releaseOp.setPositions(new HashMap());
                    }
                    releaseOp.getPositions().put(-position.getId().intValue(), releasePos);
                }
            }
        }
        return released;
    }

    @Override
    public ObjectPlannerImpl getUnreleasedObjectPlanner(Integer id) {
        return this.objectPlannerDAO.getObjectPlanner(id);
    }

    @Override
    public ReleasedObjectPlanner getReleasedObjectPlanner(Integer id, boolean checkProjectsAllowedFinalReviewCycleCell) {
        if (checkProjectsAllowedFinalReviewCycleCell) {
            ReleasedObjectPlanner releasedObjectPlanner = this.objectPlannerDAO.getReleasedObjectPlanner(id);
            ReviewCycleInstanceRelease validReviewCycleRelInstance = this.reviewCycleOperations.getReleasedReviewCycleInstance(releasedObjectPlanner.getReviewCycleInstance().getId(), true);
            releasedObjectPlanner.setReviewCycleInstance(validReviewCycleRelInstance);
            return releasedObjectPlanner;
        }
        return this.objectPlannerDAO.getReleasedObjectPlanner(id);
    }

    @Override
    public ObjectPlannerImpl insertObjectPlanner(ObjectPlannerImpl ob) {
        return this.objectPlannerDAO.save(ob);
    }

    @Override
    public ObjectPlannerImpl updateObjectPlanner(ObjectPlannerImpl ob) {
        return this.objectPlannerDAO.update(ob);
    }

    @Override
    public ObjectPlannerImpl getObjectPlanner(Integer id) {
        return this.objectPlannerDAO.getObjectPlanner(id);
    }

    @Override
    public void deleteObjectPlanner(ObjectPlannerImpl ob) {
        this.objectPlannerDAO.delete(ob);
    }

    @Override
    public CDESObjectImpl getUnreleasedObject(Integer id) {
        return this.objectDAO.getCDESObject(id);
    }

    public void setReviewCycleOperations(ReviewCycleOperations reviewCycleOperations) {
        this.reviewCycleOperations = reviewCycleOperations;
    }

    public void setTaskOperations(TaskOperations taskOperations) {
        this.taskOperations = taskOperations;
    }

    @Override
    public ReleasedObjectPlanner getReleasedObjectPlannerFromList(Integer unreleasedObjectPlannerId, Integer releasedObjectListId) {
        return this.objectPlannerDAO.getReleasedObjectPlanner(releasedObjectListId, unreleasedObjectPlannerId);
    }

    public void setDigestCalculatorDAO(DigestCalculatorDAO digestCalculatorDAO) {
        this.digestCalculatorDAO = digestCalculatorDAO;
    }

    @Override
    public CDESObjectImpl insertObject(Integer unreleasedObjectListId, CDESObjectImpl object, Collection<ObjectPlannerImpl> updates, Integer organisationPersonId, Collection<ObjectPlannerPositionImpl> positions) throws DuplicateEntryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Called insertObject");
        }
        OrganisationPerson orgPerson = this.organisationPersonDAO.get(organisationPersonId);
        ObjectListImpl objectList = this.objectListDAO.getObjectListImpl(unreleasedObjectListId);
        if (log.isDebugEnabled()) {
            log.debug((Object)".... Fetched objectList");
        }
        object.setObjectList(objectList);
        object.setModified(2);
        object.setModifiedDate(new Date(System.currentTimeMillis()));
        object.setModifiedBy(orgPerson);
        object.setInactive(false);
        if (log.isDebugEnabled()) {
            log.debug((Object)".... Set properties");
        }
        object = this.objectDAO.save(object);
        if (log.isDebugEnabled()) {
            log.debug((Object)".... Called save()");
        }
        objectList.getObjects().put(object.getId(), object);
        if (log.isDebugEnabled()) {
            log.debug((Object)".... put into objectList");
        }
        return this.updateObject(object, updates, null, organisationPersonId, positions);
    }

    @Override
    public void inactivateObject(CDESObjectImpl object) {
        object.setInactive(true);
        this.objectDAO.update(object);
        ArrayList<ObjectPlannerImpl> planners = new ArrayList<ObjectPlannerImpl>(object.getAllObjectPlanners());
        for (ObjectPlannerImpl planner : planners) {
            this.inactivateObjectPlanner(planner);
        }
    }

    @Override
    public void inactivateObjectPlanner(ObjectPlannerImpl planner) {
        planner.setInactive(true);
        this.objectPlannerDAO.update(planner);
        CDESObjectImpl obj = (CDESObjectImpl)planner.getObject();
        obj.getObjectPlanners().remove(planner.getId());
        if (obj.getInactivatedObjectPlanners() == null) {
            obj.setInactivatedObjectPlanners(new HashMap());
        }
        obj.getInactivatedObjectPlanners().put(planner.getId(), planner);
        this.objectDAO.update(obj);
    }

    @Override
    public CDESObjectImpl updateObject(CDESObjectImpl object, Collection<ObjectPlannerImpl> updates, List deletedObjectPlannerKeys, Integer organisationPersonId, Collection<ObjectPlannerPositionImpl> positions) throws DuplicateEntryException {
        ReleasedObjectList relOList;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Set updateObject");
        }
        if (ObjectListHelper.containsObjectCode(object.getObjectList(), object)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Throwing DuplicateEntryExceptino for " + object.getCode()));
            }
            throw new DuplicateEntryException("Code", object.getCode());
        }
        if (object.getObjectPlanners() == null) {
            object.setObjectPlanners(new HashMap());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"About to update positions");
        }
        ArrayList<ObjectPlannerPositionImpl> updatePositions = new ArrayList<ObjectPlannerPositionImpl>();
        if (updates != null) {
            if (positions != null) {
                for (ObjectPlannerPositionImpl position : positions) {
                    if (position.getProjectParticipation() == null) {
                        if (position.getId() == null || position.getId() <= 0) continue;
                        for (ObjectPlannerImpl impl : updates) {
                            if (!impl.getId().equals(position.getObjectPlanner().getId())) continue;
                            impl.getPositions().remove(position.getId());
                        }
                        this.objectPlannerDAO.delete(this.objectPlannerDAO.getObjectPlannerPositionImpl(position.getId()));
                        continue;
                    }
                    updatePositions.add(position);
                }
            }
            for (ObjectPlannerImpl impl : updates) {
                impl.setObject(object);
                if (impl.getCode() == null || impl.getCode().length() < 1 || impl.getArea() == null || impl.getCode().length() < 1) continue;
                impl = impl.getId() == null || impl.getId() < 1 ? this.objectPlannerDAO.save(impl) : this.objectPlannerDAO.update(impl);
                object.getObjectPlanners().put(impl.getId(), impl);
                this.objectPlannerDAO.update(impl);
            }
            if (updatePositions != null) {
                for (ObjectPlannerPositionImpl position : updatePositions) {
                    position.setRole(position.getProjectParticipation().getRole());
                    if (position.getId() == null || position.getId() < 1) {
                        position = this.objectPlannerDAO.save(position);
                        continue;
                    }
                    position = this.objectPlannerDAO.update(position);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"about to process deletedObjectPlanerKeys");
        }
        if (deletedObjectPlannerKeys != null) {
            for (int i = 0; i < deletedObjectPlannerKeys.size(); ++i) {
                Integer id = (Integer)deletedObjectPlannerKeys.get(i);
                ObjectPlannerImpl op = this.getUnreleasedObjectPlanner(id);
                if (op == null) continue;
                if (op.getReleasedVersions() != null && !op.getReleasedVersions().isEmpty()) {
                    CDESObjectImpl obj = (CDESObjectImpl)op.getObject();
                    this.inactivateObjectPlanner(op);
                    if (obj.getInactivatedObjectPlanners() != null) {
                        object.setInactivatedObjectPlanners(new HashMap());
                    }
                    obj.getInactivatedObjectPlanners().put(op.getId(), op);
                } else {
                    this.deleteObjectPlanner(op);
                }
                object.getObjectPlanners().remove(op.getId());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)".... done.");
        }
        if ((relOList = this.getActiveObjectList(object.getObjectList().getSubProject().getId())) != null) {
            ReleasedCDESObject activeObject = this.getReleasedObjectFromActiveObjectList(object.getId(), object.getObjectList().getSubProject().getId());
            object.setModified(this.getObjectChange(object, relOList, activeObject));
        }
        object.setModifiedDate(new Date(System.currentTimeMillis()));
        object.setModifiedBy(this.organisationPersonDAO.get(organisationPersonId));
        if (log.isDebugEnabled()) {
            log.debug((Object)"About to call objectDAO.update");
        }
        this.objectDAO.update(object);
        if (log.isDebugEnabled()) {
            log.debug((Object)".... done.");
        }
        ArrayList planners = new ArrayList(object.getObjectPlanners().values());
        for (ObjectPlannerImpl planner : planners) {
            if (relOList != null) {
                ReleasedObjectPlanner releasedPlanner = this.objectPlannerDAO.getReleasedObjectPlanner(relOList.getId(), planner.getId());
                planner.setChanged(this.getObjectPlannerChange(planner, releasedPlanner));
            }
            this.objectPlannerDAO.update(planner);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"updated objectPlanners");
        }
        return this.objectDAO.update(object);
    }

    @Override
    public void deleteObjectPlannerEntry(Integer objectPlannerId) {
        ObjectPlannerImpl objectPlanner = this.getObjectPlanner(objectPlannerId);
        CDESObjectImpl object = this.getUnreleasedObject(objectPlanner.getObject().getId());
        if (objectPlanner.getReleasedVersions() != null && !objectPlanner.getReleasedVersions().isEmpty()) {
            this.inactivateObjectPlanner(objectPlanner);
        } else {
            ArrayList objectPlannerPositions = new ArrayList(objectPlanner.getPositions().values());
            if (!objectPlannerPositions.isEmpty()) {
                for (ObjectPlannerPositionImpl position : objectPlannerPositions) {
                    this.deleteObjectPlannerPosition(position);
                }
            }
            this.deleteObjectPlanner(objectPlanner);
        }
    }

    @Override
    public void deleteObjectListById(Integer editObjectListId) {
        Iterator it;
        ObjectListImpl editObjectList = this.getObjectList(editObjectListId);
        if (editObjectList.getObjects() != null) {
            it = editObjectList.getObjects().values().iterator();
            while (it.hasNext()) {
                this.deleteObject(((CDESObjectImpl)it.next()).getId());
            }
        }
        if (editObjectList.getInactivatedObjects() != null) {
            it = editObjectList.getInactivatedObjects().values().iterator();
            while (it.hasNext()) {
                this.deleteObject(((CDESObjectImpl)it.next()).getId());
            }
        }
        editObjectList.getObjects().clear();
        this.objectListDAO.delete(editObjectList);
    }

    @Override
    public void deleteObject(Integer objectId) {
        CDESObjectImpl object = this.objectDAO.getCDESObject(objectId);
        if (object.getObjectPlanners() != null) {
            for (ObjectPlannerImpl planner : object.getObjectPlanners().values()) {
                if (planner.getPositions() != null || planner.getPositions().size() > 0) {
                    for (ObjectPlannerPositionImpl position : planner.getPositionsSortedByName()) {
                        this.objectPlannerDAO.delete(position);
                    }
                }
                this.delete(planner);
            }
        }
        this.objectDAO.delete(object);
    }

    public void delete(ObjectPlannerImpl objectPlanner) {
        this.objectPlannerDAO.delete(objectPlanner);
    }

    @Override
    public ReleasedCDESObject getReleasedObject(Integer id) {
        return this.objectDAO.getReleasedCDESObject(id);
    }

    public void setObjectPlannerDefinitionDAO(ObjectPlannerDefinitionDAO objectPlannerDefinitionDAO) {
        this.objectPlannerDefinitionDAO = objectPlannerDefinitionDAO;
    }

    @Override
    public ObjectPlannerDefinitionTemplate getObjectPlannerDefinitionTemplate(Integer id) {
        return this.objectPlannerDefinitionDAO.getObjectPlannerDefinitionTemplate(id);
    }

    @Override
    public ObjectPlannerDefinitionTemplate saveObjectPlannerDefinitionTemplate(ObjectPlannerDefinitionTemplate t, Collection<ObjectPlannerPositionDefinitionTemplate> positions, List<Integer> networks) {
        t = this.objectPlannerDefinitionDAO.save(t);
        return this.updateObjectPlannerDefinitionTemplate(t, positions, null, networks, null);
    }

    @Override
    public ObjectPlannerDefinitionTemplate updateObjectPlannerDefinitionTemplate(ObjectPlannerDefinitionTemplate t, Collection<ObjectPlannerPositionDefinitionTemplate> positions, Collection<Integer> deletedPositions, List<Integer> networks, List<Integer> deletedNetworks) {
        int i;
        if ((t = this.objectPlannerDefinitionDAO.update(t)).getNetworks() == null) {
            t.setNetworks(new HashMap());
        }
        for (i = 0; i < networks.size(); ++i) {
            Network n = this.networkDAO.get(networks.get(i));
            t.getNetworks().put(n.getId(), n);
            if (n.getObjectPlannerDefinitions() == null) {
                n.setObjectPlannerDefinitions(new HashMap());
            }
            n.getObjectPlannerDefinitions().put(t.getId(), t);
            this.networkDAO.save(n);
        }
        if (deletedNetworks != null) {
            for (i = 0; i < deletedNetworks.size(); ++i) {
                t.getNetworks().remove(deletedNetworks.get(i));
            }
        }
        if (t.getPositions() == null) {
            t.setPositions(new HashMap());
        }
        if (positions != null) {
            for (ObjectPlannerPositionDefinitionTemplate position : positions) {
                if (position.getName() == null || position.getRoleType() == null || deletedPositions != null && deletedPositions.contains(position.getId())) continue;
                position.setObjectPlannerDefinition(t);
                if (position.getId() == null || position.getId() < 1) {
                    position = this.objectPlannerDefinitionDAO.save(position);
                    t.getPositions().put(position.getId(), position);
                    continue;
                }
                this.objectPlannerDefinitionDAO.update(position);
            }
        }
        if (deletedPositions != null) {
            for (Integer id : deletedPositions) {
                ObjectPlannerPositionDefinitionTemplate pos = this.objectPlannerDefinitionDAO.getObjectPlannerPositionDefinitionTemplate(id);
                this.objectPlannerDefinitionDAO.delete(pos);
                t.getPositions().remove(id);
            }
        }
        return this.objectPlannerDefinitionDAO.update(t);
    }

    @Override
    public void deleteObjectPlannerDefinitionTemplate(Integer id) {
        ObjectPlannerDefinitionTemplate t = this.objectPlannerDefinitionDAO.getObjectPlannerDefinitionTemplate(id);
        if (t.getPositions() != null && !t.getPositions().isEmpty()) {
            Set positions = t.getPositions().keySet();
            for (Integer posId : positions) {
                ObjectPlannerPositionDefinitionTemplate pos = this.objectPlannerDefinitionDAO.getObjectPlannerPositionDefinitionTemplate(posId);
                this.objectPlannerDefinitionDAO.delete(pos);
            }
            t.getPositions().clear();
        }
        t.getNetworks().clear();
        this.objectPlannerDefinitionDAO.delete(t);
    }

    @Override
    public ObjectPlannerDefinition getObjectPlannerDefinitionByProject(Integer projectId) {
        ObjectPlannerDefinition t = this.objectPlannerDefinitionDAO.getObjectPlannerDefinitionByProject(projectId);
        return t;
    }

    @Override
    public void deleteObjectPlannerDefinitionByProject(Integer projectId) {
        ObjectPlannerDefinition t = this.objectPlannerDefinitionDAO.getObjectPlannerDefinitionByProject(projectId);
        if (t != null) {
            if (t.getPositions() != null && !t.getPositions().isEmpty()) {
                Set positions = t.getPositions().keySet();
                for (Integer posId : positions) {
                    ObjectPlannerPositionDefinition pos = this.objectPlannerDefinitionDAO.getObjectPlannerPositionDefinition(posId);
                    this.objectPlannerDefinitionDAO.delete(pos);
                }
                t.getPositions().clear();
            }
            this.objectPlannerDefinitionDAO.delete(t);
        }
    }

    @Override
    public void deleteObjectPlannerDefinition(Integer id) {
        ObjectPlannerDefinition t = this.objectPlannerDefinitionDAO.getObjectPlannerDefinition(id);
        if (t.getPositions() != null && !t.getPositions().isEmpty()) {
            Set positions = t.getPositions().keySet();
            for (Integer posId : positions) {
                ObjectPlannerPositionDefinition pos = this.objectPlannerDefinitionDAO.getObjectPlannerPositionDefinition(posId);
                this.objectPlannerDefinitionDAO.delete(pos);
            }
            t.getPositions().clear();
        }
        this.objectPlannerDefinitionDAO.delete(t);
    }

    @Override
    public ObjectPlannerDefinition getObjectPlannerDefinition(Integer id) {
        return this.objectPlannerDefinitionDAO.getObjectPlannerDefinition(id);
    }

    @Override
    public ObjectPlannerDefinition saveObjectPlannerDefinition(ObjectPlannerDefinition t, Collection<ObjectPlannerPositionDefinition> positions) {
        t = this.objectPlannerDefinitionDAO.save(t);
        return this.updateObjectPlannerDefinition(t, positions, null);
    }

    @Override
    public ObjectPlannerDefinition updateObjectPlannerDefinition(ObjectPlannerDefinition t, Collection<ObjectPlannerPositionDefinition> positions, Collection<Integer> deletedPositions) {
        if (t.getPositions() == null) {
            t.setPositions(new HashMap());
        }
        if (positions != null) {
            for (ObjectPlannerPositionDefinition position : positions) {
                log.info((Object)("Processing positionName [" + position.getName() + "]"));
                if (position.getName() == null || position.getName().isEmpty() || position.getRoleType() == null || deletedPositions != null && deletedPositions.contains(position.getId())) continue;
                position.setObjectPlannerDefinition(t);
                if (position.getId() == null || position.getId() < 1) {
                    position = this.objectPlannerDefinitionDAO.save(position);
                    t.getPositions().put(position.getId(), position);
                    continue;
                }
                this.objectPlannerDefinitionDAO.update(position);
            }
        }
        if (deletedPositions != null) {
            for (Integer id : deletedPositions) {
                ObjectPlannerPositionDefinition pos = this.objectPlannerDefinitionDAO.getObjectPlannerPositionDefinition(id);
                this.objectPlannerDefinitionDAO.delete(pos);
                t.getPositions().remove(id);
            }
        }
        return this.objectPlannerDefinitionDAO.update(t);
    }

    @Override
    public ObjectPlannerPositionDefinition getObjectPlannerPositionDefinition(Integer id) {
        return this.objectPlannerDefinitionDAO.getObjectPlannerPositionDefinition(id);
    }

    @Override
    public void deleteObjectPlannerPositionDefinition(Integer oppdId) {
        ObjectPlannerPositionDefinition oppd = this.objectPlannerDefinitionDAO.getObjectPlannerPositionDefinition(oppdId);
        this.objectPlannerDefinitionDAO.delete(oppd);
    }

    @Override
    public Collection<ObjectPlannerDefinitionTemplate> getObjectPlannerDefinitionTemplates() {
        return this.objectPlannerDefinitionDAO.getAllObjectPlannerDefinitionTemplates();
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    @Override
    public ObjectPlannerDefinition createObjectPlannerDefinitionFromTemplate(Integer objectPlannerDefTemplateId, Project project, String name) {
        ObjectPlannerDefinitionTemplate t = objectPlannerDefTemplateId != null ? this.objectPlannerDefinitionDAO.getObjectPlannerDefinitionTemplate(objectPlannerDefTemplateId) : null;
        ObjectPlannerDefinition def = new ObjectPlannerDefinition();
        def.setName(name == null ? t.getName() : name);
        def.setProject(project);
        def.setTemplate(t);
        def = this.objectPlannerDefinitionDAO.save(def);
        def.setPositions(new HashMap());
        if (t != null && t.getPositions() != null) {
            Collection positions = t.getPositions().values();
            for (ObjectPlannerPositionDefinitionTemplate position : positions) {
                ObjectPlannerPositionDefinition pos = new ObjectPlannerPositionDefinition();
                pos.setName(position.getName());
                pos.setObjectPlannerDefinition(def);
                pos.setRoleType(position.getRoleType());
                pos.setStatusNotification(position.getStatusNotification());
                pos = this.objectPlannerDefinitionDAO.save(pos);
                def.getPositions().put(pos.getId(), pos);
            }
        }
        def.setProject(project);
        return this.objectPlannerDefinitionDAO.update(def);
    }

    @Override
    public void deleteObjectPlannerPosition(ObjectPlannerPositionImpl position) {
        this.objectPlannerDAO.delete(position);
    }

    public void setReviewOperations(ReviewOperations reviewOperations) {
        this.reviewOperations = reviewOperations;
    }

    public void setPlanDeliverCatalogueOperations(PlanDeliverCatalogueOperations planDeliverCatalogueOperations) {
        this.planDeliverCatalogueOperations = planDeliverCatalogueOperations;
    }

    @Override
    public ReleasedCDESObject getReleasedObjectFromActiveObjectList(Integer objectId, Integer subProjectId) {
        ReleasedObjectList olist = this.subProjectDAO.get(subProjectId).getActiveObjectList();
        if (olist == null) {
            return null;
        }
        ArrayList objects = new ArrayList(olist.getObjects().values());
        for (ReleasedCDESObject object : objects) {
            if (!object.getObject().getId().equals(objectId)) continue;
            return object;
        }
        return null;
    }

    @Override
    public ReleasedObjectPlanner getReleasedObjectPlannerFromActiveObjectList(Integer objectPlannerId, Integer subProjectId) {
        ReleasedObjectList olist = null;
        try {
            olist = this.subProjectDAO.get(subProjectId).getActiveObjectList();
            return this.getReleasedObjectPlannerFromList(objectPlannerId, olist.getId());
        }
        catch (Exception e) {
            log.error((Object)("Caught Exception while calling getReleasedObjectPlannerFromList.  objectPlannerId = [" + objectPlannerId + "]; subProjectId = [" + subProjectId + "]; olist = [" + (olist == null ? "null" : olist.getId()) + "]"));
            throw e;
        }
    }

    @Override
    public ReleasedObjectPlanner getActiveReleasedObjectPlanner(Integer objectPlannerId) {
        ReleasedObjectList olist = this.getObjectPlanner(objectPlannerId).getObject().getObjectList().getSubProject().getActiveObjectList();
        if (olist == null) {
            return null;
        }
        ArrayList objects = new ArrayList(olist.getObjects().values());
        for (ReleasedCDESObject object : objects) {
            ArrayList objectPlanners = new ArrayList(object.getObjectPlanners().values());
            for (ReleasedObjectPlanner planner : objectPlanners) {
                if (!planner.getObjectPlanner().getId().equals(objectPlannerId)) continue;
                return planner;
            }
        }
        return null;
    }

    @Override
    public List getReleasedObjectListsByProject(Integer projectId) {
        return this.objectListDAO.getReleasedObjectListsByProject(projectId);
    }

    private int getObjectChange(CDESObjectImpl object, ReleasedObjectList relOList, ReleasedCDESObject activeObject) {
        if (object.getModified() == 2 || activeObject == null) {
            return 2;
        }
        if (!(object.getCode().equals(activeObject.getCode()) && object.getName().equals(activeObject.getName()) && object.getKms().equals(activeObject.getKms()))) {
            return 1;
        }
        if (object.getObjectType() != null && activeObject.getObjectType() != null && !object.getObjectType().getId().equals(activeObject.getObjectType().getId())) {
            return 1;
        }
        ArrayList planners = new ArrayList(object.getObjectPlanners().values());
        ArrayList releasedPlanners = new ArrayList(activeObject.getObjectPlanners().values());
        if (planners == null && releasedPlanners == null) {
            return 0;
        }
        if (planners == null || releasedPlanners == null) {
            return 1;
        }
        if (planners.size() != releasedPlanners.size()) {
            return 1;
        }
        for (ObjectPlanner planner : planners) {
            boolean plannerDeleted = true;
            for (ReleasedObjectPlanner releasedPlanner : releasedPlanners) {
                if (planner.getId() != releasedPlanner.getObjectPlanner().getId()) continue;
                plannerDeleted = false;
            }
            if (!plannerDeleted) continue;
            return 1;
        }
        for (ObjectPlanner planner : planners) {
            ReleasedObjectPlanner oldPlanner = this.getReleasedObjectPlannerFromList(planner.getId(), relOList.getId());
            if (oldPlanner == null) {
                return 1;
            }
            if (planner.getArea() != null && oldPlanner.getArea() != null && (planner.getArea() == null && oldPlanner.getArea() != null || planner.getArea() != null && oldPlanner.getArea() == null)) {
                return 1;
            }
            if (planner.getArea() == null || oldPlanner.getArea() == null) {
                return 1;
            }
            if (!planner.getCode().equals(oldPlanner.getCode())) {
                return 1;
            }
            if (planner.getPlanner() == null && oldPlanner.getPlanner() == null) {
                return 0;
            }
            if (planner.getPlanner() == null || oldPlanner.getPlanner() == null) {
                return 1;
            }
            if (planner.getPlanner().getId() != oldPlanner.getPlanner().getId()) {
                return 1;
            }
            ArrayList positions = new ArrayList(planner.getPositions().values());
            ArrayList releasedPositions = new ArrayList(oldPlanner.getPositions().values());
            if (positions == null && releasedPositions == null) {
                return 0;
            }
            if (positions == null || releasedPositions == null) {
                return 1;
            }
            if (positions.size() != releasedPositions.size()) {
                return 1;
            }
            for (ObjectPlannerPositionImpl position : positions) {
                boolean positionDeleted = true;
                for (ReleasedObjectPlannerPosition releasedPosition : releasedPositions) {
                    if (position.getRole().getId() != releasedPosition.getRole().getId()) continue;
                    positionDeleted = false;
                    if (position.getProjectParticipation() == null && releasedPosition.getProjectParticipation() == null) continue;
                    if (position.getProjectParticipation() == null || releasedPosition.getProjectParticipation() == null) {
                        return 1;
                    }
                    if (position.getProjectParticipation().getId() == releasedPosition.getProjectParticipation().getId()) continue;
                    return 1;
                }
                if (!positionDeleted) continue;
                return 1;
            }
        }
        return 0;
    }

    private int getObjectPlannerChange(ObjectPlannerImpl planner, ReleasedObjectPlanner releasedPlanner) {
        if (planner.getId() == null || planner.getId() < 1 || planner.getChanged() == 2 || releasedPlanner == null) {
            return 2;
        }
        if (!planner.getCode().equals(releasedPlanner.getCode())) {
            return 1;
        }
        if (planner.getArea() != null && releasedPlanner.getArea() != null && !planner.getArea().equals(releasedPlanner.getArea())) {
            return 1;
        }
        if (planner.getArea() == null && releasedPlanner.getArea() != null || planner.getArea() != null && releasedPlanner.getArea() == null) {
            return 1;
        }
        ArrayList positions = new ArrayList(planner.getPositions().values());
        ArrayList releasedPositions = new ArrayList(releasedPlanner.getPositions().values());
        if (positions == null && releasedPositions == null) {
            return 0;
        }
        if (positions == null || releasedPositions == null) {
            return 1;
        }
        if (positions.size() != releasedPositions.size()) {
            return 1;
        }
        for (ObjectPlannerPositionImpl position : positions) {
            boolean positionDeleted = true;
            for (ReleasedObjectPlannerPosition releasedPosition : releasedPositions) {
                if (position.getRole().getId() != releasedPosition.getRole().getId()) continue;
                positionDeleted = false;
                if (position.getProjectParticipation() == null && releasedPosition.getProjectParticipation() == null) continue;
                if (position.getProjectParticipation() == null || releasedPosition.getProjectParticipation() == null) {
                    return 1;
                }
                if (position.getProjectParticipation().getId() == releasedPosition.getProjectParticipation().getId()) continue;
                return 1;
            }
            if (!positionDeleted) continue;
            return 1;
        }
        if (planner.getPlanner() == null && releasedPlanner.getPlanner() == null) {
            return 0;
        }
        if (planner.getPlanner() == null || releasedPlanner.getPlanner() == null) {
            return 1;
        }
        if (planner.getPlanner().getId() != releasedPlanner.getPlanner().getId()) {
            return 1;
        }
        if (planner.getReviewCycleInstance() == null && releasedPlanner.getReviewCycleInstance() == null) {
            return 0;
        }
        if (planner.getReviewCycleInstance() == null || releasedPlanner.getReviewCycleInstance() == null) {
            return 1;
        }
        return 0;
    }

    @Override
    public ObjectPlannerPositionDefinitionTemplate getObjectPlannerPositionDefinitionTemplate(Integer id) {
        return this.objectPlannerDefinitionDAO.getObjectPlannerPositionDefinitionTemplate(id);
    }

    @Override
    public void deleteObjectPlannerPositionDefinitionTemplate(Integer objectPlannerPositionDefinitionTemplateId) {
        ObjectPlannerPositionDefinitionTemplate tmp = this.objectPlannerDefinitionDAO.getObjectPlannerPositionDefinitionTemplate(objectPlannerPositionDefinitionTemplateId);
        this.objectPlannerDefinitionDAO.delete(tmp);
    }

    @Override
    public CDESObjectImpl saveCopyOfUnreleasedObject(CDESObjectImpl original, Integer organisationPersonId) throws DuplicateEntryException {
        CDESObjectImpl copy = new CDESObjectImpl();
        ObjectList olist = original.getObjectList();
        ArrayList objects = new ArrayList(olist.getObjects().values());
        boolean findingUniqueCode = true;
        int count = 0;
        String code = original.getCodeWithoutType();
        String newCode = code;
        if (newCode.length() > 3) {
            newCode = newCode.substring(0, newCode.length() - 2);
        }
        String postfix = "~";
        String resultCode = null;
        while (findingUniqueCode && count < 99) {
            if (count == 10 && code.length() > 3) {
                newCode = code.substring(0, code.length() - 3);
            }
            boolean foundSameCode = false;
            for (CDESObjectImpl object : objects) {
                if (!object.getCodeWithoutType().equals(newCode + postfix + count)) continue;
                foundSameCode = true;
            }
            if (foundSameCode) {
                ++count;
                continue;
            }
            resultCode = newCode + postfix + count;
            findingUniqueCode = false;
        }
        if (resultCode == null || findingUniqueCode) {
            throw new DuplicateEntryException("codeWithoutType", newCode + postfix + count);
        }
        copy.setCodeWithoutType(resultCode);
        copy.setComment(original.getComment());
        copy.setName(original.getName());
        copy.setObjectList(olist);
        copy.setStretchKmFrom(original.getStretchKmFrom());
        copy.setStretchKmTo(original.getStretchKmTo());
        copy.setModifiedDate(new Date(System.currentTimeMillis()));
        copy.setModifiedBy(this.organisationPersonDAO.get(organisationPersonId));
        copy.setModified(2);
        copy.setObjectType(original.getObjectType());
        copy = this.objectDAO.save(copy);
        ArrayList<ObjectPlannerImpl> originalPlanners = new ArrayList<ObjectPlannerImpl>(original.getAllObjectPlanners());
        HashMap<Integer, ObjectPlannerImpl> plannerCopies = new HashMap<Integer, ObjectPlannerImpl>();
        for (ObjectPlannerImpl originalPlanner : originalPlanners) {
            if (originalPlanner.isInactive()) continue;
            ObjectPlannerImpl plannerCopy = new ObjectPlannerImpl();
            plannerCopy.setArea(originalPlanner.getArea());
            plannerCopy.setCode(originalPlanner.getCode());
            plannerCopy.setObject(copy);
            plannerCopy.setObjectPlannerDefinition(originalPlanner.getObjectPlannerDefinition());
            plannerCopy.setReviewCycleInstance(originalPlanner.getReviewCycleInstance());
            plannerCopy.setPlanner(originalPlanner.getPlanner());
            plannerCopy = this.objectPlannerDAO.save(plannerCopy);
            ArrayList<ObjectPlannerPositionImpl> originalPositions = new ArrayList<ObjectPlannerPositionImpl>(originalPlanner.getPositionsSortedByName());
            for (ObjectPlannerPositionImpl originalPosition : originalPositions) {
                ObjectPlannerPositionImpl positionCopy = new ObjectPlannerPositionImpl();
                positionCopy.setObjectPlanner(plannerCopy);
                positionCopy.setObjectPlannerPositionDefinition(originalPosition.getObjectPlannerPositionDefinition());
                positionCopy.setProjectParticipation(originalPosition.getProjectParticipation());
                positionCopy.setRole(originalPosition.getRole());
                this.objectPlannerDAO.save(positionCopy);
            }
            plannerCopy = this.objectPlannerDAO.update(plannerCopy);
            plannerCopies.put(plannerCopy.getId(), plannerCopy);
        }
        copy.setObjectPlanners(plannerCopies);
        return this.objectDAO.update(copy);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveCopiesOfObjects(List<CDESObjectImpl> objectsToCopy, SubProject destinationSubProject, Integer organisationPersonId, Locale locale, boolean fromOtherProject) throws DuplicateEntryException {
        int maxCodeLength = 20;
        if (destinationSubProject.getProject().getDocumentNumberPartGroup() != null) {
            ArrayList docNumbers = new ArrayList(destinationSubProject.getProject().getDocumentNumberPartGroup().getParts().values());
            for (DocumentNumberPart docNumber : docNumbers) {
                if (!docNumber.getRule().contains(".object.code") || docNumber.getLength() <= 0) continue;
                maxCodeLength = docNumber.getLength();
            }
        }
        ObjectListImpl olist = this.getUnreleasedObjectList(destinationSubProject.getId());
        ArrayList olistObjects = new ArrayList(olist.getObjects().values());
        ArrayList<Object> newObjectCodes = new ArrayList<Object>();
        if (!fromOtherProject) {
            for (CDESObjectImpl original : objectsToCopy) {
                boolean findingUniqueCode = true;
                int count = 0;
                String code = original.getCodeWithoutType();
                String newCode = code;
                if (newCode.length() >= maxCodeLength) {
                    newCode = newCode.substring(0, maxCodeLength);
                }
                String postfix = "~";
                Object resultCode = null;
                while (findingUniqueCode && count < 99) {
                    String string = newCode + postfix + count;
                    int n = string.length() - maxCodeLength;
                    if (n > 0) {
                        if (n >= newCode.length()) {
                            throw new DuplicateEntryException("codeWithoutType", newCode + postfix + count);
                        }
                        newCode = newCode.substring(0, newCode.length() - n);
                    }
                    boolean foundSameCode = false;
                    for (CDESObjectImpl cDESObjectImpl : olistObjects) {
                        if (!cDESObjectImpl.getCodeWithoutType().equals(newCode + postfix + count)) continue;
                        foundSameCode = true;
                        break;
                    }
                    if (!foundSameCode) {
                        for (String string2 : newObjectCodes) {
                            if (!string2.equals(newCode + postfix + count)) continue;
                            foundSameCode = true;
                            break;
                        }
                    }
                    if (foundSameCode) {
                        ++count;
                        continue;
                    }
                    resultCode = newCode + postfix + count;
                    newObjectCodes.add(resultCode);
                    findingUniqueCode = false;
                }
                if (resultCode != null && !findingUniqueCode) continue;
                throw new DuplicateEntryException("codeWithoutType", newCode + postfix + count);
            }
        } else {
            for (CDESObjectImpl original : objectsToCopy) {
                String newCode = original.getCodeWithoutType();
                if (newCode.length() > maxCodeLength) {
                    newCode = newCode.substring(0, maxCodeLength);
                }
                String postFix = "~";
                int count = 1;
                boolean edited = false;
                while (count < 99) {
                    boolean changed = false;
                    for (CDESObjectImpl cDESObjectImpl : olistObjects) {
                        if ((edited || !cDESObjectImpl.getCodeWithoutType().equals(newCode)) && (!edited || !cDESObjectImpl.getCodeWithoutType().equals(newCode + postFix + count))) continue;
                        changed = true;
                        break;
                    }
                    if (!changed) {
                        for (String string : newObjectCodes) {
                            if ((edited || !string.equals(newCode)) && !string.equals(newCode + postFix + count)) continue;
                            changed = true;
                            break;
                        }
                    }
                    if (changed) {
                        edited = true;
                        String editedCode = newCode + postFix + ++count;
                        int n = editedCode.length() - maxCodeLength;
                        if (n <= 0) continue;
                        if (n >= newCode.length()) {
                            throw new DuplicateEntryException("codeWithoutType", newCode + postFix + count);
                        }
                        newCode = newCode.substring(0, newCode.length() - n);
                        continue;
                    }
                    if (edited) {
                        newObjectCodes.add(newCode + postFix + count);
                        break;
                    }
                    newObjectCodes.add(newCode);
                    break;
                }
                if (count < 99) continue;
                throw new DuplicateEntryException("codeWithoutType", newCode + postFix + count);
            }
        }
        newObjectCodes.clear();
        for (CDESObjectImpl original : objectsToCopy) {
            CDESObjectImpl copy = new CDESObjectImpl();
            if (fromOtherProject) {
                String newCode = original.getCodeWithoutType();
                if (newCode.length() > maxCodeLength) {
                    newCode = newCode.substring(0, maxCodeLength);
                }
                String postFix = "~";
                int count = 1;
                boolean edited = false;
                while (count < 99) {
                    boolean changed = false;
                    for (CDESObjectImpl cDESObjectImpl : olistObjects) {
                        if ((edited || !cDESObjectImpl.getCodeWithoutType().equals(newCode)) && (!edited || !cDESObjectImpl.getCodeWithoutType().equals(newCode + postFix + count))) continue;
                        changed = true;
                        break;
                    }
                    if (!changed) {
                        for (String string : newObjectCodes) {
                            if ((edited || !string.equals(newCode)) && !string.equals(newCode + postFix + count)) continue;
                            changed = true;
                            break;
                        }
                    }
                    if (changed) {
                        edited = true;
                        String string = newCode + postFix + ++count;
                        int n = string.length() - maxCodeLength;
                        if (n <= 0) continue;
                        if (n >= newCode.length()) {
                            throw new DuplicateEntryException("codeWithoutType", newCode + postFix + count);
                        }
                        newCode = newCode.substring(0, newCode.length() - n);
                        continue;
                    }
                    newObjectCodes.add(newCode + postFix + count);
                    break;
                }
                if (edited) {
                    copy.setCodeWithoutType(newCode + postFix + count);
                    newObjectCodes.add(newCode + postFix + count);
                } else {
                    copy.setCodeWithoutType(newCode);
                    newObjectCodes.add(newCode);
                }
            } else {
                void var18_52;
                boolean findingUniqueCode = true;
                int count = 0;
                String code = original.getCodeWithoutType();
                String newCode = code;
                if (newCode.length() > 3) {
                    newCode = newCode.substring(0, newCode.length() - 2);
                }
                String postfix = "~";
                Object var18_51 = null;
                while (findingUniqueCode && count < 99) {
                    String string = newCode + postfix + count;
                    int overlength = string.length() - maxCodeLength;
                    if (overlength > 0) {
                        newCode = newCode.substring(0, newCode.length() - overlength);
                    }
                    boolean foundSameCode = false;
                    for (CDESObjectImpl cDESObjectImpl : olistObjects) {
                        if (!cDESObjectImpl.getCodeWithoutType().equals(newCode + postfix + count)) continue;
                        foundSameCode = true;
                        break;
                    }
                    if (!foundSameCode) {
                        for (String string3 : newObjectCodes) {
                            if (!string3.equals(newCode + postfix + count)) continue;
                            foundSameCode = true;
                            break;
                        }
                    }
                    if (foundSameCode) {
                        ++count;
                        continue;
                    }
                    String string4 = newCode + postfix + count;
                    newObjectCodes.add(string4);
                    findingUniqueCode = false;
                }
                copy.setCodeWithoutType((String)var18_52);
            }
            copy.setComment(original.getComment());
            copy.setName(original.getName());
            copy.setObjectList(olist);
            copy.setStretchKmFrom(original.getStretchKmFrom());
            copy.setStretchKmTo(original.getStretchKmTo());
            copy.setModifiedDate(new Date(System.currentTimeMillis()));
            copy.setModifiedBy(this.organisationPersonDAO.get(organisationPersonId));
            copy.setModified(2);
            copy.setObjectType(original.getObjectType());
            copy = this.objectDAO.save(copy);
            if (fromOtherProject) continue;
            ArrayList<ObjectPlannerImpl> originalPlanners = new ArrayList<ObjectPlannerImpl>(original.getAllObjectPlanners());
            HashMap<Integer, ObjectPlannerImpl> plannerCopies = new HashMap<Integer, ObjectPlannerImpl>();
            for (ObjectPlannerImpl originalPlanner : originalPlanners) {
                if (originalPlanner.isInactive()) continue;
                ObjectPlannerImpl plannerCopy = new ObjectPlannerImpl();
                plannerCopy.setArea(originalPlanner.getArea());
                plannerCopy.setCode(originalPlanner.getCode());
                plannerCopy.setObject(copy);
                plannerCopy.setObjectPlannerDefinition(originalPlanner.getObjectPlannerDefinition());
                if (originalPlanner.getPlanner() != null && !originalPlanner.getPlanner().getExcludedSubProjects().containsKey(destinationSubProject.getId())) {
                    plannerCopy.setPlanner(originalPlanner.getPlanner());
                }
                plannerCopy = this.objectPlannerDAO.save(plannerCopy);
                ArrayList<ObjectPlannerPositionImpl> arrayList = new ArrayList<ObjectPlannerPositionImpl>(originalPlanner.getPositionsSortedByName());
                for (ObjectPlannerPositionImpl originalPosition : arrayList) {
                    if (originalPosition.getProjectParticipation() != null && originalPosition.getProjectParticipation().getExcludedSubProjects().containsKey(destinationSubProject.getId())) continue;
                    ObjectPlannerPositionImpl positionCopy = new ObjectPlannerPositionImpl();
                    positionCopy.setObjectPlanner(plannerCopy);
                    positionCopy.setObjectPlannerPositionDefinition(originalPosition.getObjectPlannerPositionDefinition());
                    positionCopy.setProjectParticipation(originalPosition.getProjectParticipation());
                    positionCopy.setRole(originalPosition.getRole());
                    this.objectPlannerDAO.save(positionCopy);
                }
                plannerCopy = this.objectPlannerDAO.update(plannerCopy);
                plannerCopies.put(plannerCopy.getId(), plannerCopy);
            }
            copy.setObjectPlanners(plannerCopies);
            olist.getObjects().put(copy.getId(), copy);
        }
    }

    @Override
    public void deleteObjectTypeDefault(ObjectTypeDefault object) {
        this.objectTypeDAO.deleteObjectTypeDefault(object);
    }

    @Override
    public ObjectTypeDefault getObjectTypeDefault(Integer objectId) {
        return this.objectTypeDAO.getObjectTypeDefault(objectId);
    }

    @Override
    public ObjectTypeDefault insertObjectTypeDefault(ObjectTypeDefault objectTypeDefault) {
        return this.objectTypeDAO.insertObjectTypeDefault(objectTypeDefault);
    }

    @Override
    public ObjectTypeDefault updateObjectTypeDefault(ObjectTypeDefault object) {
        return this.objectTypeDAO.updateObjectTypeDefault(object);
    }

    @Override
    public ObjectType getObjectType(Integer id) {
        return this.objectTypeDAO.getObjectType(id);
    }

    @Override
    public ObjectType insertObjectType(ObjectType objectType) {
        return this.objectTypeDAO.insertObjectType(objectType);
    }

    @Override
    public ObjectType updateObjectType(ObjectType objectType) {
        return this.objectTypeDAO.updateObjectType(objectType);
    }

    @Override
    public void deleteObjectType(ObjectType objectType) {
        this.objectTypeDAO.deleteObjectType(objectType);
    }

    @Override
    public void updateNetworkObjectTypes(Integer networkId, List<ObjectType> objectTypes, Integer masterDataSetId) {
        MasterDataSet masterDataSet = this.masterDataSetDAO.getMasterDataSet(masterDataSetId);
        Network network = this.networkDAO.get(networkId);
        for (ObjectType ot : objectTypes) {
            if (ot.getId() == null && (ot.getName() == null || ot.getName().length() == 0 || ot.getCode() == null || ot.getCode().length() == 0)) continue;
            ot.setNetwork(network);
            ot.setMasterDataSet(masterDataSet);
            if (ot.getId() == null) {
                this.objectTypeDAO.insertObjectType(ot);
                continue;
            }
            if (ot.getName() == null || ot.getName().length() == 0 || ot.getCode() == null || ot.getCode().length() == 0) {
                this.objectTypeDAO.deleteObjectType(ot);
                continue;
            }
            this.objectTypeDAO.updateObjectType(ot);
        }
    }

    @Override
    public void updateObjectTypesDefault(List<ObjectTypeDefault> otdList, NetworkType networkType) {
        for (ObjectTypeDefault otd : otdList) {
            if (otd.getCode() == null || otd.getCode().length() == 0 || otd.getName() == null || otd.getName().length() == 0) continue;
            if (otd.getId() == null || otd.getId() < 0) {
                otd.setNetworkType(networkType);
                otd = this.objectTypeDAO.insertObjectTypeDefault(otd);
                networkType.getObjectTypeDefaults().put(otd.getId(), otd);
                continue;
            }
            this.objectTypeDAO.updateObjectTypeDefault(otd);
        }
    }

    @Override
    public boolean isObjectTypeDeletable(Integer objectTypeId) {
        return this.objectTypeDAO.isObjectTypeDeletable(objectTypeId);
    }

    @Override
    public ReleasedObjectPlanner getLastReleasedObjectPlannerFromInvalidatedObjectPlanner(Integer objectPlannerImplId, Integer subProjectId) {
        Integer objectListImplId = this.subProjectDAO.get(subProjectId).getEditObjectList().getId();
        return this.objectPlannerDAO.getLastReleasedObjectPlannerFromInvalidatedObjectPlanner(objectPlannerImplId, objectListImplId);
    }

    @Override
    public ReleasedCDESObject getLastReleasedObjectFromInvalidatedObject(Integer objectImplId) {
        return this.objectDAO.getLastReleasedObjectFromInvalidatedObject(objectImplId);
    }

    public void setProjectOperations(ProjectOperations projectOperations) {
        this.projectOperations = projectOperations;
    }

    public void setPersonOperations(PersonOperations personOperations) {
        this.personOperations = personOperations;
    }

    @Override
    public List getObjectPlannerPositionsByObjectPlannerId(Integer objectPlannerImplId) {
        return this.objectPlannerDAO.getObjectPlannerPositionsByObjectPlannerId(objectPlannerImplId);
    }

    @Override
    public List getAllReleasedObjectPlannersFromUnreleased(Integer objectPlannerImplId) {
        return this.objectPlannerDAO.getAllReleasedObjectPlannersFromUnreleased(objectPlannerImplId);
    }

    @Override
    public boolean isParticipationAssignedInObjectPlanners(Integer subProjectId, Integer projectParticipationId) {
        List unreleasedPlanners = this.objectPlannerDAO.getUnreleasedObjectPlannerPositionsByParticipation(subProjectId, projectParticipationId);
        if (unreleasedPlanners != null && unreleasedPlanners.size() > 0) {
            return true;
        }
        SubProject sp = this.subProjectDAO.get(subProjectId);
        if (sp.getActiveObjectList() != null) {
            List releasedPlanners = this.objectPlannerDAO.getReleasedObjectPlannerPositionByParticipation(projectParticipationId, sp.getActiveObjectList().getId());
            return releasedPlanners != null && releasedPlanners.size() > 0;
        }
        return false;
    }

    @Override
    public void updateObjectPlannerDefinitionTemplateNetworks(Integer objectPlannerDefinitionTemplateId, List<Network> selectedNetworks) {
        ObjectPlannerDefinitionTemplate template = this.objectPlannerDefinitionDAO.getObjectPlannerDefinitionTemplate(objectPlannerDefinitionTemplateId);
        template.getNetworks().clear();
        for (Network n : selectedNetworks) {
            template.getNetworks().put(n.getId(), n);
        }
        this.objectPlannerDefinitionDAO.update(template);
    }

    @Override
    public SubProjectCopyContainer insertCopyOfObjectListWithSubElements(Integer sourceSubProjectId, Integer destinationSubProjectId, SubProjectCopyContainer subProjectCopyContainer) {
        SubProject sourceSubProject = this.subProjectDAO.get(sourceSubProjectId);
        SubProject destinationSubProject = this.subProjectDAO.get(destinationSubProjectId);
        ObjectListImpl olistSource = sourceSubProject.getEditObjectList();
        ObjectListImpl olistDest = new ObjectListImpl();
        olistDest.setSubProject(destinationSubProject);
        olistDest.setVersion(olistSource.getVersion());
        olistDest = this.objectListDAO.save(olistDest);
        olistDest.setObjects(new HashMap());
        destinationSubProject.setEditObjectList(olistDest);
        subProjectCopyContainer = this.reviewCycleOperations.insertCopyOfReviewCycleInstancesWithSubElements(sourceSubProjectId, destinationSubProjectId, subProjectCopyContainer);
        ArrayList unreleasedObjects = new ArrayList(olistSource.getObjects().values());
        unreleasedObjects.addAll(olistSource.getInactivatedObjects().values());
        for (CDESObjectImpl sourceObject : unreleasedObjects) {
            CDESObjectImpl destObject = new CDESObjectImpl();
            destObject.setCodeWithoutType(sourceObject.getCodeWithoutType());
            destObject.setComment(sourceObject.getComment());
            destObject.setInactive(sourceObject.isInactive());
            destObject.setModified(sourceObject.getModified());
            destObject.setModifiedBy(sourceObject.getModifiedBy());
            destObject.setModifiedDate(sourceObject.getModifiedDate());
            destObject.setName(sourceObject.getName());
            destObject.setObjectList(olistDest);
            destObject.setObjectType(sourceObject.getObjectType());
            destObject.setStretchKmFrom(sourceObject.getStretchKmFrom());
            destObject.setStretchKmTo(sourceObject.getStretchKmTo());
            destObject = this.objectDAO.save(destObject);
            olistDest.getObjects().put(destObject.getId(), destObject);
            subProjectCopyContainer.getObjectImplIds().put(sourceObject.getId(), destObject.getId());
            destObject.setObjectPlanners(new HashMap());
            List objectPlanners = (List)sourceObject.getAllObjectPlanners();
            for (ObjectPlannerImpl sourceObjectPlanner : objectPlanners) {
                ObjectPlannerImpl destObjectPlanner = new ObjectPlannerImpl();
                destObjectPlanner.setArea(sourceObjectPlanner.getArea());
                destObjectPlanner.setChanged(sourceObjectPlanner.getChanged());
                destObjectPlanner.setCode(sourceObjectPlanner.getCode());
                destObjectPlanner.setInactive(sourceObjectPlanner.isInactive());
                destObjectPlanner.setObject(destObject);
                destObjectPlanner.setObjectPlannerDefinition(sourceObjectPlanner.getObjectPlannerDefinition());
                destObjectPlanner.setPlanner(sourceObjectPlanner.getPlanner());
                if (sourceObjectPlanner.getReviewCycleInstance() != null) {
                    ReviewCycleInstanceImpl destRCI = this.reviewCycleOperations.getReviewCycleInstance(subProjectCopyContainer.getReviewCycleInstanceImplIds().get(sourceObjectPlanner.getReviewCycleInstance().getId()), false);
                    destObjectPlanner.setReviewCycleInstance(destRCI);
                }
                destObjectPlanner = this.objectPlannerDAO.save(destObjectPlanner);
                destObjectPlanner.setPositions(new HashMap());
                subProjectCopyContainer.getObjectPlannerImplIds().put(sourceObjectPlanner.getId(), destObjectPlanner.getId());
                ArrayList positions = new ArrayList(sourceObjectPlanner.getPositions().values());
                for (ObjectPlannerPositionImpl sourcePosition : positions) {
                    ObjectPlannerPositionImpl destPosition = new ObjectPlannerPositionImpl();
                    destPosition.setObjectPlanner(destObjectPlanner);
                    destPosition.setObjectPlannerPositionDefinition(sourcePosition.getObjectPlannerPositionDefinition());
                    destPosition.setProjectParticipation(sourcePosition.getProjectParticipation());
                    destPosition.setRole(sourcePosition.getRole());
                    destPosition = this.objectPlannerDAO.save(destPosition);
                    destObjectPlanner.getPositions().put(destPosition.getId(), destPosition);
                    subProjectCopyContainer.getObjectPlannerPositionImplIds().put(sourcePosition.getId(), destPosition.getId());
                }
                destObjectPlanner = this.objectPlannerDAO.update(destObjectPlanner);
                destObject.getObjectPlanners().put(destObjectPlanner.getId(), destObjectPlanner);
            }
            destObject = this.objectDAO.update(destObject);
            olistDest = this.objectListDAO.update(olistDest);
        }
        SortedSet releasedObjectLists = sourceSubProject.getReleasedObjectLists();
        TreeSet<ReleasedObjectList> destinationRelObjectLists = new TreeSet<ReleasedObjectList>(new ReleasedObjectListVersionComparator());
        for (ReleasedObjectList sourceList : releasedObjectLists) {
            ReleasedObjectList destList = new ReleasedObjectList();
            destList.setDigest(sourceList.getDigest());
            destList.setDigestCalculatorType(sourceList.getDigestCalculatorType());
            destList.setObjectList(olistDest);
            destList.setSignature(sourceList.getSignature());
            destList.setSubProject(destinationSubProject);
            destList.setVersion(sourceList.getVersion());
            destList = this.objectListDAO.save(destList);
            subProjectCopyContainer.getObjectListReleaseIds().put(sourceList.getId(), destList.getId());
            destList.setObjects(new HashMap());
            subProjectCopyContainer = this.reviewCycleOperations.insertCopyOfReleasedReviewCycleInstancesWithSubElements(sourceList, destList, subProjectCopyContainer);
            ArrayList releasedObjects = new ArrayList(sourceList.getObjects().values());
            for (ReleasedCDESObject sourceObject : releasedObjects) {
                ReleasedCDESObject destObject = new ReleasedCDESObject();
                destObject.setCodeWithoutType(sourceObject.getCodeWithoutType());
                destObject.setComment(sourceObject.getComment());
                destObject.setModified(sourceObject.getModified());
                destObject.setName(sourceObject.getName());
                destObject.setObjectList(destList);
                destObject.setObjectType(sourceObject.getObjectType());
                destObject.setStretchKmFrom(sourceObject.getStretchKmFrom());
                destObject.setStretchKmTo(sourceObject.getStretchKmTo());
                destObject.setDigest(sourceObject.getDigest());
                destObject.setDigestCalculatorType(sourceObject.getDigestCalculatorType());
                CDESObjectImpl unreleasedDestinationObject = this.objectDAO.getCDESObject(subProjectCopyContainer.getObjectImplIds().get(sourceObject.getObject().getId()));
                destObject.setObject(unreleasedDestinationObject);
                destObject = this.objectDAO.save(destObject);
                destObject.setObjectPlanners(new HashMap());
                ArrayList objectPlanners = new ArrayList(sourceObject.getObjectPlanners().values());
                for (ReleasedObjectPlanner sourceObjectPlanner : objectPlanners) {
                    ReleasedObjectPlanner destObjectPlanner = new ReleasedObjectPlanner();
                    destObjectPlanner.setObjectPlanner(this.objectPlannerDAO.getObjectPlanner(subProjectCopyContainer.getObjectPlannerImplIds().get(sourceObjectPlanner.getObjectPlanner().getId())));
                    destObjectPlanner.setArea(sourceObjectPlanner.getArea());
                    destObjectPlanner.setChanged(sourceObjectPlanner.getChanged());
                    destObjectPlanner.setCode(sourceObjectPlanner.getCode());
                    destObjectPlanner.setObject(destObject);
                    destObjectPlanner.setObjectPlannerDefinition(sourceObjectPlanner.getObjectPlannerDefinition());
                    destObjectPlanner.setPlanner(sourceObjectPlanner.getPlanner());
                    if (sourceObjectPlanner.getReviewCycleInstance() != null) {
                        ReviewCycleInstanceRelease destRCI = this.reviewCycleOperations.getReleasedReviewCycleInstance(subProjectCopyContainer.getReviewCycleInstanceReleaseIds().get(sourceObjectPlanner.getReviewCycleInstance().getId()), false);
                        destObjectPlanner.setReviewCycleInstance(destRCI);
                    }
                    destObjectPlanner = this.objectPlannerDAO.save(destObjectPlanner);
                    destObjectPlanner.setPositions(new HashMap());
                    subProjectCopyContainer.getObjectPlannerReleaseIds().put(sourceObjectPlanner.getId(), destObjectPlanner.getId());
                    ArrayList positions = new ArrayList(sourceObjectPlanner.getPositions().values());
                    for (ReleasedObjectPlannerPosition sourcePosition : positions) {
                        ReleasedObjectPlannerPosition destPosition = new ReleasedObjectPlannerPosition();
                        destPosition.setObjectPlanner(destObjectPlanner);
                        destPosition.setObjectPlannerPositionDefinition(sourcePosition.getObjectPlannerPositionDefinition());
                        destPosition.setProjectParticipation(sourcePosition.getProjectParticipation());
                        destPosition.setRole(sourcePosition.getRole());
                        destPosition = this.objectPlannerDAO.save(destPosition);
                        destObjectPlanner.getPositions().put(destPosition.getId(), destPosition);
                    }
                    destObjectPlanner = this.objectPlannerDAO.update(destObjectPlanner);
                    destObject.getObjectPlanners().put(destObjectPlanner.getId(), destObjectPlanner);
                }
                destObject = this.objectDAO.update(destObject);
                destList.getObjects().put(destObject.getId(), destObject);
            }
            destList = this.objectListDAO.update(destList);
            destinationRelObjectLists.add(destList);
        }
        destinationSubProject.setReleasedObjectLists(destinationRelObjectLists);
        this.subProjectDAO.update(destinationSubProject);
        return subProjectCopyContainer;
    }

    @Override
    public List<AsBuiltObjectTO> getAsBuiltReferences(Integer sourceSubProjectId, Integer destSubProjectId) {
        SubProject sourceSubProject = this.subProjectDAO.get(sourceSubProjectId);
        ArrayList sourceObjects = new ArrayList(sourceSubProject.getEditObjectList().getObjects().values());
        Collections.sort(sourceObjects, new ObjectCodeComparator());
        SubProject destSubProject = this.subProjectDAO.get(destSubProjectId);
        Locale locale = new Locale(sourceSubProject.getProject().getLocalisation().getCountry().getCode2());
        I18n i18n = I18nFactory.getI18n(locale);
        Comparator objectPlannerComparator = null;
        POJOComparatorFactory fac = new POJOComparatorFactory(locale);
        try {
            objectPlannerComparator = fac.getComparator(ObjectPlanner.class, "code", false);
        }
        catch (InvalidExpressionSyntaxException e) {
            log.error((Object)("Can't get comparator for class [" + ObjectPlanner.class + "]: "), (Throwable)e);
        }
        List destinationCopiedObjects = this.objectDAO.getAllAsBuiltReferences(sourceSubProjectId, destSubProjectId);
        HashMap<Integer, CDESObjectImpl> alreadyCopiedObjects = new HashMap<Integer, CDESObjectImpl>();
        for (CDESObjectImpl obj : destinationCopiedObjects) {
            alreadyCopiedObjects.put(obj.getAsBuiltReference().getId(), obj);
        }
        List destinationCopiedObjectPlanners = this.objectPlannerDAO.getAllAsBuiltReferences(sourceSubProjectId, destSubProjectId);
        HashMap<Integer, ObjectPlannerImpl> alreadyCopiedObjectPlanners = new HashMap<Integer, ObjectPlannerImpl>();
        for (ObjectPlannerImpl op : destinationCopiedObjectPlanners) {
            alreadyCopiedObjectPlanners.put(op.getAsBuiltReference().getId(), op);
        }
        ArrayList<AsBuiltObjectTO> ret = new ArrayList<AsBuiltObjectTO>();
        for (CDESObjectImpl object : sourceObjects) {
            AsBuiltObjectTO objectTO;
            ArrayList objectPlanners = new ArrayList(object.getObjectPlanners().values());
            if (objectPlannerComparator != null) {
                Collections.sort(objectPlanners, objectPlannerComparator);
            }
            if (alreadyCopiedObjects.containsKey(object.getId())) {
                objectTO = new AsBuiltObjectTO(object, true);
                for (ObjectPlannerImpl op : objectPlanners) {
                    if (alreadyCopiedObjectPlanners.containsKey(op.getId())) {
                        objectTO.getObjectPlanners().add(new AsBuiltObjectTO(op, true, i18n));
                        continue;
                    }
                    AsBuiltObjectTO destOpTO = new AsBuiltObjectTO(op, false, i18n);
                    CDESObjectImpl destObject = (CDESObjectImpl)alreadyCopiedObjects.get(object.getId());
                    for (ObjectPlanner destObjectPlanner : destObject.getObjectPlanners().values()) {
                        if (!destObjectPlanner.getCode().equals(op.getCode())) continue;
                        destOpTO.setDuplicatedCode(true);
                        break;
                    }
                    objectTO.getObjectPlanners().add(destOpTO);
                }
                ret.add(objectTO);
                continue;
            }
            objectTO = new AsBuiltObjectTO(object, false);
            for (ObjectPlannerImpl op : objectPlanners) {
                objectTO.getObjectPlanners().add(new AsBuiltObjectTO(op, false, i18n));
            }
            if (ObjectListHelper.containsObjectCode(destSubProject.getEditObjectList(), object)) {
                objectTO.setDuplicatedCode(true);
            }
            ret.add(objectTO);
        }
        return ret;
    }

    @Override
    public void insertAsBuiltReferences(List<AsBuiltObjectTO> sourceObjects, Integer destinationSubProjectId, Integer organisationPersonId) throws MissingContractorRoleException {
        SubProject destinationSubProject = this.subProjectDAO.get(destinationSubProjectId);
        Locale locale = new Locale(destinationSubProject.getProject().getLocalisation().getCountry().getCode2());
        I18n i18n = I18nFactory.getI18n(locale);
        Date now = Calendar.getInstance().getTime();
        ObjectListImpl olistDest = null;
        OrganisationPerson orgPerson = this.organisationPersonDAO.get(organisationPersonId);
        SubProject sourceSubProject = null;
        if (destinationSubProject.getEditObjectList() == null) {
            olistDest = new ObjectListImpl();
            olistDest.setSubProject(destinationSubProject);
            olistDest.setVersion(0);
            olistDest = this.objectListDAO.save(olistDest);
            olistDest.setObjects(new HashMap());
        } else {
            olistDest = destinationSubProject.getEditObjectList();
            if (olistDest.getObjects() == null) {
                olistDest.setObjects(new HashMap());
            }
        }
        for (AsBuiltObjectTO sourceObjectTO : sourceObjects) {
            CDESObjectImpl destObject;
            ArrayList<ObjectPlannerImpl> sourceObjectPlanners = new ArrayList<ObjectPlannerImpl>();
            for (AsBuiltObjectTO sourceObjectPlannerTO : sourceObjectTO.getObjectPlanners()) {
                if (!sourceObjectPlannerTO.isSelected()) continue;
                sourceObjectPlanners.add(this.objectPlannerDAO.getObjectPlanner(sourceObjectPlannerTO.getId()));
            }
            if (sourceObjectPlanners.isEmpty()) continue;
            CDESObjectImpl sourceObject = this.objectDAO.getCDESObject(sourceObjectTO.getId());
            if (sourceSubProject == null && destinationSubProject.getAsBuiltReference() == null) {
                sourceSubProject = sourceObject.getObjectList().getSubProject();
            }
            if ((destObject = this.objectDAO.getForAsBuiltReference(sourceObject.getId(), destinationSubProjectId)) == null) {
                destObject = new CDESObjectImpl();
                destObject.setCodeWithoutType(sourceObject.getCodeWithoutType());
                destObject.setComment(sourceObject.getComment());
                destObject.setInactive(sourceObject.isInactive());
                destObject.setModified(0);
                destObject.setModifiedBy(orgPerson);
                destObject.setModifiedDate(now);
                destObject.setName(sourceObject.getName());
                destObject.setObjectList(olistDest);
                destObject.setObjectType(sourceObject.getObjectType());
                destObject.setStretchKmFrom(sourceObject.getStretchKmFrom());
                destObject.setStretchKmTo(sourceObject.getStretchKmTo());
                destObject.setAsBuiltReference(sourceObject);
                destObject = this.objectDAO.save(destObject);
                olistDest.getObjects().put(destObject.getId(), destObject);
                destObject.setObjectPlanners(new HashMap());
            }
            for (ObjectPlannerImpl sourceObjectPlanner : sourceObjectPlanners) {
                if (sourceObjectPlanner.getPlanner() == null) {
                    log.info((Object)("insertAsBuiltReferences: Ignoring  sourceObjectPlannerId [" + sourceObjectPlanner.getId() + "] because no planner is defined."));
                    continue;
                }
                ObjectPlannerImpl destObjectPlanner = new ObjectPlannerImpl();
                destObjectPlanner.setArea(sourceObjectPlanner.getArea());
                destObjectPlanner.setChanged(0);
                destObjectPlanner.setCode(sourceObjectPlanner.getCode());
                destObjectPlanner.setInactive(sourceObjectPlanner.isInactive());
                destObjectPlanner.setObject(destObject);
                destObjectPlanner.setObjectPlannerDefinition(sourceObjectPlanner.getObjectPlannerDefinition());
                destObjectPlanner.setAsBuiltReference(sourceObjectPlanner);
                destObjectPlanner = this.objectPlannerDAO.save(destObjectPlanner);
                destObjectPlanner.setPlanner(sourceObjectPlanner.getPlanner());
                destObjectPlanner.setPositions(new HashMap());
                if (sourceObjectPlanner.getPlanner().getExcludedSubProjects().containsKey(destinationSubProjectId)) {
                    sourceObjectPlanner.getPlanner().getExcludedSubProjects().remove(destinationSubProjectId);
                    log.info((Object)("insertAsBuiltReferences: Removing planner projectParticipation [" + sourceObjectPlanner.getPlanner().getId() + "] from excludedSubProjectsList for subProject [" + destinationSubProjectId + "]"));
                }
                ProjectParticipation contractor = null;
                ArrayList positions = new ArrayList(sourceObjectPlanner.getPositions().values());
                for (ObjectPlannerPositionImpl sourcePosition : positions) {
                    ObjectPlannerPositionImpl destPosition = new ObjectPlannerPositionImpl();
                    destPosition.setObjectPlanner(destObjectPlanner);
                    destPosition.setObjectPlannerPositionDefinition(sourcePosition.getObjectPlannerPositionDefinition());
                    destPosition.setProjectParticipation(sourcePosition.getProjectParticipation());
                    destPosition.setRole(sourcePosition.getRole());
                    destPosition = this.objectPlannerDAO.save(destPosition);
                    destObjectPlanner.getPositions().put(destPosition.getId(), destPosition);
                    if (sourcePosition.getProjectParticipation().getRole().isContractorRole()) {
                        contractor = sourcePosition.getProjectParticipation();
                    }
                    if (!sourcePosition.getProjectParticipation().getExcludedSubProjects().containsKey(destinationSubProjectId)) continue;
                    sourcePosition.getProjectParticipation().getExcludedSubProjects().remove(destinationSubProjectId);
                    log.info((Object)("insertAsBuiltReferences: Removing objectPlannerPosition projectParticipation [" + sourcePosition.getProjectParticipation().getId() + "] from excludedSubProjectsList for subProject [" + destinationSubProjectId + "]"));
                }
                if (contractor == null) {
                    throw new MissingContractorRoleException();
                }
                ProjectParticipation contractorPlannerRole = contractor.getAsBuiltPlannerParticipation();
                if (contractorPlannerRole == null) {
                    contractorPlannerRole = new ProjectParticipation();
                    Role plannerRole = sourceObjectPlanner.getPlanner().getRole();
                    contractorPlannerRole.setRole(plannerRole);
                    contractorPlannerRole.setAttachmentEmailAddress(contractor.getAttachmentEmailAddress());
                    contractorPlannerRole.setComment(i18n.tr("Automatisch erzeugte Planerrolle bei Bestands\u00fcbernahme."));
                    contractorPlannerRole.setCustomerId(contractor.getCustomerId());
                    contractorPlannerRole.setExcludedSubProjects(new HashMap());
                    contractorPlannerRole.setMailReciever(contractor.isMailReciever());
                    contractorPlannerRole.setOrganisation(contractor.getOrganisation());
                    contractorPlannerRole.setProject(contractor.getProject());
                    contractorPlannerRole.setStatus(contractor.getStatus());
                    ArrayList excludedSubProjects = new ArrayList(contractor.getExcludedSubProjects().values());
                    ArrayList<ProjectParticipant> participants = new ArrayList<ProjectParticipant>();
                    Collection sourceParticipants = contractor.getProjectParticipants().values();
                    for (ProjectParticipant sourcePart : sourceParticipants) {
                        ProjectParticipant destPart = new ProjectParticipant();
                        destPart.setMainParticipant(sourcePart.isMainParticipant());
                        destPart.setOrganisationPerson(sourcePart.getOrganisationPerson());
                        participants.add(destPart);
                    }
                    contractorPlannerRole = this.projectOperations.insertProjectParticipation(contractorPlannerRole, participants, excludedSubProjects, organisationPersonId);
                    contractor.setAsBuiltPlannerParticipation(contractorPlannerRole);
                    this.projectParticipationDAO.update(contractor);
                }
                destObjectPlanner.setPlanner(contractorPlannerRole);
                destObjectPlanner = this.objectPlannerDAO.update(destObjectPlanner);
                destObject.getObjectPlanners().put(destObjectPlanner.getId(), destObjectPlanner);
            }
            destObject = this.objectDAO.update(destObject);
            olistDest = this.objectListDAO.update(olistDest);
        }
        if (sourceSubProject != null) {
            destinationSubProject.setAsBuiltReference(sourceSubProject);
        }
        destinationSubProject = this.subProjectDAO.update(destinationSubProject);
    }

    @Override
    public List<AsBuiltObjectTO> getAsBuiltObjects(Integer subProjectId) {
        SubProject sp = this.subProjectDAO.get(subProjectId);
        Locale locale = new Locale(sp.getProject().getLocalisation().getCountry().getCode2());
        I18n i18n = I18nFactory.getI18n(locale);
        Comparator objectPlannerComparator = null;
        POJOComparatorFactory fac = new POJOComparatorFactory(locale);
        try {
            objectPlannerComparator = fac.getComparator(ObjectPlanner.class, "code", false);
        }
        catch (InvalidExpressionSyntaxException e) {
            log.error((Object)("Can't get comparator for class [" + ObjectPlanner.class + "]: "), (Throwable)e);
        }
        ArrayList objects = sp.getEditObjectList().getObjects() != null ? new ArrayList(sp.getEditObjectList().getObjects().values()) : new ArrayList();
        ArrayList<AsBuiltObjectTO> ret = new ArrayList<AsBuiltObjectTO>();
        Collections.sort(objects, new ObjectCodeComparator());
        for (CDESObjectImpl object : objects) {
            if (object.getAsBuiltReference() == null) continue;
            AsBuiltObjectTO objectTO = new AsBuiltObjectTO(object, true);
            ArrayList objectPlanners = new ArrayList(object.getObjectPlanners().values());
            if (objectPlannerComparator != null) {
                Collections.sort(objectPlanners, objectPlannerComparator);
            }
            for (ObjectPlannerImpl objectPlanner : objectPlanners) {
                if (objectPlanner.getAsBuiltReference() == null) continue;
                AsBuiltObjectTO objectPlannerTO = new AsBuiltObjectTO(objectPlanner, true, i18n);
                if (objectPlanner.getDocuments() != null && !objectPlanner.getDocuments().isEmpty()) {
                    ArrayList documents = new ArrayList(objectPlanner.getDocuments().values());
                    for (DocumentImpl doc : documents) {
                        if (!doc.isVersionSet()) continue;
                        objectPlannerTO.setHasDocumentVersions(true);
                        break;
                    }
                }
                objectTO.getObjectPlanners().add(objectPlannerTO);
            }
            ret.add(objectTO);
        }
        return ret;
    }

    @Override
    public void updateAsBuiltReferences(List<AsBuiltObjectTO> objectTOs, Integer destinationSubProjectId, Integer organisationPersonId) throws MissingContractorRoleException {
        for (AsBuiltObjectTO objectTO : objectTOs) {
            for (AsBuiltObjectTO objectPlannerTO : objectTO.getObjectPlanners()) {
                if (objectPlannerTO.isHasReleasedVersions()) continue;
                ObjectPlannerImpl op = this.objectPlannerDAO.getObjectPlanner(objectPlannerTO.getId());
                ProjectParticipation contractor = null;
                ProjectParticipation contractorPlannerParticipation = null;
                Collection positions = op.getPositions().values();
                for (ObjectPlannerPosition position : positions) {
                    if (!position.getRole().isContractorRole()) continue;
                    contractor = position.getProjectParticipation();
                    contractorPlannerParticipation = contractor.getAsBuiltPlannerParticipation();
                    break;
                }
                if (contractor == null) {
                    throw new MissingContractorRoleException();
                }
                boolean hasChanged = false;
                if (objectPlannerTO.isSelected() && (op.getPlanner() == null || op.getAsBuiltReference().getPlanner() != null && !op.getPlanner().getId().equals(op.getAsBuiltReference().getPlanner().getId()))) {
                    op.setPlanner(op.getAsBuiltReference().getPlanner());
                    hasChanged = true;
                }
                if (!objectPlannerTO.isSelected() && op.getPlanner() != null && !op.getPlanner().getRole().isContractorRole()) {
                    op.setPlanner(contractorPlannerParticipation);
                    hasChanged = true;
                }
                if (op.getReviewCycleInstance() == null && objectPlannerTO.getReviewCycleInstanceId() != null || op.getReviewCycleInstance() != null && (objectPlannerTO.getReviewCycleInstanceId() == null || !objectPlannerTO.getReviewCycleInstanceId().equals(op.getReviewCycleInstance().getId()))) {
                    ReviewCycleInstanceImpl newInstance = null;
                    if (objectPlannerTO.getReviewCycleInstanceId() != null) {
                        newInstance = this.reviewCycleOperations.getReviewCycleInstance(objectPlannerTO.getReviewCycleInstanceId(), false);
                    }
                    op.setReviewCycleInstance(newInstance);
                    hasChanged = true;
                }
                if (!hasChanged) continue;
                this.objectPlannerDAO.update(op);
            }
        }
    }

    @Override
    public List getAsBuiltObjectsWithDocuments(Integer subProjectId, Integer organisationPersonId) {
        SubProject sp = this.subProjectDAO.get(subProjectId);
        NumberCalculator calc = this.planDeliverCatalogueOperations.getDocumentNumberCalculator();
        I18n i18n = I18nFactory.getI18n(new Locale(sp.getProject().getLocalisation().getCountry().getCode2()));
        if (sp.getActiveObjectList() == null) {
            return new ArrayList();
        }
        HashMap<Integer, AsBuiltObjectTO> objectMap = new HashMap<Integer, AsBuiltObjectTO>();
        ArrayList releasedObjects = new ArrayList(sp.getActiveObjectList().getObjects().values());
        Collections.sort(releasedObjects, new ObjectCodeComparator());
        HashMap<String, AsBuiltDocumentTO> uniqueDocumentVersionNameMap = new HashMap<String, AsBuiltDocumentTO>();
        for (ReleasedCDESObject object : releasedObjects) {
            HashMap<Integer, AsBuiltDocumentTO> dvs = new HashMap<Integer, AsBuiltDocumentTO>();
            if (object.getObject().getAsBuiltReference() == null) continue;
            Collection objectPlanners = object.getObjectPlanners().values();
            ArrayList objectPlannersWithSufficientRights = new ArrayList();
            for (ReleasedObjectPlanner objectPlanner : objectPlanners) {
                String versionSeparator;
                String versionPartB;
                String versionPartA;
                String destinationDocumentVersionName;
                boolean fileTypeSupportedWithLabelContent;
                DocumentListImpl dummyList;
                DocumentImpl dummyDoc;
                Collection labelContents;
                Object part2;
                boolean hasLabelContentsWithAssignedReviewCycle = false;
                if (objectPlanner.getPlanner() == null || objectPlanner.getObjectPlanner().getAsBuiltReference() == null) continue;
                ReviewCycleInstance reviewCycleInstance = objectPlanner.getReviewCycleInstance();
                if (reviewCycleInstance == null) break;
                Collection cellInstances = reviewCycleInstance.getReviewCycleCellInstances().values();
                ReviewCycleCell destinationCell = null;
                for (ReviewCycleCellInstance cellInst : cellInstances) {
                    if (!cellInst.getReviewCycleCell().isAsBuiltUnchangedDestination()) continue;
                    destinationCell = cellInst.getReviewCycleCell();
                    break;
                }
                boolean hasRights = false;
                ArrayList<ProjectParticipation> ppsToCheck = new ArrayList<ProjectParticipation>();
                ppsToCheck.add(objectPlanner.getPlanner());
                for (ProjectParticipation pp : ppsToCheck) {
                    for (Object part2 : pp.getProjectParticipants().values()) {
                        if (!((ProjectParticipant)part2).getOrganisationPerson().getId().equals(organisationPersonId)) continue;
                        hasRights = true;
                        break;
                    }
                    if (!hasRights) continue;
                    break;
                }
                if (!hasRights) continue;
                ObjectPlannerImpl originalObjectPlanner = objectPlanner.getObjectPlanner().getAsBuiltReference();
                ReviewCycleInstance originalReviewCycleInstance = originalObjectPlanner.getReviewCycleInstance();
                if (originalReviewCycleInstance.getLabel() != null && (labelContents = originalReviewCycleInstance.getLabel().getLabelContents().values()) != null && !labelContents.isEmpty()) {
                    for (LabelContent labelContent : labelContents) {
                        Collection labelContentTextFields = labelContent.getTextFields().values();
                        if (!labelContent.isDefaultLabelContent() || labelContentTextFields == null || labelContentTextFields.isEmpty()) continue;
                        for (TextField labelContentTextField : labelContentTextFields) {
                            if (labelContentTextField.getReviewCycle() == null || labelContentTextField.getReviewCycle().getId().equals(originalReviewCycleInstance.getReviewCycle().getId())) continue;
                            hasLabelContentsWithAssignedReviewCycle = true;
                        }
                    }
                }
                ArrayList alreadyCopied = new ArrayList(objectPlanner.getObjectPlanner().getDocuments().values());
                part2 = alreadyCopied.iterator();
                while (part2.hasNext()) {
                    DocumentImpl destinationDoc = (DocumentImpl)part2.next();
                    if (destinationDoc.getAsBuiltReference() == null) continue;
                    DocumentVersion lastDocumentVersion = destinationDoc.getLastDocumentVersion();
                    AsBuiltDocumentTO documentTO = null;
                    if (lastDocumentVersion == null || lastDocumentVersion.getStatus() == 7) {
                        AsBuiltDocumentTO nameConflictingDoc;
                        lastDocumentVersion = destinationDoc.getAsBuiltReference().getLastDocumentVersion();
                        if (lastDocumentVersion.getStatus() != 2) continue;
                        dummyDoc = new DocumentImpl();
                        dummyList = new DocumentListImpl();
                        dummyList.setSubProject(sp);
                        dummyDoc.setDocumentList(dummyList);
                        dummyDoc.setNumber(destinationDoc.getNumber());
                        dummyDoc.setDocumentType(destinationDoc.getDocumentType());
                        dummyDoc.setObjectPlanner(objectPlanner.getObjectPlanner());
                        fileTypeSupportedWithLabelContent = lastDocumentVersion.getLabelContentId() == null || lastDocumentVersion.getLabelContentId() != null && ConfigurationHelper.isFileTypeSupportedForPreview(lastDocumentVersion.getFileType());
                        destinationDocumentVersionName = null;
                        versionPartA = null;
                        versionPartB = null;
                        versionSeparator = null;
                        try {
                            if (destinationCell != null) {
                                DocumentVersion dummy = new DocumentVersion();
                                dummy.setAsBuiltReference(lastDocumentVersion);
                                destinationDocumentVersionName = calc.getNumber((Document)dummyDoc, sp.getProject(), destinationCell, (BaseDocumentVersion)dummy);
                                versionPartA = dummy.getVersionPartA();
                                versionPartB = dummy.getVersionPartB();
                                versionSeparator = dummy.getVersionPartSeperator();
                            }
                        }
                        catch (NumberCalculatorException e) {
                            throw new ActionException("get as-built documents", e);
                        }
                        documentTO = new AsBuiltDocumentTO(destinationDoc, objectPlanner, destinationCell != null && hasLabelContentsWithAssignedReviewCycle && fileTypeSupportedWithLabelContent ? 0 : 2, destinationDocumentVersionName, versionPartA, versionPartB, versionSeparator, destinationDoc.getId(), null);
                        documentTO.setDocumentVersionName(lastDocumentVersion.getName());
                        documentTO.setDocumentVersionId(lastDocumentVersion.getId());
                        documentTO.setId(destinationDoc.getAsBuiltReference().getId());
                        if (documentTO.getDestinationDocumentVersionName() != null && (nameConflictingDoc = (AsBuiltDocumentTO)uniqueDocumentVersionNameMap.get(documentTO.getDestinationDocumentVersionName())) != null) {
                            nameConflictingDoc.setStatus(3);
                            documentTO.setStatus(3);
                        }
                    } else {
                        AsBuiltDocumentTO nameConflictingDoc;
                        documentTO = new AsBuiltDocumentTO(destinationDoc, objectPlanner, 1);
                        if (documentTO.getDestinationDocumentVersionName() != null && (nameConflictingDoc = (AsBuiltDocumentTO)uniqueDocumentVersionNameMap.get(documentTO.getDestinationDocumentVersionName())) != null) {
                            nameConflictingDoc.setStatus(3);
                            documentTO.setStatus(3);
                        }
                    }
                    dvs.put(destinationDoc.getAsBuiltReference().getId(), documentTO);
                    uniqueDocumentVersionNameMap.put(documentTO.getDestinationDocumentVersionName(), documentTO);
                }
                Collection allOriginalDocuments = originalObjectPlanner.getDocuments().values();
                if (allOriginalDocuments == null || allOriginalDocuments.isEmpty()) continue;
                for (DocumentImpl originalDocument : allOriginalDocuments) {
                    AsBuiltDocumentTO nameConflictingDoc;
                    DocumentVersion dv;
                    if (dvs.containsKey(originalDocument.getId()) || (dv = originalDocument.getLastDocumentVersion()) == null || dv.getStatus() != 2) continue;
                    dummyDoc = new DocumentImpl();
                    dummyList = new DocumentListImpl();
                    dummyList.setSubProject(sp);
                    dummyDoc.setDocumentList(dummyList);
                    dummyDoc.setNumber(originalDocument.getNumber());
                    dummyDoc.setDocumentType(originalDocument.getDocumentType());
                    dummyDoc.setObjectPlanner(objectPlanner.getObjectPlanner());
                    fileTypeSupportedWithLabelContent = dv.getLabelContentId() == null || dv.getLabelContentId() != null && ConfigurationHelper.isFileTypeSupportedForPreview(dv.getFileType());
                    destinationDocumentVersionName = null;
                    versionPartA = null;
                    versionPartB = null;
                    versionSeparator = null;
                    String documentImplName = null;
                    try {
                        if (destinationCell != null) {
                            DocumentVersion dummy = new DocumentVersion();
                            dummy.setAsBuiltReference(dv);
                            destinationDocumentVersionName = calc.getNumber((Document)dummyDoc, sp.getProject(), destinationCell, (BaseDocumentVersion)dummy);
                            documentImplName = calc.getNumber((Document)dummyDoc, sp.getProject(), true);
                            versionPartA = dummy.getVersionPartA();
                            versionPartB = dummy.getVersionPartB();
                            versionSeparator = dummy.getVersionPartSeperator();
                        }
                    }
                    catch (NumberCalculatorException e) {
                        throw new ActionException("get as-built documents", e);
                    }
                    AsBuiltDocumentTO notTakenOverDocument = null;
                    notTakenOverDocument = new AsBuiltDocumentTO(originalDocument, objectPlanner, destinationCell != null && hasLabelContentsWithAssignedReviewCycle && fileTypeSupportedWithLabelContent ? 0 : 2, destinationDocumentVersionName, versionPartA, versionPartB, versionSeparator, null, documentImplName);
                    if (notTakenOverDocument.getDestinationDocumentVersionName() != null && (nameConflictingDoc = (AsBuiltDocumentTO)uniqueDocumentVersionNameMap.get(notTakenOverDocument.getDestinationDocumentVersionName())) != null) {
                        nameConflictingDoc.setStatus(3);
                        notTakenOverDocument.setStatus(3);
                    }
                    try {
                        String destinationDocName = calc.getNumber((Document)dummyDoc, sp.getProject(), objectPlanner, false);
                        for (DocumentImpl alreadyExistingDestDoc : objectPlanner.getDocuments().values()) {
                            if (!destinationDocName.equals(alreadyExistingDestDoc.getName())) continue;
                            notTakenOverDocument.setStatus(3);
                            break;
                        }
                    }
                    catch (NumberCalculatorException e) {
                        throw new ActionException("get as-built documents", e);
                    }
                    dvs.put(originalDocument.getId(), notTakenOverDocument);
                    uniqueDocumentVersionNameMap.put(notTakenOverDocument.getDestinationDocumentVersionName(), notTakenOverDocument);
                }
            }
            if (dvs.isEmpty()) continue;
            AsBuiltObjectTO objectTO = new AsBuiltObjectTO(object, true);
            objectTO.setDocumentVersions(new ArrayList<AsBuiltDocumentTO>(dvs.values()));
            SubProject sourceSubProject = object.getObject().getAsBuiltReference().getObjectList().getSubProject();
            objectTO.setSourceSubProjectText(sourceSubProject.getCode() + " " + sourceSubProject.getName());
            objectMap.put(objectTO.getId(), objectTO);
        }
        return new ArrayList(objectMap.values());
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    @Override
    public List getReleasedObjectPlannerPositionByParticipation(Integer projectParticipationId, Integer releasedObjectListId) {
        return this.objectPlannerDAO.getReleasedObjectPlannerPositionByParticipation(projectParticipationId, releasedObjectListId);
    }

    @Override
    public List getObjectPlannerReleasesForReviewCycleInstance(Integer reviewCycleInstanceReleaseId) {
        return this.objectPlannerDAO.getAllReleasedObjectPlannersForReviewCycleInstance(reviewCycleInstanceReleaseId);
    }

    @Override
    public void updateObjectAccessMode(Integer objectId, boolean readOnly, CDESCertificate cert, ProjectParticipant projectParticipant, String password) throws WrongPasswordException, FrontendException {
        CDESObjectImpl object = this.objectDAO.getCDESObject(objectId);
        object.setReadOnly(readOnly);
        this.objectDAO.update(object);
        if (readOnly && password != null && password.length() > 0) {
            try {
                this.reviewOperations.abortDocumentsVersionOfObject(object, cert, projectParticipant, password);
            }
            catch (WrongPasswordException e) {
                throw new WrongPasswordException("UpdateObjectAccess", e);
            }
            catch (FrontendException e) {
                e.printStackTrace();
            }
        }
    }
}

