/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.person.PasswordForgottenTicket;
import at.cdes.bo.data.person.Person;
import at.cdes.bo.data.person.PersonTraining;
import at.cdes.db.dao.PersonDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class PersonDAOHibernate
extends HibernateDaoSupport
implements PersonDAO {
    @Override
    public Person getActuallyFromDatabase(Person person) {
        Integer personId = person.getId();
        this.getSession().evict((Object)person);
        Person actualPerson = this.get(personId);
        return actualPerson;
    }

    @Override
    public Person get(Integer id) {
        return (Person)this.getSession().load(Person.class, (Serializable)id);
    }

    @Override
    public List getAll(String criterion, Integer personStatus) {
        Criteria crit = this.getSession().createCriteria(Person.class);
        if (personStatus != null && personStatus >= 0) {
            crit.add((Criterion)Restrictions.like((String)"status", (Object)personStatus));
        } else if (personStatus != null && personStatus < 0) {
            crit.add((Criterion)Restrictions.ne((String)"status", (Object)2));
        }
        if (criterion != null) {
            if (criterion.length() == 1) {
                char c = (criterion = criterion.toLowerCase()).charAt(0);
                if (c == 'a') {
                    crit.add((Criterion)Restrictions.lt((String)"surName", (Object)"b"));
                } else if (c == 'z') {
                    crit.add((Criterion)Restrictions.ge((String)"surName", (Object)"z"));
                } else {
                    crit.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)"surName", (Object)String.valueOf(c)), (Criterion)Restrictions.lt((String)"surName", (Object)String.valueOf((char)(c + '\u0001')))));
                }
            } else {
                crit.add((Criterion)Restrictions.like((String)"surName", (Object)(criterion + "%")));
            }
        }
        return crit.list();
    }

    @Override
    public Person save(Person person) {
        return this.get((Integer)this.getSession().save((Object)person));
    }

    @Override
    public void delete(Person person) {
        this.getSession().delete((Object)person);
    }

    @Override
    public Person get(String login) {
        if (login == null) {
            return null;
        }
        if (login.length() == 0) {
            return null;
        }
        List persons = this.getSession().createCriteria(Person.class).add((Criterion)Restrictions.eq((String)"login", (Object)login)).list();
        if (persons == null || persons.isEmpty() || persons.size() == 0 || persons.size() > 1) {
            return null;
        }
        return (Person)persons.get(0);
    }

    @Override
    public List<Person> getByGlobalRole(Integer roleId) {
        Criteria crit = this.getSession().createCriteria(Person.class).createCriteria("role").add(Restrictions.idEq((Object)roleId));
        return crit.list();
    }

    @Override
    public Person update(Person person) {
        this.getSession().merge((Object)person);
        return person;
    }

    @Override
    public PasswordForgottenTicket getPasswordForgottenTicket(Integer id) {
        return (PasswordForgottenTicket)this.getSession().get(PasswordForgottenTicket.class, (Serializable)id);
    }

    @Override
    public PasswordForgottenTicket getPasswordForgottenTicketByUuid(String uuid) {
        Criteria crit = this.getSession().createCriteria(PasswordForgottenTicket.class);
        crit.add((Criterion)Restrictions.eq((String)"uuid", (Object)uuid));
        return (PasswordForgottenTicket)crit.uniqueResult();
    }

    @Override
    public PasswordForgottenTicket save(PasswordForgottenTicket ticket) {
        return this.getPasswordForgottenTicket((Integer)this.getSession().save((Object)ticket));
    }

    @Override
    public PasswordForgottenTicket update(PasswordForgottenTicket ticket) {
        this.getSession().merge((Object)ticket);
        return ticket;
    }

    @Override
    public List<PersonTraining> getAllTrainings(Integer personId) {
        Criteria crit = this.getSession().createCriteria(PersonTraining.class).createCriteria("person").add(Restrictions.idEq((Object)personId));
        return crit.list();
    }

    public PersonTraining getPersonTraining(Integer trainingId) {
        return (PersonTraining)this.getSession().get(PersonTraining.class, (Serializable)trainingId);
    }

    @Override
    public PersonTraining save(PersonTraining training) {
        Integer id = (Integer)this.getSession().save((Object)training);
        return this.getPersonTraining(id);
    }

    @Override
    public PersonTraining update(PersonTraining training) {
        this.getSession().merge((Object)training);
        return training;
    }

    @Override
    public int getActivePersonCount() {
        Criteria crit = this.getSession().createCriteria(Person.class);
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)2));
        crit.setProjection((Projection)Projections.count((String)"id"));
        List list = crit.list();
        if (list == null || list.isEmpty()) {
            return 0;
        }
        return (Integer)list.get(0);
    }
}

