/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.file;

import at.cdes.service.exception.FileHandleException;

public enum CDESFileRepository {
    PLANREPOSITORY("planRepository"),
    TEMPREPOSITORY("tempRepository"),
    ATTACHMENTREPOSITORY("attachmentRepository"),
    LABELREPOSITORY("labelRepository"),
    ORIGINALDOCUMENTSREPOSITORY("originalDocumentsRepository"),
    DOCUMENTREFSREPOSITORY("documentRefsRepository"),
    PLANNINGNOTIFICATIONREPOSITORY("planningNotificationRepository"),
    PLANNINGNOTIFICATIONATTACHMENTREPOSITORY("planningNotificationAttachmentRepository");

    private final String key;

    private CDESFileRepository(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String toPrefix() {
        switch (this.ordinal()) {
            case 0: {
                return "final";
            }
            case 1: {
                return "upload";
            }
            case 2: {
                return "attachment";
            }
            case 3: {
                return "label";
            }
            case 4: {
                return "original";
            }
            case 5: {
                return "documentRef";
            }
            case 6: {
                return "planningNotification";
            }
            case 7: {
                return "planningNotificationAttachmentPath";
            }
        }
        throw new InternalError("The repository " + (Object)((Object)this) + " is unimplemented.");
    }

    public static CDESFileRepository fromPrefix(String prefix) throws FileHandleException {
        if ("final".equals(prefix)) {
            return PLANREPOSITORY;
        }
        if ("upload".equals(prefix)) {
            return TEMPREPOSITORY;
        }
        if ("attachment".equals(prefix)) {
            return ATTACHMENTREPOSITORY;
        }
        if ("label".equals(prefix)) {
            return LABELREPOSITORY;
        }
        if ("original".equals(prefix)) {
            return ORIGINALDOCUMENTSREPOSITORY;
        }
        if ("documentRef".equals(prefix)) {
            return DOCUMENTREFSREPOSITORY;
        }
        throw new FileHandleException("The repository prefix [" + prefix + "] is unimplemented.");
    }
}

