/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.object.ObjectListImpl;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.project.SubProject;
import at.cdes.db.dao.ObjectListDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.criterion.Restrictions;

public class ObjectListDAOHibernate
extends HibernateDaoSupport
implements ObjectListDAO {
    @Override
    public ObjectListImpl getObjectListImpl(Integer id) {
        return (ObjectListImpl)this.getSession().load(ObjectListImpl.class, (Serializable)id);
    }

    @Override
    public ObjectListImpl save(ObjectListImpl objectList) {
        return this.getObjectListImpl((Integer)this.getSession().save((Object)objectList));
    }

    @Override
    public ObjectListImpl update(ObjectListImpl objectList) {
        this.getSession().merge((Object)objectList);
        return objectList;
    }

    @Override
    public void delete(ObjectListImpl objectList) {
        this.getSession().delete((Object)objectList);
    }

    @Override
    public ReleasedObjectList getReleasedObjectList(Integer id) {
        return (ReleasedObjectList)this.getSession().load(ReleasedObjectList.class, (Serializable)id);
    }

    @Override
    public ReleasedObjectList save(ReleasedObjectList objectList) {
        return this.getReleasedObjectList((Integer)this.getSession().save((Object)objectList));
    }

    @Override
    public ReleasedObjectList update(ReleasedObjectList objectList) {
        this.getSession().merge((Object)objectList);
        return objectList;
    }

    @Override
    public void delete(ReleasedObjectList objectList) {
        this.getSession().delete((Object)objectList);
    }

    @Override
    public List getAllUnreleased(Integer subProjectId) {
        return this.getSession().createCriteria(ObjectListImpl.class).createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId)).list();
    }

    @Override
    public List getAllReleased(Integer subProjectId) {
        return this.getSession().createCriteria(ReleasedObjectList.class).createCriteria("subProject").add(Restrictions.idEq((Object)subProjectId)).list();
    }

    @Override
    public List getReleasedObjectListsByProject(Integer projectId) {
        ArrayList ret = new ArrayList();
        List subProjects = this.getSession().createCriteria(SubProject.class).createCriteria("project").add(Restrictions.idEq((Object)projectId)).list();
        for (SubProject subProject : subProjects) {
            List ol = this.getSession().createCriteria(ReleasedObjectList.class).createCriteria("subProject").add(Restrictions.idEq((Object)subProject.getId())).list();
            if (ol == null || ol.isEmpty()) continue;
            ret.addAll(ol);
        }
        return ret;
    }
}

