/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.db.dao.ProjectParticipationDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;

public class ProjectParticipationDAOHibernate
extends HibernateDaoSupport
implements ProjectParticipationDAO {
    @Override
    public ProjectParticipation get(Integer id) {
        return (ProjectParticipation)this.getSession().load(ProjectParticipation.class, (Serializable)id);
    }

    @Override
    public List<ProjectParticipation> getAll(Integer projectId) {
        if (projectId == null) {
            return this.loadAllHibernate(ProjectParticipation.class);
        }
        return this.findHibernate("from ProjectParticipation where project.id = ?", projectId);
    }

    @Override
    public ProjectParticipation save(ProjectParticipation projectParticpation) {
        return this.get((Integer)this.getSession().save((Object)projectParticpation));
    }

    @Override
    public ProjectParticipation merge(ProjectParticipation projectParticpation) {
        this.getSession().merge((Object)projectParticpation);
        return projectParticpation;
    }

    @Override
    public ProjectParticipation update(ProjectParticipation participation) {
        this.getSession().update((Object)participation);
        return participation;
    }

    @Override
    public void delete(ProjectParticipation projectParticpation) {
        this.getSession().delete((Object)projectParticpation);
    }

    @Override
    public List<ProjectParticipation> getAll(Integer projectId, Integer roleTypeId, boolean showMarkedForDeletion, boolean showInvalidated) {
        Criteria crit = this.getSession().createCriteria(ProjectParticipation.class);
        if (projectId != null) {
            crit.createCriteria("project").add(Restrictions.idEq((Object)projectId));
        }
        if (roleTypeId != null) {
            crit.createCriteria("role").createCriteria("type").add(Restrictions.idEq((Object)roleTypeId));
        }
        if (!showInvalidated) {
            crit.add((Criterion)Restrictions.like((String)"status", (Object)0));
        }
        return crit.list();
    }

    @Override
    public ProjectParticipation getByParticipant(Integer id) {
        ProjectParticipant pant = (ProjectParticipant)this.getSession().get(ProjectParticipant.class, (Serializable)id);
        return pant != null ? pant.getParticipation() : null;
    }

    @Override
    public List<ProjectParticipation> getAllOfOrganisationPerson(Integer projectId, Integer organisationPersonId) {
        Criteria crit = this.getSession().createCriteria(ProjectParticipation.class);
        crit.createCriteria("project").add(Restrictions.idEq((Object)projectId));
        List allParts = crit.list();
        ArrayList<ProjectParticipation> validParts = new ArrayList<ProjectParticipation>();
        block0: for (ProjectParticipation part : allParts) {
            Collection<ProjectParticipant> participants = part.getAllParticipants();
            for (ProjectParticipant participant : participants) {
                if (!participant.getOrganisationPerson().getId().equals(organisationPersonId)) continue;
                validParts.add(part);
                continue block0;
            }
        }
        return validParts;
    }

    @Override
    public List<ProjectParticipation> getAllForAction(String actionName, Integer organisationpersonId, Integer roleType) {
        Criteria crit = this.getSession().createCriteria(ProjectParticipation.class);
        crit.add((Criterion)Restrictions.eq((String)"status", (Object)0));
        crit.createCriteria("project").add((Criterion)Restrictions.eq((String)"status", (Object)0)).add((Criterion)Restrictions.eq((String)"access", (Object)2));
        crit.createCriteria("projectParticipants").createCriteria("organisationPerson").add(Restrictions.idEq((Object)organisationpersonId));
        Criteria rc = crit.createCriteria("role");
        rc.createCriteria("actionRules").createCriteria("action").add((Criterion)Restrictions.eq((String)"name", (Object)actionName));
        if (roleType != null) {
            rc.createCriteria("type").add((Criterion)Restrictions.eq((String)"type", (Object)roleType));
        }
        return crit.list();
    }

    @Override
    public List<ProjectParticipation> getAllForRoleTypeAndProjects(Integer organisationPersonId, List<Project> projects, Integer roleTypeId) {
        Criteria crit = this.getSession().createCriteria(ProjectParticipation.class);
        if (roleTypeId != null) {
            crit.createCriteria("role").createCriteria("type").add(Restrictions.idEq((Object)roleTypeId));
        }
        if (organisationPersonId != null) {
            crit.createCriteria("projectParticipants").createCriteria("organisationPerson").add(Restrictions.idEq((Object)organisationPersonId));
        }
        if (projects != null && !projects.isEmpty()) {
            Disjunction disjunction = Restrictions.disjunction();
            for (Project p : projects) {
                disjunction.add(Restrictions.idEq((Object)p.getId()));
            }
            crit.createCriteria("project").add((Criterion)disjunction);
        }
        return crit.list();
    }
}

