/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.label.LabelContent;
import at.cdes.ext.preview.AbstractDocumentVersionMimeSource;
import at.cdes.ext.preview.AbstractDocumentVersionPdfMimeSource;
import at.cdes.preview.api.Annotation;
import at.cdes.preview.api.IHPGLRenderer;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.ByteArrayMimeInputStream;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.exception.FileHandleException;
import at.cdes.util.ConfigurationHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import org.clazzes.util.http.osgi.DefaultHttpContext;

public class DocumentVersionMimeSource
extends AbstractDocumentVersionMimeSource {
    static Logger logger = Logger.getLogger(AbstractDocumentVersionPdfMimeSource.class);

    @Override
    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        Object firstParameter = parameters[0];
        Integer id = firstParameter instanceof Long ? Integer.valueOf(((Long)firstParameter).intValue()) : (Integer)parameters[0];
        DocumentVersion dv = this.getDocumentVersionDAO().get(id);
        boolean fileTypeSupported = ConfigurationHelper.isFileTypeSupportedForPreview(dv.getFileType());
        FileMimeInputStream stream = null;
        FileMimeInputStream labelStream = null;
        try {
            IMimeInputStream ret;
            File file = this.getFileFinder().findFile(dv.getFileName(), CDESFileRepository.PLANREPOSITORY);
            String unique = this.getFileFinder().makeUniqueName(dv.getFileName(), CDESFileRepository.PLANREPOSITORY);
            stream = new FileMimeInputStream(file, unique, dv.getName() + "." + dv.getFileType(), DefaultHttpContext.getInstance().getMimeType(dv.getFileName()));
            if (!fileTypeSupported || dv.getLabelContentId() == null) {
                FileMimeInputStream ret2 = stream;
                stream = null;
                FileMimeInputStream fileMimeInputStream = ret2;
                return fileMimeInputStream;
            }
            IHPGLRenderer renderer = this.getHpglRenderer();
            LabelContent label = this.getLabelOperations().getLabelContent(dv.getLabelContentId());
            int angle = dv.getPreviewRotation();
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            Date creationDate = new Date();
            creationDate.setTime(file.lastModified());
            byte[] fdf_data = this.getLabelOperations().formatFDF(dv, "pdf".equalsIgnoreCase(dv.getFileType()));
            ByteArrayMimeInputStream fdf_is = new ByteArrayMimeInputStream(fdf_data, 0.001 * (double)file.lastModified(), label.getName(), "application/vnd.fdf");
            annotations.add(new Annotation((IMimeInputStream)fdf_is, "", "", "", 2));
            if (dv.getLabelCorrelation() == null) {
                file = this.getFileFinder().findFile(label.getFileName(), CDESFileRepository.LABELREPOSITORY);
                unique = this.getFileFinder().makeUniqueName(label.getFileName(), CDESFileRepository.LABELREPOSITORY);
                labelStream = new FileMimeInputStream(file, unique, label.getName() + "." + label.getFileType(), DefaultHttpContext.getInstance().getMimeType(label.getFileName()));
                ret = renderer.mergeWithAnnotations((IMimeInputStream)labelStream, label.getRotationAngle(), (IMimeInputStream)stream, angle, annotations, "");
            } else {
                ret = renderer.insertAnnotations((IMimeInputStream)stream, angle, "", annotations);
            }
            IMimeInputStream iMimeInputStream = ret;
            return iMimeInputStream;
        }
        catch (FileHandleException e) {
            throw new IOError("Invalid file handle when fetching the documentversion", (Throwable)e);
        }
        catch (IOException e) {
            throw new IOError("Error rendering FDF sample", (Throwable)e);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (labelStream != null) {
                labelStream.close();
            }
        }
    }
}

