/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.hibernate;

import java.sql.Connection;
import java.sql.SQLException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.clazzes.util.aop.ThreadLocalManager;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateJdbcInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(HibernateJdbcInterceptor.class);
    private String hibernateThreadLocalKey;
    private String threadLocalKey;
    private MethodInterceptor fallbackInterceptor;

    public void setHibernateThreadLocalKey(String hibernateThreadLocalKey) {
        this.hibernateThreadLocalKey = hibernateThreadLocalKey;
    }

    public void setThreadLocalKey(String threadLocalKey) {
        this.threadLocalKey = threadLocalKey;
    }

    public void setFallbackInterceptor(MethodInterceptor fallbackInterceptor) {
        this.fallbackInterceptor = fallbackInterceptor;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Session session = (Session)ThreadLocalManager.getBoundResource((String)this.hibernateThreadLocalKey);
        if (session == null) {
            if (this.fallbackInterceptor == null) {
                throw new RuntimeException("Could not find hibernate session and does not have fallback interceptor.");
            }
            return this.fallbackInterceptor.invoke(invocation);
        }
        try {
            HibernateWork work = new HibernateWork(invocation);
            session.doWork((Work)work);
            return work.getResult();
        }
        catch (WrappedException e) {
            throw e.getCause();
        }
    }

    private class HibernateWork
    implements Work {
        private MethodInvocation invocation;
        private Object result = null;

        public HibernateWork(MethodInvocation invocation) {
            this.invocation = invocation;
        }

        public Object getResult() {
            return this.result;
        }

        public void execute(Connection connection) throws SQLException {
            try {
                log.info("Binding connection {} at {}.", (Object)connection, (Object)HibernateJdbcInterceptor.this.threadLocalKey);
                ThreadLocalManager.bindResource((String)HibernateJdbcInterceptor.this.threadLocalKey, (Object)connection);
                this.result = this.invocation.proceed();
            }
            catch (Throwable e) {
                throw new WrappedException(e);
            }
            finally {
                log.info("Unbinding connection at {}.", (Object)HibernateJdbcInterceptor.this.threadLocalKey);
                ThreadLocalManager.unbindResource((String)HibernateJdbcInterceptor.this.threadLocalKey);
            }
        }
    }

    private static class WrappedException
    extends RuntimeException {
        public WrappedException(Throwable cause) {
            super(cause);
        }
    }
}

