/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.schema;

import at.cdes.db.SchemaUpdateSnippet;
import at.cdes.db.schema.SchemaUpdate_0_178;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.PrimaryKeyInfo;
import org.clazzes.jdbc2xml.schema.TableInfo;

public class SchemaUpdate_0_179
implements SchemaUpdateSnippet {
    protected static final Logger logger = Logger.getLogger(SchemaUpdate_0_178.class);

    @Override
    public String getTargetVersion() {
        return "0.179";
    }

    @Override
    public String getUpdateComment() {
        return "add table master_data_set and create references to sub_project_type, object_type and document_type";
    }

    @Override
    public void performUpdate(ISchemaEngine schemaEngine) throws SQLException {
        logger.info((Object)"Creating table master_data_set");
        TableInfo ti = new TableInfo("master_data_set");
        ti.addColumn(new ColumnInfo("id", 4, Integer.valueOf(20), null, false, null));
        ti.addColumn(new ColumnInfo("name", 12, Integer.valueOf(80), null, false, ""));
        ti.addColumn(new ColumnInfo("description", 12, Integer.valueOf(255), null, true, null));
        ti.addColumn(new ColumnInfo("network_id", 4, Integer.valueOf(20), null, false, null));
        ti.setPrimaryKey(new PrimaryKeyInfo(null, "id"));
        ti.addForeignKey(new ForeignKeyInfo("master_data_set_ibfk_1", "network_id", "network", "id"));
        schemaEngine.createTable(ti, true);
        logger.info((Object)"Creating reference column in sub_project_type");
        TableInfo ti2 = schemaEngine.fetchTableInfo("sub_project_type", null);
        schemaEngine.dropColumn(ti2, "valid_from_date", true);
        schemaEngine.dropColumn(ti2, "valid_to_date", true);
        schemaEngine.addColumn(ti2, new ColumnInfo("master_data_set_id", 4, Integer.valueOf(20), null, true, null));
        schemaEngine.addForeignKey(ti2, new ForeignKeyInfo("sub_project_type_ibfk_2", "master_data_set_id", "master_data_set", "id"));
        logger.info((Object)"Creating reference column in object_type");
        TableInfo ti3 = schemaEngine.fetchTableInfo("object_type", null);
        schemaEngine.dropColumn(ti3, "valid_from_date", true);
        schemaEngine.dropColumn(ti3, "valid_to_date", true);
        schemaEngine.addColumn(ti3, new ColumnInfo("master_data_set_id", 4, Integer.valueOf(20), null, true, null));
        schemaEngine.addForeignKey(ti3, new ForeignKeyInfo("object_type_ibfk_2", "master_data_set_id", "master_data_set", "id"));
        logger.info((Object)"Creating reference column in document_type");
        TableInfo ti4 = schemaEngine.fetchTableInfo("document_type", null);
        schemaEngine.dropColumn(ti4, "valid_from_date", true);
        schemaEngine.dropColumn(ti4, "valid_to_date", true);
        schemaEngine.addColumn(ti4, new ColumnInfo("master_data_set_id", 4, Integer.valueOf(20), null, true, null));
        schemaEngine.addForeignKey(ti4, new ForeignKeyInfo("document_type_ibfk_3", "master_data_set_id", "master_data_set", "id"));
        logger.info((Object)"Creating reference column in document_number_part_group");
        TableInfo ti5 = schemaEngine.fetchTableInfo("document_number_part_group", null);
        schemaEngine.addColumn(ti5, new ColumnInfo("master_data_set_id", 4, Integer.valueOf(20), null, true, null));
        schemaEngine.addForeignKey(ti5, new ForeignKeyInfo("document_number_part_group_ibfk_2", "master_data_set_id", "master_data_set", "id"));
        logger.info((Object)"Commit");
        schemaEngine.commit();
        Statement select = schemaEngine.getConnection().createStatement();
        ResultSet rs1 = select.executeQuery("select id from network");
        PreparedStatement insertStandardMasterDataSets = schemaEngine.getConnection().prepareStatement("insert into master_data_set values (?,?,?,?)");
        while (rs1.next()) {
            int networkId = rs1.getInt("id");
            logger.info((Object)("Creating MasterDataSet with id=[" + networkId + "]"));
            insertStandardMasterDataSets.setInt(1, networkId);
            insertStandardMasterDataSets.setString(2, "Standard-Stammdatensatz");
            insertStandardMasterDataSets.setString(3, "");
            insertStandardMasterDataSets.setInt(4, networkId);
            insertStandardMasterDataSets.executeUpdate();
            logger.info((Object)"updating references in sub_project_type");
            Statement statementSPT = schemaEngine.getConnection().createStatement();
            String sqlStatementSPT = "UPDATE sub_project_type set master_data_set_id=" + networkId + " where network_id=" + networkId;
            statementSPT.execute(sqlStatementSPT);
            statementSPT.close();
            logger.info((Object)"updating references in object_type");
            Statement statementOT = schemaEngine.getConnection().createStatement();
            String sqlStatementOT = "UPDATE object_type set master_data_set_id=" + networkId + " where network_id=" + networkId;
            statementOT.execute(sqlStatementOT);
            statementOT.close();
            logger.info((Object)"updating references in document_type");
            Statement statementDT = schemaEngine.getConnection().createStatement();
            String sqlStatementDT = "UPDATE document_type set master_data_set_id=" + networkId + " where network_id=" + networkId;
            statementDT.execute(sqlStatementDT);
            statementDT.close();
            logger.info((Object)"updating references in document_number_part_group");
            Statement statementDNPG = schemaEngine.getConnection().createStatement();
            statementDNPG.execute("UPDATE document_number_part_group set master_data_set_id=" + networkId + " where network_id=" + networkId);
            statementDNPG.close();
        }
    }
}

