/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.spring;

import at.cdes.util.Configuration;
import at.cdes.util.ConfigurationHelper;
import java.io.File;
import javax.servlet.ServletContext;

public abstract class ServletConfigurationHelper {
    public static final String CONFIGURATION_ATTRIBUTE = "at.cdes.configuration";

    public static String parseServletName(ServletContext scontext) {
        if (scontext != null) {
            String realPath = scontext.getRealPath("");
            return realPath.substring(realPath.lastIndexOf(File.separator) + 1);
        }
        return ConfigurationHelper.getInstanceNameStatic();
    }

    public static void attachConfiguration(ServletContext servletContext) {
        String instanceName = ServletConfigurationHelper.parseServletName(servletContext);
        Configuration configuration = new Configuration(instanceName);
        servletContext.setAttribute(CONFIGURATION_ATTRIBUTE, (Object)configuration);
    }

    public static void detachConfiguration(ServletContext servletContext) {
        servletContext.removeAttribute(CONFIGURATION_ATTRIBUTE);
    }

    public static Configuration getConfiguration(ServletContext servletContext) {
        return (Configuration)servletContext.getAttribute(CONFIGURATION_ATTRIBUTE);
    }
}

