/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec.certificate;

import at.cdes.bo.data.certificate.CDESCertificate;
import at.cdes.bo.data.certificate.CDESCertificateAuthority;
import at.cdes.bo.data.certificate.CertificateRequest;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.sec.certificate.CDESCertificateGenerator;
import at.cdes.bo.sec.certificate.KeyHelper;
import at.cdes.service.exception.CDESCertificateException;
import at.cdes.service.exception.WrongPasswordException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.openssl.PEMEncryptor;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcePEMEncryptorBuilder;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class BouncyCastleCertificateGenerator
implements CDESCertificateGenerator {
    private SecureRandom secureRandom = new SecureRandom();

    @Override
    public CertificateRequest generateInvitation(OrganisationPerson for_orgperson, OrganisationPerson created_by) {
        CertificateRequest cdes_request = new CertificateRequest();
        cdes_request.setChallenge1(this.generateChallenge());
        cdes_request.setChallenge2(this.generateChallenge());
        cdes_request.setCreatedBy(created_by);
        cdes_request.setCreatedFor(for_orgperson);
        cdes_request.setRequest(null);
        cdes_request.setRequestType("Invitation");
        cdes_request.setRequestDate(new Date());
        return cdes_request;
    }

    @Override
    public CDESCertificate generateCertificateRequest(CertificateRequest invitation, OrganisationPerson requester, String password) throws CDESCertificateException {
        if (invitation == null) {
            throw new CDESCertificateException("generateCertificateRequest(): invitation==null");
        }
        JcaPEMWriter pemWriter = null;
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
            kpg.initialize(2048);
            KeyPair kp = kpg.genKeyPair();
            StringWriter sw = new StringWriter();
            pemWriter = new JcaPEMWriter((Writer)sw);
            JcePEMEncryptorBuilder builder = new JcePEMEncryptorBuilder("AES-256-CBC");
            PEMEncryptor encryptor = builder.build(password.toCharArray());
            pemWriter.writeObject((Object)kp.getPrivate(), encryptor);
            pemWriter.close();
            pemWriter = null;
            String privkey_pem = sw.toString();
            String name = "CN=" + requester.getPerson().getCommonName().replace("+", "*").replace(",", ";") + ", O=" + requester.getOrganisation().getName().replace("+", "*").replace(",", ";") + ", C=" + requester.getCountry().getCode2().toUpperCase();
            X509Name xName = new X509Name(name);
            X509Principal subject = new X509Principal(xName);
            PKCS10CertificationRequest request = new PKCS10CertificationRequest("SHA1withRSA", (X509Name)subject, kp.getPublic(), null, kp.getPrivate());
            invitation.setRequest(request.getEncoded());
            invitation.setRequestDate(new Date());
            invitation.setRequestType("Request");
            CDESCertificate cert = new CDESCertificate();
            cert.setCertificateRequest(invitation);
            cert.setCertificate(null);
            cert.setDn(subject.toString());
            cert.setCreatedBy(requester);
            cert.setMayLogin(false);
            cert.setMaySign(false);
            cert.setOrganisationPerson(requester);
            cert.setPrivateKey(privkey_pem);
            cert.setSerial(null);
            cert.setValidFrom(new Date());
            cert.setValidTo(null);
            CDESCertificate cDESCertificate = cert;
            return cDESCertificate;
        }
        catch (IOException e) {
            throw new CDESCertificateException(e);
        }
        catch (InvalidKeyException e) {
            throw new CDESCertificateException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CDESCertificateException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CDESCertificateException(e);
        }
        catch (SignatureException e) {
            throw new CDESCertificateException(e);
        }
        finally {
            try {
                if (pemWriter != null) {
                    pemWriter.close();
                }
            }
            catch (IOException e) {
                throw new CDESCertificateException("Verifying PKCS7 Signature", e);
            }
        }
    }

    @Override
    public CDESCertificate signCertificateRequest(CDESCertificate cert2sign, CDESCertificateAuthority ca, String ca_password, OrganisationPerson signer, int years) throws CDESCertificateException, WrongPasswordException {
        PEMParser pr2 = null;
        try {
            KeyPair rootca_keypair = KeyHelper.openKeyPair(ca.getPrivateKey(), ca_password);
            StringReader sr2 = new StringReader(ca.getCertificate());
            pr2 = new PEMParser((Reader)sr2);
            Object o2 = pr2.readObject();
            X509CertificateHolder x509CertHolder2 = (X509CertificateHolder)o2;
            X509Certificate ca_cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertHolder2);
            CertificateRequest request2sign = cert2sign.getCertificateRequest();
            PKCS10CertificationRequest pkcs10_request = new PKCS10CertificationRequest(request2sign.getRequest());
            X509V3CertificateGenerator gen = new X509V3CertificateGenerator();
            CertificateRequest req = cert2sign.getCertificateRequest();
            PKCS10CertificationRequest request = new PKCS10CertificationRequest(req.getRequest());
            gen.addExtension(X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
            gen.setPublicKey(request.getPublicKey());
            gen.setSubjectDN(X509Name.getInstance((Object)request.getCertificationRequestInfo().getSubject()));
            gen.setSignatureAlgorithm("SHA1withRSA");
            gen.setPublicKey(pkcs10_request.getPublicKey());
            gen.setSubjectDN(X509Name.getInstance((Object)pkcs10_request.getCertificationRequestInfo().getSubject()));
            long now = System.currentTimeMillis();
            Date from_date = new Date(now);
            gen.setNotBefore(from_date);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(from_date);
            ((Calendar)cal).add(1, 4);
            Date to_date = cal.getTime();
            gen.setNotAfter(to_date);
            gen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
            gen.setSignatureAlgorithm("SHA1withRSA");
            gen.setIssuerDN(ca_cert.getSubjectX500Principal());
            X509Certificate cert = gen.generateX509Certificate(rootca_keypair.getPrivate());
            StringWriter sw = new StringWriter();
            PEMWriter pw = new PEMWriter((Writer)sw);
            pw.writeObject((Object)cert);
            pw.close();
            String cert_pem = sw.toString();
            cert2sign.setCertificate(cert_pem);
            cert2sign.setSerial(cert.getSerialNumber().toString(16));
            cert2sign.setCreatedBy(signer);
            cert2sign.setMayLogin(true);
            cert2sign.setMaySign(true);
            cert2sign.setValidFrom(from_date);
            cert2sign.setValidTo(to_date);
            request2sign.setRequestType("Accepted");
            cert2sign.setCertificateRequest(request2sign);
            CDESCertificate cDESCertificate = cert2sign;
            return cDESCertificate;
        }
        catch (CertificateException e) {
            throw new CDESCertificateException(e);
        }
        catch (InvalidKeyException e) {
            throw new CDESCertificateException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CDESCertificateException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CDESCertificateException(e);
        }
        catch (IOException e) {
            throw new CDESCertificateException(e);
        }
        catch (SecurityException e) {
            throw new CDESCertificateException(e);
        }
        catch (SignatureException e) {
            throw new CDESCertificateException(e);
        }
        finally {
            try {
                if (pr2 != null) {
                    pr2.close();
                }
            }
            catch (IOException e) {
                throw new CDESCertificateException("Verifying PKCS7 Signature", e);
            }
        }
    }

    @Override
    public CDESCertificateAuthority generateRootCA(String subject_dn, String password, int years, OrganisationPerson created_by) throws CDESCertificateException {
        JcaPEMWriter pw2 = null;
        try {
            KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
            kpGen.initialize(2048, new SecureRandom());
            KeyPair pair = kpGen.generateKeyPair();
            X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
            certGen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
            X509Principal subject = new X509Principal(subject_dn);
            certGen.setIssuerDN((X509Name)subject);
            long now = System.currentTimeMillis();
            Date from_date = new Date(now);
            certGen.setNotBefore(from_date);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(from_date);
            ((Calendar)cal).add(1, 4);
            Date to_date = cal.getTime();
            certGen.setNotAfter(to_date);
            certGen.setSubjectDN((X509Name)subject);
            certGen.setPublicKey(pair.getPublic());
            certGen.setSignatureAlgorithm("SHA1withRSA");
            certGen.addExtension(X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
            certGen.addExtension(X509Extensions.KeyUsage, true, (ASN1Encodable)new KeyUsage(166));
            certGen.addExtension(X509Extensions.ExtendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_serverAuth));
            X509Certificate x509_cert = certGen.generateX509Certificate(pair.getPrivate(), "BC");
            CDESCertificateAuthority cdes_ca = new CDESCertificateAuthority();
            cdes_ca.setCaCert(null);
            cdes_ca.setCertCaDn(x509_cert.getIssuerDN().toString());
            StringWriter sw = new StringWriter();
            PEMWriter pw = new PEMWriter((Writer)sw);
            pw.writeObject((Object)x509_cert);
            pw.close();
            cdes_ca.setCertificate(sw.toString());
            cdes_ca.setSerial(x509_cert.getSerialNumber().toString(16));
            StringWriter sw2 = new StringWriter();
            pw2 = new JcaPEMWriter((Writer)sw2);
            JcePEMEncryptorBuilder builder = new JcePEMEncryptorBuilder("AES-256-CBC");
            PEMEncryptor encryptor = builder.build(password.toCharArray());
            pw2.writeObject((Object)pair.getPrivate(), encryptor);
            pw2.close();
            pw2 = null;
            cdes_ca.setPrivateKey(sw2.toString());
            cdes_ca.setMayAuthenticate(true);
            cdes_ca.setMayIssue(true);
            cdes_ca.setCreatedBy(created_by);
            cdes_ca.setSerial(x509_cert.getSerialNumber().toString());
            cdes_ca.setSubjectDn(subject_dn);
            cdes_ca.setValidFrom(from_date);
            cdes_ca.setValidTo(to_date);
            CDESCertificateAuthority cDESCertificateAuthority = cdes_ca;
            return cDESCertificateAuthority;
        }
        catch (InvalidKeyException e) {
            throw new CDESCertificateException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CDESCertificateException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CDESCertificateException(e);
        }
        catch (SecurityException e) {
            throw new CDESCertificateException(e);
        }
        catch (SignatureException e) {
            throw new CDESCertificateException(e);
        }
        catch (IOException e) {
            throw new CDESCertificateException(e);
        }
        finally {
            try {
                if (pw2 != null) {
                    pw2.close();
                }
            }
            catch (IOException e) {
                throw new CDESCertificateException("Verifying PKCS7 Signature", e);
            }
        }
    }

    @Override
    public CDESCertificateAuthority generateUserCA(String subject_dn, String password, Network for_network, OrganisationPerson created_by, CDESCertificateAuthority rootca, String rootcapassword) throws CDESCertificateException, WrongPasswordException {
        PEMParser pr2 = null;
        JcaPEMWriter pw2 = null;
        try {
            KeyPair rootca_keypair = KeyHelper.openKeyPair(rootca.getPrivateKey(), rootcapassword);
            StringReader sr2 = new StringReader(rootca.getCertificate());
            pr2 = new PEMParser((Reader)sr2);
            Object o2 = pr2.readObject();
            X509CertificateHolder x509CertHolder = (X509CertificateHolder)o2;
            X509Certificate rootca_cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertHolder);
            KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
            kpGen.initialize(2048, new SecureRandom());
            KeyPair upair = kpGen.generateKeyPair();
            X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
            certGen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
            certGen.setIssuerDN(rootca_cert.getSubjectX500Principal());
            long now = System.currentTimeMillis();
            Date from_date = new Date(now);
            certGen.setNotBefore(from_date);
            certGen.setNotAfter(rootca_cert.getNotAfter());
            certGen.setSubjectDN((X509Name)new X509Principal(subject_dn));
            certGen.setPublicKey(upair.getPublic());
            certGen.setSignatureAlgorithm("SHA1withRSA");
            certGen.addExtension(X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
            certGen.addExtension(X509Extensions.KeyUsage, true, (ASN1Encodable)new KeyUsage(166));
            certGen.addExtension(X509Extensions.ExtendedKeyUsage, true, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_serverAuth));
            X509Certificate x509_cert = certGen.generateX509Certificate(rootca_keypair.getPrivate(), "BC");
            CDESCertificateAuthority cdes_userca = new CDESCertificateAuthority();
            cdes_userca.setCaCert(rootca);
            cdes_userca.setCertCaDn(rootca.getSubjectDn());
            cdes_userca.setNetwork(for_network);
            StringWriter sw = new StringWriter();
            PEMWriter pw = new PEMWriter((Writer)sw);
            pw.writeObject((Object)x509_cert);
            pw.close();
            cdes_userca.setCertificate(sw.toString());
            cdes_userca.setSerial(x509_cert.getSerialNumber().toString(16));
            StringWriter sw2 = new StringWriter();
            pw2 = new JcaPEMWriter((Writer)sw2);
            JcePEMEncryptorBuilder builder = new JcePEMEncryptorBuilder("AES-256-CBC");
            PEMEncryptor encryptor = builder.build(password.toCharArray());
            pw2.writeObject((Object)upair.getPrivate(), encryptor);
            pw2.close();
            pw2 = null;
            cdes_userca.setPrivateKey(sw2.toString());
            cdes_userca.setMayAuthenticate(true);
            cdes_userca.setMayIssue(true);
            cdes_userca.setCreatedBy(created_by);
            cdes_userca.setSerial(x509_cert.getSerialNumber().toString());
            cdes_userca.setSubjectDn(subject_dn);
            cdes_userca.setValidFrom(from_date);
            cdes_userca.setValidTo(rootca_cert.getNotAfter());
            CDESCertificateAuthority cDESCertificateAuthority = cdes_userca;
            return cDESCertificateAuthority;
        }
        catch (CertificateException e) {
            throw new CDESCertificateException(e);
        }
        catch (InvalidKeyException e) {
            throw new CDESCertificateException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CDESCertificateException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CDESCertificateException(e);
        }
        catch (SecurityException e) {
            throw new CDESCertificateException(e);
        }
        catch (SignatureException e) {
            throw new CDESCertificateException(e);
        }
        catch (IOException e) {
            throw new CDESCertificateException(e);
        }
        finally {
            try {
                if (pr2 != null) {
                    pr2.close();
                }
                if (pw2 != null) {
                    pw2.close();
                }
            }
            catch (IOException e) {
                throw new CDESCertificateException("Verifying PKCS7 Signature", e);
            }
        }
    }

    @Override
    public String generateChallenge() {
        return this.generateChallenge(16);
    }

    @Override
    public String generateChallenge(int length) {
        String randomChars = "123456789ABCDEFGHJKLMNPQRSTUVWXZ";
        char[] newpwd = new char[length];
        for (int i = 0; i < length; ++i) {
            newpwd[i] = randomChars.charAt(this.secureRandom.nextInt(randomChars.length()));
        }
        return new String(newpwd);
    }

    @Override
    public CDESCertificate changePassword(String newPassword, String oldPassword, CDESCertificate cert) throws WrongPasswordException {
        KeyPair pair = KeyHelper.openKeyPair(cert.getPrivateKey(), oldPassword);
        JcaPEMWriter pw2 = null;
        try {
            StringWriter sw2 = new StringWriter();
            pw2 = new JcaPEMWriter((Writer)sw2);
            JcePEMEncryptorBuilder builder = new JcePEMEncryptorBuilder("AES-256-CBC");
            PEMEncryptor encryptor = builder.build(newPassword.toCharArray());
            pw2.writeObject((Object)pair.getPrivate(), encryptor);
            pw2.close();
            pw2 = null;
            cert.setPrivateKey(sw2.toString());
            CDESCertificate cDESCertificate = cert;
            return cDESCertificate;
        }
        catch (IOException e) {
            throw new WrongPasswordException();
        }
        finally {
            try {
                if (pw2 != null) {
                    pw2.close();
                }
            }
            catch (IOException e) {
                throw new WrongPasswordException("Verifying PKCS7 Signature", e);
            }
        }
    }

    @Override
    public CDESCertificateAuthority changePassword(String newPassword, String oldPassword, CDESCertificateAuthority ca) throws WrongPasswordException {
        JcaPEMWriter pw2 = null;
        try {
            KeyPair pair = KeyHelper.openKeyPair(ca.getPrivateKey(), oldPassword);
            StringWriter sw2 = new StringWriter();
            pw2 = new JcaPEMWriter((Writer)sw2);
            JcePEMEncryptorBuilder builder = new JcePEMEncryptorBuilder("AES-256-CBC");
            PEMEncryptor encryptor = builder.build(newPassword.toCharArray());
            pw2.writeObject((Object)pair.getPrivate(), encryptor);
            pw2.close();
            pw2 = null;
            ca.setPrivateKey(sw2.toString());
            CDESCertificateAuthority cDESCertificateAuthority = ca;
            return cDESCertificateAuthority;
        }
        catch (IOException e) {
            throw new WrongPasswordException();
        }
        finally {
            try {
                if (pw2 != null) {
                    pw2.close();
                }
            }
            catch (IOException e) {
                throw new WrongPasswordException("Verifying PKCS7 Signature", e);
            }
        }
    }

    @Override
    public CDESCertificate renewCertificate(CDESCertificate oldCert, CDESCertificate cert2sign, CDESCertificateAuthority ca, String ca_password, OrganisationPerson signer, int years) throws CDESCertificateException, WrongPasswordException {
        PEMParser pr = null;
        PEMParser pr2 = null;
        try {
            KeyPair rootca_keypair = KeyHelper.openKeyPair(ca.getPrivateKey(), ca_password);
            StringReader sr2 = new StringReader(ca.getCertificate());
            pr2 = new PEMParser((Reader)sr2);
            Object o2 = pr2.readObject();
            X509CertificateHolder x509CertHolder2 = (X509CertificateHolder)o2;
            X509Certificate ca_cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertHolder2);
            X509V3CertificateGenerator gen = new X509V3CertificateGenerator();
            StringReader sr = new StringReader(ca.getCertificate());
            pr = new PEMParser((Reader)sr);
            Object o = pr.readObject();
            X509CertificateHolder x509CertHolder = (X509CertificateHolder)o;
            X509Certificate x509Cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertHolder);
            gen.setPublicKey(x509Cert.getPublicKey());
            gen.setSubjectDN(x509Cert.getSubjectX500Principal());
            gen.setSignatureAlgorithm("SHA1withRSA");
            long now = System.currentTimeMillis();
            Date from_date = new Date(now);
            gen.setNotBefore(from_date);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(from_date);
            ((Calendar)cal).add(1, 4);
            Date to_date = cal.getTime();
            gen.setNotAfter(to_date);
            gen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
            gen.setSignatureAlgorithm("SHA1withRSA");
            gen.setIssuerDN(ca_cert.getSubjectX500Principal());
            X509Certificate cert = gen.generateX509Certificate(rootca_keypair.getPrivate());
            StringWriter sw = new StringWriter();
            PEMWriter pw = new PEMWriter((Writer)sw);
            pw.writeObject((Object)cert);
            pw.close();
            String cert_pem = sw.toString();
            cert2sign.setCertificate(cert_pem);
            cert2sign.setSerial(cert.getSerialNumber().toString(16));
            cert2sign.setCreatedBy(signer);
            cert2sign.setMayLogin(true);
            cert2sign.setMaySign(true);
            cert2sign.setValidFrom(from_date);
            cert2sign.setValidTo(to_date);
            CDESCertificate cDESCertificate = cert2sign;
            return cDESCertificate;
        }
        catch (CertificateException e) {
            throw new CDESCertificateException(e);
        }
        catch (InvalidKeyException e) {
            throw new CDESCertificateException(e);
        }
        catch (IOException e) {
            throw new CDESCertificateException(e);
        }
        catch (SecurityException e) {
            throw new CDESCertificateException(e);
        }
        catch (SignatureException e) {
            throw new CDESCertificateException(e);
        }
        finally {
            try {
                if (pr != null) {
                    pr.close();
                }
                if (pr2 != null) {
                    pr2.close();
                }
            }
            catch (IOException e) {
                throw new CDESCertificateException("Verifying PKCS7 Signature", e);
            }
        }
    }

    @Override
    public CDESCertificate generateDirectCertificate(OrganisationPerson requester, String privkey) {
        String name = "CN=" + requester.getPerson().getCommonName().replace("+", "*").replace(",", ";") + ", O=" + requester.getOrganisation().getName().replace("+", "*").replace(",", ";") + ", C=" + requester.getCountry().getCode2().toUpperCase();
        X509Name xName = new X509Name(name);
        X509Principal subject = new X509Principal(xName);
        CDESCertificate cert = new CDESCertificate();
        cert.setCertificate(null);
        cert.setDn(subject.toString());
        cert.setCreatedBy(requester);
        cert.setMayLogin(false);
        cert.setMaySign(false);
        cert.setOrganisationPerson(requester);
        cert.setPrivateKey(privkey);
        cert.setSerial(null);
        cert.setValidFrom(new Date());
        cert.setValidTo(null);
        return cert;
    }

    @Override
    public CDESCertificate signCertificateDirectly(CDESCertificate cert2sign, CDESCertificateAuthority ca, String userPassword, OrganisationPerson signer, int duration_years, CDESCertificate oldCert) throws CDESCertificateException, WrongPasswordException {
        PEMParser pr = null;
        PEMParser pr2 = null;
        try {
            KeyPair rootca_keypair = KeyHelper.openKeyPair(ca.getPrivateKey(), userPassword);
            StringReader sr2 = new StringReader(ca.getCertificate());
            pr2 = new PEMParser((Reader)sr2);
            Object o2 = pr2.readObject();
            X509CertificateHolder x509CertHolder2 = (X509CertificateHolder)o2;
            X509Certificate ca_cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertHolder2);
            X509V3CertificateGenerator gen = new X509V3CertificateGenerator();
            StringReader sr = new StringReader(oldCert.getCertificate());
            pr = new PEMParser((Reader)sr);
            Object o = pr.readObject();
            X509CertificateHolder x509CertHolder = (X509CertificateHolder)o2;
            X509Certificate x509Cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertHolder);
            gen.addExtension(X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
            gen.setPublicKey(x509Cert.getPublicKey());
            gen.setSubjectDN(new X509Name(cert2sign.getDn()));
            long now = System.currentTimeMillis();
            Date from_date = new Date(now);
            gen.setNotBefore(from_date);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(from_date);
            ((Calendar)cal).add(1, 4);
            Date to_date = cal.getTime();
            gen.setNotAfter(to_date);
            gen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
            gen.setSignatureAlgorithm("SHA1withRSA");
            gen.setIssuerDN(ca_cert.getSubjectX500Principal());
            X509Certificate cert = gen.generateX509Certificate(rootca_keypair.getPrivate());
            StringWriter sw = new StringWriter();
            PEMWriter pw = new PEMWriter((Writer)sw);
            pw.writeObject((Object)cert);
            pw.close();
            String cert_pem = sw.toString();
            cert2sign.setCertificate(cert_pem);
            cert2sign.setCertificateRequest(oldCert.getCertificateRequest());
            cert2sign.setSerial(cert.getSerialNumber().toString(16));
            cert2sign.setCreatedBy(signer);
            cert2sign.setMayLogin(true);
            cert2sign.setMaySign(true);
            cert2sign.setValidFrom(from_date);
            cert2sign.setValidTo(to_date);
            CDESCertificate cDESCertificate = cert2sign;
            return cDESCertificate;
        }
        catch (CertificateException e) {
            throw new CDESCertificateException(e);
        }
        catch (InvalidKeyException e) {
            throw new CDESCertificateException(e);
        }
        catch (IOException e) {
            throw new CDESCertificateException(e);
        }
        catch (SecurityException e) {
            throw new CDESCertificateException(e);
        }
        catch (SignatureException e) {
            throw new CDESCertificateException(e);
        }
        finally {
            try {
                if (pr2 != null) {
                    pr2.close();
                }
            }
            catch (IOException e) {
                throw new CDESCertificateException("Verifying PKCS7 Signature", e);
            }
        }
    }
}

