/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db;

import at.cdes.db.SchemaCheckerBean;
import at.cdes.db.masterdata.IActionRuleUpdater;
import at.cdes.hibernate.HibernateSessionInterceptor;
import at.cdes.hibernate.HibernateSessionOptimizer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.aop.jdbc.JdbcTransactionInterceptor;
import org.clazzes.util.osgi.ServiceMapListener;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.w3c.dom.Document;

public class DBSetup
implements ServiceMapListener {
    private static final Logger log = Logger.getLogger(DBSetup.class);
    private IActionRuleUpdater actionRuleUpdater;
    private Integer maxFetchDepth;
    private String dataSourceName;
    private JdbcTransactionInterceptor jdbcInterceptor;
    private HibernateSessionInterceptor hibernateInterceptor;
    private SchemaCheckerBean schemaChecker;
    private HibernateSessionOptimizer hibernateSessionOptimizer;
    private String dataSourceThreadLocalKey;
    private Boolean useSecondLevelCache;

    public void setActionRuleUpdater(IActionRuleUpdater actionRuleUpdater) {
        this.actionRuleUpdater = actionRuleUpdater;
    }

    public void setMaxFetchDepth(Integer maxFetchDepth) {
        this.maxFetchDepth = maxFetchDepth;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setJdbcInterceptor(JdbcTransactionInterceptor jdbcInterceptor) {
        this.jdbcInterceptor = jdbcInterceptor;
    }

    public void setHibernateInterceptor(HibernateSessionInterceptor hibernateInterceptor) {
        this.hibernateInterceptor = hibernateInterceptor;
    }

    public void setSchemaChecker(SchemaCheckerBean schemaChecker) {
        this.schemaChecker = schemaChecker;
    }

    public void setHibernateSessionOptimizer(HibernateSessionOptimizer hibernateSessionOptimizer) {
        this.hibernateSessionOptimizer = hibernateSessionOptimizer;
    }

    public void setDataSourceThreadLocalKey(String dataSourceThreadLocalKey) {
        this.dataSourceThreadLocalKey = dataSourceThreadLocalKey;
    }

    public void setUseSecondLevelCache(Boolean useSecondLevelCache) {
        this.useSecondLevelCache = useSecondLevelCache;
    }

    private static Document parseConfiguration(String resourcePath) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceBound(String key, Object service) {
        if (!this.dataSourceName.equals(key)) {
            return;
        }
        DataSource dataSource = (DataSource)service;
        if (log.isInfoEnabled()) {
            log.info((Object)("Data source [" + this.dataSourceName + "] became available."));
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            SessionFactory sessionFactory;
            Thread.currentThread().setContextClassLoader(DBSetup.class.getClassLoader());
            try {
                Connection connection = dataSource.getConnection();
                ISchemaEngine schemaEngine = this.schemaChecker.getSchemaEngine();
                schemaEngine.setConnection(connection);
            }
            catch (Throwable e) {
                log.error((Object)"Error fetching connection and putting it into the schemaEngine of the schemaChecker", e);
                throw new DAOException(e);
            }
            try {
                this.schemaChecker.checkSchema();
            }
            catch (Throwable e) {
                log.error((Object)"Error during schema check", e);
                throw new DAOException(e);
            }
            this.hibernateInterceptor.setDataSource(dataSource);
            this.jdbcInterceptor.setDataSource(dataSource);
            ThreadLocalManager.bindResource((String)this.dataSourceThreadLocalKey, (Object)dataSource);
            try {
                Configuration configuration = new Configuration();
                Configuration config = configuration.configure(DBSetup.parseConfiguration("/conf/dbmapping/hibernate.cfg.xml"));
                ISchemaEngine schemaEngine = this.schemaChecker.getSchemaEngine();
                Connection connection = schemaEngine.getConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                String productName = metaData.getDatabaseProductName();
                if (productName != null && productName.contains("MariaDB")) {
                    config.setProperty("hibernate.dialect", "org.hibernate.dialect.MySQL5Dialect");
                }
                if (this.maxFetchDepth != null) {
                    config.setProperty("hibernate.max_fetch_depth", this.maxFetchDepth.toString());
                }
                if (this.useSecondLevelCache != null) {
                    config.setProperty("hibernate.cache.use_second_level_cache", this.useSecondLevelCache.toString());
                }
                sessionFactory = config.buildSessionFactory();
            }
            catch (Throwable e) {
                log.info((Object)"Constructing sessionFactory failed", e);
                throw new DAOException(e);
            }
            finally {
                ThreadLocalManager.unbindResource((String)this.dataSourceThreadLocalKey);
            }
            this.hibernateInterceptor.setSessionFactory(sessionFactory);
            this.hibernateSessionOptimizer.setSessionFactory(sessionFactory);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            try {
                ISchemaEngine schemaEngine = this.schemaChecker.getSchemaEngine();
                schemaEngine.getConnection().close();
                schemaEngine.setConnection(null);
            }
            catch (Throwable e) {
                log.error((Object)"Error fetching connection and putting it into the schemaEngine of the schemaChecker", e);
                throw new DAOException(e);
            }
        }
        try {
            this.actionRuleUpdater.startUpdate();
        }
        catch (Exception e) {
            log.error((Object)"Caught exception while updating masterData", (Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Data base setup for data source [" + this.dataSourceName + "] successful, cdes is now fully operational."));
        }
    }

    public void serviceUnbound(String key, Object service) {
        if (!this.dataSourceName.equals(key)) {
            return;
        }
        DataSource dataSource = (DataSource)service;
        if (log.isInfoEnabled()) {
            log.info((Object)("Data source [" + this.dataSourceName + "] is disappearing..."));
        }
        SessionFactory sessionFactory = this.hibernateInterceptor.getSessionFactory();
        try {
            sessionFactory.close();
        }
        catch (Throwable e) {
            log.warn((Object)"sessionFactory.close failed.", e);
        }
        this.hibernateInterceptor.setDataSource(null);
        this.jdbcInterceptor.setDataSource(null);
        if (log.isInfoEnabled()) {
            log.info((Object)("Data source [" + this.dataSourceName + "] has disappeared, cdes was successfully shut down."));
        }
    }
}

