/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.label.LabelContent;
import at.cdes.bo.document.DocumentTranslator;
import at.cdes.bo.document.DocumentVersionHelper;
import at.cdes.ext.preview.AbstractDocumentVersionMimeSource;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.preview.api.Annotation;
import at.cdes.preview.api.IHPGLRenderer;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.preview.api.PDFProperty;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.exception.FileHandleException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.activation.UnsupportedDataTypeException;
import org.apache.log4j.Logger;
import org.clazzes.util.http.osgi.DefaultHttpContext;
import org.xnap.commons.i18n.I18n;

public abstract class AbstractDocumentVersionPdfMimeSource
extends AbstractDocumentVersionMimeSource {
    static Logger logger = Logger.getLogger(AbstractDocumentVersionPdfMimeSource.class);

    protected abstract List<PDFProperty> getPDFProperties(DocumentVersion var1, Object[] var2, I18n var3) throws UnsupportedDataTypeException;

    public boolean needPDFPostProcessing(DocumentVersion documentVersion, Object[] parameters) {
        if (documentVersion.getPreviewRotation() != documentVersion.getNativeRotation()) {
            return true;
        }
        Locale locale = DocumentVersionHelper.getProjectLocaleFromDocumentVersion(documentVersion);
        I18n i18n = I18nFactory.getI18n(locale);
        String stamp = DocumentTranslator.getStatusStamp(i18n, documentVersion.getStatus());
        return stamp.length() > 0;
    }

    public abstract List<Annotation> getAnnotations(DocumentVersion var1, Object[] var2) throws PreviewException, IOException, FileHandleException;

    @Override
    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        Integer id;
        if (parameters[0] instanceof Long) {
            Long longValue = (Long)parameters[0];
            id = longValue.intValue();
        } else {
            id = (Integer)parameters[0];
        }
        DocumentVersion dv = this.getDocumentVersionDAO().get(id);
        FileMimeInputStream stream = null;
        FileMimeInputStream labelStream = null;
        try {
            FileMimeInputStream ret;
            File file = this.getFileFinder().findFile(dv.getFileName(), CDESFileRepository.PLANREPOSITORY);
            String unique = this.getFileFinder().makeUniqueName(dv.getFileName(), CDESFileRepository.PLANREPOSITORY);
            stream = new FileMimeInputStream(file, unique, dv.getName() + "." + dv.getFileType(), DefaultHttpContext.getInstance().getMimeType(dv.getFileName()));
            if ("pdf".equalsIgnoreCase(dv.getFileType()) && !this.needPDFPostProcessing(dv, parameters)) {
                ret = stream;
                stream = null;
            } else {
                Locale locale = DocumentVersionHelper.getProjectLocaleFromDocumentVersion(dv);
                I18n i18n = I18nFactory.getI18n(locale);
                String stamp = DocumentTranslator.getStatusStamp(i18n, dv.getStatus());
                IHPGLRenderer renderer = this.getHpglRenderer();
                List<PDFProperty> properties = this.getPDFProperties(dv, parameters, i18n);
                List<Annotation> annotations = this.getAnnotations(dv, parameters);
                if (dv.getLabelContentId() != null && dv.getLabelCorrelation() == null) {
                    LabelContent label = this.getLabelOperations().getLabelContent(dv.getLabelContentId());
                    file = this.getFileFinder().findFile(label.getFileName(), CDESFileRepository.LABELREPOSITORY);
                    unique = this.getFileFinder().makeUniqueName(label.getFileName(), CDESFileRepository.LABELREPOSITORY);
                    labelStream = new FileMimeInputStream(file, unique, label.getName() + "." + label.getFileType(), DefaultHttpContext.getInstance().getMimeType(label.getFileName()));
                    ret = renderer.mergePdfWithAnnotations((IMimeInputStream)labelStream, label.getRotationAngle(), (IMimeInputStream)stream, dv.getPreviewRotation(), annotations, stamp, properties);
                } else {
                    ret = renderer.renderPdf((IMimeInputStream)stream, properties, dv.getPreviewRotation(), stamp, annotations);
                }
            }
            FileMimeInputStream fileMimeInputStream = ret;
            return fileMimeInputStream;
        }
        catch (FileHandleException e) {
            throw new IOError("Invalid file handle when fetching the documentversion", (Throwable)e);
        }
        catch (IOException e) {
            throw new IOError("IOException preparing PDF MimeSource", (Throwable)e);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (labelStream != null) {
                labelStream.close();
            }
        }
    }
}

