/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.sec;

import at.cdes.api.compositeDto.PageContext;
import at.cdes.api.guiService.ContextService;
import at.cdes.api.guiService.TabSessionContextService;
import at.cdes.bo.data.sec.TabSession;
import at.cdes.impl.sec.CdesSessionController;
import at.cdes.impl.sec.LoginSession;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CdesSessionControllerImpl
implements CdesSessionController,
TabSessionContextService {
    private static final Logger logger = Logger.getLogger((String)CdesSessionControllerImpl.class.getName());
    private Map<String, LoginSession> validLoginSessions = new HashMap<String, LoginSession>();
    private Map<String, TabSession> validTabSessions = new HashMap<String, TabSession>();
    private final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final int TIMEOUT_MILLIS = 10800000;
    private ContextService contextService;

    public void setContextService(ContextService contextService) {
        this.contextService = contextService;
    }

    public void registerLoginSession(LoginSession session) {
        logger.info((Object)("registering login session for user=[" + session.getPersonId() + "] ssId=[" + session.getLoginSessionId() + "] validFrom=[" + this.df.format(session.getValidFrom()) + "] validTo=[" + this.df.format(session.getValidTo()) + "]"));
        this.validLoginSessions.put(session.getLoginSessionId(), session);
    }

    public boolean isLoginSessionValid(String ssId) {
        LoginSession gwtSession = this.validLoginSessions.get(ssId);
        if (gwtSession == null || gwtSession.getValidTo().before(Calendar.getInstance().getTime())) {
            if (gwtSession != null) {
                this.closeLoginSession(ssId);
            }
            return false;
        }
        return true;
    }

    public void closeLoginSession(String ssId) {
        this.validLoginSessions.remove(ssId);
    }

    public LoginSession getLoginSession(String ssId) {
        return this.validLoginSessions.get(ssId);
    }

    public void registerTabSession(TabSession tabSession) {
        this.validTabSessions.put(tabSession.getTabSessionId(), tabSession);
    }

    public boolean isTabSessionValid(String tabSessionId) {
        TabSession tabSession = this.validTabSessions.get(tabSessionId);
        return tabSession != null;
    }

    @Override
    public void closeTabSession(String tabSessionId) {
        this.validTabSessions.remove(tabSessionId);
    }

    public TabSession getTabSession(String tabSessionId) {
        return this.validTabSessions.get(tabSessionId);
    }

    @Override
    public TabSession getTabSessionIfValid(String tabSessionId) {
        if (this.isTabSessionValid(tabSessionId)) {
            return this.getTabSession(tabSessionId);
        }
        return null;
    }

    public PageContext getPageContextFromTabSession(String tabSessionId) {
        TabSession tabSession = this.getTabSessionIfValid(tabSessionId);
        if (tabSession == null) {
            return null;
        }
        Long networkId = tabSession.getContextNetworkId() != null ? new Long(tabSession.getContextNetworkId().intValue()) : null;
        Long projectId = tabSession.getContextProjectId() != null ? new Long(tabSession.getContextProjectId().intValue()) : null;
        Long subProjectId = tabSession.getContextSubProjectId() != null ? new Long(tabSession.getContextSubProjectId().intValue()) : null;
        Long pnNetworkId = tabSession.getPnContextNetworkId() != null ? new Long(tabSession.getPnContextNetworkId().intValue()) : null;
        Long pnProjectId = tabSession.getPnContextProjectId() != null ? new Long(tabSession.getPnContextProjectId().intValue()) : null;
        Long organisationPersonId = tabSession.getContextOrganisationPersonId() != null ? new Long(tabSession.getContextOrganisationPersonId().intValue()) : null;
        return this.contextService.getPageContext(networkId, projectId, subProjectId, pnNetworkId, pnProjectId, organisationPersonId);
    }

    public void writeContext(String tabSessionId, Long organisationPersonId, Long networkId, Long projectId, Long subProjectId) {
        TabSession tabSession = this.getTabSessionIfValid(tabSessionId);
        if (tabSession == null) {
            throw new SecurityException("TabSession [" + tabSessionId + "] is no longer valid.");
        }
        tabSession.setContextOrganisationPersonId(organisationPersonId != null ? Integer.valueOf(organisationPersonId.intValue()) : null);
        tabSession.setContextNetworkId(networkId != null ? Integer.valueOf(networkId.intValue()) : null);
        tabSession.setContextProjectId(projectId != null ? Integer.valueOf(projectId.intValue()) : null);
        tabSession.setContextSubProjectId(subProjectId != null ? Integer.valueOf(subProjectId.intValue()) : null);
    }

    public void writePnContext(String tabSessionId, Long organisationPersonId, Long networkId, Long projectId) {
        TabSession tabSession = this.getTabSessionIfValid(tabSessionId);
        if (tabSession == null) {
            throw new SecurityException("TabSession [" + tabSessionId + "] is no longer valid.");
        }
        tabSession.setContextOrganisationPersonId(organisationPersonId != null ? Integer.valueOf(organisationPersonId.intValue()) : null);
        tabSession.setPnContextNetworkId(networkId != null ? Integer.valueOf(networkId.intValue()) : null);
        tabSession.setPnContextProjectId(projectId != null ? Integer.valueOf(projectId.intValue()) : null);
    }

    public void addToPageList(String tabSessionId, String pageName, boolean isBasePage) {
        TabSession tabSession = this.getTabSessionIfValid(tabSessionId);
        if (tabSession == null) {
            throw new SecurityException("TabSession [" + tabSessionId + "] is no longer valid.");
        }
        if (isBasePage) {
            tabSession.getPageList().clear();
        }
        tabSession.getPageList().push(pageName);
    }

    private static Long convertToLong(Integer i) {
        return i == null ? null : new Long(i.intValue());
    }

    private static void updateTabSessionAfterNetworkProjectChange(TabSession tabSession, PageContext pageContext, boolean setPnViewActive) {
        tabSession.setContextNetworkId(pageContext.getNetwork() != null ? Integer.valueOf(pageContext.getNetwork().getId().intValue()) : null);
        tabSession.setContextProjectId(pageContext.getProject() != null ? Integer.valueOf(pageContext.getProject().getId().intValue()) : null);
        tabSession.setContextSubProjectId(pageContext.getSubProject() != null ? Integer.valueOf(pageContext.getSubProject().getId().intValue()) : null);
        tabSession.setPnContextNetworkId(pageContext.getPlanningNotificationNetwork() != null ? Integer.valueOf(pageContext.getPlanningNotificationNetwork().getId().intValue()) : null);
        tabSession.setPnContextProjectId(pageContext.getPlanningNotificationProject() != null ? Integer.valueOf(pageContext.getPlanningNotificationProject().getId().intValue()) : null);
        if (setPnViewActive) {
            tabSession.setPnViewActive(true);
        }
    }

    public PageContext setPlanningNotificationNetworkToTabSession(String tabSessionId, Long networkId, boolean setPnViewActive) {
        TabSession tabSession = this.getTabSessionIfValid(tabSessionId);
        if (tabSession == null) {
            throw new SecurityException("TabSession [" + tabSessionId + "] is no longer valid.");
        }
        PageContext newPageContext = this.contextService.getPageContext(CdesSessionControllerImpl.convertToLong(tabSession.getContextNetworkId()), CdesSessionControllerImpl.convertToLong(tabSession.getContextProjectId()), CdesSessionControllerImpl.convertToLong(tabSession.getContextSubProjectId()), networkId, CdesSessionControllerImpl.convertToLong(tabSession.getPnContextProjectId()), CdesSessionControllerImpl.convertToLong(tabSession.getContextOrganisationPersonId()));
        this.contextService.setPnNetworkIdToPersonVariables(networkId);
        CdesSessionControllerImpl.updateTabSessionAfterNetworkProjectChange(tabSession, newPageContext, setPnViewActive);
        return newPageContext;
    }
}

