/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.document;

import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.document.ReleasedDocument;
import at.cdes.bo.data.object.PDCObjectPlannerTO;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xnap.commons.i18n.I18n;

public class PDCDocumentTO
implements Serializable {
    private static final long serialVersionUID = 3433611009220362429L;
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    private Integer id;
    private Integer unreleasedDocumentId;
    private Integer number;
    private Integer duration;
    private String name;
    private String content;
    private String scale;
    private String comment;
    private String firstVersionPart;
    private String lastVersionPart;
    private Date startDate;
    private Date endDate;
    private Date uploadDate;
    private Date effectiveEndDate;
    private String realStartDateString;
    private String realEndDateString;
    private boolean versionSet;
    private boolean invalidated;
    private boolean lastVersionDeleted;
    private boolean lastVersionStatusU;
    private int modified;
    private PDCObjectPlannerTO objectPlanner;

    public PDCDocumentTO() {
    }

    public PDCDocumentTO(Document doc, Date realEndDate, I18n i18n) {
        this.id = doc.getId();
        if (doc instanceof ReleasedDocument) {
            this.unreleasedDocumentId = ((ReleasedDocument)doc).getDocument().getId();
        }
        this.number = doc.getNumber();
        this.duration = doc.getDuration();
        this.name = doc.getName();
        this.content = doc.getContent();
        this.scale = doc.getScale();
        this.comment = doc.getComment();
        this.startDate = doc.getStartDate();
        this.endDate = doc.getEndDate();
        DocumentVersion firstDocumentVersion = doc.getFirstDocumentVersion();
        if (firstDocumentVersion != null) {
            this.realStartDateString = "[" + i18n.tr("Version") + firstDocumentVersion.getVersionPart() + " " + df.format(firstDocumentVersion.getUploaded()) + "]";
            this.uploadDate = firstDocumentVersion.getUploaded();
            this.firstVersionPart = firstDocumentVersion.getVersionPart();
        }
        DocumentVersion lastDocumentVersion = doc.getLastDocumentVersion();
        if (realEndDate != null && lastDocumentVersion != null) {
            this.realEndDateString = "[" + i18n.tr("Version") + " " + lastDocumentVersion.getVersionPart() + " " + df.format(realEndDate) + "]";
            this.effectiveEndDate = realEndDate;
            this.lastVersionPart = lastDocumentVersion.getVersionPart();
        }
        if (lastDocumentVersion != null) {
            boolean bl = this.lastVersionDeleted = lastDocumentVersion.getStatus() == 7 && doc.getDocumentVersions().isEmpty();
            if (lastDocumentVersion.getStatus() == 5) {
                if (lastDocumentVersion.getRevisedDocumentVersion() != null) {
                    this.lastVersionStatusU = lastDocumentVersion.getRevisedDocumentVersion().getStatus() == 5;
                } else {
                    boolean bl2 = this.lastVersionStatusU = lastDocumentVersion.getStatus() == 5;
                }
            }
        }
        if (doc instanceof ReleasedDocument) {
            this.invalidated = ((ReleasedDocument)doc).getDocument().isInvalidated();
            this.modified = ((ReleasedDocument)doc).getModified();
        } else {
            this.invalidated = ((DocumentImpl)doc).isInvalidated();
            this.modified = ((DocumentImpl)doc).getModified();
        }
        DocumentImpl unreleasedDocument = null;
        unreleasedDocument = doc instanceof ReleasedDocument ? ((ReleasedDocument)doc).getDocument() : (DocumentImpl)doc;
        this.versionSet = unreleasedDocument.isVersionSet();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getUnreleasedDocumentId() {
        return this.unreleasedDocumentId;
    }

    public void setDocumentId(Integer unreleasedDocumentId) {
        this.unreleasedDocumentId = unreleasedDocumentId;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getScale() {
        return this.scale;
    }

    public void setScale(String scale) {
        this.scale = scale;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getRealStartDateString() {
        return this.realStartDateString;
    }

    public void setRealStartDateString(String realStartDateString) {
        this.realStartDateString = realStartDateString;
    }

    public String getRealEndDateString() {
        return this.realEndDateString;
    }

    public void setRealEndDateString(String realEndDateString) {
        this.realEndDateString = realEndDateString;
    }

    public boolean isVersionSet() {
        return this.versionSet;
    }

    public void setVersionSet(boolean versionSet) {
        this.versionSet = versionSet;
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    public void setInvalidated(boolean invalidated) {
        this.invalidated = invalidated;
    }

    public boolean isLastVersionDeleted() {
        return this.lastVersionDeleted;
    }

    public void setLastVersionDeleted(boolean lastVersionDeleted) {
        this.lastVersionDeleted = lastVersionDeleted;
    }

    public boolean isLastVersionStatusU() {
        return this.lastVersionStatusU;
    }

    public void setLastVersionStatusU(boolean lastVersionStatusU) {
        this.lastVersionStatusU = lastVersionStatusU;
    }

    public void setUnreleasedDocumentId(Integer unreleasedDocumentId) {
        this.unreleasedDocumentId = unreleasedDocumentId;
    }

    public int getModified() {
        return this.modified;
    }

    public void setModified(int modified) {
        this.modified = modified;
    }

    public PDCObjectPlannerTO getObjectPlanner() {
        return this.objectPlanner;
    }

    public void setObjectPlanner(PDCObjectPlannerTO objectPlanner) {
        this.objectPlanner = objectPlanner;
    }

    public String getFirstVersionPart() {
        return this.firstVersionPart;
    }

    public void setFirstVersionPart(String firstVersionPart) {
        this.firstVersionPart = firstVersionPart;
    }

    public String getLastVersionPart() {
        return this.lastVersionPart;
    }

    public void setLastVersionPart(String lastVersionPart) {
        this.lastVersionPart = lastVersionPart;
    }

    public Date getUploadDate() {
        return this.uploadDate;
    }

    public void setUploadDate(Date uploadDate) {
        this.uploadDate = uploadDate;
    }

    public Date getEffectiveEndDate() {
        return this.effectiveEndDate;
    }

    public void setEffectiveEndDate(Date effectiveEndDate) {
        this.effectiveEndDate = effectiveEndDate;
    }
}

