/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.schema;

import at.cdes.db.SchemaUpdateSnippet;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.clazzes.jdbc2xml.schema.ColumnInfo;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.PrimaryKeyInfo;
import org.clazzes.jdbc2xml.schema.TableInfo;

public class SchemaUpdate_0_190
implements SchemaUpdateSnippet {
    protected static final Logger logger = Logger.getLogger(SchemaUpdate_0_190.class);

    @Override
    public String getTargetVersion() {
        return "0.190";
    }

    @Override
    public String getUpdateComment() {
        return "create table action_rule_default; drop and recreate table role_default_action_rule;";
    }

    @Override
    public void performUpdate(ISchemaEngine schemaEngine) throws SQLException {
        logger.info((Object)"creating table action_rule_default");
        TableInfo ti = new TableInfo("action_rule_default");
        ti.addColumn(new ColumnInfo("id", 4, Integer.valueOf(20), null, false, null));
        ti.addColumn(new ColumnInfo("action_id", 4, Integer.valueOf(20), null, false, null));
        ti.addColumn(new ColumnInfo("destination_context_id", 4, Integer.valueOf(20), null, false, null));
        ti.addColumn(new ColumnInfo("check_member", 4, Integer.valueOf(1), null, false, null));
        ti.setPrimaryKey(new PrimaryKeyInfo(null, "id"));
        ti.addForeignKey(new ForeignKeyInfo("action_rule_default_action_fk", "action_id", "action", "id"));
        schemaEngine.createTable(ti, true);
        logger.info((Object)"committing");
        schemaEngine.commit();
        logger.info((Object)"dropping table role_default_action_rule");
        schemaEngine.dropTable(schemaEngine.fetchTableInfo("role_default_action_rule", null), false);
        logger.info((Object)"committing");
        schemaEngine.commit();
        logger.info((Object)"creating table role_default_action_rule");
        TableInfo ti2 = new TableInfo("role_default_action_rule");
        ti2.addColumn(new ColumnInfo("role_default_id", 4, Integer.valueOf(20), null, false, null));
        ti2.addColumn(new ColumnInfo("action_rule_default_id", 4, Integer.valueOf(20), null, false, null));
        ti2.addForeignKey(new ForeignKeyInfo("role_default_action_rule_role_default_fk", "role_default_id", "cdes_role_default", "id"));
        ti2.addForeignKey(new ForeignKeyInfo("role_default_action_rule_action_rule_default_fk", "action_rule_default_id", "action_rule_default", "id"));
        schemaEngine.createTable(ti2, true);
        logger.info((Object)"committing");
        schemaEngine.commit();
        logger.info((Object)"creating an action_rule_default entry for each action");
        Statement select = schemaEngine.getConnection().createStatement();
        ResultSet rs = select.executeQuery("select id from action");
        while (rs.next()) {
            Integer actionId = rs.getInt("id");
            PreparedStatement subSelect = schemaEngine.getConnection().prepareStatement("select destination_context_id, check_member from action_rule where action_id=? and network_id is not null");
            subSelect.setInt(1, actionId);
            ResultSet subSet = subSelect.executeQuery();
            int context = 20;
            int checkMember = 1;
            boolean foundRule = false;
            while (subSet.next()) {
                context = subSet.getInt("destination_context_id");
                checkMember = subSet.getInt("check_member");
                logger.info((Object)("found a network's action_rule with destination_context_id=[" + context + "] and check_member=[" + checkMember + "]"));
                foundRule = true;
                if (context == 1) continue;
            }
            if (!foundRule) {
                logger.info((Object)("could not find a network's action_rule with action_id=[" + actionId + "]"));
            }
            if (context == 1 || context == 20) continue;
            PreparedStatement insert = schemaEngine.getConnection().prepareStatement("insert into action_rule_default values (?,?,?,?)");
            insert.setInt(1, actionId);
            insert.setInt(2, actionId);
            insert.setInt(3, context);
            insert.setInt(4, checkMember);
            insert.executeUpdate();
            insert.close();
            subSet.close();
            logger.info((Object)("inserted action_rule_default with id=[" + actionId + "]"));
        }
    }
}

