/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.TemporaryDocumentVersion;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.label.LabelContent;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.file.FileFinder;
import at.cdes.preview.api.Annotation;
import at.cdes.preview.api.IHPGLRenderer;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.ByteArrayMimeInputStream;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.LabelOperations;
import at.cdes.service.ObjectOperations;
import at.cdes.service.ReviewOperations;
import at.cdes.util.ImplContextHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import org.clazzes.util.http.osgi.DefaultHttpContext;
import org.clazzes.util.io.IOUtil;

public class TemporaryDocumentVersionPngMimeSource
implements VisitlessMimeSource {
    private IHPGLRenderer hpglRenderer;
    private LabelOperations labelOperations;
    private ObjectOperations objectOperations;
    private ReviewOperations reviewOperations;
    private FileFinder fileFinder;
    static Logger logger = Logger.getLogger(TemporaryDocumentVersionPngMimeSource.class);

    protected ObjectOperations getObjectOperations() {
        return this.objectOperations;
    }

    public void setObjectOperations(ObjectOperations objectOperations) {
        this.objectOperations = objectOperations;
    }

    protected FileFinder getFileFinder() {
        return this.fileFinder;
    }

    protected IHPGLRenderer getHpglRenderer() {
        return this.hpglRenderer;
    }

    protected LabelOperations getLabelOperations() {
        return this.labelOperations;
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public void setHpglRenderer(IHPGLRenderer hpglRenderer) {
        this.hpglRenderer = hpglRenderer;
    }

    public void setLabelOperations(LabelOperations labelOperations) {
        this.labelOperations = labelOperations;
    }

    public void setReviewOperations(ReviewOperations reviewOperations) {
        this.reviewOperations = reviewOperations;
    }

    public String getActionName() {
        return "uploadDocument";
    }

    public boolean isEditable() {
        return false;
    }

    public Object getDestinationObject(Object[] parameters) {
        DocumentImpl document = this.reviewOperations.getDocument(ImplContextHelper.getTemporaryDocumentVersion().getDocumentId());
        SubProject subProject = document.getObjectPlanner().getObject().getObjectList().getSubProject();
        return this.objectOperations.getReleasedObjectPlannerFromList(document.getObjectPlanner().getId(), subProject.getActiveObjectList().getId());
    }

    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        TemporaryDocumentVersion tdv = ImplContextHelper.getTemporaryDocumentVersion();
        int pixel_sz = 1000;
        if (parameters.length > 0) {
            pixel_sz = (Integer)parameters[0];
        }
        boolean antialias = false;
        if (parameters.length > 1) {
            antialias = (Boolean)parameters[1];
        }
        int angle = tdv.getPreviewRotation();
        if (parameters.length > 2) {
            angle = (Integer)parameters[2];
        }
        LabelContent labelContent = null;
        if (tdv.getLabelContentId() != null) {
            labelContent = this.labelOperations.getLabelContent(tdv.getLabelContentId());
        }
        try (FileMimeInputStream stream = null;){
            IMimeInputStream ret;
            File file = new File(tdv.getFileName());
            String unique = this.getFileFinder().makeUniqueName(tdv.getFileName(), CDESFileRepository.TEMPREPOSITORY);
            String fileType = IOUtil.getFileExtension((String)tdv.getFileName());
            stream = new FileMimeInputStream(file, unique, tdv.getName() + "." + fileType, DefaultHttpContext.getInstance().getMimeType(tdv.getFileName()));
            ArrayList<Annotation> annotations = null;
            if (labelContent != null && !tdv.isRenderLabelOutsideOfPlan()) {
                annotations = new ArrayList<Annotation>();
                Date creationDate = new Date();
                creationDate.setTime(file.lastModified());
                byte[] fdf_data = this.labelOperations.formatFDFPreview(tdv, false);
                ByteArrayMimeInputStream fdf_is = new ByteArrayMimeInputStream(fdf_data, 0.001 * (double)file.lastModified(), labelContent.getName(), "application/vnd.fdf");
                annotations.add(new Annotation((IMimeInputStream)fdf_is, "", "", "", 2));
            }
            IMimeInputStream iMimeInputStream = ret = this.hpglRenderer.renderPngByPixelSize((IMimeInputStream)stream, pixel_sz, antialias, angle, "", annotations);
            return iMimeInputStream;
        }
    }
}

