/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.util;

import at.cdes.api.sec.CdesPrincipal;
import at.cdes.bo.data.sec.TabSession;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.util.ImplContextHelper;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.clazzes.util.aop.ThreadLocalManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class TapestryI18nHelper {
    private static String FROM_TOKEN = "[";
    private static String TO_TOKEN = "]";
    private static final Logger log = LoggerFactory.getLogger(TapestryI18nHelper.class);

    private static Map<String, String> parseI18nJsonString(String jsonString) {
        HashMap<String, String> localeToTranslation = new HashMap<String, String>();
        if (jsonString != null && jsonString.trim().startsWith("{")) {
            try {
                JsonParser jsonParser = new JsonParser();
                Set entrySet = jsonParser.parse(jsonString).getAsJsonObject().entrySet();
                for (Map.Entry entry : entrySet) {
                    String locale = (String)entry.getKey();
                    String translation = ((JsonElement)entry.getValue()).getAsString();
                    localeToTranslation.put(locale, translation);
                }
            }
            catch (JsonParseException e) {
                Locale loginLocale = ThreadLocalManager.getLoginLocale();
                String loginLocaleLanguage = loginLocale.getLanguage();
                localeToTranslation.put(loginLocaleLanguage, jsonString);
            }
        } else {
            Locale loginLocale = ThreadLocalManager.getLoginLocale();
            String loginLocaleLanguage = loginLocale.getLanguage();
            localeToTranslation.put(loginLocaleLanguage, jsonString);
        }
        return localeToTranslation;
    }

    public static String convertDatabaseToJs(String databaseString) {
        Map<String, String> localeToTranslation = TapestryI18nHelper.parseI18nJsonString(databaseString);
        for (String locale : localeToTranslation.keySet()) {
            String databaseTranslation = localeToTranslation.get(locale);
            String openToken = locale + FROM_TOKEN;
            String closeToken = TO_TOKEN + locale;
            String jsTranslation = databaseTranslation.replace(openToken, "").replace(closeToken, "");
            localeToTranslation.put(locale, jsTranslation);
        }
        Gson gson = new Gson();
        String jsString = gson.toJson(localeToTranslation);
        return jsString;
    }

    public static final String getLocalizedString(String databaseString) {
        try {
            Locale userLocaleRaw;
            CdesPrincipal loginPrincipal;
            Locale userLocaleRaw2;
            if (databaseString == null) {
                return "<not found>";
            }
            TabSession tabSession = ImplContextHelper.getTabSession();
            String userLocale = tabSession != null ? ((userLocaleRaw2 = tabSession.getLocale()) != null ? userLocaleRaw2.getLanguage() : "de") : ((loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal()) != null ? loginPrincipal.getUserLocale() : ((userLocaleRaw = ThreadLocalManager.getLoginLocale()) != null ? userLocaleRaw.getLanguage() : "de"));
            String clientString = TapestryI18nHelper.convertDatabaseToJs(databaseString);
            Map<String, String> localeToTranslation = TapestryI18nHelper.parseI18nJsonString(clientString);
            if (localeToTranslation.containsKey(userLocale)) {
                return localeToTranslation.get(userLocale);
            }
            Iterator<String> iterator = localeToTranslation.keySet().iterator();
            if (iterator.hasNext()) {
                String locale = iterator.next();
                return localeToTranslation.get(locale);
            }
            return "";
        }
        catch (Exception e) {
            log.info("Catched Exception e", (Throwable)e);
            throw e;
        }
    }

    public static String getLocaleString(String databaseString, String locale) {
        String clientString = TapestryI18nHelper.convertDatabaseToJs(databaseString);
        Map<String, String> localeToTranslation = TapestryI18nHelper.parseI18nJsonString(clientString);
        if (localeToTranslation.containsKey(locale)) {
            return localeToTranslation.get(locale);
        }
        return "";
    }

    public static final String getI18n(String string) {
        try {
            Locale userLocaleRaw;
            CdesPrincipal loginPrincipal;
            Locale userLocaleRaw2;
            if (string == null) {
                return "<not found>";
            }
            TabSession tabSession = ImplContextHelper.getTabSession();
            String userLocale = tabSession != null ? ((userLocaleRaw2 = tabSession.getLocale()) != null ? userLocaleRaw2.getLanguage() : "de") : ((loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal()) != null ? loginPrincipal.getUserLocale() : ((userLocaleRaw = ThreadLocalManager.getLoginLocale()) != null ? userLocaleRaw.getLanguage() : "de"));
            Locale locale = new Locale(userLocale);
            I18n i18n = I18nFactory.getI18n(locale);
            return i18n.tr(string);
        }
        catch (Exception e) {
            log.info("Catched Exception e", (Throwable)e);
            throw e;
        }
    }
}

