/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.cycle.cell;

import at.cdes.bo.data.CdesDataObject;
import at.cdes.bo.data.cycle.ReviewCycle;
import at.cdes.bo.data.cycle.cell.ReviewCycleEntryCondition;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.cycle.node.ReviewCycleNodePositionComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReviewCycleCell
implements CdesDataObject {
    static final long serialVersionUID = 1L;
    private Integer id;
    private String name;
    private String code;
    private String svgColor;
    private ReviewCycle reviewCycle;
    private Map reviewCycleNodes;
    private Integer position;
    private Map freeReviewCycleNodes;
    private Map incommingConnections;
    private Map leavingConnections;
    private ReviewCycleEntryCondition reviewCycleEntryCondition;
    private boolean endCell;
    private boolean documentVersionDeletable;
    private Map leavingInvalidationUploadConnections;
    private Map leavingRevisionUploadConnections;
    private boolean asBuiltUnchangedDestination;

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReviewCycle getReviewCycle() {
        return this.reviewCycle;
    }

    public void setReviewCycle(ReviewCycle reviewCycle) {
        this.reviewCycle = reviewCycle;
    }

    public Map getReviewCycleNodes() {
        return this.reviewCycleNodes;
    }

    public void setReviewCycleNodes(Map reviewCycleNodes) {
        this.reviewCycleNodes = reviewCycleNodes;
    }

    public Map getIncommingConnections() {
        return this.incommingConnections;
    }

    public void setIncommingConnections(Map incommingConnections) {
        this.incommingConnections = incommingConnections;
    }

    public Map getLeavingConnections() {
        return this.leavingConnections;
    }

    public void setLeavingConnections(Map leavingConnections) {
        this.leavingConnections = leavingConnections;
    }

    public ReviewCycleNode getNode(Integer nodeId) {
        if (this.reviewCycleNodes == null) {
            this.getReviewCycleNodes();
        }
        if (this.reviewCycleNodes == null) {
            return null;
        }
        if (nodeId == null) {
            return null;
        }
        return (ReviewCycleNode)this.reviewCycleNodes.get(nodeId);
    }

    public ReviewCycleNode getNextNode(ReviewCycleNode actualNode) {
        if (this.getReviewCycleNodes() == null) {
            return null;
        }
        if (actualNode == null) {
            return null;
        }
        Iterator it = this.getReviewCycleNodes().values().iterator();
        while (it.hasNext()) {
            ReviewCycleNode node = (ReviewCycleNode)it.next();
            if (!node.getId().equals(actualNode.getId())) continue;
            return it.hasNext() ? (ReviewCycleNode)it.next() : null;
        }
        return null;
    }

    public ReviewCycleNode getPreviousNode(ReviewCycleNode actualNode) {
        if (this.getReviewCycleNodes() == null) {
            return null;
        }
        if (actualNode == null) {
            return null;
        }
        Iterator it = this.getReviewCycleNodes().values().iterator();
        ReviewCycleNode previous = null;
        while (it.hasNext()) {
            ReviewCycleNode node = (ReviewCycleNode)it.next();
            if (node.getId().equals(actualNode.getId()) && previous != null) {
                return previous;
            }
            previous = node;
        }
        return null;
    }

    public ReviewCycleNode getFirstReviewCycleNode() {
        if (this.getReviewCycleNodes() == null) {
            return null;
        }
        return (ReviewCycleNode)this.getReviewCycleNodes().values().iterator().next();
    }

    public ReviewCycleNode getLastReviewCycleNode() {
        if (this.getReviewCycleNodes() == null) {
            return null;
        }
        Iterator it = this.getReviewCycleNodes().values().iterator();
        ReviewCycleNode node = null;
        while (it.hasNext()) {
            node = (ReviewCycleNode)it.next();
        }
        return node;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public ReviewCycleEntryCondition getReviewCycleEntryCondition() {
        return this.reviewCycleEntryCondition;
    }

    public void setReviewCycleEntryCondition(ReviewCycleEntryCondition reviewCycleEntryCondition) {
        this.reviewCycleEntryCondition = reviewCycleEntryCondition;
    }

    public List<ReviewCycleNode> getReviewCycleNodesSortedByPosition() {
        if (this.getReviewCycleNodes() == null) {
            return null;
        }
        ArrayList<ReviewCycleNode> ret = new ArrayList<ReviewCycleNode>();
        ret.addAll(this.getReviewCycleNodes().values());
        Collections.sort(ret, new ReviewCycleNodePositionComparator());
        return ret;
    }

    public boolean isEndCell() {
        return this.endCell;
    }

    public void setEndCell(boolean endCell) {
        this.endCell = endCell;
    }

    public Map getFreeReviewCycleNodes() {
        return this.freeReviewCycleNodes;
    }

    public void setFreeReviewCycleNodes(Map freeReviewCycleNodes) {
        this.freeReviewCycleNodes = freeReviewCycleNodes;
    }

    public Collection<ReviewCycleNode> getFreeReviewCycleNodesSortedByPosition() {
        if (this.getReviewCycleNodes() == null) {
            return null;
        }
        ArrayList<ReviewCycleNode> ret = new ArrayList<ReviewCycleNode>();
        ret.addAll(this.getFreeReviewCycleNodes().values());
        Collections.sort(ret, new ReviewCycleNodePositionComparator());
        return ret;
    }

    public ReviewCycleNode getReviewCycleNodeByPosition(int position1) {
        if (this.getReviewCycleNodes() == null) {
            return null;
        }
        Collection nodes = this.getReviewCycleNodes().values();
        for (ReviewCycleNode node : nodes) {
            if (node.getPosition() != position1) continue;
            return node;
        }
        return null;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public String getSvgColor() {
        return this.svgColor;
    }

    public void setSvgColor(String svgColor) {
        this.svgColor = svgColor;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!ReviewCycleCell.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        ReviewCycleCell other = (ReviewCycleCell)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    public boolean isDocumentVersionDeletable() {
        return this.documentVersionDeletable;
    }

    public void setDocumentVersionDeletable(boolean documentVersionDeletable) {
        this.documentVersionDeletable = documentVersionDeletable;
    }

    public Map getLeavingInvalidationUploadConnections() {
        return this.leavingInvalidationUploadConnections;
    }

    public void setLeavingInvalidationUploadConnections(Map leavingInvalidationUploadConnections) {
        this.leavingInvalidationUploadConnections = leavingInvalidationUploadConnections;
    }

    public Map getLeavingRevisionUploadConnections() {
        return this.leavingRevisionUploadConnections;
    }

    public void setLeavingRevisionUploadConnections(Map leavingRevisionUploadConnections) {
        this.leavingRevisionUploadConnections = leavingRevisionUploadConnections;
    }

    public void setAsBuiltUnchangedDestination(boolean asBuiltUnchangedDestination) {
        this.asBuiltUnchangedDestination = asBuiltUnchangedDestination;
    }

    public boolean isAsBuiltUnchangedDestination() {
        return this.asBuiltUnchangedDestination;
    }
}

