/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.meta.PlanningNotificationMetaInformation;
import at.cdes.bo.data.meta.PlanningNotificationTextMetaInformation;
import at.cdes.bo.data.planningNotification.PlanningNotification;
import at.cdes.bo.data.planningNotification.PlanningNotificationOrder;
import at.cdes.bo.data.workflow.WorkflowEntity;
import at.cdes.bo.data.workflow.WorkflowToken;
import at.cdes.controller.helper.PlanningNotificationFilterEvaluationHelper;
import at.cdes.db.dao.WorkflowEntityDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import at.cdes.oldGwtDto.OrderFilterDTO;
import at.cdes.oldGwtDto.PNFilterDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowEntityDAOHibernate
extends HibernateDaoSupport
implements WorkflowEntityDAO {
    private static final Logger log = LoggerFactory.getLogger(WorkflowEntityDAOHibernate.class);
    private ArrayList<String[]> results = new ArrayList();

    @Override
    public WorkflowEntity get(Integer workflowEntityId) {
        return (WorkflowEntity)this.getSession().get(WorkflowEntity.class, (Serializable)workflowEntityId);
    }

    @Override
    public WorkflowEntity save(WorkflowEntity workflowEntity) {
        return this.get((Integer)this.getSession().save((Object)workflowEntity));
    }

    @Override
    public WorkflowEntity update(WorkflowEntity workflowEntity) {
        this.getSession().update((Object)workflowEntity);
        return workflowEntity;
    }

    @Override
    public WorkflowEntity merge(WorkflowEntity workflowEntity) {
        return (WorkflowEntity)this.getSession().merge((Object)workflowEntity);
    }

    @Override
    public void delete(WorkflowEntity workflowEntity) {
        this.getSession().delete((Object)workflowEntity);
    }

    @Override
    public PlanningNotificationOrder getPlanningNotificationOrder(Integer planningNotificationOrderId) {
        return (PlanningNotificationOrder)this.getSession().get(PlanningNotificationOrder.class, (Serializable)planningNotificationOrderId);
    }

    @Override
    public PlanningNotificationOrder updatePlanningNotificationOrder(PlanningNotificationOrder planningNotificationOrder) {
        this.getSession().merge((Object)planningNotificationOrder);
        return planningNotificationOrder;
    }

    @Override
    public PlanningNotificationOrder savePlanningNotificationOrder(PlanningNotificationOrder planningNotificationOrder) {
        return this.getPlanningNotificationOrder((Integer)this.getSession().save((Object)planningNotificationOrder));
    }

    private void generatePermutations(List<String> list, int k) {
        for (int i = k; i < list.size(); ++i) {
            Collections.swap(list, i, k);
            this.generatePermutations(list, k + 1);
            Collections.swap(list, k, i);
        }
        if (k == list.size() - 1) {
            this.results.add((String[])list.toArray());
        }
    }

    private Disjunction getDisjunction(String[] tokens, String field) {
        this.results.clear();
        List<String> tmp = Arrays.asList(tokens);
        this.generatePermutations(tmp, 0);
        Disjunction disj = Restrictions.disjunction();
        for (int i = 0; i < this.results.size(); ++i) {
            String comb = "%";
            for (int j = 0; j < tokens.length; ++j) {
                comb = comb + this.results.get(i)[j] + "%";
            }
            disj.add((Criterion)Restrictions.like((String)field, (Object)comb));
        }
        return disj;
    }

    @Override
    public List<WorkflowToken> getPlanningNotificationTasksByFilter(OrderFilterDTO filter, Integer organisationPersonId) {
        Criteria criteria = this.getSession().createCriteria(WorkflowToken.class);
        Criteria criteriaOwner = criteria.createCriteria("owner");
        Criteria criteriaWorkflowEntities = criteriaOwner.createCriteria("workflowNode").createCriteria("workflow").createCriteria("workflowEntities");
        criteriaOwner.createCriteria("projectParticipation").createCriteria("projectParticipants").createCriteria("organisationPerson").add(Restrictions.idEq((Object)organisationPersonId));
        if (filter != null) {
            String[] tokens;
            if (filter.getPlanningNotificationOrderText() != null && filter.getPlanningNotificationOrderText().length() > 0) {
                tokens = filter.getPlanningNotificationOrderText().split(" ");
                if (tokens.length > 1) {
                    criteriaOwner.createCriteria("workflowNode").createCriteria("workflow").createCriteria("workflowEntities").add((Criterion)this.getDisjunction(tokens, "text"));
                } else {
                    criteriaOwner.createCriteria("workflowNode").createCriteria("workflow").createCriteria("workflowEntities").add((Criterion)Restrictions.like((String)"text", (Object)("%" + filter.getPlanningNotificationOrderText() + "%")));
                }
            }
            if (filter.getPointPage() != null && filter.getPointPage().length() > 0) {
                tokens = filter.getPointPage().split(" ");
                if (tokens.length > 1) {
                    criteriaWorkflowEntities.add((Criterion)this.getDisjunction(tokens, "documentPosition"));
                } else {
                    criteriaWorkflowEntities.add((Criterion)Restrictions.like((String)"documentPosition", (Object)("%" + filter.getPointPage() + "%")));
                }
            }
            if (filter.getAuthorizedInspector() != null && filter.getAuthorizedInspector().length() > 0) {
                tokens = filter.getAuthorizedInspector().split(" ");
                if (tokens.length > 1) {
                    criteriaWorkflowEntities.add((Criterion)this.getDisjunction(tokens, "authorizedInspector"));
                } else {
                    criteriaWorkflowEntities.add((Criterion)Restrictions.like((String)"authorizedInspector", (Object)("%" + filter.getAuthorizedInspector() + "%")));
                }
            }
            if (filter.getStatutoryDuty() != null) {
                criteriaWorkflowEntities.add((Criterion)Restrictions.eq((String)"statutoryDuty", (Object)filter.getStatutoryDuty()));
            }
            if (filter.getDueDateStart() != null && filter.getDueDateEnd() != null) {
                GregorianCalendar start = new GregorianCalendar();
                GregorianCalendar end = new GregorianCalendar();
                start.setTime(filter.getDueDateStart());
                end.setTime(filter.getDueDateEnd());
                criteriaWorkflowEntities.add(Restrictions.between((String)"dueDate", (Object)start, (Object)end));
            }
            if (filter.getStatus() != null && filter.getStatus().length() > 0) {
                if (filter.getStatus().equals("nicht initiiert")) {
                    criteriaWorkflowEntities.add(Restrictions.isNull((String)"status"));
                } else {
                    criteriaWorkflowEntities.createCriteria("status").add((Criterion)Restrictions.like((String)"name", (Object)filter.getStatus()));
                }
            }
        }
        return criteria.list();
    }

    @Override
    public List<PlanningNotificationOrder> getPlanningNotificationOrders(OrderFilterDTO filter) {
        String[] tokens;
        Criteria criteria = this.getSession().createCriteria(PlanningNotificationOrder.class);
        Criteria planningNotificationCrit = criteria.createCriteria("planningNotification");
        if (filter != null && filter.getProjectId() != null && filter.getProjectId() != 0) {
            planningNotificationCrit.createCriteria("associatedProjects").add(Restrictions.idEq((Object)filter.getProjectId()));
        }
        if (filter != null && PlanningNotificationFilterEvaluationHelper.isToFilter(filter.getPlanningNotification())) {
            tokens = new String[filter.getPlanningNotification().size()];
            for (int n = 0; n < filter.getPlanningNotification().size(); ++n) {
                tokens[n] = filter.getPlanningNotification().get(n);
            }
            planningNotificationCrit.add((Criterion)this.getDisjunction(tokens, "title"));
        }
        if (filter != null) {
            if (filter.getNetworkId() != null) {
                planningNotificationCrit.createCriteria("network").add(Restrictions.idEq((Object)filter.getNetworkId()));
            }
            if (filter.getSerialNumber() != null && filter.getSerialNumber().length() > 0) {
                try {
                    Long serial = Long.valueOf(filter.getSerialNumber());
                    criteria.add((Criterion)Restrictions.like((String)"serialNumber", (Object)serial));
                }
                catch (Exception serial) {
                    // empty catch block
                }
            }
            if (filter.getPlanningNotificationOrderText() != null && filter.getPlanningNotificationOrderText().length() > 0) {
                tokens = filter.getPlanningNotificationOrderText().split(" ");
                if (tokens.length > 1) {
                    criteria.add((Criterion)this.getDisjunction(tokens, "text"));
                } else {
                    criteria.add((Criterion)Restrictions.like((String)"text", (Object)("%" + filter.getPlanningNotificationOrderText() + "%")));
                }
            }
            if (filter.getPointPage() != null && filter.getPointPage().length() > 0) {
                tokens = filter.getPointPage().split(" ");
                if (tokens.length > 1) {
                    criteria.add((Criterion)this.getDisjunction(tokens, "documentPosition"));
                } else {
                    criteria.add((Criterion)Restrictions.like((String)"documentPosition", (Object)("%" + filter.getPointPage() + "%")));
                }
            }
            if (filter.getStatutoryDutyId() != null) {
                criteria.add((Criterion)Restrictions.like((String)"statutoryDutyId", (Object)filter.getStatutoryDutyId()));
            }
            if (filter.getAuthorizedInspector() != null && filter.getAuthorizedInspector().length() > 0) {
                tokens = filter.getAuthorizedInspector().split(" ");
                if (tokens.length > 1) {
                    criteria.add((Criterion)this.getDisjunction(tokens, "authorizedInspector"));
                } else {
                    criteria.add((Criterion)Restrictions.like((String)"authorizedInspector", (Object)("%" + filter.getAuthorizedInspector() + "%")));
                }
            }
            if (filter.getStatus() != null && filter.getStatus().length() > 0) {
                if (filter.getStatus().equals("nicht initiiert")) {
                    criteria.add(Restrictions.isNull((String)"status"));
                } else {
                    criteria.createCriteria("status").add((Criterion)Restrictions.like((String)"name", (Object)filter.getStatus()));
                }
            }
            if (filter.getDueDateStart() != null || filter.getDueDateEnd() != null) {
                Calendar start = Calendar.getInstance();
                Calendar end = Calendar.getInstance();
                Criteria positionCrit = criteria.createCriteria("workflow").createCriteria("workflowNodes").createCriteria("workflowNodePositions");
                criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
                if (filter.getDueDateStart() != null) {
                    start.setTime(filter.getDueDateStart());
                    start.set(11, 0);
                    start.set(12, 0);
                    start.set(13, 0);
                }
                if (filter.getDueDateEnd() != null) {
                    end.setTime(filter.getDueDateEnd());
                    end.set(11, 23);
                    end.set(12, 59);
                    end.set(13, 59);
                }
                if (filter.getDueDateStart() != null && filter.getDueDateEnd() != null) {
                    positionCrit.add(Restrictions.between((String)"dueDate", (Object)start.getTime(), (Object)end.getTime()));
                } else if (filter.getDueDateStart() != null) {
                    positionCrit.add((Criterion)Restrictions.ge((String)"dueDate", (Object)start.getTime()));
                } else if (filter.getDueDateEnd() != null) {
                    positionCrit.add((Criterion)Restrictions.le((String)"dueDate", (Object)end.getTime()));
                }
            }
            if (filter.getPlanningNotification() != null && filter.getPlanningNotification().size() > 0) {
                ArrayList<PlanningNotificationOrder> ret = new ArrayList<PlanningNotificationOrder>();
                List orders = criteria.list();
                List<String> tokens2 = filter.getPlanningNotification();
                for (PlanningNotificationOrder order : orders) {
                    boolean matched = false;
                    Collection<PlanningNotificationMetaInformation> metaInfos = order.getPlanningNotification().getPlanningNotificationMetaInformations().values();
                    for (String token : tokens2) {
                        if (order.getPlanningNotification().getTitle() != null && order.getPlanningNotification().getTitle().toLowerCase().contains(token.toLowerCase())) {
                            matched = true;
                            break;
                        }
                        for (PlanningNotificationMetaInformation metaInfo : metaInfos) {
                            if (!(metaInfo instanceof PlanningNotificationTextMetaInformation) || !((PlanningNotificationTextMetaInformation)metaInfo).getValue().toLowerCase().contains(token.toLowerCase())) continue;
                            matched = true;
                            break;
                        }
                        if (!matched) continue;
                        break;
                    }
                    if (!matched) continue;
                    ret.add(order);
                }
                return ret;
            }
            return criteria.list();
        }
        return criteria.list();
    }

    @Override
    public List<PlanningNotification> getPlanningNotifications(PNFilterDTO filter, Integer networkId) {
        log.info("Started getPlanningNotifications");
        if (networkId == null) {
            return null;
        }
        Criteria crit = this.getSession().createCriteria(PlanningNotification.class);
        if (networkId != null) {
            crit.createCriteria("network").add(Restrictions.idEq((Object)networkId));
        }
        if (filter != null && filter.getProjectId() != null && filter.getProjectId() != 0) {
            crit.createCriteria("associatedProjects").add(Restrictions.idEq((Object)filter.getProjectId()));
        }
        List networkPlanningNotifications = crit.list();
        log.info("Finished with crit.list(), received [" + networkPlanningNotifications.size() + "] PlanningNotifications");
        List<PlanningNotification> filteredPlanningNotifications = PlanningNotificationFilterEvaluationHelper.filterPlanningNotifications(filter, networkPlanningNotifications);
        log.info("Filtered PlanningNotifications, remaining: [" + filteredPlanningNotifications.size() + "]");
        return filteredPlanningNotifications;
    }

    @Override
    public void delete(PlanningNotificationOrder planningNotificationOrder) {
        this.getSession().delete((Object)planningNotificationOrder);
    }
}

