/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.workflow.WorkflowToken;
import at.cdes.db.dao.WorkflowTokenDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Restrictions;

public class WorkflowTokenDAOHibernate
extends HibernateDaoSupport
implements WorkflowTokenDAO {
    @Override
    public List<WorkflowToken> getAll() {
        return this.loadAllHibernate(WorkflowToken.class);
    }

    @Override
    public WorkflowToken save(WorkflowToken token) {
        return this.get((Integer)this.getSession().save((Object)token));
    }

    @Override
    public WorkflowToken update(WorkflowToken token) {
        this.getSession().update((Object)token);
        return token;
    }

    @Override
    public WorkflowToken get(Integer id) {
        return (WorkflowToken)this.getSession().get(WorkflowToken.class, (Serializable)id);
    }

    @Override
    public void delete(WorkflowToken token) {
        this.getSession().delete((Object)token);
    }

    @Override
    public List<WorkflowToken> getAllTokensOwnedByWorkflowNode(Integer workflowNodeId) {
        Criteria crit = this.getSession().createCriteria(WorkflowToken.class);
        crit.createCriteria("owner").createCriteria("workflowNode").add(Restrictions.idEq((Object)workflowNodeId));
        return crit.list();
    }

    @Override
    public List<WorkflowToken> getAllTokensByOwnerPosition(Integer workflowNodePositionId) {
        Criteria crit = this.getSession().createCriteria(WorkflowToken.class);
        crit.createCriteria("owner").add(Restrictions.idEq((Object)workflowNodePositionId));
        return crit.list();
    }

    @Override
    public WorkflowToken getTokenByInitiatorPosition(Integer workflowNodePositionId) {
        Criteria crit = this.getSession().createCriteria(WorkflowToken.class);
        crit.createCriteria("initiator").add(Restrictions.idEq((Object)workflowNodePositionId));
        return (WorkflowToken)crit.uniqueResult();
    }

    @Override
    public List<WorkflowToken> getAllTokensOwnedByOrganisationPerson(Integer organisationPersonId) {
        Criteria crit = this.getSession().createCriteria(WorkflowToken.class);
        crit.createCriteria("owner").createCriteria("projectParticipation").createCriteria("projectParticipants").createCriteria("organisationPerson").add(Restrictions.idEq((Object)organisationPersonId));
        return crit.list();
    }

    @Override
    public boolean isWorkflowInitialized(Integer workflowId) {
        Criteria crit = this.getSession().createCriteria(WorkflowToken.class);
        crit.createCriteria("owner").createCriteria("workflowNode").createCriteria("workflow").add(Restrictions.idEq((Object)workflowId));
        return !crit.list().isEmpty();
    }
}

