/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.bo.data.attachment.Attachment;
import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.data.cycle.ReviewCyclePositionResultImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.planningNotification.PlanningNotificationAttachment;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.sec.DigestCalculatorType;
import at.cdes.bo.data.workflow.WorkflowActivityPositionResult;
import at.cdes.bo.file.FileFinder;
import at.cdes.bo.file.UploadFileHandler;
import at.cdes.bo.sec.digest.DigestCalculator;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.DigestCalculatorFactory;
import at.cdes.controller.helper.CdesDTOHelper;
import at.cdes.controller.helper.DataSourceHelper;
import at.cdes.db.dao.AttachmentDAO;
import at.cdes.db.dao.DigestCalculatorDAO;
import at.cdes.db.dao.PlanningNotificationAttachmentDAO;
import at.cdes.db.dao.ReviewCyclePositionResultDAO;
import at.cdes.oldGwtDto.AttachmentDTO;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.service.AttachmentOperations;
import at.cdes.service.ProjectOperations;
import at.cdes.service.ReviewOperations;
import at.cdes.service.exception.ActionException;
import at.cdes.service.exception.FileHandleException;
import at.cdes.service.exception.FrontendException;
import at.cdes.service.exception.OutdatedRedliningException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataSource;
import org.apache.log4j.Logger;
import org.clazzes.util.io.IOUtil;

public class AttachmentOperationsImpl
implements AttachmentOperations {
    private static final long serialVersionUID = 1L;
    private AttachmentDAO attachmentDAO;
    private ReviewCyclePositionResultDAO reviewCyclePositionResultDAO;
    private UploadFileHandler uploadHandler;
    private FileFinder fileFinder;
    private DigestCalculatorFactory digestCalculatorFactory;
    private DigestCalculatorDAO digestCalculatorDAO;
    private ReviewOperations reviewOperations;
    private ProjectOperations projectOperations;
    static Logger logger = Logger.getLogger(AttachmentOperationsImpl.class);
    private PlanningNotificationAttachmentDAO planningNotificationAttachmentDAO;

    @Override
    public void updateFileDigest(Attachment att, Network network) {
        try {
            File file = this.fileFinder.findFile(att.getFileName(), CDESFileRepository.ATTACHMENTREPOSITORY);
            DigestCalculator attDig = this.digestCalculatorFactory.getDigestCalculator(network, file);
            DigestCalculatorType t = this.digestCalculatorDAO.get(attDig.getClass().getName());
            att.setDigest(attDig.getDigest(file));
            att.setDigestCalculatorType(t);
            ArrayList results = new ArrayList(att.getResults().values());
            att = this.attachmentDAO.merge(att);
            for (ReviewCyclePositionResult result : results) {
                att.getResults().put(result.getId(), result);
            }
            this.attachmentDAO.update(att);
        }
        catch (FileHandleException e) {
            throw new ActionException("updateFileDigest", e);
        }
        catch (DigestCalculatorException e) {
            throw new ActionException("updateFileDigest", e);
        }
    }

    @Override
    public Attachment saveReviewAttachmentSimple(Attachment attachment, ReviewCyclePositionResult res) {
        attachment.setCreated(new Date(System.currentTimeMillis()));
        attachment = this.attachmentDAO.save(attachment);
        if (attachment.getResults() == null) {
            attachment.setResults(new HashMap());
        }
        attachment.getResults().put(res.getId(), res);
        this.attachmentDAO.update(attachment);
        if (res.getAttachments() == null) {
            res.setAttachments(new HashMap());
        }
        res.getAttachments().put(attachment.getId(), attachment);
        this.reviewCyclePositionResultDAO.update(res);
        return this.attachmentDAO.update(attachment);
    }

    @Override
    public List<Attachment> getAttachments(Integer reviewCycleResultId, boolean isReadliningType) {
        return this.attachmentDAO.getAll(reviewCycleResultId, isReadliningType);
    }

    @Override
    public List<AttachmentDTO> getAttachmentDTOs(Integer reviewCyclePositionResultId, boolean isRedliningDelta) {
        ArrayList<AttachmentDTO> attachmentDTOs = new ArrayList<AttachmentDTO>();
        for (Attachment attachment : this.getAttachments(reviewCyclePositionResultId, isRedliningDelta)) {
            ProjectParticipant pp = this.projectOperations.getProjectParticipant(attachment.getProjectParticipantId());
            AttachmentDTO attachmentDTO = CdesDTOHelper.getAttachmentDTO(attachment);
            attachmentDTO.setProjectParticipant(CdesDTOHelper.getProjectParticipantDTO(pp, false));
            attachmentDTOs.add(attachmentDTO);
        }
        return attachmentDTOs;
    }

    @Override
    public void deleteAttachment(Integer id) {
        Attachment att = this.attachmentDAO.get(id);
        if (att.getResults() != null && att.getResults().size() > 0) {
            att.getResults().clear();
            this.attachmentDAO.update(att);
        }
        try {
            this.uploadHandler.deleteAttachment(att);
        }
        catch (FileHandleException e) {
            throw new ActionException("Deleting Attachment " + att.getId(), e);
        }
        this.attachmentDAO.delete(att);
    }

    public void setAttachmentDAO(AttachmentDAO attachmentDAO) {
        this.attachmentDAO = attachmentDAO;
    }

    public void setReviewCyclePositionResultDAO(ReviewCyclePositionResultDAO reviewCyclePositionResultDAO) {
        this.reviewCyclePositionResultDAO = reviewCyclePositionResultDAO;
    }

    @Override
    public void saveReviewCyclePositionResultAttachment2(Integer reviewCyclePositionResultId, Integer reviewCycleNodePositionId, IMimeInputStream data, Integer orgPersonId, Integer taskId, String originalFileName) {
        ProjectParticipant participant = this.reviewOperations.getSignerByPositionAndTaskId(orgPersonId, reviewCycleNodePositionId, taskId);
        ReviewCyclePositionResultImpl res = (ReviewCyclePositionResultImpl)this.reviewCyclePositionResultDAO.get(reviewCyclePositionResultId);
        try {
            if (data != null) {
                this.saveReviewAttachment(DataSourceHelper.toDataSource(data), res, participant.getId(), originalFileName);
            }
        }
        catch (FileHandleException e) {
            throw new ActionException("Saving Attachment", e);
        }
        catch (IOError e) {
            throw new ActionException("IOError Saving Attachment", e);
        }
        finally {
            if (data != null) {
                try {
                    data.close();
                }
                catch (Throwable e) {
                    logger.warn((Object)"Error closing ReviewCyclePositionResultAttachment.", e);
                }
            }
        }
    }

    @Override
    public void saveReviewCyclePositionResultAttachment(Integer reviewCyclePositionId, IMimeInputStream data, Integer participantId) {
        ReviewCyclePositionResultImpl res = (ReviewCyclePositionResultImpl)this.reviewCyclePositionResultDAO.get(reviewCyclePositionId);
        try {
            if (data != null) {
                this.saveReviewAttachment(DataSourceHelper.toDataSource(data), res, participantId, null);
            }
        }
        catch (FileHandleException e) {
            throw new ActionException("Saving Attachment", e);
        }
        catch (IOError e) {
            throw new ActionException("IOError Saving Attachment", e);
        }
        finally {
            if (data != null) {
                try {
                    data.close();
                }
                catch (Throwable e) {
                    logger.warn((Object)"Error closing ReviewCyclePositionResultAttachment.", e);
                }
            }
        }
    }

    @Override
    public PlanningNotificationAttachment savePlanningNotificationAttachment(Integer networkId, WorkflowActivityPositionResult result, IMimeInputStream stream, String originalFileName) {
        PlanningNotificationAttachment pna = new PlanningNotificationAttachment();
        pna.setFileType(IOUtil.getFileExtension((String)originalFileName));
        pna.setOriginalName(originalFileName);
        String fileName = null;
        InputStream fis = null;
        try {
            fis = DataSourceHelper.toDataSource(stream).getInputStream();
            fileName = this.uploadHandler.savePlanningNotificationAttachment(networkId, result.getId(), originalFileName, fis);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IOError e) {
            e.printStackTrace();
        }
        catch (FileHandleException e) {
            e.printStackTrace();
        }
        pna.setFileName(fileName);
        pna = this.planningNotificationAttachmentDAO.save(pna);
        if (pna.getResults() == null) {
            pna.setResults(new HashMap());
        }
        if (!pna.getResults().containsKey(result.getId())) {
            pna.getResults().put(result.getId(), result);
        }
        this.planningNotificationAttachmentDAO.update(pna);
        return pna;
    }

    @Override
    public void deletePlanningNotificationAttachment(Integer id) {
        PlanningNotificationAttachment att = this.planningNotificationAttachmentDAO.get(id);
        if (att.getResults() != null && att.getResults().size() > 0) {
            att.getResults().clear();
            this.planningNotificationAttachmentDAO.update(att);
        }
        try {
            this.uploadHandler.deletePlanningNotificationFile(att.getFileName());
        }
        catch (FileHandleException e) {
            throw new ActionException("Deleting planningNotificationAttachment " + att.getId(), e);
        }
        this.planningNotificationAttachmentDAO.delete(att);
    }

    private Attachment saveReviewAttachment(DataSource uploadFile, ReviewCyclePositionResult res, Integer projectParticipantId, String originalFileName) throws FileHandleException {
        String fileName;
        if (originalFileName == null) {
            originalFileName = uploadFile.getName();
        }
        Attachment attachment = new Attachment();
        attachment.setDocumentVersionId(res.getDocumentVersion().getId());
        attachment.setReviewCycleNodeId(res.getReviewCycleNode().getId());
        attachment.setProjectParticipantId(projectParticipantId);
        attachment.setOriginalName(originalFileName);
        attachment.setCreated(new Date(System.currentTimeMillis()));
        attachment.setFileType(IOUtil.getFileExtension((String)originalFileName));
        try {
            fileName = this.uploadHandler.saveAttachment(res.getDocumentVersion(), originalFileName, uploadFile.getInputStream());
        }
        catch (IOException e) {
            throw new FileHandleException("Error getting upload data stream", e);
        }
        attachment.setFileName(fileName);
        attachment = this.attachmentDAO.save(attachment);
        if (attachment.getResults() == null) {
            attachment.setResults(new HashMap());
        }
        if (!attachment.getResults().containsKey(res.getId())) {
            attachment.getResults().put(res.getId(), res);
        }
        this.attachmentDAO.update(attachment);
        if (res.getAttachments() == null) {
            res.setAttachments(new HashMap());
        }
        res.getAttachments().put(attachment.getId(), attachment);
        this.reviewCyclePositionResultDAO.update(res);
        return attachment;
    }

    public void setUploadHandler(UploadFileHandler uploadHandler) {
        this.uploadHandler = uploadHandler;
    }

    @Override
    public int saveRedlining(IMimeInputStream is, Integer documentVersionId, Integer reviewCyclePostionResultId, Integer projectParticipantId, Integer attachmentId) throws FrontendException {
        ReviewCyclePositionResult res = this.reviewCyclePositionResultDAO.get(reviewCyclePostionResultId);
        ReviewCycleNode node = res.getReviewCycleNode();
        if (!res.getDocumentVersion().getId().equals(documentVersionId)) {
            throw new ActionException("Invalid document version in submitted Redlining Delta.");
        }
        if (!node.isFree() && !res.getDocumentVersion().getActualReviewCycleNode().getId().equals(node.getId())) {
            throw new OutdatedRedliningException("The Redlining attachment does not correspond to the actual node of the document version.");
        }
        if (res.getSignature() != null) {
            throw new OutdatedRedliningException("The Redlining attachment has already been signed.");
        }
        Attachment attachment = null;
        if (attachmentId != null) {
            attachment = this.attachmentDAO.get(attachmentId);
        }
        if (attachment == null) {
            attachment = new Attachment();
        }
        attachment.setDocumentVersionId(res.getDocumentVersion().getId());
        attachment.setReviewCycleNodeId(res.getReviewCycleNode().getId());
        attachment.setRedliningDelta(true);
        attachment.setCreated(new Date(System.currentTimeMillis()));
        attachment.setProjectParticipantId(projectParticipantId);
        attachment.setFileType("fdf");
        String fileName = res.getDocumentVersion().getId().toString() + "-" + System.currentTimeMillis() + "." + attachment.getFileType();
        try {
            DataSource ds = DataSourceHelper.toDataSource(is);
            fileName = this.uploadHandler.saveAttachment(res.getDocumentVersion(), fileName, ds.getInputStream());
        }
        catch (FileHandleException e) {
            throw new ActionException("Saving Redlining Delta ", e);
        }
        catch (IOError e) {
            throw new ActionException("IOError - Saving redlining data ", e);
        }
        catch (IOException e) {
            throw new ActionException("IOException - Saving redlining data ", e);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable e) {
                throw new ActionException("IOError - upload document reference attachment tmp ", e);
            }
        }
        attachment.setOriginalName(fileName);
        attachment.setFileName(fileName);
        if (attachment.getId() == null) {
            attachment = this.attachmentDAO.save(attachment);
        }
        if (attachment.getResults() == null) {
            attachment.setResults(new HashMap());
        }
        if (!attachment.getResults().containsKey(res.getId())) {
            attachment.getResults().put(res.getId(), res);
        }
        this.attachmentDAO.update(attachment);
        List<Attachment> allRedlinings = this.getAttachments(res.getId(), true);
        ArrayList<Attachment> ids2Delete = new ArrayList<Attachment>();
        if (allRedlinings != null) {
            for (Attachment att : allRedlinings) {
                if (att.getId().equals(attachment.getId())) continue;
                ids2Delete.add(att);
            }
            Iterator<Attachment> it = ids2Delete.iterator();
            while (it.hasNext()) {
                this.attachmentDAO.delete(it.next());
            }
        }
        if (allRedlinings == null) {
            return 0;
        }
        return allRedlinings.size();
    }

    public void setDigestCalculatorDAO(DigestCalculatorDAO digestCalculatorDAO) {
        this.digestCalculatorDAO = digestCalculatorDAO;
    }

    public void setDigestCalculatorFactory(DigestCalculatorFactory digestCalculatorFactory) {
        this.digestCalculatorFactory = digestCalculatorFactory;
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    @Override
    public boolean isRedliningAttachmentExistent(Integer rcPosResultId) {
        return this.attachmentDAO.isRedliningAttachmentExistent(rcPosResultId);
    }

    public void setProjectOperations(ProjectOperations projectOperations) {
        this.projectOperations = projectOperations;
    }

    public void setReviewOperations(ReviewOperations reviewOperations) {
        this.reviewOperations = reviewOperations;
    }

    public void setPlanningNotificationAttachmentDAO(PlanningNotificationAttachmentDAO planningNotificationAttachmentDAO) {
        this.planningNotificationAttachmentDAO = planningNotificationAttachmentDAO;
    }
}

